/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.container.util;

import com.ibm.ejs.container.BeanMetaData;
import com.ibm.ejs.container.ContainerProperties;
import com.ibm.ejs.container.EJBConfigurationException;
import com.ibm.ejs.csi.ActivitySessionMethod;
import com.ibm.ejs.models.base.extensions.ejbext.AccessIntent;
import com.ibm.ejs.models.base.extensions.ejbext.IsolationLevelAttributes;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.csi.ActivitySessionAttribute;
import com.ibm.websphere.csi.J2EEName;
import com.ibm.websphere.csi.TransactionAttribute;
import com.ibm.ws.metadata.EJBMethodInterfaceType;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import javax.annotation.security.DenyAll;
import javax.annotation.security.PermitAll;
import javax.annotation.security.RolesAllowed;
import javax.ejb.TransactionAttributeType;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jst.j2ee.common.SecurityRole;
import org.eclipse.jst.j2ee.ejb.EnterpriseBean;
import org.eclipse.jst.j2ee.ejb.ExcludeList;
import org.eclipse.jst.j2ee.ejb.MethodElement;
import org.eclipse.jst.j2ee.ejb.MethodPermission;
import org.eclipse.jst.j2ee.ejb.MethodTransaction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MethodAttribUtils {
    private static final String CLASS_NAME = MethodAttribUtils.class.getName();
    private static TraceComponent tc = Tr.register(CLASS_NAME, "MetaData", "com.ibm.ejs.container.container");
    private static final String newLine;
    private static final String indent = "   ";
    private static final String indent2 = "      ";
    private static final String indent3 = "         ";
    public static final String METHOD_ARGLIST_SEP = ":";
    public static final String[] TX_ATTR_STR;
    private static int[] isoLevelMOFMap;
    private static String[] ISOLATION_STR;
    private static TransactionAttribute[] txMOFMap;
    private static TransactionAttribute[] txAttrFromJEE15Map;
    private static final EJBMethodInterfaceType[] methodInterfaceTypeMap;

    public static final void getAnnotationCMTransactions(TransactionAttribute[] tranAttrs, Method[] beanMethods, BeanMetaData bmd) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "getAnnotationCMTransactions");
        }
        javax.ejb.TransactionAttribute methTranAttr = null;
        for (int i = 0; i < beanMethods.length; ++i) {
            if (tranAttrs[i] != null) continue;
            methTranAttr = null;
            if (!bmd.metadataComplete) {
                methTranAttr = beanMethods[i].getAnnotation(javax.ejb.TransactionAttribute.class);
                if (methTranAttr == null) {
                    methTranAttr = beanMethods[i].getDeclaringClass().getAnnotation(javax.ejb.TransactionAttribute.class);
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled() && methTranAttr != null) {
                        Tr.debug(tc, beanMethods[i].getName() + " from class " + beanMethods[i].getDeclaringClass().getName());
                    }
                }
                if (methTranAttr != null) {
                    int tranType = methTranAttr.value().ordinal();
                    tranAttrs[i] = txAttrFromJEE15Map[tranType];
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug(tc, beanMethods[i].getName() + " = " + (Object)((Object)methTranAttr.value()));
                    }
                }
            }
            if (methTranAttr != null) continue;
            tranAttrs[i] = TransactionAttribute.TX_REQUIRED;
            if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
            Tr.debug(tc, beanMethods[i].getName() + " = REQUIRED (defaulted)");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "getAnnotationsCMTransactions", Arrays.toString(tranAttrs));
        }
    }

    public static final void getAnnotationsForSecurity(Method[] beanMethods, ArrayList<String>[] rolesAllowed, boolean[] denyAll, boolean[] permitAll) throws EJBConfigurationException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "getAnnotationsForSecurity");
        }
        for (int i = 0; i < beanMethods.length; ++i) {
            RolesAllowed classRolesAllowed = null;
            RolesAllowed methRolesAllowed = null;
            DenyAll methDenyAll = null;
            PermitAll classPermitAll = null;
            PermitAll methPermitAll = null;
            if (beanMethods[i] != null) {
                boolean roleAdded;
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "Processing method: " + beanMethods[i].getName());
                }
                if (denyAll[i] || permitAll[i] || rolesAllowed[i] != null) {
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
                    Tr.debug(tc, "DenyAll, PermitAll, or Roles already set in XML.");
                    continue;
                }
                methDenyAll = beanMethods[i].getAnnotation(DenyAll.class);
                if (methDenyAll != null) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug(tc, "DenyAll annotation set: " + methDenyAll.toString());
                    }
                    denyAll[i] = true;
                }
                if ((methPermitAll = beanMethods[i].getAnnotation(PermitAll.class)) != null) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug(tc, "PermitAll annotation set: " + methPermitAll.toString());
                    }
                    if (methDenyAll != null) {
                        Tr.error(tc, "CONFLICTING_ANNOTATIONS_CONFIGURED_ON_METHOD_CNTR0150E", new Object[]{"@PermitAll", "@DenyAll", beanMethods[i].getName(), beanMethods[i].getDeclaringClass().getName()});
                        throw new EJBConfigurationException("@DenyAll and @PermitAll annotations are both set on class:  " + beanMethods[i].getDeclaringClass().getName() + " method: " + beanMethods[i].getName());
                    }
                    permitAll[i] = true;
                }
                if ((methRolesAllowed = beanMethods[i].getAnnotation(RolesAllowed.class)) != null) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug(tc, "Method-level RolsAllowed annotation set. ");
                    }
                    if (methDenyAll != null) {
                        Tr.error(tc, "CONFLICTING_ANNOTATIONS_CONFIGURED_ON_METHOD_CNTR0150E", new Object[]{"@RolesAllowed", "@DenyAll", beanMethods[i].getName(), beanMethods[i].getDeclaringClass().getName()});
                        throw new EJBConfigurationException("@RolesAllowed and @DenyAll annotations are both set on class:  " + beanMethods[i].getDeclaringClass().getName() + " method: " + beanMethods[i].getName());
                    }
                    if (methDenyAll != null || methPermitAll != null) {
                        Tr.error(tc, "CONFLICTING_ANNOTATIONS_CONFIGURED_ON_METHOD_CNTR0150E", new Object[]{"RolesAllowed", "@PermitAll", beanMethods[i].getName(), beanMethods[i].getDeclaringClass().getName()});
                        throw new EJBConfigurationException("@RolesAllowed and @PermitAll annotations are both set on class:  " + beanMethods[i].getDeclaringClass().getName() + " method: " + beanMethods[i].getName());
                    }
                    rolesAllowed[i] = new ArrayList();
                    for (String role : methRolesAllowed.value()) {
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            Tr.debug(tc, "Adding role: " + role);
                        }
                        if (roleAdded = rolesAllowed[i].add(role)) continue;
                        Tr.error(tc, "MULTIPLE_ROLES_SPECIFIED_IN_METHOD_ANNOTATION_CNTR0151E", new Object[]{role, beanMethods[i].getName(), beanMethods[i].getDeclaringClass().getName()});
                        throw new EJBConfigurationException("Role: " + role + " is defined multiple times on the @RolesAllowed annotation for class: " + beanMethods[i].getDeclaringClass().getName() + " method: " + beanMethods[i].getName());
                    }
                }
                if (methRolesAllowed == null && methDenyAll == null && methPermitAll == null) {
                    classRolesAllowed = beanMethods[i].getDeclaringClass().getAnnotation(RolesAllowed.class);
                    classPermitAll = beanMethods[i].getDeclaringClass().getAnnotation(PermitAll.class);
                    if (classRolesAllowed != null && classPermitAll != null) {
                        Tr.error(tc, "CONFLICTING_ANNOTATIONS_CONFIGURED_ON_CLASS_CNTR0152E", new Object[]{"@RolesAllowed", "@PermitAll", beanMethods[i].getDeclaringClass().getName()});
                        throw new EJBConfigurationException("@PermitAll and @RolesAllowed must not both be set on class level annotation of class: " + beanMethods[i].getDeclaringClass().getName());
                    }
                    if (classRolesAllowed != null) {
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            Tr.debug(tc, "Class RolesAllowed annotation set: ");
                        }
                        rolesAllowed[i] = new ArrayList();
                        for (String role : classRolesAllowed.value()) {
                            roleAdded = rolesAllowed[i].add(role);
                            if (roleAdded) continue;
                            Tr.error(tc, "MULTIPLE_ROLES_SPECIFIED_IN_CLASS_ANNOTATION_CNTR0153E", new Object[]{role, beanMethods[i].getDeclaringClass().getName()});
                            throw new EJBConfigurationException("Role: " + role + " is defined multiple times on the @RolesAllowed class level annotation of class: " + beanMethods[i].getDeclaringClass().getName());
                        }
                    }
                    if (classPermitAll != null) {
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            Tr.debug(tc, "Class PermitAll annotation set: ");
                        }
                        permitAll[i] = true;
                    }
                }
            }
            String methodName = null;
            methodName = beanMethods[i] != null ? beanMethods[i].getName() : "Unknown";
            if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
            Tr.debug(tc, methodName + " denyAll:  " + denyAll[i]);
            Tr.debug(tc, methodName + " permitAll:  " + permitAll[i]);
            if (rolesAllowed[i] == null) {
                Tr.debug(tc, methodName + " roles:  null");
                continue;
            }
            Tr.debug(tc, methodName + " roles:  " + Arrays.toString(rolesAllowed[i].toArray()));
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "getAnnotationsForSecurity");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void getXMLCMTransactions(TransactionAttribute[] tranAttrs, int type, String[] methodNames, String[] methodSignatures, List tranAttrList, EnterpriseBean enterpriseBean) {
        block36: {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.entry(tc, "getXMLCMTransactions", Arrays.toString(tranAttrs));
            }
            StringBuffer sb = null;
            try {
                if (tranAttrList != null) {
                    sb = new StringBuffer();
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        sb.append(newLine + newLine + "*** TX list has " + tranAttrList.size() + " TX attribute(s) to process ***");
                    }
                    int[] highestStyleOnMethod = new int[methodNames.length];
                    for (int i = 0; i < tranAttrList.size(); ++i) {
                        MethodTransaction methodTransaction = (MethodTransaction)tranAttrList.get(i);
                        int tranType = methodTransaction.getTransactionAttribute().getValue();
                        EList methodElements = methodTransaction.getMethodElements();
                        for (int j = 0; j < methodElements.size(); ++j) {
                            int k;
                            MethodElement me = (MethodElement)methodElements.get(j);
                            EnterpriseBean meEnterpriseBean = me.getEnterpriseBean();
                            int meType = me.getType().getValue();
                            if (meEnterpriseBean == null) {
                                Tr.warning(tc, "INVALID_CONTAINER_TRANSACTION_XML_CNTR0121W", new Object[]{enterpriseBean.getEjbJar().getDisplayName(), txMOFMap[tranType]});
                            }
                            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled() && j == 0) {
                                sb.append(newLine + indent + "#" + i + " Method transaction type: " + txMOFMap[tranType]);
                            }
                            if (me.getEnterpriseBean() != enterpriseBean) continue;
                            String meName = me.getName().trim();
                            if (meName.equals("*")) {
                                if (me.isUnspecified()) {
                                    for (k = 0; k < methodNames.length; ++k) {
                                        if (highestStyleOnMethod[k] > 1) continue;
                                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                            if (meEnterpriseBean != null) {
                                                sb.append(newLine + indent2 + "Enterprise Bean Name: " + meEnterpriseBean.getName());
                                            }
                                            sb.append(newLine + indent2 + "Method name: " + me.getName());
                                            if (me.getParms() != null) {
                                                sb.append(newLine + indent2 + "Method signature = " + me.getParms());
                                            } else {
                                                sb.append(newLine + indent2 + "Method signature = null");
                                            }
                                            sb.append(newLine + indent2 + "Method interface type: " + methodInterfaceTypeMap[meType]);
                                            sb.append(newLine + indent3 + "Style 1 - replacing TX attrubute " + tranAttrs[k] + " with " + txMOFMap[tranType]);
                                        }
                                        tranAttrs[k] = txMOFMap[tranType];
                                        highestStyleOnMethod[k] = 1;
                                    }
                                    continue;
                                }
                                if (meType != type) continue;
                                for (k = 0; k < methodNames.length; ++k) {
                                    if (highestStyleOnMethod[k] > 2) continue;
                                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                        if (meEnterpriseBean != null) {
                                            sb.append(newLine + indent2 + "Enterprise Bean Name: " + meEnterpriseBean.getName());
                                        }
                                        sb.append(newLine + indent2 + "Method name: " + me.getName());
                                        if (me.getParms() != null) {
                                            sb.append(newLine + indent2 + "Method signature = " + me.getParms());
                                        } else {
                                            sb.append(newLine + indent2 + "Method signature = null");
                                        }
                                        sb.append(newLine + indent2 + "Method interface type: " + methodInterfaceTypeMap[meType]);
                                        sb.append(newLine + indent3 + "Style 2 - replacing " + tranAttrs[k] + " with " + txMOFMap[tranType]);
                                    }
                                    tranAttrs[k] = txMOFMap[tranType];
                                    highestStyleOnMethod[k] = 2;
                                }
                                continue;
                            }
                            if (!me.isUnspecified() && meType != type) continue;
                            for (k = 0; k < methodNames.length; ++k) {
                                if (!meName.equals(methodNames[k])) continue;
                                String meParms = me.getParms();
                                if (meParms == null) {
                                    if (highestStyleOnMethod[k] > 3) continue;
                                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                        if (meEnterpriseBean != null) {
                                            sb.append(newLine + indent2 + "Enterprise Bean Name: " + meEnterpriseBean.getName());
                                        }
                                        sb.append(newLine + indent2 + "Method name: " + me.getName());
                                        if (me.getParms() != null) {
                                            sb.append(newLine + indent2 + "Method signature = " + me.getParms());
                                        } else {
                                            sb.append(newLine + indent2 + "Method signature = null");
                                        }
                                        sb.append(newLine + indent2 + "Method interface type: " + methodInterfaceTypeMap[meType]);
                                        sb.append(newLine + indent3 + "Style 3 - replacing " + tranAttrs[k] + " with " + txMOFMap[tranType]);
                                    }
                                    tranAttrs[k] = txMOFMap[tranType];
                                    highestStyleOnMethod[k] = 3;
                                    continue;
                                }
                                if (!(meParms = MethodAttribUtils.normalizeSignature(meParms.trim())).equals(methodSignatures[k])) continue;
                                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                    if (meEnterpriseBean != null) {
                                        sb.append(newLine + indent2 + "Enterprise Bean Name: " + meEnterpriseBean.getName());
                                    }
                                    sb.append(newLine + indent2 + "Method name: " + me.getName());
                                    if (me.getParms() != null) {
                                        sb.append(newLine + indent2 + "Method signature = " + me.getParms());
                                    } else {
                                        sb.append(newLine + indent2 + "Method signature = null");
                                    }
                                    sb.append(newLine + indent2 + "Method interface type: " + methodInterfaceTypeMap[meType]);
                                    sb.append(newLine + indent3 + "Style 4 - replacing " + tranAttrs[k] + " with " + txMOFMap[tranType]);
                                }
                                tranAttrs[k] = txMOFMap[tranType];
                                highestStyleOnMethod[k] = 4;
                            }
                        }
                    }
                }
                Object var20_19 = null;
            }
            catch (Throwable throwable) {
                Object var20_20 = null;
                if (TraceComponent.isAnyTracingEnabled()) {
                    if (tc.isDebugEnabled() && sb != null) {
                        Tr.debug(tc, sb.toString());
                    }
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "getXMLCMTransactions", Arrays.toString(tranAttrs));
                    }
                }
                throw throwable;
            }
            if (!TraceComponent.isAnyTracingEnabled()) break block36;
            if (tc.isDebugEnabled() && sb != null) {
                Tr.debug(tc, sb.toString());
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getXMLCMTransactions", Arrays.toString(tranAttrs));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void getXMLMethodsDenied(boolean[] denyAll, int type, String[] methodNames, String[] methodSignatures, ExcludeList excludeList, EnterpriseBean enterpriseBean) {
        block34: {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.entry(tc, "getXMLMethodsDenied", Arrays.toString(denyAll));
            }
            StringBuffer sb = null;
            try {
                if (excludeList != null) {
                    sb = new StringBuffer();
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        sb.append(newLine + newLine + "*** Exclude List has " + excludeList.getMethodElements().size() + " entries to process ***");
                    }
                    int[] highestStyleOnMethod = new int[methodNames.length];
                    EList methodElements = excludeList.getMethodElements();
                    for (int j = 0; j < methodElements.size(); ++j) {
                        int k;
                        MethodElement me = (MethodElement)methodElements.get(j);
                        EnterpriseBean meEnterpriseBean = me.getEnterpriseBean();
                        int meType = me.getType().getValue();
                        if (meEnterpriseBean == null) {
                            Tr.warning(tc, "INVALID_EXCLUDE_LIST_XML_CNTR0124W", new Object[]{enterpriseBean.getEjbJar().getDisplayName(), enterpriseBean.getName()});
                        }
                        if (me.getEnterpriseBean() != enterpriseBean) continue;
                        String meName = me.getName().trim();
                        if (meName.equals("*")) {
                            if (me.isUnspecified()) {
                                for (k = 0; k < methodNames.length; ++k) {
                                    if (highestStyleOnMethod[k] > 1) continue;
                                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                        if (meEnterpriseBean != null) {
                                            sb.append(newLine + indent2 + "Enterprise Bean Name: " + meEnterpriseBean.getName());
                                        }
                                        sb.append(newLine + indent2 + "Method name: " + me.getName());
                                        if (me.getParms() != null) {
                                            sb.append(newLine + indent2 + "Method signature = " + me.getParms());
                                        } else {
                                            sb.append(newLine + indent2 + "Method signature = null");
                                        }
                                        sb.append(newLine + indent2 + "Method interface type: " + methodInterfaceTypeMap[meType]);
                                        sb.append(newLine + indent3 + "Style 1 - assigning denyAll " + true);
                                    }
                                    denyAll[k] = true;
                                    highestStyleOnMethod[k] = 1;
                                }
                                continue;
                            }
                            if (meType != type) continue;
                            for (k = 0; k < methodNames.length; ++k) {
                                if (highestStyleOnMethod[k] > 2) continue;
                                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                    if (meEnterpriseBean != null) {
                                        sb.append(newLine + indent2 + "Enterprise Bean Name: " + meEnterpriseBean.getName());
                                    }
                                    sb.append(newLine + indent2 + "Method name: " + me.getName());
                                    if (me.getParms() != null) {
                                        sb.append(newLine + indent2 + "Method signature = " + me.getParms());
                                    } else {
                                        sb.append(newLine + indent2 + "Method signature = null");
                                    }
                                    sb.append(newLine + indent2 + "Method interface type: " + methodInterfaceTypeMap[meType]);
                                    sb.append(newLine + indent3 + "Style 2 - assigning denyAll " + true);
                                }
                                denyAll[k] = true;
                                highestStyleOnMethod[k] = 2;
                            }
                            continue;
                        }
                        if (!me.isUnspecified() && meType != type) continue;
                        for (k = 0; k < methodNames.length; ++k) {
                            if (!meName.equals(methodNames[k])) continue;
                            String meParms = me.getParms();
                            if (meParms == null) {
                                if (highestStyleOnMethod[k] > 3) continue;
                                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                    if (meEnterpriseBean != null) {
                                        sb.append(newLine + indent2 + "Enterprise Bean Name: " + meEnterpriseBean.getName());
                                    }
                                    sb.append(newLine + indent2 + "Method name: " + me.getName());
                                    if (me.getParms() != null) {
                                        sb.append(newLine + indent2 + "Method signature = " + me.getParms());
                                    } else {
                                        sb.append(newLine + indent2 + "Method signature = null");
                                    }
                                    sb.append(newLine + indent2 + "Method interface type: " + methodInterfaceTypeMap[meType]);
                                    sb.append(newLine + indent3 + "Style 3 - assigning denyAll " + true);
                                }
                                denyAll[k] = true;
                                highestStyleOnMethod[k] = 3;
                                continue;
                            }
                            if (!(meParms = MethodAttribUtils.normalizeSignature(meParms.trim())).equals(methodSignatures[k])) continue;
                            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                if (meEnterpriseBean != null) {
                                    sb.append(newLine + indent2 + "Enterprise Bean Name: " + meEnterpriseBean.getName());
                                }
                                sb.append(newLine + indent2 + "Method name: " + me.getName());
                                if (me.getParms() != null) {
                                    sb.append(newLine + indent2 + "Method signature = " + me.getParms());
                                } else {
                                    sb.append(newLine + indent2 + "Method signature = null");
                                }
                                sb.append(newLine + indent2 + "Method interface type: " + methodInterfaceTypeMap[meType]);
                                sb.append(newLine + indent3 + "Style 4 - assigning denyAll " + true);
                            }
                            denyAll[k] = true;
                            highestStyleOnMethod[k] = 4;
                        }
                    }
                }
                Object var17_16 = null;
            }
            catch (Throwable throwable) {
                Object var17_17 = null;
                if (TraceComponent.isAnyTracingEnabled()) {
                    if (tc.isDebugEnabled() && sb != null) {
                        Tr.debug(tc, sb.toString());
                    }
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "getXMLMethodsDenied", Arrays.toString(denyAll));
                    }
                }
                throw throwable;
            }
            if (!TraceComponent.isAnyTracingEnabled()) break block34;
            if (tc.isDebugEnabled() && sb != null) {
                Tr.debug(tc, sb.toString());
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getXMLMethodsDenied", Arrays.toString(denyAll));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void getXMLPermissions(ArrayList[] securityRoles, boolean[] permitAll, boolean[] denyAll, int type, String[] methodNames, String[] methodSignatures, List permissionsList, EnterpriseBean enterpriseBean) {
        block49: {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.entry(tc, "getXMLPermissions", Arrays.toString(securityRoles));
            }
            StringBuffer sb = null;
            try {
                if (permissionsList != null) {
                    sb = new StringBuffer();
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        sb.append(newLine + newLine + "*** Method Permissions list has " + permissionsList.size() + " Security Permission(s) to process ***");
                    }
                    for (int i = 0; i < permissionsList.size(); ++i) {
                        MethodPermission methodPermission = (MethodPermission)permissionsList.get(i);
                        boolean isUnchecked = methodPermission.isUnchecked();
                        EList roleList = methodPermission.getRoles();
                        SecurityRole[] roles = roleList.toArray(new SecurityRole[0]);
                        EList methodElements = methodPermission.getMethodElements();
                        for (int j = 0; j < methodElements.size(); ++j) {
                            int k;
                            MethodElement me = (MethodElement)methodElements.get(j);
                            EnterpriseBean meEnterpriseBean = me.getEnterpriseBean();
                            int meType = me.getType().getValue();
                            if (meEnterpriseBean == null) {
                                Tr.warning(tc, "INVALID_METHOD_PERMISSION_XML_CNTR0123W", new Object[]{enterpriseBean.getEjbJar().getDisplayName(), enterpriseBean.getName()});
                            }
                            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                if (j == 0) {
                                    sb.append(newLine + indent + "#" + i + " Method Permission  has " + methodElements.size() + " Method Element(s).");
                                }
                                sb.append(newLine + indent + "Process element " + me.getName() + " Method Element type = " + meType);
                            }
                            if (me.getEnterpriseBean() != enterpriseBean) continue;
                            String meName = me.getName().trim();
                            if (meName.equals("*")) {
                                if (me.isUnspecified()) {
                                    for (k = 0; k < methodNames.length; ++k) {
                                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                            if (meEnterpriseBean != null) {
                                                sb.append(newLine + indent2 + "Enterprise Bean Name: " + meEnterpriseBean.getName());
                                            }
                                            sb.append(newLine + indent2 + "Method name: " + me.getName());
                                            if (me.getParms() != null) {
                                                sb.append(newLine + indent2 + "Method signature = " + me.getParms());
                                            } else {
                                                sb.append(newLine + indent2 + "Method signature = null");
                                            }
                                            sb.append(newLine + indent2 + "Method interface type: " + methodInterfaceTypeMap[meType]);
                                        }
                                        if (isUnchecked) {
                                            sb.append(newLine + indent3 + "Style 1 - Permit all roles.");
                                            permitAll[k] = true;
                                            continue;
                                        }
                                        if (securityRoles[k] == null) {
                                            securityRoles[k] = new ArrayList();
                                        }
                                        for (SecurityRole role : roles) {
                                            sb.append(newLine + indent3 + "Style 1 - assigning role " + role);
                                            securityRoles[k].add(role.getRoleName());
                                        }
                                    }
                                    continue;
                                }
                                if (meType != type) continue;
                                for (k = 0; k < methodNames.length; ++k) {
                                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                        if (meEnterpriseBean != null) {
                                            sb.append(newLine + indent2 + "Enterprise Bean Name: " + meEnterpriseBean.getName());
                                        }
                                        sb.append(newLine + indent2 + "Method name: " + me.getName());
                                        if (me.getParms() != null) {
                                            sb.append(newLine + indent2 + "Method signature = " + me.getParms());
                                        } else {
                                            sb.append(newLine + indent2 + "Method signature = null");
                                        }
                                        sb.append(newLine + indent2 + "Method interface type: " + methodInterfaceTypeMap[meType]);
                                    }
                                    if (isUnchecked) {
                                        sb.append(newLine + indent3 + "Style 2 - Permit all roles.");
                                        permitAll[k] = true;
                                        continue;
                                    }
                                    if (securityRoles[k] == null) {
                                        securityRoles[k] = new ArrayList();
                                    }
                                    for (SecurityRole role : roles) {
                                        sb.append(newLine + indent3 + "Style 2 - assigning role " + role);
                                        securityRoles[k].add(role.getRoleName());
                                    }
                                }
                                continue;
                            }
                            if (!me.isUnspecified() && meType != type) continue;
                            for (k = 0; k < methodNames.length; ++k) {
                                if (!meName.equals(methodNames[k])) continue;
                                String meParms = me.getParms();
                                if (meParms == null) {
                                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                        if (meEnterpriseBean != null) {
                                            sb.append(newLine + indent2 + "Enterprise Bean Name: " + meEnterpriseBean.getName());
                                        }
                                        sb.append(newLine + indent2 + "Method name: " + me.getName());
                                        if (me.getParms() != null) {
                                            sb.append(newLine + indent2 + "Method signature = " + me.getParms());
                                        } else {
                                            sb.append(newLine + indent2 + "Method signature = null");
                                        }
                                        sb.append(newLine + indent2 + "Method interface type: " + methodInterfaceTypeMap[meType]);
                                    }
                                    if (isUnchecked) {
                                        sb.append(newLine + indent3 + "Style 3 - Permit all roles.");
                                        permitAll[k] = true;
                                        continue;
                                    }
                                    if (securityRoles[k] == null) {
                                        securityRoles[k] = new ArrayList();
                                    }
                                    for (SecurityRole role : roles) {
                                        sb.append(newLine + indent3 + "Style 3 - assigning role " + role);
                                        securityRoles[k].add(role.getRoleName());
                                    }
                                    continue;
                                }
                                if (!(meParms = MethodAttribUtils.normalizeSignature(meParms.trim())).equals(methodSignatures[k])) continue;
                                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                    if (meEnterpriseBean != null) {
                                        sb.append(newLine + indent2 + "Enterprise Bean Name: " + meEnterpriseBean.getName());
                                    }
                                    sb.append(newLine + indent2 + "Method name: " + me.getName());
                                    if (me.getParms() != null) {
                                        sb.append(newLine + indent2 + "Method signature = " + me.getParms());
                                    } else {
                                        sb.append(newLine + indent2 + "Method signature = null");
                                    }
                                    sb.append(newLine + indent2 + "Method interface type: " + methodInterfaceTypeMap[meType]);
                                }
                                if (isUnchecked) {
                                    sb.append(newLine + indent3 + "Style 4 - Permit all roles.");
                                    permitAll[k] = true;
                                    continue;
                                }
                                if (securityRoles[k] == null) {
                                    securityRoles[k] = new ArrayList();
                                }
                                for (SecurityRole role : roles) {
                                    sb.append(newLine + indent3 + "Style 4 - assigning role " + role);
                                    securityRoles[k].add(role.getRoleName());
                                }
                            }
                        }
                    }
                }
                Object var27_30 = null;
            }
            catch (Throwable throwable) {
                Object var27_31 = null;
                if (TraceComponent.isAnyTracingEnabled()) {
                    if (tc.isDebugEnabled() && sb != null) {
                        Tr.debug(tc, sb.toString());
                    }
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "getXMLPermissions " + Arrays.toString(securityRoles) + " PermitAll = " + Arrays.toString(permitAll));
                    }
                }
                throw throwable;
            }
            if (!TraceComponent.isAnyTracingEnabled()) break block49;
            if (tc.isDebugEnabled() && sb != null) {
                Tr.debug(tc, sb.toString());
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getXMLPermissions " + Arrays.toString(securityRoles) + " PermitAll = " + Arrays.toString(permitAll));
            }
        }
    }

    public static final void getActivitySessions(ActivitySessionAttribute[] asAttrs, int type, String[] methodNames, String[] methodSignatures, List asAttrList, String ejbName, boolean usesBeanManagedAS) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "getActivitySessions", asAttrs);
        }
        if (!usesBeanManagedAS) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Bean is CMAS");
            }
            if (asAttrList != null) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "asAttrList non-null");
                }
                int[] highestStyleOnMethod = new int[methodNames.length];
                for (int i = 0; i < asAttrList.size(); ++i) {
                    ActivitySessionMethod asMethod = (ActivitySessionMethod)asAttrList.get(i);
                    ActivitySessionAttribute asAttr = asMethod.getActivitySessionAttribute();
                    List methodElements = asMethod.getMethodElements();
                    for (int j = 0; j < methodElements.size(); ++j) {
                        int k;
                        MethodElement me = (MethodElement)methodElements.get(j);
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            Tr.debug(tc, "MethodElement EnterpriseBean name:", me.getEnterpriseBean());
                            Tr.debug(tc, "MethodElement method name:", me.getName());
                            Tr.debug(tc, "MethodElement method parms:", me.getParms());
                            if (me.isUnspecified()) {
                                Tr.debug(tc, "Interface type unspecified");
                            } else {
                                Tr.debug(tc, "Interface type specified");
                                Tr.debug(tc, "Interface type:", new Integer(me.getType().getValue()));
                            }
                        }
                        if (!me.getEnterpriseBean().getName().equals(ejbName)) continue;
                        String meName = me.getName().trim();
                        if (meName.equals("*")) {
                            if (me.isUnspecified()) {
                                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                    Tr.debug(tc, "Style type 1 - all bean methods:", asAttr);
                                }
                                for (k = 0; k < methodNames.length; ++k) {
                                    if (highestStyleOnMethod[k] > 1) continue;
                                    asAttrs[k] = asAttr;
                                    highestStyleOnMethod[k] = 1;
                                }
                                continue;
                            }
                            if (me.getType().getValue() != type) continue;
                            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                Tr.debug(tc, "Style type 2 - home/remote methods only:", asAttr);
                            }
                            for (k = 0; k < methodNames.length; ++k) {
                                if (highestStyleOnMethod[k] > 2) continue;
                                asAttrs[k] = asAttr;
                                highestStyleOnMethod[k] = 2;
                            }
                            continue;
                        }
                        if (!me.isUnspecified() && me.getType().getValue() != type) continue;
                        for (k = 0; k < methodNames.length; ++k) {
                            if (!meName.equals(methodNames[k])) continue;
                            String meParms = me.getParms();
                            if (meParms == null) {
                                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                    Tr.debug(tc, "Style type 3 - method name only:", asAttr);
                                }
                                if (highestStyleOnMethod[k] > 3) continue;
                                asAttrs[k] = asAttr;
                                highestStyleOnMethod[k] = 3;
                                continue;
                            }
                            if (!(meParms = MethodAttribUtils.normalizeSignature(meParms.trim())).equals(methodSignatures[k])) continue;
                            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                Tr.debug(tc, "Style type 4 - method name and signature:", asAttr);
                            }
                            asAttrs[k] = asAttr;
                            highestStyleOnMethod[k] = 4;
                        }
                    }
                }
            }
        } else if (usesBeanManagedAS) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Bean is BMAS -- all methods will be set to AS_BEAN_MANAGED");
            }
            for (int i = 0; i < asAttrs.length; ++i) {
                asAttrs[i] = ActivitySessionAttribute.AS_BEAN_MANAGED;
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "getActivitySessions");
        }
    }

    public static final void getIsolationLevels(int[] isoLevels, int type, String[] methodNames, String[] methodSignatures, List isoLevelList, EnterpriseBean enterpriseBean) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "getIsolationLevels");
        }
        if (isoLevelList != null) {
            int[] highestStyleOnMethod = new int[methodNames.length];
            for (int i = 0; i < isoLevelList.size(); ++i) {
                IsolationLevelAttributes isolationLevel = (IsolationLevelAttributes)isoLevelList.get(i);
                int isoLevel = isolationLevel.getIsolationLevel().getValue();
                EList methodElements = isolationLevel.getMethodElements();
                for (int j = 0; j < methodElements.size(); ++j) {
                    int k;
                    MethodElement me = (MethodElement)methodElements.get(j);
                    if (me.getEnterpriseBean() != enterpriseBean) continue;
                    String meName = me.getName().trim();
                    if (meName.equals("*")) {
                        if (me.isUnspecified()) {
                            for (k = 0; k < methodNames.length; ++k) {
                                if (highestStyleOnMethod[k] > 1) continue;
                                isoLevels[k] = isoLevelMOFMap[isoLevel];
                                highestStyleOnMethod[k] = 1;
                            }
                            continue;
                        }
                        if (me.getType().getValue() != type) continue;
                        for (k = 0; k < methodNames.length; ++k) {
                            if (highestStyleOnMethod[k] > 2) continue;
                            isoLevels[k] = isoLevelMOFMap[isoLevel];
                            highestStyleOnMethod[k] = 2;
                        }
                        continue;
                    }
                    if (!me.isUnspecified() && me.getType().getValue() != type) continue;
                    for (k = 0; k < methodNames.length; ++k) {
                        if (!meName.equals(methodNames[k])) continue;
                        String meParms = me.getParms();
                        if (meParms == null) {
                            if (highestStyleOnMethod[k] > 3) continue;
                            isoLevels[k] = isoLevelMOFMap[isoLevel];
                            highestStyleOnMethod[k] = 3;
                            continue;
                        }
                        if (!(meParms = MethodAttribUtils.normalizeSignature(meParms.trim())).equals(methodSignatures[k])) continue;
                        isoLevels[k] = isoLevelMOFMap[isoLevel];
                        highestStyleOnMethod[k] = 4;
                    }
                }
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "getIsolationLevels");
        }
    }

    public static final void getReadOnlyAttributes(boolean[] readOnlyAttrs, int type, String[] methodNames, String[] methodSignatures, List accessIntentList, EnterpriseBean enterpriseBean) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "getReadOnlyAttributes");
        }
        if (accessIntentList != null) {
            int[] highestStyleOnMethod = new int[methodNames.length];
            for (int i = 0; i < accessIntentList.size(); ++i) {
                AccessIntent intent = (AccessIntent)accessIntentList.get(i);
                boolean roa = intent.getIntentType().getValue() == 0;
                EList methodElements = intent.getMethodElements();
                for (int j = 0; j < methodElements.size(); ++j) {
                    int k;
                    MethodElement me = (MethodElement)methodElements.get(j);
                    if (me.getEnterpriseBean() != enterpriseBean) continue;
                    String meName = me.getName().trim();
                    if (meName.equals("*")) {
                        if (me.isUnspecified()) {
                            for (k = 0; k < methodNames.length; ++k) {
                                if (highestStyleOnMethod[k] > 1) continue;
                                readOnlyAttrs[k] = roa;
                                highestStyleOnMethod[k] = 1;
                            }
                            continue;
                        }
                        if (me.getType().getValue() != type) continue;
                        for (k = 0; k < methodNames.length; ++k) {
                            if (highestStyleOnMethod[k] > 2) continue;
                            readOnlyAttrs[k] = roa;
                            highestStyleOnMethod[k] = 2;
                        }
                        continue;
                    }
                    if (!me.isUnspecified() && me.getType().getValue() != type) continue;
                    for (k = 0; k < methodNames.length; ++k) {
                        if (!meName.equals(methodNames[k])) continue;
                        String meParms = me.getParms();
                        if (meParms == null) {
                            if (highestStyleOnMethod[k] > 3) continue;
                            readOnlyAttrs[k] = roa;
                            highestStyleOnMethod[k] = 3;
                            continue;
                        }
                        if (!(meParms = MethodAttribUtils.normalizeSignature(meParms.trim())).equals(methodSignatures[k])) continue;
                        readOnlyAttrs[k] = roa;
                        highestStyleOnMethod[k] = 4;
                    }
                }
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "getReadOnlyAttributes");
        }
    }

    public static final void checkTxAttrs(TransactionAttribute[] txAttrs, String[] methodNames, String[] methodSignatures, String[] checkedNames, String[] checkedSignatures, TransactionAttribute prescribedAttr) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "checkTxAttrs");
        }
        block0: for (int i = 0; i < methodNames.length; ++i) {
            for (int j = 0; j < checkedNames.length; ++j) {
                if (!((methodNames[i].equals(checkedNames[j]) && methodSignatures[i].equals(checkedSignatures[j])) | checkedNames[j].equals("*"))) continue;
                txAttrs[i] = prescribedAttr;
                continue block0;
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "checkTxAttrs");
        }
    }

    public static final void chkBMTFromXML(List tranAttrList, EnterpriseBean enterpriseBean, J2EEName j2eeName) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "chkBMTFromXML");
        }
        if (tranAttrList != null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "tranAttrList non-null");
            }
            for (int i = 0; i < tranAttrList.size(); ++i) {
                MethodTransaction methodTransaction = (MethodTransaction)tranAttrList.get(i);
                EList methodElements = methodTransaction.getMethodElements();
                for (int j = 0; j < methodElements.size(); ++j) {
                    MethodElement me = (MethodElement)methodElements.get(j);
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug(tc, "MethodElement EnterpriseBean name:", me.getEnterpriseBean());
                        Tr.debug(tc, "MethodElement method name:", me.getName());
                        Tr.debug(tc, "MethodElement method parms:", me.getParms());
                        if (me.isUnspecified()) {
                            Tr.debug(tc, "Interface type unspecified");
                        } else {
                            Tr.debug(tc, "Interface type specified");
                            Tr.debug(tc, "Interface type:", new Integer(me.getType().getValue()));
                        }
                    }
                    if (me.getEnterpriseBean() != enterpriseBean) continue;
                    Tr.warning(tc, "BMT_DEFINES_CMT_ATTRIBUTES_CNTR0067W", new Object[]{j2eeName});
                }
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "chkBMTFromXML");
        }
    }

    public static final void chkBMTFromAnnotations(Method[] beanMethods, J2EEName j2eeName) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "chkBMTFromAnnotations");
        }
        javax.ejb.TransactionAttribute methTranAttr = null;
        for (int i = 0; i < beanMethods.length; ++i) {
            if (beanMethods[i] == null) continue;
            methTranAttr = beanMethods[i].getAnnotation(javax.ejb.TransactionAttribute.class);
            if (methTranAttr == null) {
                methTranAttr = beanMethods[i].getDeclaringClass().getAnnotation(javax.ejb.TransactionAttribute.class);
            }
            if (methTranAttr == null) continue;
            Tr.warning(tc, "BMT_DEFINES_CMT_ATTRIBUTES_CNTR0067W", new Object[]{j2eeName});
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "chkBMTFromAnnotations");
        }
    }

    public static final void chkBMASFromXML(List asAttrList, EnterpriseBean enterpriseBean, J2EEName j2eeName) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "chkBMAS");
        }
        if (enterpriseBean != null && asAttrList != null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "asAttrList non-null");
            }
            for (int i = 0; i < asAttrList.size(); ++i) {
                ActivitySessionMethod asMethod = (ActivitySessionMethod)asAttrList.get(i);
                List methodElements = asMethod.getMethodElements();
                for (int j = 0; j < methodElements.size(); ++j) {
                    MethodElement me = (MethodElement)methodElements.get(j);
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug(tc, "MethodElement EnterpriseBean name:", me.getEnterpriseBean());
                        Tr.debug(tc, "MethodElement method name:", me.getName());
                        Tr.debug(tc, "MethodElement method parms:", me.getParms());
                        if (me.isUnspecified()) {
                            Tr.debug(tc, "Interface type unspecified");
                        } else {
                            Tr.debug(tc, "Interface type specified");
                            Tr.debug(tc, "Interface type:", new Integer(me.getType().getValue()));
                        }
                    }
                    if (me.getEnterpriseBean() != enterpriseBean) continue;
                    Tr.warning(tc, "BMAS_DEFINES_CMAS_ATTRIBUTES_CNTR0068W", new Object[]{j2eeName});
                }
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "chkBMAS");
        }
    }

    public static final String normalizeSignature(String deplDescriptorSignature) {
        StringBuffer theSignature = new StringBuffer(deplDescriptorSignature);
        int scanIndex = 0;
        while (scanIndex < theSignature.length()) {
            if (theSignature.charAt(scanIndex) == ' ') {
                char next = theSignature.charAt(scanIndex + 1);
                if (next == ' ' | next == '[' | next == ']') {
                    theSignature.deleteCharAt(scanIndex);
                    continue;
                }
                ++scanIndex;
                continue;
            }
            ++scanIndex;
        }
        return theSignature.toString();
    }

    public static final String methodSignature(MethodElement methodElement) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "methodSignature", methodElement.getName());
        }
        String methodSig = methodElement.getName() + METHOD_ARGLIST_SEP + methodElement.getParms();
        methodSig = methodSig.trim();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "methodSignature", methodSig);
        }
        return methodSig;
    }

    public static final String methodSignature(Method method) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "methodSignature", method.getName());
        }
        StringBuffer sb = new StringBuffer();
        sb.append(method.getName());
        sb.append(METHOD_ARGLIST_SEP);
        Class<?>[] methodParams = method.getParameterTypes();
        for (int j = 0; j < methodParams.length; ++j) {
            if (j != 0) {
                sb.append(",");
            }
            if (methodParams[j].isArray()) {
                sb.append(MethodAttribUtils.convertArraySignature(methodParams[j].getName()));
                continue;
            }
            sb.append(methodParams[j].getName());
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "methodSignature", sb.toString());
        }
        return sb.toString();
    }

    public static final String convertArraySignature(String theJavaSignature) {
        StringBuffer sb = new StringBuffer();
        int dimensionCount = 0;
        while (theJavaSignature.charAt(dimensionCount) == '[') {
            ++dimensionCount;
        }
        switch (theJavaSignature.charAt(dimensionCount)) {
            case 'B': {
                sb.append("byte[]");
                break;
            }
            case 'C': {
                sb.append("char[]");
                break;
            }
            case 'D': {
                sb.append("double[]");
                break;
            }
            case 'F': {
                sb.append("float[]");
                break;
            }
            case 'I': {
                sb.append("int[]");
                break;
            }
            case 'J': {
                sb.append("long[]");
                break;
            }
            case 'L': {
                sb.append(theJavaSignature.substring(dimensionCount + 1, theJavaSignature.length() - 1));
                sb.append("[]");
                break;
            }
            case 'S': {
                sb.append("short[]");
                break;
            }
            case 'Z': {
                sb.append("boolean[]");
            }
        }
        while (--dimensionCount > 0) {
            sb.append("[]");
        }
        return sb.toString();
    }

    public static final String methodSignatureOnly(Method method) {
        StringBuffer sb = new StringBuffer();
        Class<?>[] methodParams = method.getParameterTypes();
        for (int j = 0; j < methodParams.length; ++j) {
            if (j != 0) {
                sb.append(" ");
            }
            if (methodParams[j].isArray()) {
                sb.append(MethodAttribUtils.convertArraySignature(methodParams[j].getName()));
                continue;
            }
            sb.append(methodParams[j].getName());
        }
        return sb.toString();
    }

    public static final String mapTypeToJDIEncoding(Class type) {
        String typeName = type.getName();
        String returnValue = type.isArray() ? typeName.replace('.', '/') : (typeName.indexOf(46) > 0 ? "L" + typeName.replace('.', '/') + ";" : (typeName.equals("void") ? "V" : (typeName.equals("boolean") ? "Z" : (typeName.equals("int") ? "I" : (typeName.equals("long") ? "J" : (typeName.equals("double") ? "D" : (typeName.equals("float") ? "F" : (typeName.equals("char") ? "C" : (typeName.equals("byte") ? "B" : (typeName.equals("short") ? "S" : "L" + typeName + ";"))))))))));
        return returnValue;
    }

    public static final String jdiMethodSignature(Method method) {
        StringBuffer sb = new StringBuffer();
        Class<?>[] methodParams = method.getParameterTypes();
        sb.append("(");
        for (int j = 0; j < methodParams.length; ++j) {
            sb.append(MethodAttribUtils.mapTypeToJDIEncoding(methodParams[j]));
        }
        sb.append(")");
        sb.append(MethodAttribUtils.mapTypeToJDIEncoding(method.getReturnType()));
        return sb.toString();
    }

    public static final boolean methodsEqual(Method remoteMethod, Method beanMethod) {
        Class<?>[] beanMethodParamTypes;
        if (remoteMethod == null || beanMethod == null) {
            return false;
        }
        if (!remoteMethod.getName().equals(beanMethod.getName())) {
            return false;
        }
        Class<?>[] remoteMethodParamTypes = remoteMethod.getParameterTypes();
        if (remoteMethodParamTypes.length != (beanMethodParamTypes = beanMethod.getParameterTypes()).length) {
            return false;
        }
        for (int i = 0; i < remoteMethodParamTypes.length; ++i) {
            if (remoteMethodParamTypes[i].equals(beanMethodParamTypes[i])) continue;
            return false;
        }
        return true;
    }

    public static final boolean homeMethodEquals(Method homeMethod, Properties beanMethodProps) {
        String[] beanMethodParamTypes;
        String beanMethodName;
        if (homeMethod == null || beanMethodProps == null) {
            return false;
        }
        String homeMethodName = homeMethod.getName();
        if (!homeMethodName.equals(beanMethodName = (String)beanMethodProps.get("Name"))) {
            return false;
        }
        Class<?>[] homeMethodParamTypes = homeMethod.getParameterTypes();
        if (homeMethodParamTypes.length != (beanMethodParamTypes = (String[])beanMethodProps.get("ArgumentTypes")).length) {
            return false;
        }
        for (int i = 0; i < homeMethodParamTypes.length; ++i) {
            if (homeMethodParamTypes[i].getName().equals(beanMethodParamTypes[i])) continue;
            return false;
        }
        return true;
    }

    public static final String getIsolationLevelString(int isolationLevel) {
        if (isolationLevel >= 0 && isolationLevel < ISOLATION_STR.length) {
            return ISOLATION_STR[isolationLevel];
        }
        return "-- ILLEGAL ISOLATION LEVEL --";
    }

    private static final void populateIsoStringMap() {
        ISOLATION_STR = new String[9];
        for (int i = 0; i < ISOLATION_STR.length; ++i) {
            MethodAttribUtils.ISOLATION_STR[i] = "-- ILLEGAL ISOLATION LEVEL --";
        }
        MethodAttribUtils.ISOLATION_STR[1] = "TRANSACTION_READ_UNCOMMITTED";
        MethodAttribUtils.ISOLATION_STR[2] = "TRANSACTION_READ_COMMITTED";
        MethodAttribUtils.ISOLATION_STR[4] = "TRANSACTION_REPEATABLE_READ";
        MethodAttribUtils.ISOLATION_STR[8] = "TRANSACTION_SERIALIZABLE";
        MethodAttribUtils.ISOLATION_STR[0] = "TRANSACTION_NONE";
    }

    private static final void populateTxMofMap() {
        txMOFMap = new TransactionAttribute[7];
        MethodAttribUtils.txMOFMap[0] = TransactionAttribute.TX_NOT_SUPPORTED;
        MethodAttribUtils.txMOFMap[1] = TransactionAttribute.TX_SUPPORTS;
        MethodAttribUtils.txMOFMap[2] = TransactionAttribute.TX_REQUIRED;
        MethodAttribUtils.txMOFMap[3] = TransactionAttribute.TX_REQUIRES_NEW;
        MethodAttribUtils.txMOFMap[4] = TransactionAttribute.TX_MANDATORY;
        MethodAttribUtils.txMOFMap[5] = TransactionAttribute.TX_NEVER;
    }

    private static final void populateTxAttrFromJEE15Map() {
        txAttrFromJEE15Map = new TransactionAttribute[6];
        MethodAttribUtils.txAttrFromJEE15Map[TransactionAttributeType.NOT_SUPPORTED.ordinal()] = TransactionAttribute.TX_NOT_SUPPORTED;
        MethodAttribUtils.txAttrFromJEE15Map[TransactionAttributeType.SUPPORTS.ordinal()] = TransactionAttribute.TX_SUPPORTS;
        MethodAttribUtils.txAttrFromJEE15Map[TransactionAttributeType.REQUIRED.ordinal()] = TransactionAttribute.TX_REQUIRED;
        MethodAttribUtils.txAttrFromJEE15Map[TransactionAttributeType.REQUIRES_NEW.ordinal()] = TransactionAttribute.TX_REQUIRES_NEW;
        MethodAttribUtils.txAttrFromJEE15Map[TransactionAttributeType.MANDATORY.ordinal()] = TransactionAttribute.TX_MANDATORY;
        MethodAttribUtils.txAttrFromJEE15Map[TransactionAttributeType.NEVER.ordinal()] = TransactionAttribute.TX_NEVER;
    }

    private static final void populateIsoLevelMOFMap() {
        isoLevelMOFMap = new int[5];
        MethodAttribUtils.isoLevelMOFMap[2] = 1;
        MethodAttribUtils.isoLevelMOFMap[1] = 2;
        MethodAttribUtils.isoLevelMOFMap[0] = 4;
        MethodAttribUtils.isoLevelMOFMap[3] = 8;
    }

    static {
        MethodAttribUtils.populateTxMofMap();
        MethodAttribUtils.populateTxAttrFromJEE15Map();
        MethodAttribUtils.populateIsoLevelMOFMap();
        MethodAttribUtils.populateIsoStringMap();
        newLine = ContainerProperties.LineSeparator;
        TX_ATTR_STR = new String[]{"TX_NOT_SUPPORTED", "TX_BEAN_MANAGED", "TX_REQUIRED", "TX_SUPPORTS", "TX_REQUIRES_NEW", "TX_MANDATORY", "TX_NEVER"};
        methodInterfaceTypeMap = EJBMethodInterfaceType.values();
    }
}

