/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.container.passivator;

import com.ibm.ejs.container.BeanId;
import com.ibm.ejs.container.BeanMetaData;
import com.ibm.ejs.container.EJSContainer;
import com.ibm.ejs.container.StatefulBeanO;
import com.ibm.ejs.container.drs.SfDRSCache;
import com.ibm.ejs.container.passivator.EJBObjectInfo;
import com.ibm.ejs.container.passivator.NewInputStream;
import com.ibm.ejs.container.passivator.NewOutputStream;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.util.dopriv.SetAccessiblePrivilegedAction;
import com.ibm.websphere.csi.CSIException;
import com.ibm.websphere.csi.RemoveCollaborator;
import com.ibm.websphere.csi.SessionBeanStore;
import com.ibm.websphere.csi.StreamUnavailableException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.jpa.JPAExPcBindingContext;
import com.ibm.ws.security.auth.j2c.WSLoginLocalOSExtension;
import com.ibm.ws.security.auth.j2c.WSLoginLocalOSExtensionFactory;
import com.ibm.ws.security.util.AccessController;
import com.ibm.ws.security.util.ServerIdentityHelper;
import com.ibm.ws.util.PlatformHelperFactory;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.rmi.NoSuchObjectException;
import java.rmi.RemoteException;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

public class StatefulPassivator {
    private static final TraceComponent tc = Tr.register(StatefulPassivator.class, "EJBContainer", "com.ibm.ejs.container.container");
    private static final String CLASS_NAME = "com.ibm.ejs.container.passivator.StatefulPassivator";
    private static final boolean isZOS = PlatformHelperFactory.getPlatformHelper().isZOS();
    private SessionBeanStore ivBeanStore;
    private RemoveCollaborator[] ivRemoveCollaborators;
    private EJSContainer ivContainer;
    private boolean ivTerminating = false;
    private Object ivActivateLock;
    private Object ivPassivateLock;
    private Object ivRemoveLock;
    private SfDRSCache ivStatefulDRSCache;

    public StatefulPassivator(SessionBeanStore beanStore, RemoveCollaborator[] removeCollaborators, EJSContainer container2, SfDRSCache drsCache) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "StatefulPassivator");
        }
        this.ivBeanStore = beanStore;
        this.ivRemoveCollaborators = removeCollaborators;
        this.ivContainer = container2;
        this.ivStatefulDRSCache = drsCache;
        this.ivActivateLock = new Object();
        this.ivPassivateLock = new Object();
        this.ivRemoveLock = new Object();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "StatefulPassivator");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void passivate(Object obj) throws RemoteException {
        block42: {
            block40: {
                block41: {
                    if (TraceComponent.isAnyTracingEnabled() && StatefulPassivator.tc.isEntryEnabled()) {
                        Tr.entry(StatefulPassivator.tc, "passivate", obj);
                    }
                    syncToThread = false;
                    beanO = (StatefulBeanO)obj;
                    if (beanO.isRemoved() || this.isTerminating()) {
                        if (TraceComponent.isAnyTracingEnabled() == false) return;
                        if (StatefulPassivator.tc.isEventEnabled() == false) return;
                        Tr.event(StatefulPassivator.tc, "Bean removed!");
                        return;
                    }
                    bid = beanO.getId();
                    sb = beanO.ivEjbInstance;
                    exceptionCaught = false;
                    beanStream = null;
                    if (StatefulPassivator.isZOS) {
                        localSecurityLoginExt = WSLoginLocalOSExtensionFactory.getInstance();
                        syncToThread = localSecurityLoginExt.isApplicationSyncToOSThreadEnabled();
                    }
                    if (this.ivRemoveCollaborators != null) {
                        for (i = 0; i < this.ivRemoveCollaborators.length; ++i) {
                            this.ivRemoveCollaborators[i].passivate(bid);
                        }
                    }
                    credToken = null;
                    if (StatefulPassivator.isZOS && syncToThread) {
                        credToken = ServerIdentityHelper.getServerIdentityHelper().push();
                    }
                    beanStream2 = null;
                    exPC = beanO.getJPAExPcBindingContext();
                    try {
                        try {
                            baos = null;
                            lastAccessTime = beanO.getLastAccessTime();
                            var14_16 = this.ivPassivateLock;
                            synchronized (var14_16) {
                                block45: {
                                    block44: {
                                        if (!beanO.sfsbFailoverEnabled()) break block44;
                                        if (TraceComponent.isAnyTracingEnabled() && StatefulPassivator.tc.isDebugEnabled()) {
                                            Tr.debug(StatefulPassivator.tc, "failover is enabled");
                                        }
                                        if (this.getEJBModuleVersion(beanO) >= 30) {
                                            baos = new ByteArrayOutputStream(1024);
                                            beanStream = new NewOutputStream(new GZIPOutputStream(baos), this.ivContainer);
                                            break block45;
                                        } else {
                                            if (TraceComponent.isAnyTracingEnabled() && StatefulPassivator.tc.isDebugEnabled()) {
                                                Tr.debug(StatefulPassivator.tc, "processing EJB 2.1 module or prior");
                                            }
                                            bytes = this.getCompressedBytes(sb, lastAccessTime, exPC);
                                            ostream = this.ivBeanStore.getOutputStream(bid);
                                            beanStream = new NewOutputStream(ostream, this.ivContainer);
                                            beanStream.writeInt(bytes.length);
                                            if (TraceComponent.isAnyTracingEnabled() && StatefulPassivator.tc.isDebugEnabled()) {
                                                Tr.debug(StatefulPassivator.tc, "length of compressed bytes is: " + bytes.length);
                                            }
                                            beanStream.write(bytes);
                                            beanStream.close();
                                            beanO.updateDRSEntry(bytes, lastAccessTime);
                                            // MONITOREXIT @DISABLED, blocks:[0, 1, 6, 38] lbl50 : MonitorExitStatement: MONITOREXIT : var14_16
                                            var24_21 = null;
                                            if (!StatefulPassivator.isZOS || !syncToThread) break block40;
                                            break block41;
                                        }
                                    }
                                    if (TraceComponent.isAnyTracingEnabled() && StatefulPassivator.tc.isDebugEnabled()) {
                                        Tr.debug(StatefulPassivator.tc, "failover is NOT enabled");
                                    }
                                    beanStream = new NewOutputStream(this.ivBeanStore.getGZIPOutputStream(bid), this.ivContainer);
                                }
                                objectInfo = null;
                                objectInfo = sb instanceof Serializable != false ? this.createSerializableObjectInfo(sb) : this.createNonSerializableObjectInfo(sb);
                                beanStream.writeLong(lastAccessTime);
                                beanStream.writeObject(exPC);
                                beanStream.writeObject(objectInfo);
                                interceptors = beanO.ivInterceptors;
                                if (interceptors == null) {
                                    beanStream.writeInt(-1);
                                } else {
                                    if (TraceComponent.isAnyTracingEnabled() && StatefulPassivator.tc.isDebugEnabled()) {
                                        Tr.debug(StatefulPassivator.tc, "Processing " + interceptors.length + " interceptors");
                                    }
                                    beanStream.writeInt(interceptors.length);
                                    for (Object interceptor : interceptors) {
                                        interceptorObjectInfo = null;
                                        interceptorObjectInfo = interceptor instanceof Serializable != false ? this.createSerializableObjectInfo(interceptor) : this.createNonSerializableObjectInfo(interceptor);
                                        beanStream.writeObject(interceptorObjectInfo);
                                    }
                                }
                                beanStream.close();
                                if (beanO.sfsbFailoverEnabled() && baos != null) {
                                    bytes = baos.toByteArray();
                                    beanStream2 = new NewOutputStream(this.ivBeanStore.getOutputStream(bid), this.ivContainer);
                                    beanStream2.writeInt(bytes.length);
                                    beanStream2.write(bytes);
                                    beanStream2.close();
                                    beanO.updateDRSEntry(bytes, lastAccessTime);
                                }
                                break block42;
                            }
                        }
                        catch (CSIException ex) {
                            exceptionCaught = true;
                            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ejs.container.passivator.StatefulPassivator.passivate", (String)"113", (Object)this);
                            throw new RemoteException("passivation failed", ex);
                        }
                        catch (Exception e) {
                            exceptionCaught = true;
                            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ejs.container.passivator.StatefulPassivator.passivate", (String)"107", (Object)this);
                            Tr.warning(StatefulPassivator.tc, "CANNOT_PASSIVATE_STATEFUL_BEAN_CNTR0001W", new Object[]{obj.toString(), this, e});
                            throw new RemoteException("passivation failed", e);
                        }
                    }
                    catch (Throwable var23_35) {
                        var24_23 = null;
                        if (StatefulPassivator.isZOS && syncToThread) {
                            ServerIdentityHelper.getServerIdentityHelper().pop(credToken);
                        }
                        if (exceptionCaught == false) throw var23_35;
                        try {
                            if (beanStream != null) {
                                beanStream.close();
                                var25_28 = this.ivRemoveLock;
                                synchronized (var25_28) {
                                    this.ivBeanStore.remove(bid);
                                }
                            }
                            if (beanStream2 == null) throw var23_35;
                            beanStream2.close();
                            throw var23_35;
                        }
                        catch (Exception ex) {
                            // empty catch block
                        }
                        throw var23_35;
                    }
                }
                ServerIdentityHelper.getServerIdentityHelper().pop(credToken);
            }
            if (exceptionCaught == false) return;
            ** try [egrp 4[TRYBLOCK] [12 : 863->919)] { 
lbl118:
            // 1 sources

            if (beanStream != null) {
                beanStream.close();
                var25_24 = this.ivRemoveLock;
                synchronized (var25_24) {
                    this.ivBeanStore.remove(bid);
                }
            }
            if (beanStream2 == null) return;
            beanStream2.close();
            return;
lbl126:
            // 1 sources

            catch (Exception ex) {
                // empty catch block
            }
            return;
        }
        var24_22 = null;
        if (StatefulPassivator.isZOS && syncToThread) {
            ServerIdentityHelper.getServerIdentityHelper().pop(credToken);
        }
        if (exceptionCaught) {
            try {}
            catch (Exception ex) {}
            if (beanStream != null) {
                beanStream.close();
                var25_26 = this.ivRemoveLock;
                synchronized (var25_26) {
                    this.ivBeanStore.remove(bid);
                }
            }
            if (beanStream2 != null) {
                beanStream2.close();
            }
        }
        if (TraceComponent.isAnyTracingEnabled() == false) return;
        if (StatefulPassivator.tc.isEntryEnabled() == false) return;
        Tr.exit(StatefulPassivator.tc, "passivate");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void activate(Object obj, ClassLoader classLoader) throws RemoteException {
        block36: {
            WSLoginLocalOSExtension localSecurityLoginExt;
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.entry(tc, "activate", obj);
            }
            boolean syncToThread = false;
            Object sb = null;
            StatefulBeanO beanO = (StatefulBeanO)obj;
            BeanId bid = beanO.getId();
            Object credToken = null;
            if (isZOS && (syncToThread = (localSecurityLoginExt = WSLoginLocalOSExtensionFactory.getInstance()).isApplicationSyncToOSThreadEnabled())) {
                credToken = ServerIdentityHelper.getServerIdentityHelper().push();
            }
            NewInputStream beanStream = null;
            GZIPInputStream istream = null;
            try {
                try {
                    Object object = this.ivActivateLock;
                    synchronized (object) {
                        JPAExPcBindingContext exPC;
                        if (!beanO.sfsbFailoverEnabled()) {
                            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                Tr.debug(tc, "Failover is NOT enabled");
                            }
                            istream = this.ivBeanStore.getGZIPInputStream(bid);
                            beanStream = new NewInputStream(istream, beanO, classLoader, this.ivContainer);
                        } else {
                            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                Tr.debug(tc, "Failover is enabled");
                            }
                            byte[] data = null;
                            if (this.ivStatefulDRSCache.beanExists(bid)) {
                                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                    Tr.debug(tc, "Retrieving data from DRS cache");
                                }
                                boolean isSticky = this.ivStatefulDRSCache.inStickyUOW(bid);
                                data = this.ivStatefulDRSCache.getAndRemoveData(bid, beanO.ivSfDRSClient);
                                if (isSticky) {
                                    throw new NoSuchObjectException("Bean Managed Transaction is active, SFSB failover not supported");
                                }
                                if (data == null) {
                                    throw new NoSuchObjectException("SFSB replication failed.");
                                }
                            } else {
                                InputStream fis = this.ivBeanStore.getInputStream(bid);
                                NewInputStream beanStream2 = new NewInputStream(fis, beanO, classLoader, this.ivContainer);
                                int n = beanStream2.readInt();
                                data = new byte[n];
                                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                    Tr.debug(tc, "length of compressed bytes is: " + n);
                                }
                                int bytesRead = 0;
                                for (int offset = 0; offset < n; offset += bytesRead) {
                                    bytesRead = beanStream2.read(data, offset, n - offset);
                                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                        Tr.debug(tc, "bytes read from input stream is: " + bytesRead);
                                    }
                                    if (bytesRead != -1) continue;
                                    throw new IOException("end of input stream while reading compressed bytes");
                                }
                                beanStream2.close();
                            }
                            ByteArrayInputStream bais = new ByteArrayInputStream(data);
                            istream = new GZIPInputStream(bais);
                            beanStream = new NewInputStream(istream, beanO, classLoader, this.ivContainer);
                        }
                        if (beanO.sfsbFailoverEnabled() && this.getEJBModuleVersion(beanO) < 30) {
                            long lastAccessTime = beanStream.readLong();
                            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                Tr.debug(tc, "read from data last access time: " + lastAccessTime);
                            }
                            beanO.setLastAccessTime(lastAccessTime);
                            exPC = (JPAExPcBindingContext)beanStream.readObject();
                            beanO.setJPAExPcBindingContext(exPC);
                            sb = beanStream.readObject();
                        } else {
                            long lastAccessTime = beanStream.readLong();
                            exPC = (JPAExPcBindingContext)beanStream.readObject();
                            beanO.setJPAExPcBindingContext(exPC);
                            EJBObjectInfo sbObjectInfo = (EJBObjectInfo)beanStream.readObject();
                            sb = sbObjectInfo.isSerializable() ? sbObjectInfo.getSerializableObject() : this.activateObjectFromInfo(sbObjectInfo, classLoader);
                            int n = beanStream.readInt();
                            if (n == -1) {
                                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                    Tr.debug(tc, "no interceptors");
                                }
                            } else {
                                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                    Tr.debug(tc, "number of interceptors is " + n);
                                }
                                Object[] interceptors = new Object[n];
                                for (int i = 0; i < n; ++i) {
                                    EJBObjectInfo interceptorObjectInfo = (EJBObjectInfo)beanStream.readObject();
                                    interceptors[i] = interceptorObjectInfo.isSerializable() ? interceptorObjectInfo.getSerializableObject() : this.activateObjectFromInfo(interceptorObjectInfo, classLoader);
                                }
                                beanO.setInterceptors(interceptors);
                            }
                            beanO.setLastAccessTime(lastAccessTime);
                        }
                        beanStream.close();
                    }
                    beanO.setEnterpriseBean(sb);
                    object = this.ivRemoveLock;
                    synchronized (object) {
                        this.ivBeanStore.remove(bid);
                    }
                }
                catch (StreamUnavailableException ex) {
                    FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ejs.container.passivator.StatefulPassivator.activate", (String)"146", (Object)this);
                    throw new NoSuchObjectException("");
                }
                catch (CSIException ex) {
                    FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ejs.container.passivator.StatefulPassivator.activate", (String)"149", (Object)this);
                    throw new RemoteException("passivation failed", ex);
                }
                catch (ClassNotFoundException e) {
                    FFDCFilter.processException((Throwable)e, (String)"com.ibm.ejs.container.passivator.StatefulPassivator.activate", (String)"152", (Object)this);
                    Tr.warning(tc, "CANNOT_ACTIVATE_STATEFUL_BEAN_CNTR0003W", new Object[]{obj.toString(), this, e});
                    throw new RemoteException("", e);
                }
                catch (RemoteException rex) {
                    FFDCFilter.processException((Throwable)rex, (String)"com.ibm.ejs.container.passivator.StatefulPassivator.activate", (String)"576", (Object)this);
                    Tr.warning(tc, "CANNOT_ACTIVATE_STATEFUL_BEAN_CNTR0003W", new Object[]{obj.toString(), this, rex});
                    throw rex;
                }
                catch (IOException e) {
                    FFDCFilter.processException((Throwable)e, (String)"com.ibm.ejs.container.passivator.StatefulPassivator.activate", (String)"157", (Object)this);
                    Tr.warning(tc, "CANNOT_ACTIVATE_STATEFUL_BEAN_CNTR0003W", new Object[]{obj.toString(), this, e});
                    throw new RemoteException("", e);
                }
                Object var22_30 = null;
                if (!isZOS || !syncToThread) break block36;
            }
            catch (Throwable throwable) {
                Object var22_31 = null;
                if (isZOS && syncToThread) {
                    ServerIdentityHelper.getServerIdentityHelper().pop(credToken);
                }
                throw throwable;
            }
            ServerIdentityHelper.getServerIdentityHelper().pop(credToken);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "activate");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(BeanId beanId, boolean removeFromDRS) throws RemoteException {
        if (this.ivStatefulDRSCache == null || !this.ivStatefulDRSCache.beanExists(beanId)) {
            Object object = this.ivRemoveLock;
            synchronized (object) {
                this.ivBeanStore.remove(beanId);
            }
        } else if (removeFromDRS) {
            this.ivStatefulDRSCache.removeCacheEntry(beanId);
        }
    }

    public synchronized void terminate() {
        this.ivTerminating = true;
    }

    private synchronized boolean isTerminating() {
        return this.ivTerminating;
    }

    private byte[] getCompressedBytes(Object sb, long lastAccessTime, JPAExPcBindingContext exPC) throws IOException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "getCompressedBytes", sb);
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream(1024);
        GZIPOutputStream gout = new GZIPOutputStream(baos);
        NewOutputStream beanStream2 = new NewOutputStream(gout, this.ivContainer);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "writing DRS data with last access time set to: " + lastAccessTime);
        }
        beanStream2.writeLong(lastAccessTime);
        beanStream2.writeObject(exPC);
        beanStream2.writeObject(sb);
        gout.finish();
        gout.close();
        beanStream2.close();
        byte[] bytes = baos.toByteArray();
        baos.close();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "getCompressedBytes");
        }
        return bytes;
    }

    private EJBObjectInfo createNonSerializableObjectInfo(Object obj) throws RemoteException {
        Class<?> clazz;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "createNonSerializableObjectInfo", obj);
        }
        EJBObjectInfo ejbObjectInfo = new EJBObjectInfo();
        ejbObjectInfo.setSerializable(false);
        ejbObjectInfo.setClassName(clazz.getName());
        for (clazz = obj.getClass(); clazz != Object.class; clazz = clazz.getSuperclass()) {
            Field[] fields;
            ArrayList<EJBObjectInfo.FieldInfo> fieldInfoList = new ArrayList<EJBObjectInfo.FieldInfo>();
            for (Field field : fields = clazz.getDeclaredFields()) {
                int modifiers = field.getModifiers();
                if (Modifier.isStatic(modifiers) || Modifier.isTransient(modifiers)) {
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
                    Tr.debug(tc, "field " + field.getName() + " is static or transient");
                    continue;
                }
                if (!Modifier.isPublic(modifiers)) {
                    try {
                        SetAccessiblePrivilegedAction privilegedFieldAction = new SetAccessiblePrivilegedAction((AccessibleObject)field, true);
                        AccessController.doPrivileged((PrivilegedExceptionAction)privilegedFieldAction);
                    }
                    catch (PrivilegedActionException paex) {
                        FFDCFilter.processException((Throwable)paex, (String)"com.ibm.ejs.container.passivator.StatefulPassivator.<init>", (String)"97", (Object)this);
                        SecurityException ex = (SecurityException)paex.getException();
                        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                            Tr.exit(tc, "<init> : " + ex);
                        }
                        throw ex;
                    }
                }
                EJBObjectInfo.FieldInfo fieldInfo = this.generateFieldInfo(obj, field);
                fieldInfoList.add(fieldInfo);
            }
            ejbObjectInfo.addFieldInfo(clazz.getName(), fieldInfoList);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "createNonSerializableObjectInfo", ejbObjectInfo);
        }
        return ejbObjectInfo;
    }

    private EJBObjectInfo createSerializableObjectInfo(Object parentObj) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "createSerializableObjectInfo", parentObj);
        }
        EJBObjectInfo objectInfo = new EJBObjectInfo();
        objectInfo.setSerializable(true);
        objectInfo.setSerializableObject(parentObj);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "createSerializableObjectInfo", objectInfo);
        }
        return objectInfo;
    }

    private EJBObjectInfo.FieldInfo generateFieldInfo(Object obj, Field field) throws RemoteException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "generateFieldInfo", field);
        }
        EJBObjectInfo.FieldInfo fieldInfo = new EJBObjectInfo.FieldInfo();
        String fieldName = field.getName();
        Object fieldObj = null;
        try {
            fieldObj = field.get(obj);
        }
        catch (IllegalArgumentException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ejs.container.passivator.StatefulPassivator.generateFieldInfo", (String)"851", (Object)this);
            throw new RemoteException("passivation failed", e);
        }
        catch (IllegalAccessException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ejs.container.passivator.StatefulPassivator.generateFieldInfo", (String)"857", (Object)this);
            throw new RemoteException("passivation failed", e);
        }
        fieldInfo.name = fieldName;
        fieldInfo.value = fieldObj;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "generateFieldInfo", fieldInfo);
        }
        return fieldInfo;
    }

    private Object activateObjectFromInfo(EJBObjectInfo ejbObjectInfo, ClassLoader classLoader) throws RemoteException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "activateObjectFromInfo", new Object[]{ejbObjectInfo, classLoader});
        }
        Object obj = null;
        try {
            Class<?> objClass;
            String className = ejbObjectInfo.getClassName();
            obj = objClass.newInstance();
            Map<String, List<EJBObjectInfo.FieldInfo>> fieldInfoMap = ejbObjectInfo.getFieldInfoMap();
            for (objClass = classLoader.loadClass(className); objClass != Object.class; objClass = objClass.getSuperclass()) {
                List<EJBObjectInfo.FieldInfo> fieldInfoList = fieldInfoMap.get(className);
                for (EJBObjectInfo.FieldInfo fieldInfo : fieldInfoList) {
                    Field field = objClass.getDeclaredField(fieldInfo.name);
                    int modifiers = field.getModifiers();
                    if (!Modifier.isPublic(modifiers)) {
                        try {
                            SetAccessiblePrivilegedAction privilegedFieldAction = new SetAccessiblePrivilegedAction((AccessibleObject)field, true);
                            AccessController.doPrivileged((PrivilegedExceptionAction)privilegedFieldAction);
                        }
                        catch (PrivilegedActionException paex) {
                            FFDCFilter.processException((Throwable)paex, (String)"com.ibm.ejs.container.passivator.StatefulPassivator.<init>", (String)"97", (Object)this);
                            SecurityException ex = (SecurityException)paex.getException();
                            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                                Tr.exit(tc, "<init> : " + ex);
                            }
                            throw ex;
                        }
                    }
                    field.set(obj, fieldInfo.value);
                }
                className = objClass.getName();
            }
        }
        catch (Throwable e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ejs.container.passivator.StatefulPassivator.activateObjectFromInfo", (String)"843", (Object)this);
            throw new RemoteException("activation failed", e);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "activateObjectFromInfo", obj);
        }
        return obj;
    }

    private int getEJBModuleVersion(StatefulBeanO beanO) {
        BeanId beanId = beanO.getId();
        BeanMetaData beanMetaData = beanId.getBeanMetaData();
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "EJB module version is " + beanMetaData.ivModuleVersion);
        }
        return beanMetaData.ivModuleVersion;
    }
}

