/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.container.interceptors;

import com.ibm.ejs.container.interceptors.InterceptorProxy;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InterceptorMetaData {
    private static final String CLASS_NAME = InterceptorMetaData.class.getName();
    private static final TraceComponent tc = Tr.register(CLASS_NAME, "EJBContainer", "com.ibm.ejs.container.container");
    public final Class<?>[] ivInterceptorClasses;
    public final InterceptorProxy[] ivAroundInvokeInterceptors;
    public final InterceptorProxy[] ivPrePassivateInterceptors;
    public final InterceptorProxy[] ivPreDestroyInterceptors;
    public final InterceptorProxy[] ivPostConstructInterceptors;
    public final InterceptorProxy[] ivPostActivateInterceptors;

    public InterceptorMetaData(Class<?>[] classes, InterceptorProxy[] aroundInvoke, InterceptorProxy[] postConstruct, InterceptorProxy[] postActivate, InterceptorProxy[] prePassivate, InterceptorProxy[] preDestroy) {
        this.ivInterceptorClasses = classes;
        this.ivAroundInvokeInterceptors = aroundInvoke;
        this.ivPostConstructInterceptors = postConstruct;
        this.ivPostActivateInterceptors = postActivate;
        this.ivPrePassivateInterceptors = prePassivate;
        this.ivPreDestroyInterceptors = preDestroy;
    }

    private InterceptorMetaData() {
        this.ivInterceptorClasses = null;
        this.ivAroundInvokeInterceptors = null;
        this.ivPostConstructInterceptors = null;
        this.ivPostActivateInterceptors = null;
        this.ivPrePassivateInterceptors = null;
        this.ivPreDestroyInterceptors = null;
    }

    public Object[] createInterceptorInstances() throws IllegalAccessException, InstantiationException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "createInterceptorInstances");
        }
        Object[] interceptors = null;
        if (this.ivInterceptorClasses != null) {
            int numberOfInterceptors = this.ivInterceptorClasses.length;
            interceptors = new Object[numberOfInterceptors];
            int i = 0;
            for (Class<?> interceptorClass : this.ivInterceptorClasses) {
                interceptors[i++] = interceptorClass.newInstance();
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "createInterceptorInstances");
        }
        return interceptors;
    }
}

