/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.container.drs.ws390;

import com.ibm.ejs.container.drs.ws390.SfDRSControllerBootstrapImpl;
import com.ibm.ejs.container.drs.ws390.SfDRSControllerCacheMsgListenerImpl;
import com.ibm.ejs.container.drs.ws390.SfDRSControllerDataXferImpl;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.wsspi.drs.DRSControllerDataXfer;
import com.ibm.wsspi.drs.DRSControllerInstance;
import com.ibm.wsspi.drs.DRSControllerInstanceFactoryConfig;
import com.ibm.wsspi.drs.DRSDataXfer;
import com.ibm.wsspi.drs.DRSEventObject;
import com.ibm.wsspi.drs.DRSInstanceToken;
import com.ibm.wsspi.drs.DRSInstanceTokenTable;
import com.ibm.wsspi.drs.DRSServantProxyFactory;
import com.ibm.wsspi.drs.DRSSettings;
import java.util.Map;

public class SfDRSControllerInstanceImpl
implements DRSControllerInstance {
    DRSInstanceTokenTable registerendServants;
    DRSInstanceTokenTable unRegisterendServants;
    DRSServantProxyFactory drsServantProxyFactory;
    SfDRSControllerDataXferImpl ddx;
    DRSDataXfer baseDDX;
    DRSSettings drss;
    String ddxKey;
    Map miscParms;
    SfDRSControllerCacheMsgListenerImpl dcml;
    SfDRSControllerBootstrapImpl db;
    boolean usingHAManager;
    long uniqueInstanceId;
    long instanceId;
    String instanceName;
    String instanceUniqueName;
    private DRSEventObject isUpEvent;
    private DRSEventObject isNotCongestedEvent;
    boolean eventStateReplicationUp;
    boolean eventStateIsCongested;
    private Integer drsStateLock;
    private int unAvailableCount;
    private static final int MAX_UNAVAILABLE_ATTEMPTS = 500;
    private static TraceComponent tc = Tr.register(SfDRSControllerInstanceImpl.class, "EJBDRSCache", "com.ibm.ejs.container.container");
    private static boolean _loggedVersion = false;

    public SfDRSControllerInstanceImpl(String _ddxKey, DRSSettings _drss, Map _misc, boolean _usingHAManager, long _uniqueInstanceId) {
        String m = "SfDRSControllerInstanceImpl.constructor: ";
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "SfDRSControllerInstanceImpl.constructor:  Entry - ddxKey = " + _ddxKey);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled() && !_loggedVersion) {
            Tr.debug(tc, "SfDRSControllerInstanceImpl.constructor: Version 1.9 9/16/07 21:29:57");
            _loggedVersion = true;
        }
        this.ddxKey = _ddxKey;
        this.drss = _drss;
        this.miscParms = _misc;
        this.usingHAManager = _usingHAManager;
        this.uniqueInstanceId = _uniqueInstanceId;
        this.instanceUniqueName = this.ddxKey + ":" + this.uniqueInstanceId;
        this.drsStateLock = new Integer(9472);
        this.unAvailableCount = 0;
        this.isUpEvent = new DRSEventObject(1, (Object)this);
        this.isNotCongestedEvent = new DRSEventObject(4, (Object)this);
        this.eventStateReplicationUp = true;
        this.eventStateIsCongested = false;
        this.ddx = null;
        this.baseDDX = null;
        this.dcml = null;
        this.drsServantProxyFactory = null;
        this.instanceId = 0L;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "SfDRSControllerInstanceImpl.constructor:  ddxKey = " + this.ddxKey);
            Tr.debug(tc, "SfDRSControllerInstanceImpl.constructor:  DRS Settings = " + this.drss);
            Tr.debug(tc, "SfDRSControllerInstanceImpl.constructor:  Misc Parms = " + this.miscParms);
            Tr.debug(tc, "SfDRSControllerInstanceImpl.constructor:  Using HAManager = " + this.usingHAManager);
            Tr.debug(tc, "SfDRSControllerInstanceImpl.constructor:  Unique Instance Id = " + this.uniqueInstanceId);
        }
        this.registerendServants = DRSControllerInstanceFactoryConfig.createDRSInstanceTokenTable((String)("SfDRSControllerInstance" + this.instanceUniqueName), (String)"registerendServants");
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "SfDRSControllerInstanceImpl.constructor:  ddxKey = " + this.ddxKey);
        }
    }

    public void init() {
        String m = "SfDRSControllerInstanceImpl.init: ";
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "SfDRSControllerInstanceImpl.init:  Entry - ddxKey = " + this.ddxKey);
        }
        if (this.usingHAManager) {
            this.instanceId = this.ddx.getInstanceId();
            this.instanceName = this.ddx.getInstanceName();
        } else {
            this.instanceId = this.uniqueInstanceId;
            this.instanceName = this.ddxKey;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "SfDRSControllerInstanceImpl.init:  instanceId = " + this.instanceId);
            Tr.debug(tc, "SfDRSControllerInstanceImpl.init:  instanceName = " + this.instanceName);
            Tr.debug(tc, "SfDRSControllerInstanceImpl.init:  instanceUniqueName = " + this.instanceUniqueName);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "SfDRSControllerInstanceImpl.init:  Exit - ddxKey = " + this.ddxKey + " instanceUniqueName = " + this.instanceUniqueName);
        }
    }

    public DRSControllerDataXfer getDRSControllerDataXfer() {
        String m = "SfDRSControllerInstanceImpl.getDRSControllerDataXfer/" + this.instanceUniqueName + "/";
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, m + " Entry");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, m + " Exit");
        }
        return this.ddx;
    }

    public DRSInstanceTokenTable getDRSInstanceTokenTable() {
        String m = "SfDRSControllerInstanceImpl.getDRSInstanceTokenTable/" + this.instanceUniqueName + "/";
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, m + " Entry");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, m + " Exit");
        }
        return this.registerendServants;
    }

    public void addServant(DRSInstanceToken token, DRSEventObject event2) {
        String m = "SfDRSControllerInstanceImpl.addServant/" + this.instanceUniqueName + "/";
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, m + " token = " + token + " event = " + event2);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, m + " token = " + token + " event = " + event2);
        }
        this.dcml.sendEvent(token, this.isUpEvent);
        this.dcml.sendEvent(token, this.isNotCongestedEvent);
        this.registerendServants.addServant(token);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, m + " Exit");
        }
    }

    public void deleteServant(DRSInstanceToken token) {
        String m = "SfDRSControllerInstanceImpl.deleteServant/" + this.instanceUniqueName + "/";
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, m + " Token = " + token);
        }
        this.registerendServants.deleteServant(token);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, m + " Exit");
        }
    }

    public void deleteServant(String stoken) {
        String m = "SfDRSControllerInstanceImpl.deleteServant/" + this.instanceUniqueName + "/";
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, m + " Stoken = " + stoken);
        }
        this.registerendServants.deleteServant(stoken);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, m + " Exit");
        }
    }

    public long getInstanceId() {
        String m = "SfDRSControllerInstanceImpl.getInstanceId/" + this.instanceUniqueName + "/";
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, m + "Entry");
        }
        long rc = this.instanceId;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, m + " Exit - instanceId = " + rc);
        }
        return rc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDRSReplicationUp() {
        boolean wasUp;
        String m = "SfDRSControllerInstanceImpl.setDRSReplicationUp/" + this.instanceUniqueName + "/ ";
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, m + "Entry  - eventStateReplicationUp = " + this.eventStateReplicationUp);
        }
        Integer n = this.drsStateLock;
        synchronized (n) {
            wasUp = this.eventStateReplicationUp;
            this.eventStateReplicationUp = true;
            this.eventStateIsCongested = false;
        }
        if (!wasUp) {
            Tr.info(tc, "SFB_CONTROLLER_DRSEVENT_REPLICATION_UP_CNTR0113I", this.instanceUniqueName);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, m + "Exit - eventStateReplicationUp = " + this.eventStateReplicationUp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDRSReplicationDown() {
        boolean wasUp;
        String m = "SfDRSControllerInstanceImpl.setDRSReplicationDown/" + this.instanceUniqueName + "/ ";
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, m + "Entry  - eventStateReplicationUp = " + this.eventStateReplicationUp);
        }
        Integer n = this.drsStateLock;
        synchronized (n) {
            wasUp = this.eventStateReplicationUp;
            this.eventStateReplicationUp = false;
            this.eventStateIsCongested = false;
        }
        if (wasUp) {
            Tr.info(tc, "SFB_CONTROLLER_DRSEVENT_REPLICATION_DOWN_CNTR0114I", this.instanceUniqueName);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, m + "Exit - eventStateReplicationUp = " + this.eventStateReplicationUp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDRSCongested() {
        boolean wasCongested;
        String m = "SfDRSControllerInstanceImpl.setDRSCongested/" + this.instanceUniqueName + "/ ";
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, m + "Entry  - eventStateIsCongested = " + this.eventStateIsCongested);
        }
        Integer n = this.drsStateLock;
        synchronized (n) {
            wasCongested = this.eventStateIsCongested;
            this.eventStateIsCongested = true;
        }
        if (!wasCongested) {
            Tr.info(tc, "SFB_CONTROLLER_DRSEVENT_IS_CONGESTED_CNTR0115I", this.instanceUniqueName);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, m + "Exit - eventStateIsCongested = " + this.eventStateIsCongested);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDRSNotCongested() {
        boolean wasCongested;
        String m = "SfDRSControllerInstanceImpl.setDRSNotCongested/" + this.instanceUniqueName + "/ ";
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, m + "Entry  - eventStateIsCongested = " + this.eventStateIsCongested);
        }
        Integer n = this.drsStateLock;
        synchronized (n) {
            wasCongested = this.eventStateIsCongested;
            this.eventStateIsCongested = false;
        }
        if (wasCongested) {
            Tr.info(tc, "SFB_CONTROLLER_DRSEVENT_NOT_CONGESTED_CNTR0116I", this.instanceUniqueName);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, m + "Exit - eventStateIsCongested = " + this.eventStateIsCongested);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isDRSAvailable() {
        String m = "SfDRSControllerInstanceImpl.isDRSAvailable/" + this.instanceUniqueName + "/ ";
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, m + "Entry.");
        }
        boolean rc = false;
        Integer n = this.drsStateLock;
        synchronized (n) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, m + "DRS state - eventStateReplicationUp = " + this.eventStateReplicationUp + " - eventStateIsCongested = " + this.eventStateIsCongested);
            }
            boolean bl = rc = this.eventStateReplicationUp && !this.eventStateIsCongested;
            if (!rc && this.usingHAManager) {
                try {
                    ++this.unAvailableCount;
                    if (this.unAvailableCount > 500) {
                        this.unAvailableCount = 0;
                        if (!this.eventStateReplicationUp) {
                            boolean replicationUp = this.baseDDX.isReplicationUp();
                            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                Tr.debug(tc, m + "replicationUp = " + replicationUp);
                            }
                            if (replicationUp) {
                                this.setDRSReplicationUp();
                            }
                        }
                        if (this.eventStateReplicationUp && this.eventStateIsCongested) {
                            boolean isCongested = this.baseDDX.isCongested();
                            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                Tr.debug(tc, m + "isCongested = " + isCongested);
                            }
                            if (!isCongested) {
                                this.setDRSNotCongested();
                            }
                        }
                        rc = this.eventStateReplicationUp && !this.eventStateIsCongested;
                    }
                }
                catch (Throwable t) {
                    Tr.error(tc, "ControllerSession.CaughtException", new Object[]{m, t});
                }
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, m + "Exit - isDRSAvailable = " + rc);
        }
        return rc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isDRSUp() {
        String m = "SfDRSControllerInstanceImpl.isDRSUp/" + this.instanceUniqueName + "/ ";
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, m + "Entry.");
        }
        boolean rc = false;
        Integer n = this.drsStateLock;
        synchronized (n) {
            rc = this.eventStateReplicationUp;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, m + "Exit - isDRSUp = " + rc);
        }
        return rc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isDRSCongested() {
        String m = "SfDRSControllerInstanceImpl.isDRSCongested/" + this.instanceUniqueName + "/ ";
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, m + "Entry.");
        }
        boolean rc = false;
        Integer n = this.drsStateLock;
        synchronized (n) {
            rc = this.eventStateIsCongested;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, m + "Exit - isDRSUp = " + rc);
        }
        return rc;
    }
}

