/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.container.activator;

import com.ibm.ejs.container.BeanId;
import com.ibm.ejs.container.BeanMetaData;
import com.ibm.ejs.container.BeanO;
import com.ibm.ejs.container.ContainerTx;
import com.ibm.ejs.container.SessionBeanTimeoutException;
import com.ibm.ejs.container.StatefulBeanO;
import com.ibm.ejs.container.StatefulBeanReaper;
import com.ibm.ejs.container.activator.Activator;
import com.ibm.ejs.container.activator.ActivatorCacheFullException;
import com.ibm.ejs.container.activator.MasterKey;
import com.ibm.ejs.container.activator.SingletonActivationStrategy;
import com.ibm.ejs.container.drs.SfDRSCache;
import com.ibm.ejs.container.drs.SfDRSClient;
import com.ibm.ejs.container.passivator.StatefulPassivator;
import com.ibm.ejs.container.util.EJSPlatformHelper;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.csi.IllegalOperationException;
import com.ibm.websphere.csi.InsufficientCacheSpaceException;
import com.ibm.websphere.csi.PassivationPolicy;
import com.ibm.ws.ffdc.FFDCFilter;
import java.rmi.NoSuchObjectException;
import java.rmi.RemoteException;
import java.util.Date;
import javax.transaction.TransactionRolledbackException;

public abstract class StatefulSessionActivationStrategy
extends SingletonActivationStrategy {
    protected PassivationPolicy passivationPolicy;
    protected StatefulBeanReaper reaper;
    public StatefulPassivator ivPassivator;
    public SfDRSCache ivSfDRSCache;
    private static final TraceComponent tc = Tr.register(StatefulSessionActivationStrategy.class, "EJBContainer", "com.ibm.ejs.container.container");
    private static final String CLASS_NAME = "com.ibm.ejs.container.activator.StatefulSessionActivationStrategy";

    StatefulSessionActivationStrategy(Activator activator, PassivationPolicy passivationPolicy) {
        this(activator, passivationPolicy, null);
    }

    StatefulSessionActivationStrategy(Activator activator, PassivationPolicy passivationPolicy, SfDRSCache drsCache) {
        super(activator);
        this.passivationPolicy = passivationPolicy;
        this.reaper = activator.statefulBeanReaper;
        this.ivPassivator = activator.passivator;
        this.ivSfDRSCache = drsCache;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "<init>", passivationPolicy);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "Reaper", this);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "<init>");
        }
    }

    BeanO atCreate(ContainerTx tx, BeanO bean) throws RemoteException {
        BeanO beanO;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "atCreate");
        }
        if ((beanO = super.atCreate(tx, bean)) == null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Adding beanO to reaper list");
            }
            StatefulBeanO statefulBeanO = (StatefulBeanO)bean;
            this.reaper.add(statefulBeanO.getId(), statefulBeanO.getSessionTimeoutInMilliSeconds());
            if (statefulBeanO.sfsbFailoverEnabled()) {
                statefulBeanO.createDRSEntry();
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "atCreate");
        }
        return beanO;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    BeanO atActivate(ContainerTx tx, BeanId beanId) throws RemoteException {
        BeanO bean;
        block35: {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.entry(tc, "atActivate (" + beanId + ")", tx);
            }
            bean = null;
            Exception exception = null;
            MasterKey key = new MasterKey(beanId);
            boolean activate = false;
            boolean found = false;
            StatefulBeanO statefulBeanO = null;
            Object object = this.locks.getLock(key);
            synchronized (object) {
                try {
                    block34: {
                        try {
                            bean = (BeanO)this.cache.find(key);
                            if (bean == null) {
                                boolean timedOut;
                                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                    Tr.debug(tc, "Bean not in cache");
                                }
                                if (EJSPlatformHelper.isZOS()) {
                                    timedOut = this.reaper.beanExistsAndTimedOut(beanId) || this.passivationPolicy.equals(PassivationPolicy.ON_DEMAND);
                                } else {
                                    boolean bl = timedOut = this.reaper.beanDoesNotExistOrHasTimedOut(beanId) || this.passivationPolicy.equals(PassivationPolicy.ON_DEMAND);
                                }
                                if (timedOut) {
                                    if (this.reaper.beanExistsAndTimedOut(beanId)) {
                                        if (!TraceComponent.isAnyTracingEnabled()) throw new SessionBeanTimeoutException("Stateful bean " + beanId + " timed out.");
                                        if (!tc.isDebugEnabled()) throw new SessionBeanTimeoutException("Stateful bean " + beanId + " timed out.");
                                        Tr.debug(tc, "Bean " + beanId + " in passivated filesystem or SfDRSCache, " + " but timed out.");
                                        throw new SessionBeanTimeoutException("Stateful bean " + beanId + " timed out.");
                                    }
                                    if (!TraceComponent.isAnyTracingEnabled()) throw new NoSuchObjectException("Stateful bean " + beanId + " was removed or timed out.");
                                    if (!tc.isDebugEnabled()) throw new NoSuchObjectException("Stateful bean " + beanId + " was removed or timed out.");
                                    Tr.debug(tc, "Bean " + beanId + " not in the passivated filesystem either.");
                                    throw new NoSuchObjectException("Stateful bean " + beanId + " was removed or timed out.");
                                }
                                bean = beanId.getHome().createBeanO(beanId, tx);
                                this.cache.insert(key, bean);
                                bean.ivCacheKey = key;
                                activate = true;
                                statefulBeanO = (StatefulBeanO)bean;
                            } else {
                                found = true;
                                statefulBeanO = (StatefulBeanO)bean;
                                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                    Tr.debug(tc, "Found bean in cache");
                                }
                                if (tx != null) {
                                    tx.ivCallbackBeanO = bean;
                                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                        Tr.debug(tc, "CallbackBeanO = " + bean);
                                    }
                                }
                            }
                            if (activate) {
                                bean.activate(beanId, tx);
                                if (!this.reaper.beanExists(beanId) || this.passivationPolicy.equals(PassivationPolicy.ON_DEMAND)) {
                                    this.reaper.add(beanId, statefulBeanO.getSessionTimeoutInMilliSeconds());
                                    long lastaccess = statefulBeanO.getLastAccessTime();
                                    this.reaper.setLastAccessTime(beanId, lastaccess);
                                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                        Tr.debug(tc, "Bean last access: " + new Date(lastaccess).toString());
                                    }
                                } else {
                                    this.reaper.setActive(beanId);
                                }
                                if (statefulBeanO.sfsbFailoverEnabled()) {
                                    statefulBeanO.updateDRSSetActiveProp();
                                }
                                if (beanId.getBeanMetaData().ivHasAppManagedPersistenceContext || beanId.getBeanMetaData().ivHasCMExtendedPersistenceContext) {
                                    this.cache.markEvictionIneligible(key);
                                }
                            }
                            if (statefulBeanO.timedOut(this.reaper)) {
                                throw new SessionBeanTimeoutException("Stateful bean " + bean + " timed out");
                            }
                            if (!bean.enlist(tx)) break block34;
                            this.cache.pin(key);
                        }
                        catch (InsufficientCacheSpaceException e) {
                            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ejs.container.activator.StatefulSessionActivationStrategy.atActivate", (String)"163", (Object)this);
                            exception = e;
                            throw new ActivatorCacheFullException();
                        }
                        catch (RemoteException e) {
                            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ejs.container.activator.StatefulSessionActivationStrategy.atActivate", (String)"169", (Object)this);
                            exception = e;
                            throw e;
                        }
                        catch (RuntimeException e) {
                            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ejs.container.activator.StatefulSessionActivationStrategy.atActivate", (String)"175", (Object)this);
                            exception = e;
                            throw e;
                        }
                    }
                    Object var13_15 = null;
                    if (exception != null && TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                        Tr.event(tc, "atActivation: exception raised", exception);
                    }
                    if (exception == null || bean == null) break block35;
                    if (activate || found) {
                        try {
                            this.cache.remove(key, true);
                            bean.ivCacheKey = null;
                            this.reaper.remove(beanId);
                            bean.destroy();
                        }
                        catch (IllegalOperationException ex) {
                            this.cache.unpin(key);
                        }
                    } else {
                        bean.destroy();
                    }
                }
                catch (Throwable throwable) {
                    Object var13_16 = null;
                    if (exception != null && TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                        Tr.event(tc, "atActivation: exception raised", exception);
                    }
                    if (exception == null) throw throwable;
                    if (bean == null) throw throwable;
                    if (!activate && !found) {
                        bean.destroy();
                        throw throwable;
                    }
                    try {}
                    catch (IllegalOperationException ex) {
                        this.cache.unpin(key);
                        throw throwable;
                    }
                    this.cache.remove(key, true);
                    bean.ivCacheKey = null;
                    this.reaper.remove(beanId);
                    bean.destroy();
                    throw throwable;
                }
            }
        }
        if (!TraceComponent.isAnyTracingEnabled()) return bean;
        if (!tc.isEntryEnabled()) return bean;
        Tr.exit(tc, "atActivate", bean);
        return bean;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void atPostInvoke(ContainerTx tx, BeanO bean) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "atPostInvoke", new Object[]{tx, bean});
        }
        BeanId id = bean.getId();
        Object key = bean.ivCacheKey;
        this.reaper.setLastAccessTime(id);
        Object object = this.locks.getLock(key);
        synchronized (object) {
            bean = (BeanO)this.cache.findDontPinNAdjustPinCount(key, -1);
            if (bean != null && (bean.isRemoved() || bean.isDiscarded())) {
                block9: {
                    if (tx != null) {
                        try {
                            tx.delist(bean);
                        }
                        catch (TransactionRolledbackException ex) {
                            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ejs.container.activator.StatefulSessionActivationStrategy.atPostInvoke", (String)"261", (Object)this);
                            if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block9;
                            Tr.debug(tc, "atPostInvoke : transaction has rolledback");
                        }
                    }
                }
                ((BeanO)this.cache.remove(key, true)).destroy();
                bean.ivCacheKey = null;
                this.reaper.remove(id);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "atPostInvoke");
        }
    }

    void atDiscard(BeanO bean) throws RemoteException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "atDiscard", bean);
        }
        try {
            BeanId beanId = ((StatefulBeanO)bean).getId();
            StatefulBeanO statefulBeanO = (StatefulBeanO)bean;
            if (!this.reaper.beanDoesNotExistOrHasTimedOut(beanId)) {
                if (EJSPlatformHelper.isZOS()) {
                    ((StatefulBeanO)bean).setLastAccessTime(this.reaper.getLastAccessTime(beanId));
                }
                bean.ivCacheKey = null;
                long lastAccessTime = this.reaper.getLastAccessTime(beanId);
                statefulBeanO.setLastAccessTime(lastAccessTime);
                bean.passivate();
                this.reaper.setPassivated(beanId);
                statefulBeanO.destroyNotRemove();
            } else {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                    Tr.event(tc, "Discarding session bean", bean);
                }
                this.reaper.remove(beanId);
                statefulBeanO.destroy();
                bean.ivCacheKey = null;
            }
        }
        catch (RemoteException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ejs.container.activator.StatefulSessionActivationStrategy.atDiscard", (String)"368", (Object)this);
            Tr.warning(tc, "UNABLE_TO_PASSIVATE_EJB_CNTR0005W", new Object[]{bean, this, e});
            throw e;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "atDiscard");
        }
    }

    void atRemove(ContainerTx tx, BeanO bean) {
        super.atRemove(tx, bean);
        this.reaper.remove(bean.getId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void atTimeout(BeanId beanId) throws RemoteException {
        block24: {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.entry(tc, "atTimeout " + beanId);
            }
            BeanO bean = null;
            Exception exception = null;
            MasterKey key = new MasterKey(beanId);
            try {
                block27: {
                    try {
                        Object object = this.locks.getLock(key);
                        synchronized (object) {
                            block26: {
                                bean = (BeanO)this.cache.find(key);
                                if (bean != null) break block26;
                                if (this.reaper.beanExistsAndTimedOut(beanId)) {
                                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                        Tr.debug(tc, "Bean not in cache: removing file");
                                    }
                                    this.ivPassivator.remove(beanId, true);
                                    this.reaper.remove(beanId);
                                    BeanMetaData bmd = beanId.getBeanMetaData();
                                    SfDRSClient drs = bmd.getSfDRSClient();
                                    if (drs != null) {
                                        drs.removeEntry(beanId);
                                    }
                                    break block27;
                                } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                    Tr.debug(tc, "Bean not in cache: already removed");
                                }
                                break block27;
                            }
                            if (this.reaper.beanDoesNotExistOrHasTimedOut(beanId)) {
                                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                    Tr.debug(tc, "Found bean in cache: passivating / removing");
                                }
                                try {
                                    bean = (BeanO)this.cache.remove(key, true);
                                    bean.ivCacheKey = null;
                                    this.reaper.remove(beanId);
                                    BeanMetaData bmd = beanId.getBeanMetaData();
                                    SfDRSClient drs = bmd.getSfDRSClient();
                                    if (drs != null) {
                                        drs.removeEntry(beanId);
                                    }
                                    ((StatefulBeanO)bean).uninstall();
                                }
                                catch (IllegalOperationException ioe) {
                                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                        Tr.debug(tc, "Found bean in cache: active");
                                    }
                                    this.cache.unpin(key);
                                }
                            } else {
                                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                    Tr.debug(tc, "Found bean in cache: no longer timed out");
                                }
                                this.cache.unpin(key);
                            }
                        }
                    }
                    catch (RemoteException e) {
                        FFDCFilter.processException((Throwable)e, (String)"com.ibm.ejs.container.activator.StatefulSessionActivationStrategy.atTimeout", (String)"474", (Object)this);
                        exception = e;
                        throw e;
                    }
                    catch (RuntimeException e) {
                        FFDCFilter.processException((Throwable)e, (String)"com.ibm.ejs.container.activator.StatefulSessionActivationStrategy.atTimeout", (String)"480", (Object)this);
                        exception = e;
                        throw e;
                    }
                }
                Object var10_13 = null;
                if (exception == null) break block24;
            }
            catch (Throwable throwable) {
                Object var10_14 = null;
                if (exception != null && TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                    Tr.event(tc, "atTimeout: exception raised", exception);
                }
                if (!TraceComponent.isAnyTracingEnabled()) throw throwable;
                if (!tc.isEntryEnabled()) throw throwable;
                Tr.exit(tc, "atTimeout");
                throw throwable;
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                Tr.event(tc, "atTimeout: exception raised", exception);
            }
        }
        if (!TraceComponent.isAnyTracingEnabled()) return;
        if (!tc.isEntryEnabled()) return;
        Tr.exit(tc, "atTimeout");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void atPassivate(BeanId beanId) throws RemoteException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "atPassivate " + beanId);
        }
        BeanO bean = null;
        MasterKey key = new MasterKey(beanId);
        try {
            Object object = this.locks.getLock(key);
            synchronized (object) {
                bean = (BeanO)this.cache.find(key);
                if (bean != null) {
                    StatefulBeanO statefulBeanO = (StatefulBeanO)bean;
                    long lastAccessTime = this.reaper.getLastAccessTime(beanId);
                    statefulBeanO.setLastAccessTime(lastAccessTime);
                    bean.passivate();
                    this.cache.remove(key, true);
                    bean.ivCacheKey = null;
                    this.reaper.setPassivated(beanId);
                    if (EJSPlatformHelper.isZOS() || this.passivationPolicy.equals(PassivationPolicy.ON_DEMAND)) {
                        this.reaper.remove(beanId);
                    }
                    statefulBeanO.destroyNotRemove();
                }
            }
        }
        catch (RemoteException ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ejs.container.activator.StatefulSessionActivationStrategy.atPassivate", (String)"525", (Object)this);
            Tr.warning(tc, "UNABLE_TO_PASSIVATE_EJB_CNTR0005W", new Object[]{bean, this, ex});
            throw ex;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "atPassivate");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void atUninstall(BeanId beanId, BeanO bean) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "atUninstall (" + beanId + ")");
        }
        MasterKey key = new MasterKey(beanId);
        Object object = this.locks.getLock(key);
        synchronized (object) {
            bean = (BeanO)this.cache.find(key);
            if (bean != null) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                    Tr.event(tc, "Found bean in cache: uninstalling");
                }
                try {
                    this.cache.remove(key, true);
                    bean.ivCacheKey = null;
                    this.reaper.remove(beanId);
                    ((StatefulBeanO)bean).uninstall();
                }
                catch (IllegalOperationException ioe) {
                    FFDCFilter.processException((Throwable)ioe, (String)"com.ibm.ejs.container.activator.StatefulSessionActivationStrategy.atUninstall", (String)"590", (Object)this);
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug(tc, "Found bean in cache: active!");
                    }
                    this.cache.unpin(key);
                }
            } else {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "Bean not in cache: removing file");
                }
                try {
                    if (this.reaper.remove(beanId)) {
                        this.ivPassivator.remove(beanId, false);
                    }
                }
                catch (RemoteException rex) {
                    FFDCFilter.processException((Throwable)rex, (String)"com.ibm.ejs.container.activator.StatefulSessionActivationStrategy.atUninstall", (String)"598", (Object)this);
                    Tr.warning(tc, "REMOVE_FROM_PASSIVATION_STORE_FAILED_CNTR0016W", new Object[]{beanId, rex});
                }
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "atUninstall");
        }
    }

    public StatefulBeanReaper getReaper() {
        return this.reaper;
    }
}

