/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.container.activator;

import com.ibm.ejs.container.BeanId;
import com.ibm.ejs.container.BeanMetaData;
import com.ibm.ejs.container.BeanO;
import com.ibm.ejs.container.ContainerAS;
import com.ibm.ejs.container.ContainerTx;
import com.ibm.ejs.container.EJSContainer;
import com.ibm.ejs.container.EJSHome;
import com.ibm.ejs.container.StatefulBeanReaper;
import com.ibm.ejs.container.activator.ActivationStrategy;
import com.ibm.ejs.container.activator.OptAEntityActivationStrategy;
import com.ibm.ejs.container.activator.OptBEntityActivationStrategy;
import com.ibm.ejs.container.activator.OptCEntityActivationStrategy;
import com.ibm.ejs.container.activator.ReadOnlyEntityActivationStrategy;
import com.ibm.ejs.container.activator.StatefulActivateOnceActivationStrategy;
import com.ibm.ejs.container.activator.StatefulActivateTranActivationStrategy;
import com.ibm.ejs.container.activator.UncachedActivationStrategy;
import com.ibm.ejs.container.drs.SfDRSCache;
import com.ibm.ejs.container.passivator.StatefulPassivator;
import com.ibm.ejs.container.util.EJSPlatformHelper;
import com.ibm.ejs.container.util.locking.LockTable;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.csi.CacheElement;
import com.ibm.websphere.csi.EJBCache;
import com.ibm.websphere.csi.EJBCacheFactory;
import com.ibm.websphere.csi.J2EEName;
import com.ibm.websphere.csi.PassivationPolicy;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.util.cache.DiscardWithLockStrategy;
import java.rmi.RemoteException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.StringTokenizer;
import javax.ejb.DuplicateKeyException;

public final class Activator
implements DiscardWithLockStrategy {
    public static final int UNCACHED_ACTIVATION_STRATEGY = 0;
    public static final int STATEFUL_ACTIVATE_ONCE_ACTIVATION_STRATEGY = 1;
    public static final int STATEFUL_ACTIVATE_TRAN_ACTIVATION_STRATEGY = 2;
    public static final int STATEFUL_ACTIVATE_SESSION_ACTIVATION_STRATEGY = 3;
    public static final int OPTA_ENTITY_ACTIVATION_STRATEGY = 4;
    public static final int OPTB_ENTITY_ACTIVATION_STRATEGY = 5;
    public static final int OPTC_ENTITY_ACTIVATION_STRATEGY = 6;
    public static final int ENTITY_SESSIONAL_TRAN_ACTIVATION_STRATEGY = 7;
    public static final int READONLY_ENTITY_ACTIVATION_STRATEGY = 8;
    protected static final String[] svStrategyStrs = new String[]{"Uncached", "Stateful Once", "Stateful Transaction", "Stateful Session", "Entity Option A", "Entity Option B", "Entity Option C", "Entity Option C Sessional", "Entity Read Only"};
    EJBCache beanCache;
    LockTable activationLocks;
    protected EJSContainer container;
    private ActivationStrategy[] strategies;
    StatefulPassivator passivator;
    private static final TraceComponent tc = Tr.register(Activator.class, "EJBContainer", "com.ibm.ejs.container.container");
    private static final String CLASS_NAME = "com.ibm.ejs.container.activator.Activator";
    StatefulBeanReaper statefulBeanReaper;
    private Hashtable ivEjbCacheActivators;
    private Hashtable ivActivatorsByHome;
    private static final long DEFAULT_CACHE_SIZE = 2053L;
    private static final long DEFAULT_CACHE_SWEEP = 3000L;

    public Activator(EJSContainer container2, EJBCache cache, PassivationPolicy passivationPolicy, StatefulPassivator passivator, SfDRSCache drsCache) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "<init>", new Object[]{container2, cache, passivationPolicy});
        }
        if (EJSPlatformHelper.isZOS()) {
            long sweepInterval = 0L;
            Long sweepIntervallong = Long.getLong("com.ibm.websphere.bean.delete.sleep.time");
            if (sweepIntervallong != null) {
                sweepInterval = sweepIntervallong * 1000L;
            }
            this.statefulBeanReaper = new StatefulBeanReaper(this, cache.getConfigSize(), sweepInterval, drsCache);
        } else {
            this.statefulBeanReaper = new StatefulBeanReaper(this, cache.getConfigSize(), drsCache);
        }
        this.initialize(container2, cache, passivationPolicy, passivator, drsCache);
        if (!passivationPolicy.equals(PassivationPolicy.ON_DEMAND)) {
            this.statefulBeanReaper.start();
        }
        this.processConfiguredEJBCaches(passivationPolicy, drsCache);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "<init>");
        }
    }

    private Activator(Activator activator, EJBCache cache, PassivationPolicy passivationPolicy, SfDRSCache drsCache) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "Activator", new Object[]{activator, passivationPolicy});
        }
        this.statefulBeanReaper = activator.statefulBeanReaper;
        this.initialize(activator.container, cache, passivationPolicy, activator.passivator, drsCache);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "Activator");
        }
    }

    private void initialize(EJSContainer container2, EJBCache cache, PassivationPolicy passivationPolicy, StatefulPassivator passivator, SfDRSCache drsCache) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "initialize");
        }
        this.container = container2;
        this.beanCache = cache;
        this.passivator = passivator;
        this.activationLocks = new LockTable(this.beanCache.getConfigSize());
        this.strategies = new ActivationStrategy[9];
        this.strategies[0] = new UncachedActivationStrategy(this);
        this.strategies[1] = new StatefulActivateOnceActivationStrategy(this, passivationPolicy);
        this.strategies[2] = new StatefulActivateTranActivationStrategy(this, passivationPolicy, drsCache);
        this.strategies[3] = container2.getContainerExtensionFactory().getActivationStrategy(3, this, passivationPolicy, drsCache);
        this.strategies[4] = new OptAEntityActivationStrategy(this);
        this.strategies[5] = new OptBEntityActivationStrategy(this);
        this.strategies[6] = new OptCEntityActivationStrategy(this);
        this.strategies[7] = container2.getContainerExtensionFactory().getActivationStrategy(7, this, null, null);
        this.strategies[8] = new ReadOnlyEntityActivationStrategy(this);
        this.beanCache.setDiscardStrategy(this);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "initialize");
        }
    }

    private void processConfiguredEJBCaches(PassivationPolicy passivationPolicy, SfDRSCache drsCache) {
        String ejbCacheConfig = System.getProperty("com.ibm.websphere.ejbcontainer.EJBCacheConfig");
        if (ejbCacheConfig == null) {
            return;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "Processing Configured EJB Caches:", ejbCacheConfig);
        }
        this.ivEjbCacheActivators = new Hashtable();
        Hashtable ejbCacheFactories = new Hashtable();
        StringTokenizer st = new StringTokenizer(ejbCacheConfig, ":");
        while (st.hasMoreTokens()) {
            long cacheSize = 2053L;
            long cacheSweep = 3000L;
            String token = st.nextToken();
            int assignmentPivot = token.indexOf(61);
            if (assignmentPivot > 0) {
                String cacheName = token.substring(0, assignmentPivot).trim();
                String rh = token.substring(assignmentPivot + 1).trim();
                int separationPivot = rh.indexOf(44);
                if (separationPivot > 0) {
                    String cacheSizeStr = rh.substring(0, separationPivot).trim();
                    try {
                        cacheSize = Long.parseLong(cacheSizeStr);
                    }
                    catch (NumberFormatException e) {
                        FFDCFilter.processException((Throwable)e, (String)"com.ibm.ejs.container.activator.Activator.processConfiguredEJBCaches", (String)"312", (Object)this);
                        Tr.warning(tc, "INVALID_MIN_POOLSIZE_CNTR0057W", new Object[]{cacheName, cacheSizeStr});
                    }
                }
                if (separationPivot + 1 < rh.length()) {
                    String cacheSweepStr = rh.substring(separationPivot + 1).trim();
                    try {
                        cacheSweep = Long.parseLong(cacheSweepStr);
                    }
                    catch (NumberFormatException e) {
                        FFDCFilter.processException((Throwable)e, (String)"com.ibm.ejs.container.activator.Activator.processConfiguredEJBCaches", (String)"325", (Object)this);
                        Tr.warning(tc, "INVALID_MIN_POOLSIZE_CNTR0057W", new Object[]{cacheName, cacheSweepStr});
                    }
                }
                this.createEJBCacheActivator(cacheName, cacheSize, cacheSweep, passivationPolicy, ejbCacheFactories, drsCache);
                continue;
            }
            Tr.warning(tc, "POOLSIZE_MISSING_EQUALS_SIGN_CNTR0062W", new Object[]{token});
        }
        String ejbCacheUse = System.getProperty("com.ibm.websphere.ejbcontainer.EJBCacheUse");
        if (ejbCacheUse == null) {
            return;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "Processing EJB Cache Usage:", ejbCacheUse);
        }
        this.ivActivatorsByHome = new Hashtable();
        st = new StringTokenizer(ejbCacheUse, ":");
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            int assignmentPivot = token.indexOf(61);
            if (assignmentPivot > 0) {
                String cacheName = token.substring(0, assignmentPivot).trim();
                Activator activator = (Activator)this.ivEjbCacheActivators.get(cacheName);
                if (activator == null) {
                    Tr.warning(tc, "POOLSIZE_MISSING_EQUALS_SIGN_CNTR0062W", new Object[]{token});
                    continue;
                }
                String rh = token.substring(assignmentPivot + 1).trim();
                while (rh != null && rh.length() > 0) {
                    String j2eeName = null;
                    int separationPivot = rh.indexOf(44);
                    if (separationPivot > 0) {
                        j2eeName = rh.substring(0, separationPivot).trim();
                        rh = rh.substring(separationPivot + 1).trim();
                    } else {
                        j2eeName = rh;
                        rh = null;
                    }
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug(tc, "Associating " + cacheName + " with " + j2eeName);
                    }
                    this.ivActivatorsByHome.put(j2eeName, activator);
                }
                continue;
            }
            Tr.warning(tc, "POOLSIZE_MISSING_EQUALS_SIGN_CNTR0062W", new Object[]{token});
        }
    }

    private void createEJBCacheActivator(String cacheName, long cacheSize, long cacheSweepInterval, PassivationPolicy passivationPolicy, Hashtable ejbCacheFactories, SfDRSCache drsCache) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "createEJBCacheActivator (" + cacheName + ")");
        }
        EJBCache ejbCache = null;
        Activator activator = null;
        EJBCacheFactory factory = null;
        String ejbCacheFactoryName = System.getProperty("com.ibm.websphere.ejbcontainer.EJBCacheConfig." + cacheName);
        if (ejbCacheFactoryName == null) {
            ejbCacheFactoryName = "com.ibm.ejs.util.cache.EJBCacheFactoryImpl";
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "EJBCacheFactory = " + ejbCacheFactoryName);
        }
        try {
            factory = (EJBCacheFactory)ejbCacheFactories.get(ejbCacheFactoryName);
            if (factory == null) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "factory not in cache, creating new instance");
                }
                Class<?> factoryClass = Class.forName(ejbCacheFactoryName);
                factory = (EJBCacheFactory)factoryClass.newInstance();
                ejbCacheFactories.put(ejbCacheFactoryName, factory);
            }
            ejbCache = factory.create(cacheName, cacheSize, cacheSweepInterval);
        }
        catch (Throwable th) {
            FFDCFilter.processException((Throwable)th, (String)"com.ibm.ejs.container.activator.Activator.createEJBCacheActivator", (String)"452", (Object)this);
            Tr.warning(tc, "IGNORING_UNEXPECTED_EXCEPTION_CNTR0033E", th);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "createEJBCacheActivator (" + cacheName + ")" + " : Cache not created");
            }
            return;
        }
        activator = new Activator(this, ejbCache, passivationPolicy, drsCache);
        this.ivEjbCacheActivators.put(cacheName, activator);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "createEJBCacheActivator (" + cacheName + ")");
        }
    }

    public BeanO activateBean(ContainerTx tx, BeanId beanId) throws RemoteException {
        return beanId.getActivationStrategy().atActivate(tx, beanId);
    }

    public void postInvoke(ContainerTx tx, BeanO bean) {
        bean.getActivationStrategy().atPostInvoke(tx, bean);
    }

    public BeanO addBean(ContainerTx tx, BeanO bean) throws DuplicateKeyException, RemoteException {
        return bean.getHome().getActivationStrategy().atCreate(tx, bean);
    }

    public boolean lockBean(ContainerTx tx, BeanId beanId) throws RemoteException {
        return beanId.getActivationStrategy().atLock(tx, beanId);
    }

    public void removeBean(ContainerTx tx, BeanO bean) {
        bean.getActivationStrategy().atRemove(tx, bean);
    }

    public BeanO getBean(ContainerTx tx, BeanId id) {
        return id.getActivationStrategy().atGet(tx, id);
    }

    public void commitBean(ContainerTx tx, BeanO bean) {
        bean.getActivationStrategy().atCommit(tx, bean);
    }

    public void unitOfWorkEnd(ContainerAS as, BeanO bean) {
        bean.getActivationStrategy().atUnitOfWorkEnd(as, bean);
    }

    public void rollbackBean(ContainerTx tx, BeanO bean) {
        bean.getActivationStrategy().atRollback(tx, bean);
    }

    public final void enlistBean(ContainerTx tx, BeanO bean) {
        bean.getActivationStrategy().atEnlist(tx, bean);
    }

    public final ActivationStrategy getActivationStrategy(int id) {
        return this.strategies[id];
    }

    public final ActivationStrategy getActivationStrategy(EJSHome home, int id) {
        Activator activator = null;
        if (this.ivActivatorsByHome != null) {
            activator = (Activator)this.ivActivatorsByHome.get(((Object)home.getJ2EEName()).toString());
        }
        if (activator == null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "getActivationStrategy: Default EJB Cache used for " + home.getJ2EEName());
            }
            activator = this;
        } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "getActivationStrategy: " + activator.beanCache.getName() + " used for " + home.getJ2EEName());
        }
        return activator.strategies[id];
    }

    public static final String getActivationStrategyString(int id) {
        if (id < 0 || id >= svStrategyStrs.length) {
            return "Unknown (" + id + ")";
        }
        return svStrategyStrs[id];
    }

    public void discardObject(EJBCache cache, Object key, Object object) throws RemoteException {
        BeanO bean = (BeanO)object;
        bean.getActivationStrategy().atDiscard(bean);
    }

    public LockTable getEvictionLockTable() {
        return this.activationLocks;
    }

    public void timeoutBean(BeanId beanId) throws RemoteException {
        beanId.getActivationStrategy().atTimeout(beanId);
    }

    public void passivate(J2EEName homeName) throws RemoteException {
        Iterator beanList = this.statefulBeanReaper.getStatefulBeanIds(homeName);
        this.passivateBeans(beanList);
    }

    public void passivateAll() throws RemoteException {
        Iterator beanList = this.statefulBeanReaper.getStatefulBeanIds();
        this.passivateBeans(beanList);
    }

    private void passivateBeans(Iterator beanList) throws RemoteException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "passivateBeans");
        }
        RemoteException exception = null;
        while (beanList.hasNext()) {
            try {
                BeanId beanId = (BeanId)beanList.next();
                beanId.getActivationStrategy().atPassivate(beanId);
            }
            catch (RemoteException ex) {
                FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ejs.container.activator.Activator.passivateBeans", (String)"454", (Object)this);
                exception = ex;
            }
        }
        if (exception != null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "passivateBeans", exception);
            }
            throw exception;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "passivateBeans");
        }
    }

    public void terminate() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "terminate");
        }
        this.statefulBeanReaper.finalSweep(this.passivator);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "terminate");
        }
    }

    public void uninstallBean(J2EEName homeName) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "uninstallBean " + homeName);
        }
        int numEnumerated = 0;
        int numRemoved = 0;
        int numTimedout = 0;
        Activator activator = null;
        if (this.ivActivatorsByHome != null) {
            activator = (Activator)this.ivActivatorsByHome.get(((Object)homeName).toString());
        }
        if (activator == null) {
            activator = this;
        }
        Enumeration enumerate = activator.beanCache.enumerateElements();
        while (enumerate.hasMoreElements()) {
            BeanO cacheMember = (BeanO)((CacheElement)enumerate.nextElement()).getObject();
            BeanId cacheMemberBeanId = cacheMember.getId();
            J2EEName cacheHomeName = cacheMemberBeanId.getJ2EEName();
            ++numEnumerated;
            if (!cacheHomeName.equals(homeName)) continue;
            EJSHome home = cacheMember.getHome();
            BeanMetaData bmd = cacheMemberBeanId.getBeanMetaData();
            if (EJSPlatformHelper.isZOS() && !bmd.ivHasAppManagedPersistenceContext && !bmd.ivHasCMExtendedPersistenceContext) {
                try {
                    home.getActivationStrategy().atPassivate(cacheMemberBeanId);
                }
                catch (Exception ex) {
                    Tr.warning(tc, "UNABLE_TO_PASSIVATE_EJB_CNTR0005W", new Object[]{cacheMemberBeanId, this, ex});
                }
            } else {
                home.getActivationStrategy().atUninstall(cacheMemberBeanId, cacheMember);
            }
            ++numRemoved;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, activator.beanCache.getName() + ": Uninstalled " + numRemoved + " bean instances (total = " + numEnumerated + ")");
        }
        Iterator statefulBeans = this.statefulBeanReaper.getPassivatedStatefulBeanIds(homeName);
        while (statefulBeans.hasNext()) {
            BeanId beanId = (BeanId)statefulBeans.next();
            if (EJSPlatformHelper.isZOS()) {
                this.statefulBeanReaper.remove(beanId);
            } else {
                beanId.getActivationStrategy().atUninstall(beanId, null);
            }
            ++numTimedout;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "Passivated Beans: Uninstalled " + numTimedout + " bean instances");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "uninstallBean");
        }
    }

    public int size() {
        int size = this.beanCache.getSize();
        if (this.ivEjbCacheActivators != null) {
            Enumeration activators = this.ivEjbCacheActivators.elements();
            while (activators.hasMoreElements()) {
                Activator activator = (Activator)activators.nextElement();
                size += activator.size();
            }
        }
        return size;
    }

    public void dump() {
        if (!tc.isDumpEnabled()) {
            return;
        }
        Enumeration vEnum = this.beanCache.enumerateElements();
        Tr.dump(tc, "-- Activator Dump : " + this.beanCache.getName() + " --");
        while (vEnum.hasMoreElements()) {
            Tr.dump(tc, "bean cache element", vEnum.nextElement());
        }
        if (this.ivEjbCacheActivators != null) {
            Enumeration activators = this.ivEjbCacheActivators.elements();
            while (activators.hasMoreElements()) {
                Activator activator = (Activator)activators.nextElement();
                activator.dump();
            }
        }
    }
}

