/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.container.activator;

import com.ibm.ejs.container.BeanId;
import com.ibm.ejs.container.BeanO;
import com.ibm.ejs.container.ContainerAS;
import com.ibm.ejs.container.ContainerTx;
import com.ibm.ejs.container.activator.Activator;
import com.ibm.ejs.container.util.locking.LockTable;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.csi.EJBCache;
import com.ibm.ws.ffdc.FFDCFilter;
import java.rmi.RemoteException;
import javax.ejb.DuplicateKeyException;

public abstract class ActivationStrategy {
    final EJBCache cache;
    final LockTable locks;
    private static final TraceComponent tc = Tr.register(ActivationStrategy.class, "EJBContainer", "com.ibm.ejs.container.container");
    private static final String CLASS_NAME = "com.ibm.ejs.container.activator.ActivationStrategy";

    ActivationStrategy(Activator activator) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "<init>", activator);
        }
        this.cache = activator.beanCache;
        this.locks = activator.activationLocks;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "<init>");
        }
    }

    abstract BeanO atActivate(ContainerTx var1, BeanId var2) throws RemoteException;

    abstract void atPostInvoke(ContainerTx var1, BeanO var2);

    abstract BeanO atCreate(ContainerTx var1, BeanO var2) throws DuplicateKeyException, RemoteException;

    boolean atLock(ContainerTx tx, BeanId id) throws RemoteException {
        return false;
    }

    abstract void atCommit(ContainerTx var1, BeanO var2);

    void atUnitOfWorkEnd(ContainerAS as, BeanO beanO) {
    }

    abstract void atRollback(ContainerTx var1, BeanO var2);

    abstract void atEnlist(ContainerTx var1, BeanO var2);

    abstract void atRemove(ContainerTx var1, BeanO var2);

    void atTimeout(BeanId id) throws RemoteException {
    }

    void atPassivate(BeanId id) throws RemoteException {
    }

    abstract BeanO atGet(ContainerTx var1, BeanId var2);

    void atDiscard(BeanO bean) throws RemoteException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "atDiscard", bean);
        }
        try {
            bean.passivate();
            bean.destroy();
        }
        catch (RemoteException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ejs.container.activator.ActivationStrategy.atDiscard", (String)"106", (Object)this);
            Tr.warning(tc, "UNABLE_TO_PASSIVATE_EJB_CNTR0005W", new Object[]{bean, this, e});
            throw e;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "atDiscard");
        }
    }

    void atUninstall(BeanId id, BeanO bean) {
    }
}

