/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.container;

import com.ibm.ejs.container.BeanId;
import com.ibm.ejs.container.BeanIdCache;
import com.ibm.ejs.container.EJBNotFoundException;
import com.ibm.ejs.container.EJSContainer;
import com.ibm.ejs.container.EJSHome;
import com.ibm.ejs.container.EJSRemoteWrapper;
import com.ibm.ejs.container.EJSWrapperBase;
import com.ibm.ejs.container.EJSWrapperCommon;
import com.ibm.ejs.container.InvalidBeanIdException;
import com.ibm.ejs.container.WrapperId;
import com.ibm.ejs.container.util.ByteArray;
import com.ibm.ejs.oa.EJBOAKeyImpl;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.csi.CSIException;
import com.ibm.websphere.csi.CacheElement;
import com.ibm.websphere.csi.DiscardException;
import com.ibm.websphere.csi.DiscardStrategy;
import com.ibm.websphere.csi.EJBCache;
import com.ibm.websphere.csi.EJBServantManager;
import com.ibm.websphere.csi.FaultException;
import com.ibm.websphere.csi.FaultStrategy;
import com.ibm.websphere.csi.IllegalOperationException;
import com.ibm.websphere.csi.J2EEName;
import com.ibm.websphere.csi.ObjectAdapter;
import com.ibm.ws.ffdc.FFDCFilter;
import java.rmi.RemoteException;
import java.util.Enumeration;

public final class WrapperManager
implements DiscardStrategy,
FaultStrategy,
EJBServantManager {
    private static final TraceComponent tc = Tr.register(WrapperManager.class, "EJBContainer", "com.ibm.ejs.container.container");
    private static final String CLASS_NAME = "com.ibm.ejs.container.WrapperManager";
    protected EJBCache wrapperCache;
    private EJSContainer container;
    protected ObjectAdapter oa;
    protected BeanIdCache beanIdCache;

    public WrapperManager(EJSContainer container2) throws CSIException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "WrapperManager");
        }
        this.wrapperCache = container2.wrapperCache;
        this.wrapperCache.setDiscardStrategy(this);
        this.wrapperCache.setFaultStrategy(this);
        this.container = container2;
        this.oa = container2.objectAdapter;
        this.oa.registerServantManager(this);
        int beanIdCacheSize = this.wrapperCache.getConfigSize();
        beanIdCacheSize = beanIdCacheSize < 0x3FFFFFFF ? (beanIdCacheSize *= 2) : Integer.MAX_VALUE;
        this.beanIdCache = new BeanIdCache(beanIdCacheSize);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "WrapperManager");
        }
    }

    public void destroy() {
    }

    public boolean preInvoke(EJSWrapperBase wrapper) throws CSIException, RemoteException {
        if (wrapper.ivCommon.pinned > 0) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "preInvoke : pinned = false (already pinned)", wrapper);
            }
            return false;
        }
        boolean pinned = wrapper.ivCommon.pinOnce();
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "preInvoke : pinned = " + pinned, wrapper);
        }
        return pinned;
    }

    public void postInvoke(EJSWrapperBase wrapper) throws CSIException, RemoteException {
        wrapper.ivCommon.unpin();
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "postInvoke : unpinned", wrapper);
        }
    }

    public EJSWrapperCommon getWrapper(BeanId id) throws CSIException, RemoteException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "getWrapper");
        }
        EJSWrapperCommon result = null;
        if (id.byteArray == null && !id._isHome && id.pkey != null) {
            id = this.beanIdCache.find(id);
        }
        ByteArray wrapperKey = id.getByteArray();
        wrapperKey.setBeanId(id);
        try {
            result = (EJSWrapperCommon)this.wrapperCache.findAndFault((Object)wrapperKey);
        }
        catch (FaultException ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ejs.container.WrapperManager.getWrapper", (String)"259", (Object)this);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                Tr.event(tc, "Unable to fault in wrapper", ex);
            }
            throw new CSIException(ex.toString());
        }
        if (!id._isHome && id.pkey != null) {
            this.beanIdCache.add(result.getBeanId());
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "getWrapper");
        }
        return result;
    }

    public boolean unregister(BeanId beanId, boolean dropRef) throws CSIException {
        boolean removed;
        block7: {
            removed = false;
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.entry(tc, "unregister", new Object[]{beanId, new Boolean(dropRef)});
            }
            ByteArray wrapperKey = beanId.getByteArray();
            try {
                EJSWrapperCommon wrapperCommon = (EJSWrapperCommon)this.wrapperCache.removeAndDiscard((Object)wrapperKey, dropRef);
                if (wrapperCommon != null) {
                    removed = true;
                }
            }
            catch (IllegalOperationException ex) {
                FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ejs.container.WrapperManager.unregister", (String)"351", (Object)this);
                if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                    Tr.event(tc, "unregister ignoring IllegalOperationException for object " + beanId);
                    Tr.event(tc, "Exception: " + ex);
                }
            }
            catch (DiscardException ex) {
                FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ejs.container.WrapperManager.unregister", (String)"358", (Object)this);
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isEventEnabled()) break block7;
                Tr.event(tc, "Unable to discard element");
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "unregister");
        }
        return removed;
    }

    public void unregisterHome(J2EEName homeName, EJSHome homeObj) throws CSIException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "unregisterHome");
        }
        int numEnumerated = 0;
        int numRemoved = 0;
        Enumeration enumerate = this.wrapperCache.enumerateElements();
        while (enumerate.hasMoreElements()) {
            EJSWrapperCommon wCommon = (EJSWrapperCommon)((CacheElement)enumerate.nextElement()).getObject();
            BeanId cacheMemberBeanId = wCommon.getBeanId();
            J2EEName cacheHomeName = cacheMemberBeanId.getJ2EEName();
            ++numEnumerated;
            if (!cacheHomeName.equals(homeName) && !cacheMemberBeanId.equals(homeObj.getId())) continue;
            this.unregister(cacheMemberBeanId, true);
            ++numRemoved;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "Unregistered " + numRemoved + " wrappers (total = " + numEnumerated + ")");
        }
        this.beanIdCache.removeAll(homeObj);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "unregisterHome");
        }
    }

    public void discardObject(EJBCache wrapperCache, Object key, Object ele) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "discardObject", new Object[]{key, ele});
        }
        EJSWrapperCommon wrapperCommon = (EJSWrapperCommon)ele;
        wrapperCommon.unregisterServant();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "discardObject");
        }
    }

    public Object keyToObject(byte[] key) throws RemoteException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "keyToObject");
        }
        EJSWrapperCommon wc = null;
        EJSRemoteWrapper wrapper = null;
        try {
            if (key[0] == -83) {
                WrapperId wrapperId = new WrapperId(key);
                ByteArray wrapperKey = wrapperId.getBeanIdArray();
                wc = (EJSWrapperCommon)this.wrapperCache.findAndFault((Object)wrapperKey);
                if (wc != null) {
                    wrapper = wc.getRemoteBusinessWrapper(wrapperId);
                    BeanId beanId = wrapper.beanId;
                    if (!beanId._isHome && beanId.pkey != null) {
                        this.beanIdCache.add(beanId);
                    }
                }
            } else {
                ByteArray wrapperKey = new ByteArray(key);
                wc = (EJSWrapperCommon)this.wrapperCache.findAndFault((Object)wrapperKey);
                if (wc != null) {
                    wrapper = wc.getRemoteObject();
                    BeanId beanId = wrapper.beanId;
                    if (!beanId._isHome && beanId.pkey != null) {
                        this.beanIdCache.add(beanId);
                    }
                }
            }
        }
        catch (FaultException ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ejs.container.WrapperManager.keyToObject", (String)"501", (Object)this);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                Tr.event(tc, "Unable to fault in wrapper", ex);
            }
            throw new RemoteException(ex.getMessage(), ex);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "keyToObject", wrapper);
        }
        return wrapper;
    }

    public Object faultOnKey(EJBCache cache, Object key) throws FaultException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "faultOnKey", key);
        }
        ByteArray wrapperKey = (ByteArray)((Object)key);
        EJSWrapperCommon result = null;
        BeanId beanId = wrapperKey.getBeanId();
        try {
            if (beanId == null) {
                beanId = BeanId.getBeanId(wrapperKey, this.container);
            }
            result = this.container.createWrapper(beanId);
        }
        catch (InvalidBeanIdException ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ejs.container.WrapperManager.faultOnKey", (String)"533", (Object)this);
            Throwable cause = ex.getCause();
            if (cause instanceof EJBNotFoundException) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                    Tr.event(tc, "Application Not Started", ex);
                }
                throw new FaultException((EJBNotFoundException)cause, "Application not started or not installed");
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                Tr.event(tc, "Malformed object key", ex);
            }
            throw new FaultException(ex, "Malformed object key");
        }
        catch (Exception ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ejs.container.WrapperManager.faultOnKey", (String)"548", (Object)this);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                Tr.event(tc, "Malformed object key", ex);
            }
            throw new FaultException(ex, "Malformed object key");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "faultOnKey");
        }
        return result;
    }

    public byte[] getJ2EENameBytes(byte[] servantKey) throws CSIException {
        EJBOAKeyImpl key = new EJBOAKeyImpl(servantKey);
        return key.getJ2EENameBytes();
    }

    public void dump() {
    }
}

