/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.container;

import com.ibm.ejs.container.BeanNotReentrantException;
import com.ibm.ejs.container.ContainerProperties;
import com.ibm.ejs.container.CreateFailureException;
import com.ibm.ejs.container.EJSDeployedSupport;
import com.ibm.ejs.container.ExceptionMappingStrategy;
import com.ibm.ejs.container.InvalidTransactionLocalException;
import com.ibm.ejs.container.WrapperInterface;
import com.ibm.ejs.container.util.ExceptionUtil;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.csi.CSIAccessException;
import com.ibm.websphere.csi.CSIActivityCompletedException;
import com.ibm.websphere.csi.CSIActivityRequiredException;
import com.ibm.websphere.csi.CSIException;
import com.ibm.websphere.csi.CSIInvalidActivityException;
import com.ibm.websphere.csi.CSIInvalidTransactionException;
import com.ibm.websphere.csi.CSINoSuchObjectException;
import com.ibm.websphere.csi.CSITransactionRequiredException;
import com.ibm.websphere.csi.CSITransactionRolledbackException;
import com.ibm.websphere.csi.ExceptionType;
import com.ibm.websphere.csi.OrbUtils;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.javax.activity.ActivityCompletedException;
import com.ibm.ws.javax.activity.ActivityRequiredException;
import com.ibm.ws.javax.activity.InvalidActivityException;
import com.ibm.ws.javax.ejb.ActivityCompletedLocalException;
import com.ibm.ws.javax.ejb.ActivityRequiredLocalException;
import com.ibm.ws.javax.ejb.InvalidActivityLocalException;
import java.rmi.AccessException;
import java.rmi.NoSuchObjectException;
import java.rmi.RemoteException;
import javax.ejb.AccessLocalException;
import javax.ejb.ConcurrentAccessException;
import javax.ejb.EJBException;
import javax.ejb.NoSuchObjectLocalException;
import javax.ejb.TransactionRequiredLocalException;
import javax.ejb.TransactionRolledbackLocalException;
import javax.transaction.HeuristicMixedException;
import javax.transaction.InvalidTransactionException;
import javax.transaction.TransactionRequiredException;
import javax.transaction.TransactionRolledbackException;

public class RemoteExceptionMappingStrategy
extends ExceptionMappingStrategy {
    protected static TraceComponent tc = Tr.register(RemoteExceptionMappingStrategy.class, "EJBContainer", "com.ibm.ejs.container.container");
    private static final String CLASS_NAME = "com.ibm.ejs.container.RemoteExceptionMappingStrategy";
    OrbUtils ivOrbUtils = null;

    public RemoteExceptionMappingStrategy(EJSDeployedSupport wrapper) {
        super(wrapper);
        this.ivOrbUtils = wrapper.container.orbUtils;
    }

    private Throwable mapException(RemoteException ex) {
        try {
            if (ex instanceof CSIException) {
                CSIException csiex = (CSIException)ex;
                return this.mapCSIException(csiex);
            }
            if (ex.detail instanceof CSIException) {
                CSIException csiex = (CSIException)ex.detail;
                return this.mapCSIException(csiex);
            }
            if (ex instanceof CreateFailureException) {
                if (this.ivOrbUtils == null) {
                    return ex;
                }
                return this.ivOrbUtils.mapException(ex);
            }
            if (ex instanceof BeanNotReentrantException && (this.thisStrategiesOwner.ivWrapper.ivInterface == WrapperInterface.BUSINESS_RMI_REMOTE || this.thisStrategiesOwner.ivWrapper.ivInterface == WrapperInterface.SERVICE_ENDPOINT)) {
                ConcurrentAccessException caex = new ConcurrentAccessException(ex.getMessage());
                caex.setStackTrace(ex.getStackTrace());
                this.root = caex;
                return this.mapEJBException(caex);
            }
            if (ex.detail instanceof EJBException) {
                EJBException ejbex = (EJBException)ex.detail;
                return this.mapEJBException(ejbex);
            }
            if (this.ivOrbUtils == null) {
                return ex;
            }
            return this.ivOrbUtils.mapException(ex);
        }
        catch (CSIException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ejs.container.RemoteExceptionMappingStrategy.mapException", (String)"119", (Object)this);
            Tr.warning(tc, "UNABLE_TO_MAP_EXCEPTION_CNTR0013W", new Object[]{ex, e});
            return ex;
        }
    }

    public final Throwable setUncheckedException(Throwable ex) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "setUncheckedException in param:" + ex);
        }
        if (this.ivException != null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                Tr.event(tc, "setting unchecked exception again", ex);
                Tr.event(tc, "original exception", this.ivException);
            }
            return this.ivException;
        }
        Boolean applicationExceptionRollback = null;
        int moduleVersion = this.thisStrategiesOwner.ivWrapper.bmd.ivModuleVersion;
        if (moduleVersion >= 30 && ex instanceof Exception && !(ex instanceof RemoteException)) {
            applicationExceptionRollback = this.getApplicationExceptionRollback(ex);
        }
        if (applicationExceptionRollback != null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                Tr.event(tc, "ApplicationException with rollback set to true, changing to a checked exception", ex);
            }
            this.exType = ExceptionType.CHECKED_EXCEPTION;
            this.ivException = ex;
            this.root = ex;
            if (applicationExceptionRollback == Boolean.TRUE) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                    Tr.event(tc, "ApplicationException with rollback set to true, setting rollback only", ex);
                }
                this.thisStrategiesOwner.currentTx.setRollbackOnly();
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "setUncheckedException returning: " + this.ivException);
            }
            return this.ivException;
        }
        if (this.thisStrategiesOwner.preInvokeException && (ex instanceof NoSuchObjectException || ex instanceof CSIAccessException || ex instanceof BeanNotReentrantException)) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception should not cause rollback, changing to checked exception");
            }
            if (ex instanceof BeanNotReentrantException) {
                this.thisStrategiesOwner.beanO = null;
            }
            this.exType = ExceptionType.CHECKED_EXCEPTION;
        } else {
            this.exType = ExceptionType.UNCHECKED_EXCEPTION;
            ExceptionUtil.logException(tc, ex, this.thisStrategiesOwner.getEJBMethodInfo(), this.thisStrategiesOwner.getBeanO());
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ejs.container.RemoteExceptionMappingStrategy.setUncheckedException", (String)"200", (Object)this);
        }
        this.root = this.findRootCause(ex);
        if (!(ex instanceof RemoteException)) {
            ex = new RemoteException("", ex);
            ex.setStackTrace(this.root.getStackTrace());
        }
        this.ivException = this.mapException((RemoteException)ex);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "setUncheckedException returning : " + this.ivException);
        }
        this.ivException.setStackTrace(this.root.getStackTrace());
        return this.ivException;
    }

    private Exception mapCSIException(CSIException e) throws CSIException {
        RemoteException rex;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "mapCSIException: " + e);
        }
        Exception mappedException = null;
        String message = " ";
        if (e instanceof CSITransactionRolledbackException) {
            rex = e.detail instanceof HeuristicMixedException ? new RemoteException("", e.detail) : new TransactionRolledbackException(message);
        } else if (e instanceof CSIAccessException) {
            rex = new AccessException(message);
        } else if (e instanceof CSIInvalidTransactionException) {
            rex = new InvalidTransactionException(message);
        } else if (e instanceof CSITransactionRequiredException) {
            rex = new TransactionRequiredException(message);
        } else if (e instanceof CSIInvalidActivityException) {
            rex = new InvalidActivityException(message);
        } else if (e instanceof CSIActivityRequiredException) {
            rex = new ActivityRequiredException(message);
        } else if (e instanceof CSIActivityCompletedException) {
            rex = new ActivityCompletedException(message);
        } else if (e instanceof CSINoSuchObjectException) {
            rex = new NoSuchObjectException(message);
        } else {
            e.detail = null;
            rex = new RemoteException(e.getMessage());
        }
        if (ContainerProperties.IncludeNestedExceptions) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Nested exceptions will be included on rollback when possible. " + rex + ": " + this.thisStrategiesOwner.began);
            }
            if (rex instanceof TransactionRolledbackException && this.thisStrategiesOwner.began) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "Transaction was begun in context of this bean method.");
                }
                rex = new RemoteException("", rex);
            }
        }
        rex.detail = this.root;
        rex.setStackTrace(this.root.getStackTrace());
        if (this.ivOrbUtils != null) {
            int minorCode;
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "mapCSIException calling OrbUtils.mapException: " + rex);
            }
            mappedException = (minorCode = e.getMinorCode()) == 0 ? this.ivOrbUtils.mapException(rex) : this.ivOrbUtils.mapException(rex, minorCode);
        } else {
            mappedException = rex;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "mapCSIException returning: " + mappedException);
        }
        return mappedException;
    }

    public Exception mapCSITransactionRolledBackException(CSITransactionRolledbackException ex) throws CSIException {
        if (this.root == null) {
            this.root = ExceptionUtil.findRootCause(ex);
        }
        Exception mappedEx = this.mapCSIException(ex);
        mappedEx.setStackTrace(this.root.getStackTrace());
        return mappedEx;
    }

    private Exception mapEJBException(EJBException e) throws CSIException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "mapEJBException: " + e);
        }
        Exception mappedException = null;
        String message = " ";
        Object rex = e instanceof TransactionRolledbackLocalException ? new TransactionRolledbackException(message) : (e instanceof AccessLocalException ? new AccessException(message) : (e instanceof InvalidTransactionLocalException ? new InvalidTransactionException(message) : (e instanceof NoSuchObjectLocalException ? new NoSuchObjectException(message) : (e instanceof TransactionRequiredLocalException ? new TransactionRequiredException(message) : (e instanceof InvalidActivityLocalException ? new InvalidActivityException(message) : (e instanceof ActivityRequiredLocalException ? new ActivityRequiredException(message) : (e instanceof ActivityCompletedLocalException ? new ActivityCompletedException(message) : new RemoteException(message))))))));
        ((RemoteException)rex).detail = this.root;
        ((Throwable)rex).setStackTrace(this.root.getStackTrace());
        if (this.ivOrbUtils != null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "mapEJBException calling OrbUtils.mapException: " + rex);
            }
            mappedException = this.ivOrbUtils.mapException((RemoteException)rex);
        } else {
            mappedException = rex;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "mapEJBException returning: " + mappedException);
        }
        return mappedException;
    }
}

