/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.container;

import com.ibm.ejs.container.BeanId;
import com.ibm.ejs.container.BeanMetaData;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.rmi.NoSuchObjectException;
import java.rmi.RemoteException;
import java.util.Properties;
import javax.ejb.EJBHome;
import javax.ejb.EJBObject;
import javax.ejb.Handle;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.naming.NoInitialContextException;
import javax.rmi.PortableRemoteObject;

public class EntityHandle
implements Handle,
Serializable {
    private static final TraceComponent tc = Tr.register(EntityHandle.class, "EJBContainer", "com.ibm.ejs.container.container");
    String homeJNDIName;
    String homeInterface;
    Serializable key;
    final Properties initialContextProperties;
    transient EJBObject object;
    transient ClassLoader classLoader;
    private static final long serialVersionUID = 2909502407438195167L;

    EntityHandle(BeanId id, BeanMetaData bmd, Properties props) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "<init>", id);
        }
        this.homeJNDIName = id.getJNDIName();
        this.key = id.getPrimaryKey();
        this.homeInterface = bmd.homeInterfaceClass.getName();
        this.initialContextProperties = props;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "<init>");
        }
    }

    public EJBObject getEJBObject() throws RemoteException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "getEJBObject");
        }
        if (this.object == null) {
            try {
                Class<?> homeClass = null;
                try {
                    ClassLoader cl = Thread.currentThread().getContextClassLoader();
                    if (cl == null) {
                        throw new ClassNotFoundException();
                    }
                    homeClass = cl.loadClass(this.homeInterface);
                }
                catch (ClassNotFoundException ex) {
                    try {
                        homeClass = Class.forName(this.homeInterface);
                    }
                    catch (ClassNotFoundException e) {
                        throw new ClassNotFoundException(this.homeInterface);
                    }
                }
                InitialContext ctx = null;
                EJBHome home = null;
                try {
                    if (this.initialContextProperties == null) {
                        ctx = new InitialContext();
                    } else {
                        try {
                            ctx = new InitialContext(this.initialContextProperties);
                            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                Tr.debug(tc, "Created an initial context with the initialContextProperties, providerURL = " + (String)this.initialContextProperties.get("java.naming.provider.url") + " INITIAL_CONTEXT_FACTORY = " + (String)this.initialContextProperties.get("java.naming.factory.initial"));
                            }
                        }
                        catch (NamingException ne) {
                            ctx = new InitialContext();
                        }
                    }
                    home = (EJBHome)PortableRemoteObject.narrow((Object)ctx.lookup(this.homeJNDIName), homeClass);
                }
                catch (NoInitialContextException e) {
                    Properties p = new Properties();
                    p.put("java.naming.factory.initial", "com.ibm.websphere.naming.WsnInitialContextFactory");
                    ctx = new InitialContext(p);
                    home = (EJBHome)PortableRemoteObject.narrow((Object)ctx.lookup(this.homeJNDIName), homeClass);
                }
                Method fbpk = this.findFindByPrimaryKey(homeClass);
                this.object = (EJBObject)fbpk.invoke((Object)home, this.key);
            }
            catch (InvocationTargetException e) {
                Throwable t;
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.exit(tc, "getEJBObject", e);
                }
                if ((t = e.getTargetException()) instanceof RemoteException) {
                    throw (RemoteException)t;
                }
                throw new RemoteException("Could not find bean", t);
            }
            catch (NamingException e) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.exit(tc, "getEJBObject", e);
                }
                NoSuchObjectException re = new NoSuchObjectException("Could not find home in JNDI");
                re.detail = e;
                throw re;
            }
            catch (ClassNotFoundException e) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.exit(tc, "getEJBObject", e);
                }
                throw new RemoteException("Could not load home interface", e);
            }
            catch (IllegalAccessException e) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.exit(tc, "getEJBObject", e);
                }
                throw new RemoteException("Bad home interface definition", e);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "getEJBObject");
        }
        return this.object;
    }

    private Method findFindByPrimaryKey(Class c) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "findFindByPrimaryKey", c);
        }
        Method[] methods = c.getMethods();
        for (int i = 0; i < methods.length; ++i) {
            if (!methods[i].getName().equals("findByPrimaryKey")) continue;
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "findFindByPrimaryKey");
            }
            return methods[i];
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "findFindByPrimaryKey: method findByPrimaryKey not found!");
        }
        return null;
    }
}

