/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.container;

import com.ibm.ejs.container.BeanId;
import com.ibm.ejs.container.BeanMetaData;
import com.ibm.ejs.container.BusinessLocalWrapper;
import com.ibm.ejs.container.BusinessRemoteWrapper;
import com.ibm.ejs.container.ContainerException;
import com.ibm.ejs.container.EJSContainer;
import com.ibm.ejs.container.EJSLocalWrapper;
import com.ibm.ejs.container.EJSRemoteWrapper;
import com.ibm.ejs.container.EJSWrapper;
import com.ibm.ejs.container.WrapperId;
import com.ibm.ejs.container.WrapperInterface;
import com.ibm.ejs.container.WrapperManager;
import com.ibm.ejs.container.drs.SfDRSClient;
import com.ibm.ejs.container.util.EJSPlatformHelper;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.util.cache.Element;
import com.ibm.ejs.util.cache.WrapperBucket;
import com.ibm.ejs.util.dopriv.SetContextClassLoaderPrivileged;
import com.ibm.websphere.pmi.PmiBean;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.runtime.component.EJBContainerImpl;
import com.ibm.ws.runtime.component.EJBContainerImpl_threadLocal;
import com.ibm.ws.security.util.AccessController;
import com.ibm.wsspi.cluster.Identity;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.security.PrivilegedAction;

public final class EJSWrapperCommon
extends Element {
    private static final TraceComponent tc = Tr.register(EJSWrapperCommon.class, "EJBContainer", "com.ibm.ejs.container.container");
    private static final String CLASS_NAME = "com.ibm.ejs.container.EJSWrapperCommon";
    private static final boolean isZOS = EJSPlatformHelper.isZOS();
    protected EJSWrapper remoteWrapper;
    protected EJSRemoteWrapper ivRemoteObject;
    protected EJSLocalWrapper localWrapper;
    protected BusinessLocalWrapper[] ivBusinessLocal;
    protected BusinessRemoteWrapper[] ivBusinessRemote;
    protected boolean[] ivBusinessRemoteRegistered;
    protected boolean isHome;
    protected boolean isRemoteRegistered;
    public WrapperBucket ivWrapperCacheBucket;
    private BeanId ivBeanId;
    protected BeanMetaData ivBMD;

    public EJSWrapperCommon(Class remoteClass, Class localClass, BeanId id, BeanMetaData bmd, PmiBean pmiBean, EJSContainer container2, WrapperManager wrapperManager, boolean isHome) throws RemoteException {
        super((Object)id.getByteArray());
        this.ivBeanId = id;
        String className = null;
        try {
            int i;
            this.isHome = isHome;
            this.ivBMD = bmd;
            if (remoteClass != null) {
                className = remoteClass.getName();
                this.remoteWrapper = (EJSWrapper)remoteClass.newInstance();
                this.ivRemoteObject = this.remoteWrapper;
                this.remoteWrapper.beanId = id;
                this.remoteWrapper.bmd = bmd;
                this.remoteWrapper.methodInfos = isHome ? bmd.homeMethodInfos : bmd.methodInfos;
                this.remoteWrapper.isolationAttrs = isHome ? bmd.homeIsolationAttrs : bmd.isolationAttrs;
                this.remoteWrapper.methodNames = isHome ? bmd.homeMethodNames : bmd.methodNames;
                this.remoteWrapper.container = container2;
                this.remoteWrapper.wrapperManager = wrapperManager;
                this.remoteWrapper.ivPmiBean = pmiBean;
                this.remoteWrapper.ivCommon = this;
                this.remoteWrapper.isManagedWrapper = true;
                WrapperInterface wrapperInterface = this.remoteWrapper.ivInterface = isHome ? WrapperInterface.HOME : WrapperInterface.REMOTE;
                if (isHome || !bmd.isStatefulSessionBean()) {
                    this.remoteWrapper.ivCluster = bmd.ivCluster;
                } else {
                    this.remoteWrapper.ivCluster = null;
                    SfDRSClient drs = bmd.ivSfDRSClient;
                    if (drs != null) {
                        this.remoteWrapper.ivCluster = drs.getWLMIdentity(id);
                    }
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug(tc, "SFSB WLM Cluster Identity from DRS: " + this.remoteWrapper.ivCluster);
                    }
                }
            }
            if (localClass != null) {
                className = localClass.getName();
                this.localWrapper = (EJSLocalWrapper)localClass.newInstance();
                this.localWrapper.beanId = id;
                this.localWrapper.bmd = bmd;
                this.localWrapper.methodInfos = isHome ? bmd.localHomeMethodInfos : bmd.localMethodInfos;
                this.localWrapper.methodNames = isHome ? bmd.localHomeMethodNames : bmd.localMethodNames;
                this.localWrapper.container = container2;
                this.localWrapper.wrapperManager = wrapperManager;
                this.localWrapper.ivPmiBean = pmiBean;
                this.localWrapper.ivCommon = this;
                this.localWrapper.isManagedWrapper = false;
                WrapperInterface wrapperInterface = this.localWrapper.ivInterface = isHome ? WrapperInterface.LOCAL_HOME : WrapperInterface.LOCAL;
            }
            if (!isHome && bmd.ivBusinessLocalImplClasses != null) {
                BusinessLocalWrapper bLocal = null;
                int numLocalWrappers = bmd.ivBusinessLocalImplClasses.length;
                this.ivBusinessLocal = new BusinessLocalWrapper[numLocalWrappers];
                for (i = 0; i < numLocalWrappers; ++i) {
                    className = bmd.ivBusinessLocalImplClasses[i].getName();
                    bLocal = (BusinessLocalWrapper)bmd.ivBusinessLocalImplClasses[i].newInstance();
                    bLocal.beanId = id;
                    bLocal.bmd = bmd;
                    bLocal.methodInfos = bmd.localMethodInfos;
                    bLocal.methodNames = bmd.localMethodNames;
                    bLocal.container = container2;
                    bLocal.wrapperManager = wrapperManager;
                    bLocal.ivPmiBean = pmiBean;
                    bLocal.ivCommon = this;
                    bLocal.isManagedWrapper = false;
                    bLocal.ivInterface = WrapperInterface.BUSINESS_LOCAL;
                    bLocal.ivBusinessInterfaceIndex = i;
                    this.ivBusinessLocal[i] = bLocal;
                }
            }
            if (!isHome && bmd.ivBusinessRemoteImplClasses != null) {
                BusinessRemoteWrapper bRemote = null;
                int numRemoteWrappers = bmd.ivBusinessRemoteImplClasses.length;
                this.ivBusinessRemote = new BusinessRemoteWrapper[numRemoteWrappers];
                this.ivBusinessRemoteRegistered = new boolean[numRemoteWrappers];
                for (i = 0; i < numRemoteWrappers; ++i) {
                    className = bmd.ivBusinessRemoteImplClasses[i].getName();
                    bRemote = (BusinessRemoteWrapper)bmd.ivBusinessRemoteImplClasses[i].newInstance();
                    bRemote.beanId = id;
                    bRemote.bmd = bmd;
                    bRemote.methodInfos = bmd.methodInfos;
                    bRemote.isolationAttrs = bmd.isolationAttrs;
                    bRemote.methodNames = bmd.methodNames;
                    bRemote.container = container2;
                    bRemote.wrapperManager = wrapperManager;
                    bRemote.ivPmiBean = pmiBean;
                    bRemote.ivCommon = this;
                    bRemote.isManagedWrapper = true;
                    bRemote.ivInterface = Remote.class.isAssignableFrom(bmd.ivBusinessRemoteInterfaceClasses[i]) ? WrapperInterface.BUSINESS_RMI_REMOTE : WrapperInterface.BUSINESS_REMOTE;
                    bRemote.ivBusinessInterfaceIndex = i;
                    if (!bmd.isStatefulSessionBean()) {
                        bRemote.ivCluster = bmd.ivCluster;
                    } else {
                        bRemote.ivCluster = null;
                        SfDRSClient drs = bmd.ivSfDRSClient;
                        if (drs != null) {
                            bRemote.ivCluster = drs.getWLMIdentity(id);
                        }
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            Tr.debug(tc, "SFSB WLM Cluster Identity from DRS: " + bRemote.ivCluster);
                        }
                    }
                    this.ivBusinessRemote[i] = bRemote;
                }
            }
        }
        catch (Exception ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ejs.container.EJSWrapperCommon.EJSWrapperCommon", (String)"123", (Object)this);
            throw new ContainerException(className, ex);
        }
    }

    public EJSWrapperCommon(EJSRemoteWrapper ejbFactory, BeanId beanId, Identity cluster, EJSContainer container2) {
        super((Object)beanId.getByteArray());
        this.ivBeanId = beanId;
        this.isHome = true;
        this.ivBMD = null;
        this.ivRemoteObject = ejbFactory;
        this.ivRemoteObject.beanId = beanId;
        this.ivRemoteObject.bmd = null;
        this.ivRemoteObject.methodInfos = null;
        this.ivRemoteObject.methodNames = null;
        this.ivRemoteObject.isolationAttrs = null;
        this.ivRemoteObject.container = container2;
        this.ivRemoteObject.wrapperManager = container2.wrapperManager;
        this.ivRemoteObject.ivPmiBean = null;
        this.ivRemoteObject.ivCommon = this;
        this.ivRemoteObject.isManagedWrapper = true;
        this.ivRemoteObject.ivInterface = WrapperInterface.HOME;
        this.ivRemoteObject.ivCluster = cluster;
    }

    public EJSWrapper getRemoteWrapper() {
        if (this.remoteWrapper == null) {
            throw new IllegalStateException("Remote interface not defined");
        }
        this.registerServant();
        return this.remoteWrapper;
    }

    public EJSRemoteWrapper getRemoteObject() {
        this.registerServant();
        return this.ivRemoteObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void registerServant() {
        if (this.ivRemoteObject != null) {
            EJSRemoteWrapper eJSRemoteWrapper = this.ivRemoteObject;
            synchronized (eJSRemoteWrapper) {
                block16: {
                    if (!this.isRemoteRegistered) {
                        try {
                            block15: {
                                if (!isZOS) {
                                    ClassLoader originalLoader = null;
                                    boolean resetClassLoader = false;
                                    SetContextClassLoaderPrivileged setCLPrivObj = ((EJBContainerImpl_threadLocal)EJBContainerImpl.svEJBContainerImpl_threadLocal.get()).ivClassLoaderChanger;
                                    try {
                                        if (this.ivBMD != null) {
                                            setCLPrivObj.newClassLoader = this.ivBMD.classLoader;
                                            AccessController.doPrivileged((PrivilegedAction)setCLPrivObj);
                                            originalLoader = setCLPrivObj.oldClassLoader;
                                            resetClassLoader = setCLPrivObj.wasChanged;
                                            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                                if (resetClassLoader) {
                                                    Tr.debug(tc, "registerServant : old ClassLoader = " + originalLoader);
                                                    Tr.debug(tc, "registerServant : new ClassLoader = " + this.ivBMD.classLoader);
                                                } else {
                                                    Tr.debug(tc, "registerServant : current ClassLoader = " + this.ivBMD.classLoader);
                                                }
                                            }
                                        }
                                        this.ivRemoteObject.wrapperManager.oa.registerServant(this.ivRemoteObject, this.ivRemoteObject.beanId.getByteArray(), this.ivRemoteObject.ivCluster, this.ivRemoteObject.beanId.useLSD());
                                        Object var6_6 = null;
                                        if (!resetClassLoader) break block15;
                                        setCLPrivObj.newClassLoader = originalLoader;
                                    }
                                    catch (Throwable throwable) {
                                        Object var6_7 = null;
                                        if (resetClassLoader) {
                                            setCLPrivObj.newClassLoader = originalLoader;
                                            AccessController.doPrivileged((PrivilegedAction)setCLPrivObj);
                                        }
                                        throw throwable;
                                    }
                                    AccessController.doPrivileged((PrivilegedAction)setCLPrivObj);
                                    {
                                    }
                                }
                            }
                            this.isRemoteRegistered = true;
                        }
                        catch (Exception ex) {
                            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ejs.container.EJSWrapperCommon.registerServant", (String)"184", (Object)this);
                            if (!TraceComponent.isAnyTracingEnabled() || !tc.isEventEnabled()) break block16;
                            Tr.event(tc, "Failed to register wrapper instance", new Object[]{this.ivRemoteObject, ex});
                        }
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerServant(BusinessRemoteWrapper wrapper, int i) {
        BusinessRemoteWrapper businessRemoteWrapper = wrapper;
        synchronized (businessRemoteWrapper) {
            block15: {
                if (!this.ivBusinessRemoteRegistered[i]) {
                    try {
                        block14: {
                            if (!isZOS) {
                                WrapperId wrapperId = new WrapperId(wrapper.beanId.getByteArrayBytes(), wrapper.bmd.ivBusinessRemoteInterfaceClasses[i].getName(), i);
                                ClassLoader originalLoader = null;
                                boolean resetClassLoader = false;
                                SetContextClassLoaderPrivileged setCLPrivObj = ((EJBContainerImpl_threadLocal)EJBContainerImpl.svEJBContainerImpl_threadLocal.get()).ivClassLoaderChanger;
                                try {
                                    if (this.ivBMD != null) {
                                        setCLPrivObj.newClassLoader = this.ivBMD.classLoader;
                                        AccessController.doPrivileged((PrivilegedAction)setCLPrivObj);
                                        originalLoader = setCLPrivObj.oldClassLoader;
                                        resetClassLoader = setCLPrivObj.wasChanged;
                                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                            if (resetClassLoader) {
                                                Tr.debug(tc, "registerServant : old ClassLoader = " + originalLoader);
                                                Tr.debug(tc, "registerServant : new ClassLoader = " + this.ivBMD.classLoader);
                                            } else {
                                                Tr.debug(tc, "registerServant : current ClassLoader = " + this.ivBMD.classLoader);
                                            }
                                        }
                                    }
                                    wrapper.wrapperManager.oa.registerServant(wrapper, wrapperId, wrapper.ivCluster, wrapper.beanId.useLSD());
                                    Object var9_9 = null;
                                    if (!resetClassLoader) break block14;
                                    setCLPrivObj.newClassLoader = originalLoader;
                                }
                                catch (Throwable throwable) {
                                    Object var9_10 = null;
                                    if (resetClassLoader) {
                                        setCLPrivObj.newClassLoader = originalLoader;
                                        AccessController.doPrivileged((PrivilegedAction)setCLPrivObj);
                                    }
                                    throw throwable;
                                }
                                AccessController.doPrivileged((PrivilegedAction)setCLPrivObj);
                                {
                                }
                            }
                        }
                        this.ivBusinessRemoteRegistered[i] = true;
                    }
                    catch (Throwable ex) {
                        FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ejs.container.EJSWrapperCommon.registerServant", (String)"439", (Object)this);
                        if (!TraceComponent.isAnyTracingEnabled() || !tc.isEventEnabled()) break block15;
                        Tr.event(tc, "Failed to register wrapper instance", new Object[]{wrapper, ex});
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void unregisterServant() {
        if (this.ivRemoteObject != null) {
            EJSRemoteWrapper eJSRemoteWrapper = this.ivRemoteObject;
            synchronized (eJSRemoteWrapper) {
                block17: {
                    if (this.isRemoteRegistered) {
                        try {
                            if (!isZOS || this.ivRemoteObject.intie != null) {
                                this.ivRemoteObject.wrapperManager.oa.unregisterServant(this.ivRemoteObject);
                            }
                            this.isRemoteRegistered = false;
                        }
                        catch (Exception ex) {
                            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ejs.container.EJSWrapperCommon.unregisterServant", (String)"207", (Object)this);
                            if (!TraceComponent.isAnyTracingEnabled() || !tc.isEventEnabled()) break block17;
                            Tr.event(tc, "Failed to unregister wrapper instance", new Object[]{this.ivRemoteObject, ex});
                        }
                    }
                }
            }
        }
        if (this.ivBusinessRemote != null) {
            int numWrappers = this.ivBusinessRemote.length;
            for (int i = 0; i < numWrappers; ++i) {
                BusinessRemoteWrapper wrapper;
                BusinessRemoteWrapper businessRemoteWrapper = wrapper = this.ivBusinessRemote[i];
                synchronized (businessRemoteWrapper) {
                    block18: {
                        if (this.ivBusinessRemoteRegistered[i]) {
                            try {
                                if (!isZOS || wrapper.intie != null) {
                                    wrapper.wrapperManager.oa.unregisterServant(wrapper);
                                }
                                this.ivBusinessRemoteRegistered[i] = false;
                            }
                            catch (Throwable ex) {
                                FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ejs.container.EJSWrapperCommon.unregisterServant", (String)"516", (Object)this);
                                if (!TraceComponent.isAnyTracingEnabled() || !tc.isEventEnabled()) break block18;
                                Tr.event(tc, "Failed to unregister wrapper instance", new Object[]{wrapper, ex});
                            }
                        }
                    }
                    continue;
                }
            }
        }
    }

    public EJSLocalWrapper getLocalWrapper() {
        if (this.localWrapper == null) {
            throw new IllegalStateException("Local interface not defined");
        }
        return this.localWrapper;
    }

    public Object getBusinessObject(Class businessInterface) {
        int i;
        int numInterfaces;
        Class[] bInterfaces = this.ivBMD.ivBusinessLocalInterfaceClasses;
        if (bInterfaces != null) {
            numInterfaces = bInterfaces.length;
            for (i = 0; i < numInterfaces; ++i) {
                if (bInterfaces[i] != businessInterface) continue;
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "getBusinessObject : " + this.ivBusinessLocal[i].getClass().getName());
                }
                return this.ivBusinessLocal[i];
            }
        }
        if ((bInterfaces = this.ivBMD.ivBusinessRemoteInterfaceClasses) != null) {
            numInterfaces = bInterfaces.length;
            for (i = 0; i < numInterfaces; ++i) {
                if (bInterfaces[i] != businessInterface) continue;
                BusinessRemoteWrapper wrapper = this.ivBusinessRemote[i];
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "getBusinessObject : " + wrapper.getClass().getName());
                }
                this.registerServant(wrapper, i);
                return wrapper;
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "getBusinessObject : IllegalStateException : Requested business interface not found : " + businessInterface);
        }
        throw new IllegalStateException("Requested business interface not found : " + (businessInterface == null ? "null" : businessInterface.getName()));
    }

    public BusinessRemoteWrapper getRemoteBusinessWrapper(WrapperId wrapperId) {
        int remoteIndex = wrapperId.ivInterfaceIndex;
        BusinessRemoteWrapper wrapper = null;
        String wrapperInterfaceName = "";
        if (remoteIndex < this.ivBusinessRemote.length) {
            wrapper = this.ivBusinessRemote[remoteIndex];
            wrapperInterfaceName = this.ivBMD.ivBusinessRemoteInterfaceClasses[remoteIndex].getName();
        }
        String interfaceName = wrapperId.ivInterfaceClassName;
        if (wrapper == null || !wrapperInterfaceName.equals(interfaceName)) {
            wrapper = null;
            for (int i = 0; i < this.ivBusinessRemote.length; ++i) {
                wrapperInterfaceName = this.ivBMD.ivBusinessRemoteInterfaceClasses[i].getName();
                if (!wrapperInterfaceName.equals(interfaceName)) continue;
                remoteIndex = i;
                wrapper = this.ivBusinessRemote[remoteIndex];
                wrapperId.ivInterfaceIndex = remoteIndex;
                break;
            }
        }
        this.registerServant(wrapper, remoteIndex);
        return wrapper;
    }

    public BeanId getBeanId() {
        return this.ivBeanId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean pinOnce() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "pinOnce: " + this.ivBeanId);
        }
        boolean pinnedOnce = false;
        WrapperBucket wrapperBucket = this.ivWrapperCacheBucket;
        synchronized (wrapperBucket) {
            if (this.pinned == 0) {
                ++this.pinned;
                pinnedOnce = true;
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "pinOnce : " + this.pinned);
        }
        return pinnedOnce;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unpin() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "unpin: " + this.ivBeanId);
        }
        WrapperBucket wrapperBucket = this.ivWrapperCacheBucket;
        synchronized (wrapperBucket) {
            if (this.pinned > 0) {
                --this.pinned;
                this.ivWrapperCacheBucket.ivWrapperCache.touch(this);
            } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "unpin: Not pinned : " + this.pinned);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "unpin");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean inCache() {
        boolean inCache = false;
        WrapperBucket wrapperBucket = this.ivWrapperCacheBucket;
        synchronized (wrapperBucket) {
            if (this.pinned >= 0) {
                this.ivWrapperCacheBucket.ivWrapperCache.touch(this);
                inCache = true;
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "touch: inCache = " + inCache + ", " + this.ivBeanId);
        }
        return inCache;
    }

    public String toString() {
        String businessRemote = "NoBRemote, ";
        if (this.ivBusinessRemote != null) {
            businessRemote = "BR: ";
            for (BusinessRemoteWrapper wrapper : this.ivBusinessRemote) {
                businessRemote = businessRemote + wrapper.getClass().getName();
                businessRemote = businessRemote + ", ";
            }
        }
        String businessLocal = "NoBLocal, ";
        if (this.ivBusinessLocal != null) {
            businessLocal = "BL: ";
            for (BusinessLocalWrapper wrapper : this.ivBusinessLocal) {
                businessLocal = businessLocal + wrapper.getClass().getName();
                businessLocal = businessLocal + ", ";
            }
        }
        return "EJSWrapperCommon(" + this.ivBeanId + ", " + (this.ivRemoteObject != null ? this.ivRemoteObject.getClass().getName() : "NoRemote") + ", " + (this.localWrapper != null ? this.localWrapper.getClass().getName() : "NoLocal") + ", " + businessRemote + businessLocal + "pinned = " + this.pinned + ", accessed = " + this.accessedSweep + ")";
    }
}

