/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.container;

import com.ibm.ejs.container.BindingData;
import com.ibm.ejs.container.BindingsHelper;
import com.ibm.ejs.container.ContainerTx;
import com.ibm.ejs.container.EJBMethodInfoImpl;
import com.ibm.ejs.container.EJSContainer;
import com.ibm.ejs.container.EJSDeployedSupport;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.util.dopriv.SystemGetPropertyPrivileged;
import com.ibm.ws.Transaction.TransactionManagerFactory;
import com.ibm.ws.Transaction.UOWCoordinator;
import com.ibm.ws.Transaction.UOWCurrent;
import com.ibm.ws.ffdc.DiagnosticModule;
import com.ibm.ws.ffdc.FFDC;
import com.ibm.ws.ffdc.IncidentStream;
import com.ibm.ws.runtime.component.EJBContainerImpl;
import com.ibm.ws.runtime.metadata.ComponentMetaData;
import com.ibm.ws.security.util.AccessController;
import com.ibm.ws.threadContext.ComponentMetaDataAccessorImpl;
import com.ibm.ws.threadContext.ThreadContext;
import java.security.PrivilegedAction;
import java.util.HashMap;
import javax.naming.NameAlreadyBoundException;

public class EJBContainerDiagnosticModule
extends DiagnosticModule {
    private static final TraceComponent tc = Tr.register(EJBContainerDiagnosticModule.class, "EJBContainer", "com.ibm.ejs.container.container");
    private static final String JNDI_NAME = "     jndi name = ";
    private static final String EXPLICIT_BEAN = "                 explicit bean      = ";
    private static final String EXPLICIT_INTF = "                 explicit interface = ";
    private static final String IMPLICIT_BEAN = "                 implicit beans     = ";
    private static EJBContainerDiagnosticModule svInstance = null;
    private boolean ivRegisteredWithFFDC = false;
    private EJBContainerImpl ivEJBContainer = null;
    private EJSContainer ivEJSContainer = null;
    private String[] ivPackageList = new String[]{"com.ibm.ejs.container", "com.ibm.ejs.csi", "com.ibm.ejs.persistence", "com.ibm.ejs.util.cache", "com.ibm.ejs.util.opool", "com.ibm.ejs.util.tran", "com.ibm.websphere.cpi", "com.ibm.websphere.cpmi", "com.ibm.websphere.csi", "com.ibm.ws.ejb.portable", "com.ibm.ws.ejbcontainer", "com.ibm.ws.cpi", "com.ibm.ws.cpmi", "com.ibm.ws.metadata.ejb", "com.ibm.ws.runtime.component.EJBContainerImpl", "com.ibm.ws.threadContext.ws.ComponentMetaDataAccessorImpl", "com.ibm.ws.threadContext.ws.EJBMethodInfoAccessorImpl", "com.ibm.ws.threadContext.ws.EJSDeployedSupportAccessorImpl"};

    private EJBContainerDiagnosticModule() {
    }

    public static synchronized EJBContainerDiagnosticModule instance() {
        if (svInstance == null) {
            svInstance = new EJBContainerDiagnosticModule();
        }
        return svInstance;
    }

    public synchronized void initialize(EJBContainerImpl service, EJSContainer internal) {
        this.ivEJBContainer = service;
        this.ivEJSContainer = internal;
    }

    public synchronized boolean registerWithFFDCService() {
        boolean result = true;
        boolean abort = false;
        int retCode = 0;
        int packageIndex = 0;
        if (this.ivRegisteredWithFFDC) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                Tr.event(tc, "EJBContainerDiagnosticModule already registered");
            }
            result = false;
            abort = true;
        }
        if (this.ivEJBContainer == null || this.ivEJSContainer == null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                Tr.event(tc, "EJBContainerDiagnosticModule not initialized: registration with FFDC Service not performed");
            }
            result = false;
            abort = true;
        }
        while (!abort && packageIndex < this.ivPackageList.length) {
            retCode = FFDC.registerDiagnosticModule((DiagnosticModule)this, (String)this.ivPackageList[packageIndex]);
            switch (retCode) {
                case 0: {
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isEventEnabled()) break;
                    Tr.event(tc, "EJBContainerDiagnosticModule successfully registered for package " + this.ivPackageList[packageIndex]);
                    break;
                }
                case 1: {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                        Tr.event(tc, "Unable to register EJBContainerDiagnosticModule as another diagnostic module has already been registered with the package " + this.ivPackageList[packageIndex]);
                    }
                    result = false;
                    break;
                }
                case 2: {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                        Tr.event(tc, "Unable to register EJBContainerDiagnosticModule as it does not support the minimum diagnostic module interface.");
                    }
                    result = false;
                    abort = true;
                    break;
                }
                case 3: {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                        Tr.event(tc, "Unable to register EJBContainerDiagnosticModule due to an unknown failure.");
                    }
                    result = false;
                    abort = true;
                    break;
                }
                default: {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                        Tr.event(tc, "EJBContainerDiagnosticModule registration with " + this.ivPackageList[packageIndex] + " resulted in an " + "unexpected return code: " + retCode);
                    }
                    result = false;
                    abort = true;
                }
            }
            ++packageIndex;
        }
        return result;
    }

    public void ffdcDumpDefault(Throwable th, IncidentStream is, Object callerThis, Object[] o, String sourceId) {
        if (o == null) {
            is.writeLine(">EJB DM: Object array.", (Object)o);
        } else {
            is.introspectAndWrite(">EJB DM: Object array", (Object)o, 2);
        }
        if (callerThis != this.ivEJSContainer) {
            is.introspectAndWriteLine("Dump of EJBContainer Internals", (Object)this.ivEJSContainer);
        } else {
            is.writeLine("EJB Container", this.ivEJSContainer.name);
        }
    }

    public void ffdcDumpDefaultComponentMetaData(Throwable th, IncidentStream is, Object callerThis, Object[] o, String sourceId) {
        ComponentMetaData cmd = ComponentMetaDataAccessorImpl.getComponentMetaDataAccessor().getComponentMetaData();
        is.writeLine("Dump of ComponentMetaData", (Object)cmd);
    }

    public void ffdcDumpDefaultContainerTx(Throwable th, IncidentStream is, Object callerThis, Object[] o, String sourceId) {
        EJSDeployedSupport s;
        ContainerTx currentTx;
        block11: {
            currentTx = null;
            s = null;
            if (callerThis instanceof ContainerTx) {
                currentTx = (ContainerTx)callerThis;
            } else {
                block10: {
                    try {
                        UOWCurrent uowCurrent = TransactionManagerFactory.getUOWCurrent();
                        UOWCoordinator uowId = uowCurrent.getUOWCoord();
                        if (uowId != null) {
                            currentTx = (ContainerTx)EJSContainer.containerTxMap.get((Object)uowId);
                        }
                    }
                    catch (Throwable throwable) {
                        if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block10;
                        Tr.debug(tc, "ffdcDumpDefaultContainerTx : Unable to find ContainerTx : " + throwable);
                    }
                }
                try {
                    ThreadContext methodContext = EJSContainer.methodContext;
                    s = (EJSDeployedSupport)methodContext.getContext();
                }
                catch (Throwable throwable) {
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block11;
                    Tr.debug(tc, "ffdcDumpDefaultContainerTx : Unable to find ContainerTx : " + throwable);
                }
            }
        }
        if (currentTx != null) {
            is.writeLine("Dump of ContainerTx", currentTx.ffdcDump());
        } else {
            is.writeLine("Dump of ContainerTx", "CountainerTx not found for current thread");
        }
        if (s != null && s.currentTx != null && s.currentTx != currentTx) {
            is.writeLine("Dump of ContinerTx from EJSDeployedSupport", s.currentTx.ffdcDump());
        }
    }

    public void ffdcDumpDefaultEJBMethodInfo(Throwable th, IncidentStream is, Object callerThis, Object[] o, String sourceId) {
        block4: {
            SystemGetPropertyPrivileged pa = new SystemGetPropertyPrivileged("line.separator", "\n");
            String newLine = (String)AccessController.doPrivileged((PrivilegedAction)pa);
            try {
                ThreadContext methodContext = EJSContainer.methodContext;
                EJSDeployedSupport s = (EJSDeployedSupport)methodContext.getContext();
                EJBMethodInfoImpl ctxMethodInfo = null;
                String sep = "     ";
                if (s != null && (ctxMethodInfo = s.methodInfo) != null) {
                    StringBuilder sb = new StringBuilder(256);
                    sb.append(newLine).append("  *** START EJBMethodInfoImpl fields ***");
                    ctxMethodInfo.dump(sb, newLine, sep, s.methodId, true);
                    sb.append(newLine).append("  *** END EJBMethodInfoImpl fields ***");
                    sb.append(newLine);
                    String info = sb.toString();
                    is.writeLine(newLine + "Dump of EJBMethodInfo from EJSDeployedSupport", info);
                }
                EJBMethodInfoImpl callerMethodInfo = null;
                if (callerThis != ctxMethodInfo && callerThis instanceof EJBMethodInfoImpl) {
                    callerMethodInfo = (EJBMethodInfoImpl)callerThis;
                    StringBuilder sb = new StringBuilder(256);
                    sb.append(newLine).append("  *** START EJBMethodInfoImpl fields ***");
                    callerMethodInfo.dump(sb, newLine, sep, Integer.MAX_VALUE, false);
                    sb.append(newLine).append("  *** END EJBMethodInfoImpl fields ***");
                    sb.append(newLine);
                    String info = sb.toString();
                    is.writeLine(newLine + "Dump of EJBMethodInfo where exception occured", info);
                }
            }
            catch (Throwable throwable) {
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block4;
                Tr.debug(tc, newLine + "ffdcDumpDefaultEJBMethodInfo unable to find EJBMethodInfo: " + throwable);
            }
        }
    }

    public void ffdcDumpDefaultBindingsMaps(Throwable th, IncidentStream is, Object callerThis, Object[] o, String sourceId) {
        if (th instanceof NameAlreadyBoundException) {
            BindingData bdata;
            StringBuilder sb = new StringBuilder();
            HashMap<String, BindingData> bindings = null;
            SystemGetPropertyPrivileged pa = new SystemGetPropertyPrivileged("line.separator", "\n");
            String newLine = (String)AccessController.doPrivileged((PrivilegedAction)pa);
            bindings = BindingsHelper.cvAllRemoteBindings;
            sb.append(" Total Entries : " + bindings.size()).append(newLine);
            for (String jndiName : bindings.keySet()) {
                bdata = bindings.get(jndiName);
                sb.append(newLine);
                sb.append(JNDI_NAME).append(jndiName);
                sb.append(newLine);
                sb.append(EXPLICIT_BEAN).append(bdata.ivExplicitBean);
                sb.append(newLine);
                sb.append(EXPLICIT_INTF).append(bdata.ivExplicitInterface);
                sb.append(newLine);
                sb.append(IMPLICIT_BEAN).append(bdata.ivImplicitBeans);
            }
            if (bindings.size() > 0) {
                sb.append(newLine);
            }
            sb.append(newLine).append("End Dump of Remote Bindings Map");
            is.writeLine(newLine + "Start Dump of Remote Bindings Map", sb.toString());
            sb.setLength(0);
            bindings = BindingsHelper.cvAllLocalBindings;
            sb.append(" Total Entries : " + bindings.size()).append(newLine);
            for (String jndiName : bindings.keySet()) {
                bdata = bindings.get(jndiName);
                sb.append(newLine);
                sb.append(JNDI_NAME).append(jndiName);
                sb.append(newLine);
                sb.append(EXPLICIT_BEAN).append(bdata.ivExplicitBean);
                sb.append(newLine);
                sb.append(EXPLICIT_INTF).append(bdata.ivExplicitInterface);
                sb.append(newLine);
                sb.append(IMPLICIT_BEAN).append(bdata.ivImplicitBeans);
            }
            if (bindings.size() > 0) {
                sb.append(newLine);
            }
            sb.append(newLine).append("End Dump of Local Bindings Map");
            sb.append(newLine);
            is.writeLine(newLine + "Dump of Local Bindings Map", sb.toString());
        }
    }

    public static void main(String[] args) {
        EJBContainerDiagnosticModule dm = new EJBContainerDiagnosticModule();
        dm.validate();
    }
}

