/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.container;

import com.ibm.ejs.container.BindingData;
import com.ibm.ejs.container.ContainerProperties;
import com.ibm.ejs.container.HomeRecord;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.csi.J2EEName;
import com.ibm.ws.ejbcontainer.util.AmbiguousEJBRefReferenceFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import javax.naming.NameAlreadyBoundException;
import javax.naming.Reference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BindingsHelper {
    private static final String CLASS_NAME = BindingsHelper.class.getName();
    private static final TraceComponent tc = Tr.register(CLASS_NAME, "EJBContainer", "com.ibm.ejs.container.container");
    static final HashMap<String, BindingData> cvAllRemoteBindings = new HashMap();
    static final HashMap<String, BindingData> cvAllLocalBindings = new HashMap();
    private final HomeRecord ivHomeRecord;
    private final HashMap<String, BindingData> ivServerContextBindingMap;
    private final HashMap<String, String> ivEjbContextBindingMap;
    private final HashSet<String> ivEjbContextShortDefaultJndiNames;
    private final HashMap<String, Reference> ivEjbContextAmbiguousMap;
    private final String ivContextPrefix;
    private String ivDefaultJNDIPrefix = null;

    private BindingsHelper(HomeRecord homeRecord, HashMap<String, BindingData> serverContextBindingMap, String contextPrefix) {
        this.ivHomeRecord = homeRecord;
        this.ivServerContextBindingMap = serverContextBindingMap;
        this.ivEjbContextBindingMap = new HashMap();
        this.ivEjbContextShortDefaultJndiNames = new HashSet();
        this.ivEjbContextAmbiguousMap = new HashMap();
        this.ivContextPrefix = contextPrefix;
    }

    public void addBinding(String interfaceName, String specificBindingName) throws NameAlreadyBoundException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "addBinding: " + interfaceName + ", " + specificBindingName);
        }
        this.addToServerContextBindingMap(interfaceName, specificBindingName);
        this.ivEjbContextBindingMap.put(interfaceName, specificBindingName);
    }

    public String getBinding(String interfaceName) {
        return this.ivEjbContextBindingMap.get(interfaceName);
    }

    public Collection<String> getBindings() {
        return this.ivEjbContextBindingMap.values();
    }

    public void removeEjbBindings() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "removeEjbBindings called");
        }
        for (String bindingName : this.ivEjbContextBindingMap.values()) {
            this.removeFromServerContextBindingMap(bindingName, true);
        }
        this.ivEjbContextBindingMap.clear();
    }

    public boolean hasShortDefaultBinding(String interfaceName) {
        return this.ivEjbContextShortDefaultJndiNames.contains(interfaceName);
    }

    public boolean isUniqueShortDefaultBinding(String interfaceName) {
        BindingData bdata = this.ivServerContextBindingMap.get(interfaceName);
        return bdata != null && bdata.ivExplicitBean == null && bdata.ivImplicitBeans != null && bdata.ivImplicitBeans.size() == 1;
    }

    public Collection<String> getShortDefaultBindings() {
        return this.ivEjbContextShortDefaultJndiNames;
    }

    public void removeShortDefaultBindings() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "removeShortDefaultBindings called");
        }
        for (String bindingName : this.ivEjbContextShortDefaultJndiNames) {
            this.removeFromServerContextBindingMap(bindingName, false);
        }
        this.ivEjbContextShortDefaultJndiNames.clear();
    }

    public HashMap<String, Reference> getAmbiguousReferenceMap() {
        return this.ivEjbContextAmbiguousMap;
    }

    public ArrayList<String> generateBindings(String interfaceName, String specificBindingName, boolean generateDisambiguatedSimpleBindingNames) throws NameAlreadyBoundException {
        ArrayList<String> jndiNamesToBind;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "generateBindings: " + interfaceName + ", " + specificBindingName + ", " + generateDisambiguatedSimpleBindingNames);
        }
        if (specificBindingName == null) {
            String simpleBindingName = this.ivHomeRecord.getBeanMetaData().simpleJndiBindingName;
            if (simpleBindingName == null) {
                jndiNamesToBind = this.generateDefaultEjbBindings(interfaceName);
            } else {
                if (generateDisambiguatedSimpleBindingNames) {
                    Reference ambiguousRef = this.ivEjbContextAmbiguousMap.get(simpleBindingName);
                    if (ambiguousRef == null) {
                        this.addAmbiguousSimpleBindingName(simpleBindingName);
                        this.addToServerContextBindingMap(interfaceName, simpleBindingName);
                        this.ivEjbContextBindingMap.put("#" + interfaceName, simpleBindingName);
                    }
                    StringBuilder sb = new StringBuilder(simpleBindingName);
                    sb.append("#").append(interfaceName);
                    simpleBindingName = sb.toString();
                }
                jndiNamesToBind = new ArrayList(1);
                jndiNamesToBind.add(simpleBindingName);
                this.addToServerContextBindingMap(interfaceName, simpleBindingName);
                this.ivEjbContextBindingMap.put(interfaceName, simpleBindingName);
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "using simple binding : " + simpleBindingName);
                }
            }
        } else {
            jndiNamesToBind = new ArrayList<String>(1);
            jndiNamesToBind.add(specificBindingName);
            this.addToServerContextBindingMap(interfaceName, specificBindingName);
            this.ivEjbContextBindingMap.put(interfaceName, specificBindingName);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "using specific bindings : " + specificBindingName);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "generateBindings: " + jndiNamesToBind);
        }
        return jndiNamesToBind;
    }

    private ArrayList<String> generateDefaultEjbBindings(String interfaceName) throws NameAlreadyBoundException {
        ArrayList<String> defaultJNDINames = new ArrayList<String>(2);
        StringBuilder sb = new StringBuilder(256);
        if (this.ivDefaultJNDIPrefix == null) {
            if (this.ivContextPrefix != null) {
                sb.append(this.ivContextPrefix);
            }
            if (this.ivHomeRecord.bmd.ivComponent_Id != null) {
                sb.append(this.ivHomeRecord.bmd.ivComponent_Id).append("#");
            } else {
                sb.append(this.ivHomeRecord.j2eeName.getApplication()).append("/");
                sb.append(this.ivHomeRecord.j2eeName.getModule()).append("/");
                sb.append(this.ivHomeRecord.j2eeName.getComponent()).append("#");
            }
            this.ivDefaultJNDIPrefix = sb.toString();
        } else {
            sb.append(this.ivDefaultJNDIPrefix);
        }
        sb.append(interfaceName);
        String longBindingName = sb.toString();
        defaultJNDINames.add(longBindingName);
        this.addToServerContextBindingMap(interfaceName, longBindingName);
        this.ivEjbContextBindingMap.put(interfaceName, longBindingName);
        if (this.ivHomeRecord.shortDefaultBindingsEnabled()) {
            BindingData bdata = this.ivServerContextBindingMap.get(interfaceName);
            this.addToServerContextBindingMap(interfaceName);
            this.ivEjbContextShortDefaultJndiNames.add(interfaceName);
            if (bdata == null) {
                defaultJNDINames.add(interfaceName);
            } else if (bdata.ivExplicitBean == null) {
                this.addAmbiguousShortDefaultBindingName(interfaceName);
            } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "generateDefaultEjbBindings: " + interfaceName + " short-form default overridden : " + bdata.ivExplicitBean);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "generateDefaultEjbBindings: " + defaultJNDINames);
        }
        return defaultJNDINames;
    }

    private void addAmbiguousSimpleBindingName(String simpleBindingName) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "adding AmbiguousEJBReference for simple-binding-name '" + simpleBindingName + "', for EJB " + this.ivHomeRecord.getJ2EEName());
        }
        Reference ambiguousReference = AmbiguousEJBRefReferenceFactory.createAmbiguousReference(simpleBindingName, this.ivHomeRecord.getJ2EEName());
        this.ivEjbContextAmbiguousMap.put(simpleBindingName, ambiguousReference);
    }

    private void addAmbiguousShortDefaultBindingName(String shortBindingName) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "adding AmbiguousEJBReference for short default binding name '" + shortBindingName + "', for EJB " + this.ivHomeRecord.getJ2EEName());
        }
        ArrayList<J2EEName> beans = null;
        BindingData bdata = this.ivServerContextBindingMap.get(shortBindingName);
        if (bdata != null) {
            beans = bdata.ivImplicitBeans;
        }
        Reference ambiguousReference = AmbiguousEJBRefReferenceFactory.createAmbiguousReference(shortBindingName, beans);
        this.ivEjbContextAmbiguousMap.put(shortBindingName, ambiguousReference);
    }

    private void addToServerContextBindingMap(String interfaceName, String bindingName) throws NameAlreadyBoundException {
        BindingData bdata;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "addToServerContextBindingMap : " + interfaceName + ", binding : " + bindingName);
        }
        if ((bdata = this.ivServerContextBindingMap.get(bindingName)) == null) {
            bdata = new BindingData();
            this.ivServerContextBindingMap.put(bindingName, bdata);
        }
        if (bdata.ivExplicitBean == null) {
            bdata.ivExplicitBean = this.ivHomeRecord.j2eeName;
            bdata.ivExplicitInterface = interfaceName;
            if (bdata.ivImplicitBeans != null && bdata.ivImplicitBeans.size() > 1) {
                this.ivEjbContextAmbiguousMap.remove(interfaceName);
            }
        } else {
            J2EEName j2eeName = this.ivHomeRecord.j2eeName;
            if (bdata.ivExplicitBean.equals(j2eeName)) {
                Tr.error(tc, "NAME_ALREADY_BOUND_FOR_SAME_EJB_CNTR0173E", new Object[]{interfaceName, j2eeName.getComponent(), j2eeName.getModule(), j2eeName.getApplication(), bindingName, bdata.ivExplicitInterface});
                String message = "The " + interfaceName + " interface of the " + j2eeName.getComponent() + " bean in the " + j2eeName.getModule() + " module of the " + j2eeName.getApplication() + " application " + "cannot be bound to the " + bindingName + " name location. " + "The " + bdata.ivExplicitInterface + " interface of the " + "same bean has already been bound to the " + bindingName + " name location.";
                throw new NameAlreadyBoundException(message);
            }
            Tr.error(tc, "NAME_ALREADY_BOUND_FOR_EJB_CNTR0172E", new Object[]{interfaceName, j2eeName.getComponent(), j2eeName.getModule(), j2eeName.getApplication(), bindingName, bdata.ivExplicitInterface, bdata.ivExplicitBean.getComponent(), bdata.ivExplicitBean.getModule(), bdata.ivExplicitBean.getApplication()});
            String message = "The " + interfaceName + " interface of the " + j2eeName.getComponent() + " bean in the " + j2eeName.getModule() + " module of the " + j2eeName.getApplication() + " application " + "cannot be bound to the " + bindingName + " name location. " + "The " + bdata.ivExplicitInterface + " interface of the " + bdata.ivExplicitBean.getComponent() + " bean in the " + bdata.ivExplicitBean.getModule() + " module of the " + bdata.ivExplicitBean.getApplication() + " application " + "has already been bound to the " + bindingName + " name location.";
            throw new NameAlreadyBoundException(message);
        }
    }

    private void addToServerContextBindingMap(String interfaceName) {
        ArrayList<J2EEName> beans;
        BindingData bdata;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "addToServerContextBindingMap : " + interfaceName + " (implicit)");
        }
        if ((bdata = this.ivServerContextBindingMap.get(interfaceName)) == null) {
            bdata = new BindingData();
            this.ivServerContextBindingMap.put(interfaceName, bdata);
        }
        if ((beans = bdata.ivImplicitBeans) != null) {
            beans.add(this.ivHomeRecord.j2eeName);
        } else {
            beans = new ArrayList(1);
            beans.add(this.ivHomeRecord.j2eeName);
            bdata.ivImplicitBeans = beans;
        }
    }

    private void removeFromServerContextBindingMap(String bindingName, boolean explicit) {
        BindingData bdata;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "removeFromServerContextBindingMap : " + bindingName + ", explicit : " + explicit);
        }
        if ((bdata = this.ivServerContextBindingMap.get(bindingName)) != null) {
            if (explicit) {
                if (this.ivHomeRecord.j2eeName.equals(bdata.ivExplicitBean)) {
                    bdata.ivExplicitBean = null;
                    bdata.ivExplicitInterface = null;
                } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "removeFromServerContextBindingMap : ERROR : explicit binding for different bean : " + bdata.ivExplicitBean);
                }
            } else if (bdata.ivImplicitBeans != null) {
                bdata.ivImplicitBeans.remove(this.ivHomeRecord.j2eeName);
                if (bdata.ivImplicitBeans.size() == 0) {
                    bdata.ivImplicitBeans = null;
                }
            } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "removeFromServerContextBindingMap : ERROR : no implicit binding");
            }
            if (bdata.ivExplicitBean == null && bdata.ivImplicitBeans == null) {
                this.ivServerContextBindingMap.remove(bindingName);
            }
        } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "removeFromServerContextBindingMap : ERROR : no binding data");
        }
    }

    public static Boolean shortDefaultBindingsEnabled(String appName) {
        if (ContainerProperties.DisableShortDefaultBindings != null) {
            if (ContainerProperties.DisableShortDefaultBindings.size() == 0) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "Short form default binding disabled for application : " + appName);
                }
                return Boolean.FALSE;
            }
            for (String disabledApp : ContainerProperties.DisableShortDefaultBindings) {
                if (!appName.equalsIgnoreCase(disabledApp)) continue;
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "Short form default binding explicity disabled for application : " + appName);
                }
                return Boolean.FALSE;
            }
        }
        return Boolean.TRUE;
    }

    public static BindingsHelper getLocalHelper(HomeRecord homeRecord) {
        if (homeRecord.ivLocalBindingsHelper == null) {
            homeRecord.ivLocalBindingsHelper = new BindingsHelper(homeRecord, cvAllLocalBindings, null);
        }
        return homeRecord.ivLocalBindingsHelper;
    }

    public static BindingsHelper getRemoteHelper(HomeRecord homeRecord) {
        if (homeRecord.ivRemoteBindingsHelper == null) {
            homeRecord.ivRemoteBindingsHelper = new BindingsHelper(homeRecord, cvAllRemoteBindings, "ejb/");
        }
        return homeRecord.ivRemoteBindingsHelper;
    }
}

