/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.container;

import com.ibm.ejs.container.BeanMetaData;
import com.ibm.ejs.container.EJBNotFoundException;
import com.ibm.ejs.container.EJSContainer;
import com.ibm.ejs.container.ExternalizedBeanId;
import com.ibm.ejs.container.HomeInternal;
import com.ibm.ejs.container.activator.ActivationStrategy;
import com.ibm.ejs.container.drs.SfDRSKey;
import com.ibm.ejs.container.util.ByteArray;
import com.ibm.ejs.container.util.EJSPlatformHelper;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.csi.CSIException;
import com.ibm.websphere.csi.CSIRuntimeException;
import com.ibm.websphere.csi.EJBKey;
import com.ibm.websphere.csi.J2EEName;
import com.ibm.websphere.csi.StatefulSessionKey;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.util.AccessController;
import com.ibm.ws.util.WsObjectInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;

public class BeanId
implements EJBKey,
Serializable {
    private static final TraceComponent tc = Tr.register(BeanId.class, "EJBContainer", "com.ibm.ejs.container.container");
    private static final String CLASS_NAME = "com.ibm.ejs.container.BeanId";
    private static final long serialVersionUID = -7591924738493976976L;
    boolean _isHome;
    Serializable pkey;
    transient J2EEName j2eeName;
    transient ByteArray byteArray;
    byte[] j2eeNameBytes = null;
    transient byte[] serialized;
    transient HomeInternal home;
    transient ActivationStrategy activationStrategy;
    transient int hashValue;
    transient SfDRSKey ivDrsKey;
    private static final byte HOME_BEAN = 0;
    private static final byte STATELESS_BEAN = 1;
    private static final byte STATEFUL_BEAN = 2;
    private static final byte ENTITY_BEAN = 3;
    private static final byte MESSAGEDRIVEN_BEAN = 4;
    private static final byte USES_BEAN_MANAGED_TX = 16;
    private static final byte SERIALIZED_PKEY = 0;
    private static final byte INTEGER_PKEY = 1;
    private static final byte STRING_PKEY = 3;
    private static final byte LONG_PKEY = 4;
    private static final byte BYTE_ARRAY_PKEY = 8;
    private static final int BEAN_TYPE_LEN = 1;
    private static final int J2EE_NAME_LEN = 4;
    private static final int PKEY_TYPE_LEN = 1;
    private static final byte[] header = new byte[]{-84, -84, 0, 2, 0, 1};
    private static final int HEADER_LEN = header.length;
    private static final ByteArrayOutputStream[] svBAOSs = new ByteArrayOutputStream[50];
    private static int svBAOSsSize = 0;

    public final SfDRSKey getDRSKey() {
        if (this.ivDrsKey == null) {
            this.ivDrsKey = new SfDRSKey(this);
        }
        return this.ivDrsKey;
    }

    public BeanId() {
        this.pkey = null;
        this.j2eeName = null;
        this._isHome = false;
    }

    public BeanId(HomeInternal home, Serializable pkey) {
        this(home, pkey, false);
    }

    public BeanId(HomeInternal home, Serializable pkey, boolean isHome) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "BeanId", new Object[]{home, pkey, new Boolean(isHome)});
        }
        if (home == null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Home given for BeanId is null, this is most likely an internal PM or container issue");
            }
            throw new CSIRuntimeException("Home given for BeanId is null, this is most likely an internal PM or container issue");
        }
        this.home = home;
        this._isHome = isHome;
        this.j2eeName = home.getJ2EEName();
        this.j2eeNameBytes = this.j2eeName.getBytes();
        this.pkey = pkey;
        this.hashValue = BeanId.computeHashValue(this.j2eeName, pkey, this._isHome);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "BeanId");
        }
    }

    public BeanId(J2EEName j2eeName, Serializable pkey, boolean isHome) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "BeanId : " + j2eeName + " : " + pkey);
        }
        this.home = null;
        this._isHome = isHome;
        this.j2eeName = j2eeName;
        this.j2eeNameBytes = j2eeName.getBytes();
        this.pkey = pkey;
        this.hashValue = BeanId.computeHashValue(j2eeName, pkey, this._isHome);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "BeanId : " + this);
        }
    }

    public final String getJNDIName() {
        return this.home.getJNDIName(this.pkey);
    }

    public final HomeInternal getHome() {
        return this.home;
    }

    public final BeanMetaData getBeanMetaData() {
        return this.home.getBeanMetaData(this);
    }

    public final Serializable getPrimaryKey() {
        return this.pkey;
    }

    public final J2EEName getJ2EEName() {
        return this._isHome ? (J2EEName)this.pkey : this.j2eeName;
    }

    public final ActivationStrategy getActivationStrategy() {
        if (this.activationStrategy == null) {
            this.activationStrategy = this.home.getActivationStrategy();
        }
        return this.activationStrategy;
    }

    public final int hashCode() {
        return this.hashValue;
    }

    public final boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof BeanId) {
            BeanId e = (BeanId)o;
            if (e.hashValue == this.hashValue) {
                if (this._isHome) {
                    return this.pkey == e.pkey || this.pkey != null && this.pkey.equals(e.pkey);
                }
                return this.j2eeName == e.j2eeName && (this.pkey == e.pkey || this.pkey != null && this.pkey.equals(e.pkey));
            }
        }
        return false;
    }

    public final boolean equals(BeanId beanId) {
        if (this == beanId) {
            return true;
        }
        if (beanId != null && beanId.hashValue == this.hashValue) {
            if (this._isHome) {
                return this.pkey == beanId.pkey || this.pkey != null && this.pkey.equals(beanId.pkey);
            }
            return this.j2eeName == beanId.j2eeName && (this.pkey == beanId.pkey || this.pkey != null && this.pkey.equals(beanId.pkey));
        }
        return false;
    }

    public final boolean equals(HomeInternal compareHome, Serializable comparePkey, boolean isHome) {
        if (isHome) {
            return this.pkey == comparePkey || this.pkey != null && this.pkey.equals(comparePkey);
        }
        J2EEName compareJ2EEName = compareHome.getJ2EEName();
        return (this.j2eeName == compareJ2EEName || this.j2eeName.equals(compareJ2EEName)) && (this.pkey == comparePkey || this.pkey != null && this.pkey.equals(comparePkey));
    }

    public String toString() {
        return "BeanId(" + this.j2eeName + ", " + this.pkey + ")";
    }

    public final String getIdString() {
        return this.j2eeName + ":" + this.pkey;
    }

    public final byte[] getBytes() {
        if (this.serialized != null) {
            return this.serialized;
        }
        try {
            ByteArrayOutputStream ostream = this.getByteArrayStream();
            ObjectOutputStream objOstream = new ObjectOutputStream(ostream);
            objOstream.writeObject(this);
            objOstream.flush();
            this.serialized = ostream.toByteArray();
            this.byteArray = new ByteArray(this.serialized);
            this.freeByteArrayStream(ostream);
        }
        catch (IOException ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ejs.container.BeanId.getBytes", (String)"492", (Object)this);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                Tr.event(tc, "Unable to create serialized representation of BeanId: " + this, ex);
            }
            return null;
        }
        return this.serialized;
    }

    public final ByteArray getByteArray() {
        if (this.byteArray != null) {
            return this.byteArray;
        }
        this.getByteArrayBytes();
        return this.byteArray;
    }

    public final byte[] getByteArrayBytes() {
        if (this.byteArray != null) {
            return this.byteArray.getBytes();
        }
        try {
            ByteArrayOutputStream baos = this.getByteArrayStream();
            baos.write(header);
            baos.write(this.getBeanType());
            int j2eeNameBytesLength = this.j2eeNameBytes.length;
            if (EJSPlatformHelper.isZOS()) {
                baos.write((byte)(j2eeNameBytesLength >> 24));
                baos.write((byte)(j2eeNameBytesLength >> 16));
                baos.write((byte)(j2eeNameBytesLength >> 8));
                baos.write((byte)j2eeNameBytesLength);
            } else {
                for (int i = 0; i < 4; ++i) {
                    baos.write(j2eeNameBytesLength >> i * 8);
                }
            }
            baos.write(this.j2eeNameBytes);
            this.writePKeyBytes(baos);
            this.serialized = baos.toByteArray();
            this.byteArray = new ByteArray(this.serialized);
            this.freeByteArrayStream(baos);
        }
        catch (Exception ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ejs.container.BeanId.getByteArrayBytes", (String)"550", (Object)this);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                Tr.event(tc, "Unable to serialize primary key for bean", new Object[]{this, ex});
            }
            return null;
        }
        return this.serialized;
    }

    private final byte getBeanType() {
        if (this._isHome) {
            return 0;
        }
        if (this.home == null) {
            if (EJSContainer.homeOfHomes.getHomeRecord((J2EEName)this.j2eeName).bmd.usesBeanManagedTx) {
                return 17;
            }
            return 1;
        }
        if (this.home.isStatelessSessionHome()) {
            if (this.home.getBeanMetaData((Object)this.j2eeName).usesBeanManagedTx) {
                return 17;
            }
            return 1;
        }
        if (this.home.isStatefulSessionHome()) {
            if (this.home.getBeanMetaData((Object)this.j2eeName).usesBeanManagedTx) {
                return 18;
            }
            return 2;
        }
        if (this.home.isMessageDrivenHome()) {
            if (this.home.getBeanMetaData((Object)this.j2eeName).usesBeanManagedTx) {
                return 20;
            }
            return 4;
        }
        return 3;
    }

    public static BeanId deserialize(byte[] bytes, EJSContainer container2) throws ClassNotFoundException, IOException {
        BeanId id;
        block3: {
            WsObjectInputStream objIstream = new WsObjectInputStream((InputStream)new ByteArrayInputStream(bytes), EJSContainer.classLoader);
            id = null;
            try {
                id = (BeanId)AccessController.doPrivileged(new PrivilegedExceptionAction((ObjectInputStream)objIstream){
                    final /* synthetic */ ObjectInputStream val$objIstream;
                    {
                        this.val$objIstream = objectInputStream;
                    }

                    public Object run() throws ClassNotFoundException, IOException {
                        return this.val$objIstream.readObject();
                    }
                });
            }
            catch (PrivilegedActionException e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ejs.container.BeanId.deserialize", (String)"619");
                Exception e2 = e.getException();
                if (e2 instanceof ClassNotFoundException) {
                    throw (ClassNotFoundException)e2;
                }
                if (!(e2 instanceof IOException)) break block3;
                throw (IOException)e2;
            }
        }
        id.j2eeName = EJSContainer.getJ2EENameFactory().create(id.j2eeNameBytes);
        id.home = container2.getHomeOfHomes().getHome(id.j2eeName);
        id.j2eeName = id.home.getJ2EEName();
        id.hashValue = BeanId.computeHashValue(id.j2eeName, id.pkey, id._isHome);
        return id;
    }

    public static BeanId getBeanId(ByteArray byteArray, EJSContainer container2) throws IOException, ClassNotFoundException {
        BeanId id = null;
        Serializable pkey = null;
        boolean isHome = false;
        J2EEName j2eeName = null;
        byte[] bytes = byteArray.getBytes();
        for (int i = 0; i < HEADER_LEN; ++i) {
            if (bytes[i] == header[i]) continue;
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Header mismatch, attempting to deserialize BeanId");
            }
            return BeanId.deserialize(bytes, container2);
        }
        switch (bytes[HEADER_LEN]) {
            case 0: {
                isHome = true;
            }
            case 2: 
            case 3: 
            case 18: {
                byte[] j2eeNameBytes = BeanId.readJ2EENameBytes(bytes);
                j2eeName = EJSContainer.getJ2EENameFactory().create(j2eeNameBytes);
                int pkeyIndex = HEADER_LEN + 1 + 4 + j2eeNameBytes.length;
                pkey = BeanId.readPKey(bytes, pkeyIndex, j2eeName);
                break;
            }
            case 1: 
            case 4: 
            case 17: 
            case 20: {
                byte[] j2eeNameBytes = BeanId.readJ2EENameBytes(bytes);
                j2eeName = EJSContainer.getJ2EENameFactory().create(j2eeNameBytes);
                break;
            }
            default: {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                    Tr.event(tc, "Unable to parse bean id: unsupported EJB type: " + bytes[HEADER_LEN]);
                }
                throw new IOException("Unsupported EJB Type: " + bytes[HEADER_LEN]);
            }
        }
        HomeInternal home = container2.getHomeOfHomes().getHome(j2eeName);
        if (home == null) {
            Tr.warning(tc, "HOME_NOT_FOUND_CNTR0092W", ((Object)j2eeName).toString());
            throw new EJBNotFoundException(((Object)j2eeName).toString());
        }
        if (home.isStatefulSessionHome()) {
            pkey = EJSContainer.sessionKeyFactory.create((byte[])pkey);
        }
        if (isHome) {
            pkey = EJSContainer.getJ2EENameFactory().create((byte[])pkey);
        }
        id = new BeanId(home, pkey, isHome);
        id.byteArray = byteArray;
        return id;
    }

    private static byte[] readJ2EENameBytes(byte[] bytes) {
        int j2eeNameLength = 0;
        int j2eeNameIndex = HEADER_LEN + 1;
        if (EJSPlatformHelper.isZOS()) {
            int ix = j2eeNameIndex;
            j2eeNameLength = (bytes[ix] & 0xFF) << 24 | (bytes[ix + 1] & 0xFF) << 16 | (bytes[ix + 2] & 0xFF) << 8 | bytes[ix + 3] & 0xFF;
        } else {
            for (int i = 3; i >= 0; --i) {
                j2eeNameLength ^= bytes[j2eeNameIndex + i] & 0xFF;
                if (i <= 0) continue;
                j2eeNameLength <<= 8;
            }
        }
        byte[] temp = new byte[j2eeNameLength];
        System.arraycopy(bytes, j2eeNameIndex += 4, temp, 0, j2eeNameLength);
        return temp;
    }

    private static Serializable readPKey(byte[] bytes, int pkeyIndex, J2EEName j2eeName) throws IOException, ClassNotFoundException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "readPKey", new Object[]{new Integer(pkeyIndex), j2eeName});
        }
        Object pkey = null;
        int pkeyLen = bytes.length - pkeyIndex - 1;
        int index = pkeyIndex++;
        byte type = bytes[index++];
        switch (type) {
            case 0: {
                pkey = BeanId.readSerializedPKey(bytes, pkeyIndex, pkeyLen, j2eeName);
                break;
            }
            case 1: {
                int ivalue = 0;
                for (int i = 3; i >= 0; --i) {
                    ivalue ^= bytes[index + i] & 0xFF;
                    if (i <= 0) continue;
                    ivalue <<= 8;
                }
                pkey = new Integer(ivalue);
                break;
            }
            case 4: {
                long lvalue = 0L;
                for (int i = 7; i >= 0; --i) {
                    lvalue ^= (long)bytes[index + i] & 0xFFL;
                    if (i <= 0) continue;
                    lvalue <<= 8;
                }
                pkey = new Long(lvalue);
                break;
            }
            case 3: {
                pkey = new String(bytes, pkeyIndex, pkeyLen);
                break;
            }
            case 8: {
                byte[] b = new byte[pkeyLen];
                System.arraycopy(bytes, pkeyIndex, b, 0, pkeyLen);
                pkey = b;
                break;
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "readPKey", pkey);
        }
        return pkey;
    }

    private static Serializable readSerializedPKey(byte[] bytes, int start, int len, J2EEName j2eeName) throws IOException, ClassNotFoundException {
        Serializable pkey;
        block3: {
            ByteArrayInputStream bais = new ByteArrayInputStream(bytes, start, len);
            WsObjectInputStream objIstream = new WsObjectInputStream((InputStream)bais, EJSContainer.getClassLoader(j2eeName));
            pkey = null;
            try {
                pkey = (Serializable)AccessController.doPrivileged(new PrivilegedExceptionAction((ObjectInputStream)objIstream){
                    final /* synthetic */ ObjectInputStream val$objIstream;
                    {
                        this.val$objIstream = objectInputStream;
                    }

                    public Object run() throws ClassNotFoundException, IOException {
                        return this.val$objIstream.readObject();
                    }
                });
            }
            catch (PrivilegedActionException e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ejs.container.BeanId.readSerializedPKey", (String)"863");
                Exception e2 = e.getException();
                if (e2 instanceof ClassNotFoundException) {
                    throw (ClassNotFoundException)e2;
                }
                if (!(e2 instanceof IOException)) break block3;
                throw (IOException)e2;
            }
        }
        return pkey;
    }

    protected static byte[] getJ2EENameBytes(byte[] bytes) throws CSIException {
        boolean isHome = false;
        byte[] j2eeNameBytes = null;
        for (int i = 0; i < HEADER_LEN; ++i) {
            if (bytes[i] == header[i]) continue;
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Header mismatch, attempting to deserialize BeanId");
            }
            throw new CSIException("Parser Error: header mismatch");
        }
        switch (bytes[HEADER_LEN]) {
            case 0: {
                isHome = true;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 17: 
            case 18: 
            case 20: {
                j2eeNameBytes = BeanId.readJ2EENameBytes(bytes);
                break;
            }
            default: {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                    Tr.event(tc, "Unable to parse bean id: unsupported EJB type: " + bytes[HEADER_LEN]);
                }
                throw new CSIException("Unsupported EJB Type: " + bytes[HEADER_LEN]);
            }
        }
        if (isHome) {
            try {
                int pkeyIndex = HEADER_LEN + 1 + 4 + j2eeNameBytes.length;
                j2eeNameBytes = (byte[])BeanId.readPKey(bytes, pkeyIndex, null);
            }
            catch (Throwable th) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                    Tr.event(tc, "Unable to parse bean id: home j2eeName: " + th);
                }
                throw new CSIException("Unable to read j2eeName bytes", th);
            }
        }
        return j2eeNameBytes;
    }

    protected static Serializable getPrimaryKey(byte[] bytes) throws CSIException {
        boolean isStateful = false;
        Serializable pkey = null;
        byte[] j2eeNameBytes = null;
        J2EEName j2eeName = null;
        for (int i = 0; i < HEADER_LEN; ++i) {
            if (bytes[i] == header[i]) continue;
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Header mismatch, attempting to deserialize BeanId");
            }
            throw new CSIException("Parser Error: header mismatch");
        }
        switch (bytes[HEADER_LEN]) {
            case 0: 
            case 1: 
            case 4: 
            case 17: 
            case 20: {
                break;
            }
            case 2: 
            case 18: {
                isStateful = true;
            }
            case 3: {
                j2eeNameBytes = BeanId.readJ2EENameBytes(bytes);
                j2eeName = EJSContainer.getJ2EENameFactory().create(j2eeNameBytes);
                int pkeyIndex = HEADER_LEN + 1 + 4 + j2eeNameBytes.length;
                try {
                    pkey = BeanId.readPKey(bytes, pkeyIndex, j2eeName);
                    break;
                }
                catch (Throwable th) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                        Tr.event(tc, "Unable to parse bean id: primary key: " + th);
                    }
                    throw new CSIException("Unable to read primary key", th);
                }
            }
            default: {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                    Tr.event(tc, "Unable to parse bean id: unsupported EJB type: " + bytes[HEADER_LEN]);
                }
                throw new CSIException("Unsupported EJB Type: " + bytes[HEADER_LEN]);
            }
        }
        if (isStateful) {
            pkey = EJSContainer.sessionKeyFactory.create((byte[])pkey);
        }
        return pkey;
    }

    public final String getMethodName(int id) {
        return this.home.getMethodName(this.pkey, id, this._isHome);
    }

    public final boolean isHome() {
        return this._isHome;
    }

    public final String getEnterpriseBeanClassName() {
        return this.home.getEnterpriseBeanClassName(this.pkey);
    }

    protected static int computeHashValue(J2EEName j2eeName, Serializable pkey, boolean isHome) {
        return j2eeName.hashCode() + (pkey == null ? 0 : pkey.hashCode()) + (isHome ? 1 : 0);
    }

    private Object writeReplace() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "writeReplace");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "writeReplace");
        }
        return new ExternalizedBeanId(this.pkey, this.j2eeName, this._isHome);
    }

    public final boolean useLSD() {
        if (this._isHome) {
            return true;
        }
        BeanMetaData bmd = this.home.getBeanMetaData(this.j2eeName);
        return bmd.type == 5 || bmd.type == 2 || bmd.type == 4 || bmd.ivSFSBFailover;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final ByteArrayOutputStream getByteArrayStream() {
        ByteArrayOutputStream rtnBaos = null;
        ByteArrayOutputStream[] byteArrayOutputStreamArray = svBAOSs;
        synchronized (svBAOSs) {
            if (svBAOSsSize > 0) {
                rtnBaos = svBAOSs[--svBAOSsSize];
                BeanId.svBAOSs[BeanId.svBAOSsSize] = null;
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            if (rtnBaos == null) {
                rtnBaos = new ByteArrayOutputStream();
            } else {
                rtnBaos.reset();
            }
            return rtnBaos;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void freeByteArrayStream(ByteArrayOutputStream baos) {
        ByteArrayOutputStream[] byteArrayOutputStreamArray = svBAOSs;
        synchronized (svBAOSs) {
            if (svBAOSsSize < svBAOSs.length) {
                BeanId.svBAOSs[BeanId.svBAOSsSize] = baos;
                ++svBAOSsSize;
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    private final void writePKeyBytes(ByteArrayOutputStream baos) throws IOException {
        if (this.pkey != null) {
            if (this._isHome) {
                baos.write(8);
                baos.write(((J2EEName)this.pkey).getBytes());
            } else if (this.home.isStatefulSessionHome()) {
                baos.write(8);
                baos.write(((StatefulSessionKey)this.pkey).getBytes());
            } else if (this.pkey.getClass().getName().startsWith("java.lang")) {
                if (this.pkey instanceof Integer) {
                    baos.write(1);
                    int value = (Integer)this.pkey;
                    for (int i = 0; i < 4; ++i) {
                        baos.write(value >> i * 8);
                    }
                } else if (this.pkey instanceof Long) {
                    baos.write(4);
                    long value = (Long)this.pkey;
                    for (int i = 0; i < 8; ++i) {
                        baos.write((byte)(value >> i * 8));
                    }
                } else if (this.pkey instanceof String) {
                    baos.write(3);
                    baos.write(((String)((Object)this.pkey)).getBytes());
                } else {
                    this.writeSerializedPKey(baos);
                }
            } else {
                this.writeSerializedPKey(baos);
            }
        }
    }

    private final void writeSerializedPKey(ByteArrayOutputStream baos) throws IOException {
        baos.write(0);
        ObjectOutputStream objOstream = new ObjectOutputStream(baos);
        objOstream.writeObject(this.pkey);
        objOstream.flush();
    }
}

