/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.serializer.unicode;

import com.ibm.icu.text.Normalizer;
import org.apache.xml.serializer.unicode.UnicodeNormalizer;
import org.apache.xml.serializer.utils.Utils;

public final class UnicodeNormalizerFactory {
    static final Class m_icu = UnicodeNormalizerFactory.init();

    private static Class init() {
        Class<?> clazz;
        try {
            clazz = Class.forName("com.ibm.icu.text.Normalizer");
        }
        catch (ClassNotFoundException classNotFoundException) {
            clazz = null;
        }
        return clazz;
    }

    private static boolean icuIsOnTheClassPath() {
        return m_icu != null;
    }

    public static final int getNormalizerMode(String string) {
        if (string.equals("NFC")) {
            return 2;
        }
        if (string.equals("NFD")) {
            return 3;
        }
        if (string.equals("NFKC")) {
            return 4;
        }
        if (string.equals("NFKD")) {
            return 5;
        }
        if (string.equals("none")) {
            return 1;
        }
        if (string.equals("fully-normalized")) {
            return 6;
        }
        throw new RuntimeException(Utils.messages.createMessage("ER_UNSUPPORTED_NORMALIZATION_FORM", new Object[]{string}));
    }

    public static final UnicodeNormalizer getUnicodeNormalizer() {
        UnicodeNormalizer unicodeNormalizer = UnicodeNormalizerFactory.icuIsOnTheClassPath() ? new UnicodeNormalizerICUImpl() : new UnicodeNormalizerDefaultImpl();
        return unicodeNormalizer;
    }

    private static class UnicodeNormalizerDefaultImpl
    implements UnicodeNormalizer {
        private UnicodeNormalizerDefaultImpl() {
        }

        public boolean alreadyNormalized(int n, int n2) {
            return true;
        }

        public boolean alreadyNormalized(char[] cArray, int n, int n2, int n3) {
            return true;
        }

        public boolean alreadyNormalized(String string, int n) {
            return true;
        }

        public String normalizeUnicode(int n, int n2) {
            return null;
        }

        public int normalizeUnicode(char[] cArray, int n, int n2, char[] cArray2, int n3, int n4, int n5) {
            return 0;
        }

        public String normalizeUnicode(String string, int n) {
            return null;
        }
    }

    private static class UnicodeNormalizerICUImpl
    implements UnicodeNormalizer {
        final Normalizer.Mode getMode(int n) {
            switch (n) {
                case 2: {
                    return Normalizer.NFC;
                }
                case 3: {
                    return Normalizer.NFD;
                }
                case 4: {
                    return Normalizer.NFKC;
                }
                case 5: {
                    return Normalizer.NFKD;
                }
                case 1: {
                    return Normalizer.NONE;
                }
                case 6: {
                    return Normalizer.NFC;
                }
            }
            return Normalizer.NONE;
        }

        public final boolean alreadyNormalized(int n, int n2) {
            return Normalizer.isNormalized((int)n, (Normalizer.Mode)this.getMode(n2), (int)0);
        }

        public final boolean alreadyNormalized(char[] cArray, int n, int n2, int n3) {
            Normalizer.QuickCheckResult quickCheckResult = Normalizer.quickCheck((char[])cArray, (int)n, (int)n2, (Normalizer.Mode)this.getMode(n3), (int)0);
            boolean bl = quickCheckResult == Normalizer.YES;
            return bl;
        }

        public final boolean alreadyNormalized(String string, int n) {
            Normalizer.QuickCheckResult quickCheckResult = Normalizer.quickCheck((String)string, (Normalizer.Mode)this.getMode(n), (int)0);
            boolean bl = quickCheckResult == Normalizer.YES;
            return bl;
        }

        public final String normalizeUnicode(int n, int n2) {
            return Normalizer.normalize((int)n, (Normalizer.Mode)this.getMode(n2), (int)0);
        }

        public final int normalizeUnicode(char[] cArray, int n, int n2, char[] cArray2, int n3, int n4, int n5) {
            return Normalizer.normalize((char[])cArray, (int)n, (int)n2, (char[])cArray2, (int)n3, (int)n4, (Normalizer.Mode)this.getMode(n5), (int)0);
        }

        public final String normalizeUnicode(String string, int n) {
            return Normalizer.normalize((String)string, (Normalizer.Mode)this.getMode(n));
        }
    }
}

