/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.serializer;

import java.io.IOException;
import java.io.Writer;
import java.util.HashMap;
import java.util.Properties;
import javax.xml.namespace.QName;
import org.apache.xml.serializer.AttributesImplSerializer;
import org.apache.xml.serializer.CharInfo;
import org.apache.xml.serializer.ElemContext;
import org.apache.xml.serializer.ElemDesc;
import org.apache.xml.serializer.EncodingInfo;
import org.apache.xml.serializer.Encodings;
import org.apache.xml.serializer.NamespaceMappings;
import org.apache.xml.serializer.OutputPropertiesFactory;
import org.apache.xml.serializer.OutputPropertyUtils;
import org.apache.xml.serializer.ToHTMLCommon;
import org.apache.xml.serializer.WriterOptimized;
import org.apache.xml.serializer.utils.Utils;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class ToHTMLStream
extends ToHTMLCommon {
    protected boolean m_inDTD = false;
    private boolean m_inBlockElem = false;
    private static final CharInfo s_htmlcharInfo = CharInfo.getCharInfo(null, "html");
    static final Trie m_elementFlags = new Trie();
    private Trie m_htmlInfo = new Trie(m_elementFlags);

    static void initTagReference(Trie trie) {
        trie.put("BASEFONT", new ElemDesc(2));
        trie.put("FRAME", new ElemDesc(10));
        trie.put("FRAMESET", new ElemDesc(8));
        trie.put("NOFRAMES", new ElemDesc(8));
        trie.put("ISINDEX", new ElemDesc(10));
        trie.put("APPLET", new ElemDesc(0x200000));
        trie.put("CENTER", new ElemDesc(8));
        trie.put("DIR", new ElemDesc(8));
        trie.put("MENU", new ElemDesc(8));
        trie.put("TT", new ElemDesc(4096));
        trie.put("I", new ElemDesc(4096));
        trie.put("B", new ElemDesc(4096));
        trie.put("BIG", new ElemDesc(4096));
        trie.put("SMALL", new ElemDesc(4096));
        trie.put("EM", new ElemDesc(8192));
        trie.put("STRONG", new ElemDesc(8192));
        trie.put("DFN", new ElemDesc(8192));
        trie.put("CODE", new ElemDesc(8192));
        trie.put("SAMP", new ElemDesc(8192));
        trie.put("KBD", new ElemDesc(8192));
        trie.put("VAR", new ElemDesc(8192));
        trie.put("CITE", new ElemDesc(8192));
        trie.put("ABBR", new ElemDesc(8192));
        trie.put("ACRONYM", new ElemDesc(8192));
        trie.put("SUP", new ElemDesc(98304));
        trie.put("SUB", new ElemDesc(98304));
        trie.put("SPAN", new ElemDesc(98304));
        trie.put("BDO", new ElemDesc(98304));
        trie.put("BR", new ElemDesc(98314));
        trie.put("BODY", new ElemDesc(8));
        trie.put("ADDRESS", new ElemDesc(56));
        trie.put("DIV", new ElemDesc(56));
        trie.put("A", new ElemDesc(32768));
        trie.put("MAP", new ElemDesc(98312));
        trie.put("AREA", new ElemDesc(10));
        trie.put("LINK", new ElemDesc(131082));
        trie.put("IMG", new ElemDesc(2195458));
        trie.put("OBJECT", new ElemDesc(2326528));
        trie.put("PARAM", new ElemDesc(2));
        trie.put("HR", new ElemDesc(58));
        trie.put("P", new ElemDesc(56));
        trie.put("H1", new ElemDesc(262152));
        trie.put("H2", new ElemDesc(262152));
        trie.put("H3", new ElemDesc(262152));
        trie.put("H4", new ElemDesc(262152));
        trie.put("H5", new ElemDesc(262152));
        trie.put("H6", new ElemDesc(262152));
        trie.put("PRE", new ElemDesc(0x100008));
        trie.put("Q", new ElemDesc(98304));
        trie.put("BLOCKQUOTE", new ElemDesc(56));
        trie.put("INS", new ElemDesc(0));
        trie.put("DEL", new ElemDesc(0));
        trie.put("DL", new ElemDesc(56));
        trie.put("DT", new ElemDesc(8));
        trie.put("DD", new ElemDesc(8));
        trie.put("OL", new ElemDesc(524296));
        trie.put("UL", new ElemDesc(524296));
        trie.put("LI", new ElemDesc(8));
        trie.put("FORM", new ElemDesc(8));
        trie.put("LABEL", new ElemDesc(16384));
        trie.put("INPUT", new ElemDesc(18434));
        trie.put("SELECT", new ElemDesc(18432));
        trie.put("OPTGROUP", new ElemDesc(0));
        trie.put("OPTION", new ElemDesc(0));
        trie.put("TEXTAREA", new ElemDesc(18432));
        trie.put("FIELDSET", new ElemDesc(24));
        trie.put("LEGEND", new ElemDesc(0));
        trie.put("BUTTON", new ElemDesc(18432));
        trie.put("TABLE", new ElemDesc(56));
        trie.put("CAPTION", new ElemDesc(8));
        trie.put("THEAD", new ElemDesc(8));
        trie.put("TFOOT", new ElemDesc(8));
        trie.put("TBODY", new ElemDesc(8));
        trie.put("COLGROUP", new ElemDesc(8));
        trie.put("COL", new ElemDesc(10));
        trie.put("TR", new ElemDesc(8));
        trie.put("TH", new ElemDesc(0));
        trie.put("TD", new ElemDesc(0));
        trie.put("HEAD", new ElemDesc(0x400008));
        trie.put("TITLE", new ElemDesc(8));
        trie.put("BASE", new ElemDesc(10));
        trie.put("META", new ElemDesc(131082));
        trie.put("STYLE", new ElemDesc(131336));
        trie.put("SCRIPT", new ElemDesc(229632));
        trie.put("NOSCRIPT", new ElemDesc(56));
        trie.put("HTML", new ElemDesc(0x800008));
        trie.put("FONT", new ElemDesc(4096));
        trie.put("S", new ElemDesc(4096));
        trie.put("STRIKE", new ElemDesc(4096));
        trie.put("U", new ElemDesc(4096));
        trie.put("NOBR", new ElemDesc(4096));
        trie.put("IFRAME", new ElemDesc(56));
        trie.put("LAYER", new ElemDesc(56));
        trie.put("ILAYER", new ElemDesc(56));
        ElemDesc elemDesc = (ElemDesc)trie.get("a");
        elemDesc.setAttr("HREF", 2);
        elemDesc.setAttr("NAME", 2);
        elemDesc = (ElemDesc)trie.get("area");
        elemDesc.setAttr("HREF", 2);
        elemDesc.setAttr("NOHREF", 4);
        elemDesc = (ElemDesc)trie.get("base");
        elemDesc.setAttr("HREF", 2);
        elemDesc = (ElemDesc)trie.get("button");
        elemDesc.setAttr("DISABLED", 4);
        elemDesc = (ElemDesc)trie.get("blockquote");
        elemDesc.setAttr("CITE", 2);
        elemDesc = (ElemDesc)trie.get("del");
        elemDesc.setAttr("CITE", 2);
        elemDesc = (ElemDesc)trie.get("dir");
        elemDesc.setAttr("COMPACT", 4);
        elemDesc = (ElemDesc)trie.get("div");
        elemDesc.setAttr("SRC", 2);
        elemDesc.setAttr("NOWRAP", 4);
        elemDesc = (ElemDesc)trie.get("dl");
        elemDesc.setAttr("COMPACT", 4);
        elemDesc = (ElemDesc)trie.get("form");
        elemDesc.setAttr("ACTION", 2);
        elemDesc = (ElemDesc)trie.get("frame");
        elemDesc.setAttr("SRC", 2);
        elemDesc.setAttr("LONGDESC", 2);
        elemDesc.setAttr("NORESIZE", 4);
        elemDesc = (ElemDesc)trie.get("head");
        elemDesc.setAttr("PROFILE", 2);
        elemDesc = (ElemDesc)trie.get("hr");
        elemDesc.setAttr("NOSHADE", 4);
        elemDesc = (ElemDesc)trie.get("iframe");
        elemDesc.setAttr("SRC", 2);
        elemDesc.setAttr("LONGDESC", 2);
        elemDesc = (ElemDesc)trie.get("ilayer");
        elemDesc.setAttr("SRC", 2);
        elemDesc = (ElemDesc)trie.get("img");
        elemDesc.setAttr("SRC", 2);
        elemDesc.setAttr("LONGDESC", 2);
        elemDesc.setAttr("USEMAP", 2);
        elemDesc.setAttr("ISMAP", 4);
        elemDesc = (ElemDesc)trie.get("input");
        elemDesc.setAttr("SRC", 2);
        elemDesc.setAttr("USEMAP", 2);
        elemDesc.setAttr("CHECKED", 4);
        elemDesc.setAttr("DISABLED", 4);
        elemDesc.setAttr("ISMAP", 4);
        elemDesc.setAttr("READONLY", 4);
        elemDesc = (ElemDesc)trie.get("ins");
        elemDesc.setAttr("CITE", 2);
        elemDesc = (ElemDesc)trie.get("layer");
        elemDesc.setAttr("SRC", 2);
        elemDesc = (ElemDesc)trie.get("link");
        elemDesc.setAttr("HREF", 2);
        elemDesc = (ElemDesc)trie.get("menu");
        elemDesc.setAttr("COMPACT", 4);
        elemDesc = (ElemDesc)trie.get("object");
        elemDesc.setAttr("CLASSID", 2);
        elemDesc.setAttr("CODEBASE", 2);
        elemDesc.setAttr("DATA", 2);
        elemDesc.setAttr("ARCHIVE", 2);
        elemDesc.setAttr("USEMAP", 2);
        elemDesc.setAttr("DECLARE", 4);
        elemDesc = (ElemDesc)trie.get("ol");
        elemDesc.setAttr("COMPACT", 4);
        elemDesc = (ElemDesc)trie.get("optgroup");
        elemDesc.setAttr("DISABLED", 4);
        elemDesc = (ElemDesc)trie.get("option");
        elemDesc.setAttr("SELECTED", 4);
        elemDesc.setAttr("DISABLED", 4);
        elemDesc = (ElemDesc)trie.get("q");
        elemDesc.setAttr("CITE", 2);
        elemDesc = (ElemDesc)trie.get("script");
        elemDesc.setAttr("SRC", 2);
        elemDesc.setAttr("FOR", 2);
        elemDesc.setAttr("DEFER", 4);
        elemDesc = (ElemDesc)trie.get("select");
        elemDesc.setAttr("DISABLED", 4);
        elemDesc.setAttr("MULTIPLE", 4);
        elemDesc = (ElemDesc)trie.get("table");
        elemDesc.setAttr("NOWRAP", 4);
        elemDesc = (ElemDesc)trie.get("td");
        elemDesc.setAttr("NOWRAP", 4);
        elemDesc = (ElemDesc)trie.get("textarea");
        elemDesc.setAttr("DISABLED", 4);
        elemDesc.setAttr("READONLY", 4);
        elemDesc = (ElemDesc)trie.get("th");
        elemDesc.setAttr("NOWRAP", 4);
        elemDesc = (ElemDesc)trie.get("tr");
        elemDesc.setAttr("NOWRAP", 4);
        elemDesc = (ElemDesc)trie.get("ul");
        elemDesc.setAttr("COMPACT", 4);
    }

    public void setSpecialEscapeURLs(boolean bl) {
        this.m_specialEscapeURLs = bl;
    }

    public void setOmitMetaTag(boolean bl) {
        this.m_omitMetaTag = bl;
    }

    public void setOutputFormat(Properties properties) {
        Object object;
        if (this.m_wasJustReset && properties instanceof OutputPropertiesFactory.SerializerProps && ((OutputPropertiesFactory.SerializerProps)(object = (OutputPropertiesFactory.SerializerProps)properties)).hasOnlyStandardDefaults()) {
            this.m_specialEscapeURLs = true;
            this.m_omitMetaTag = false;
            super.setOutputFormat(properties);
            return;
        }
        object = properties.getProperty("{http://xml.apache.org/xalan}use-url-escaping");
        if (object != null) {
            this.m_specialEscapeURLs = OutputPropertyUtils.getBooleanProperty("{http://xml.apache.org/xalan}use-url-escaping", properties);
        }
        if ((object = properties.getProperty("{http://xml.apache.org/xalan}omit-meta-tag")) != null) {
            this.m_omitMetaTag = OutputPropertyUtils.getBooleanProperty("{http://xml.apache.org/xalan}omit-meta-tag", properties);
        }
        super.setOutputFormat(properties);
    }

    public static final ElemDesc getElemDesc(String string) {
        Object object = m_elementFlags.get(string);
        if (null != object) {
            return (ElemDesc)object;
        }
        return s_elemNotFound;
    }

    private ElemDesc getElemDesc2(String string) {
        Object object = this.m_htmlInfo.get2(string);
        if (null != object) {
            return (ElemDesc)object;
        }
        return s_elemNotFound;
    }

    public ToHTMLStream() {
        EncodingInfo encodingInfo;
        this.m_doIndent = true;
        this.m_charInfo = s_htmlcharInfo;
        this.m_prefixMap = new NamespaceMappings();
        this.m_OutputPropsDefault = new HashMap();
        this.m_OutputPropsDefault.put("method", "html");
        this.m_OutputPropsDefault.put("indent", "yes");
        this.m_mediatype = "text/html";
        this.m_OutputPropsDefault.put("media-type", "text/html");
        this.m_version = "4.0";
        this.m_OutputPropsDefault.put("version", "4.0");
        this.m_OutputPropsDefault.put("mime-name", "UTF-8");
        this.m_encodingInfo = encodingInfo = Encodings.getEncodingInfo("UTF-8");
        this.m_isUTF8 = true;
        this.m_OutputPropsDefault.put("encoding", "UTF-8");
        this.m_wasJustReset = true;
    }

    protected void startDocumentInternal() throws SAXException {
        super.startDocumentInternal();
        this.m_needToCallStartDocument = false;
        this.m_needToOutputDocTypeDecl = true;
        this.m_startNewLine = false;
        this.setOmitXMLDeclaration(true);
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        ElemContext elemContext = this.m_elemContext;
        if (elemContext.m_startTagOpen) {
            this.closeStartTag();
            elemContext.m_startTagOpen = false;
        } else if (this.m_cdataTagOpen) {
            this.closeCDATA();
            this.m_cdataTagOpen = false;
        } else if (this.m_needToCallStartDocument) {
            this.startDocumentInternal();
            this.m_needToCallStartDocument = false;
            this.m_docIsEmpty = false;
            if (this.m_needToOutputDocTypeDecl) {
                this.outputDocTypeDecl(string2, string3);
            }
        } else if (this.m_needToOutputDocTypeDecl) {
            this.outputDocTypeDecl(string2, string3);
        }
        if (null != string && string.length() > 0) {
            super.startElement(string, string2, string3, attributes);
            return;
        }
        try {
            ElemDesc elemDesc = this.getElemDesc2(string3);
            int n = elemDesc.getFlags();
            if (this.m_doIndent) {
                boolean bl;
                boolean bl2 = bl = (n & 8) != 0;
                if (this.m_ispreserve) {
                    this.m_ispreserve = false;
                } else if (null != elemContext.m_elementName && (!this.m_inBlockElem || bl)) {
                    this.m_writer.write(this.m_lineSep, 0, this.m_lineSepLen);
                    if (this.m_indentAmount > 0) {
                        this.printSpace(this.m_elemContext.m_currentElemDepth * this.m_indentAmount);
                    }
                }
                this.m_inBlockElem = !bl;
            }
            this.m_isprevtext = false;
            this.m_startNewLine = true;
            if (attributes != null) {
                this.addAttributes(attributes);
            }
            if (this.m_tracer != null) {
                this.firePseudoAttributes();
            }
            if ((n & 2) != 0) {
                this.m_elemContext = elemContext.push();
                this.m_elemContext.m_elementName = string3;
                this.m_elemContext.m_elementDesc = elemDesc;
                return;
            }
            this.m_elemContext = elemContext = elemContext.push(string, string2, string3);
            elemContext.m_elementDesc = elemDesc;
            elemContext.m_isRaw = (n & 0x100) != 0;
        }
        catch (IOException iOException) {
            throw new SAXException(iOException);
        }
    }

    private void outputDocTypeDecl(String string, String string2) throws SAXException {
        String string3 = string2;
        if (string3 == null || string3.length() == 0) {
            string3 = string;
        }
        this.outputDocTypeDecl(string3);
    }

    private void metaCreate(ElemContext elemContext, Writer writer) throws SAXException, IOException {
        if (!this.m_omitMetaTag) {
            if (this.m_doIndent) {
                this.indent();
            }
            String string = this.m_mediatype == null ? "text/html" : this.m_mediatype;
            writer.write("<META http-equiv=\"Content-Type\" content=\"");
            writer.write(string);
            writer.write("; charset=");
            String string2 = this.getEncoding();
            String string3 = Encodings.getMimeEncoding(string2);
            writer.write(string3);
            writer.write("\">");
        }
    }

    public final void endElement(String string, String string2, String string3) throws SAXException {
        if (this.m_cdataTagOpen) {
            this.closeCDATA();
        }
        if (null != string && string.length() > 0) {
            super.endElement(string, string2, string3);
            return;
        }
        try {
            boolean bl;
            ElemContext elemContext = this.m_elemContext;
            int n = elemContext.m_elementDesc.getFlags();
            boolean bl2 = (n & 2) == 0;
            Writer writer = this.m_writer;
            boolean bl3 = this.m_doIndent;
            if (!elemContext.m_startTagOpen) {
                bl = false;
                if (bl3) {
                    boolean bl4;
                    boolean bl5 = bl4 = (n & 8) != 0;
                    if (this.m_ispreserve) {
                        this.m_ispreserve = false;
                    } else if (!this.m_inBlockElem || bl4) {
                        writer.write(this.m_lineSep, 0, this.m_lineSepLen);
                        if (this.m_indentAmount > 0) {
                            this.printSpace((elemContext.m_currentElemDepth - 1) * this.m_indentAmount);
                        }
                    }
                    this.m_inBlockElem = !bl4;
                }
                writer.write("</");
                writer.write(string3);
                writer.write(62);
            } else {
                String string4 = string2 == null ? string3 : string2;
                bl = string4.length() == 4 && this.metaDiscard(string4);
                int n2 = this.m_attributes.getLength();
                if (!bl) {
                    writer.write(60);
                    writer.write(string3);
                    if (this.m_tracer != null) {
                        super.fireStartElem(string3);
                    }
                    if (n2 > 0) {
                        this.processAttributes(writer, n2);
                    }
                    if (bl2) {
                        if (this.m_elemContext.m_elementDesc != null && (this.m_elemContext.m_elementDesc.getFlags() & 0x400000) != 0 && ("".equals(this.m_elemContext.m_elementURI) || this.m_elemContext.m_elementURI == null)) {
                            writer.write(62);
                            this.metaCreate(this.m_elemContext, writer);
                            if (bl3) {
                                if (this.m_ispreserve) {
                                    this.m_ispreserve = false;
                                } else {
                                    this.m_startNewLine = true;
                                    this.indent(elemContext.m_currentElemDepth - 1);
                                }
                                this.m_inBlockElem = false;
                            }
                            writer.write("</");
                        } else {
                            writer.write("></");
                        }
                        writer.write(string3);
                        writer.write(62);
                    } else {
                        writer.write(62);
                    }
                }
                if (n2 > 0) {
                    this.m_attributes.clear();
                }
            }
            if ((n & 0x200000) != 0) {
                this.m_ispreserve = true;
            }
            this.m_isprevtext = false;
            if (this.m_tracer != null && !bl) {
                super.fireEndElem(string3);
            }
            this.m_prefixMap.popNamespaces(this.m_elemContext.m_currentElemDepth, null);
            this.m_elemContext = elemContext.m_prev;
        }
        catch (IOException iOException) {
            throw new SAXException(iOException);
        }
    }

    public void characters(char[] cArray, int n, int n2, int n3) throws SAXException {
        if ((n3 & 1) != 0 && this.m_optLevel == 0) {
            if (this.m_elemContext.m_startTagOpen) {
                this.closeStartTag();
                this.m_elemContext.m_startTagOpen = false;
            } else if (this.m_needToCallStartDocument) {
                this.m_docIsEmpty = false;
                this.startDocumentInternal();
            }
            if ((n3 & 8) == 0) {
                this.m_ispreserve = true;
            }
            try {
                if (this.m_writerOptimized != null) {
                    if (n2 == 1) {
                        this.m_writerOptimized.write(cArray[n]);
                    } else {
                        this.m_writerOptimized.writeASCII(cArray, n, n2);
                    }
                    return;
                }
                this.m_writer.write(cArray, n, n2);
                return;
            }
            catch (IOException iOException) {
                throw new SAXException(iOException);
            }
        }
        this.characters(cArray, n, n2);
    }

    public final void characters(char[] cArray, int n, int n2) throws SAXException {
        if (this.m_elemContext.m_isRaw) {
            try {
                if (this.m_elemContext.m_startTagOpen) {
                    this.closeStartTag();
                    this.m_elemContext.m_startTagOpen = false;
                }
                this.m_ispreserve = true;
                this.writeNormalizedChars(cArray, n, n2, false, this.m_lineSepUse);
                if (this.m_tracer != null) {
                    super.fireCharEvent(cArray, n, n2);
                }
                return;
            }
            catch (IOException iOException) {
                throw new SAXException(Utils.messages.createMessage("ER_OIERROR", null), iOException);
            }
        }
        this.processChars(cArray, n, n2);
    }

    private void processChars(char[] cArray, int n, int n2) throws SAXException {
        if (n2 == 0 || this.m_inEntityRef && !this.m_expandDTDEntities) {
            return;
        }
        if (this.m_elemContext.m_startTagOpen) {
            this.closeStartTag();
            this.m_elemContext.m_startTagOpen = false;
        } else if (this.m_needToCallStartDocument) {
            this.m_docIsEmpty = false;
            this.startDocumentInternal();
        }
        if (this.m_cdataStartCalled || this.m_elemContext.m_isCdataSection) {
            this.cdata(cArray, n, n2);
            return;
        }
        if (this.m_cdataTagOpen) {
            this.closeCDATA();
        }
        if (this.m_disableOutputEscapingStates.peekOrFalse() || !this.m_escaping) {
            this.charactersRaw(cArray, n, n2);
            if (this.m_tracer != null) {
                super.fireCharEvent(cArray, n, n2);
            }
            return;
        }
        Writer writer = this.m_writer;
        try {
            int n3;
            int n4 = cArray[n];
            if (97 <= n4 && n4 <= 122 || 65 <= n4 && n4 <= 90) {
                n3 = n;
                this.m_ispreserve = true;
            } else if (n4 == 10 && n2 == 1) {
                boolean bl;
                boolean bl2 = bl = this.m_codepoint2String != null;
                if (bl) {
                    String string = this.m_codepoint2String.getString(n4);
                    if (string != null) {
                        writer.write(string);
                        this.m_ispreserve = true;
                    } else {
                        writer.write(this.m_lineSep, 0, this.m_lineSepLen);
                    }
                } else {
                    writer.write(this.m_lineSep, 0, this.m_lineSepLen);
                }
                n3 = n + 1;
            } else {
                n3 = this.processLeadingWhiteSpace(writer, cArray, n, n2);
            }
            n4 = n2 - (n3 - n);
            if (0 < n4) {
                switch (this.m_optLevel) {
                    case 0: {
                        this.processTextOptimized(cArray, writer, this.m_writerOptimized, n3, n4);
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: 
                    case 8: {
                        this.processTextNonOpt(cArray, writer, this.m_writerOptimized, n3, n4);
                    }
                }
            }
        }
        catch (IOException iOException) {
            throw new SAXException(iOException);
        }
        if (this.m_tracer != null) {
            super.fireCharEvent(cArray, n, n2);
        }
        this.m_isprevtext = true;
    }

    private void processTextOptimized(char[] cArray, Writer writer, WriterOptimized writerOptimized, int n, int n2) throws IOException {
        int n3 = n;
        int n4 = n;
        int n5 = n + n2;
        block17: while (n4 < n5) {
            int n6;
            int n7;
            int n8 = cArray[n4];
            if (n8 < 128) {
                switch (n8) {
                    case 0: 
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: 
                    case 8: {
                        this.flushClean(writer, writerOptimized, cArray, n3, n4);
                        writer.write("&#");
                        writer.write(Integer.toString(n8));
                        writer.write(59);
                        n3 = ++n4;
                        continue block17;
                    }
                    case 9: {
                        ++n4;
                        continue block17;
                    }
                    case 10: {
                        if (!this.m_lineSepUse || this.m_lineSepLen == 1 && this.m_lineSep[0] == '\n') {
                            ++n4;
                            continue block17;
                        }
                        this.flushClean(writer, writerOptimized, cArray, n3, n4);
                        writer.write(this.m_lineSep, 0, this.m_lineSepLen);
                        n3 = ++n4;
                        continue block17;
                    }
                    case 11: 
                    case 12: {
                        this.flushClean(writer, writerOptimized, cArray, n3, n4);
                        writer.write("&#");
                        writer.write(Integer.toString(n8));
                        writer.write(59);
                        n3 = ++n4;
                        continue block17;
                    }
                    case 13: {
                        this.flushClean(writer, writerOptimized, cArray, n3, n4);
                        writer.write("&#13;");
                        n3 = ++n4;
                        continue block17;
                    }
                    case 14: 
                    case 15: 
                    case 16: 
                    case 17: 
                    case 18: 
                    case 19: 
                    case 20: 
                    case 21: 
                    case 22: 
                    case 23: 
                    case 24: 
                    case 25: 
                    case 26: 
                    case 27: 
                    case 28: 
                    case 29: 
                    case 30: 
                    case 31: {
                        this.flushClean(writer, writerOptimized, cArray, n3, n4);
                        writer.write("&#");
                        writer.write(Integer.toString(n8));
                        writer.write(59);
                        n3 = ++n4;
                        continue block17;
                    }
                    case 32: 
                    case 33: {
                        ++n4;
                        continue block17;
                    }
                    case 34: 
                    case 35: 
                    case 36: 
                    case 37: {
                        ++n4;
                        continue block17;
                    }
                    case 38: {
                        this.flushClean(writer, writerOptimized, cArray, n3, n4);
                        writer.write("&amp;");
                        n3 = ++n4;
                        continue block17;
                    }
                    case 39: 
                    case 40: 
                    case 41: 
                    case 42: 
                    case 43: 
                    case 44: 
                    case 45: 
                    case 46: 
                    case 47: 
                    case 48: 
                    case 49: 
                    case 50: 
                    case 51: 
                    case 52: 
                    case 53: 
                    case 54: 
                    case 55: 
                    case 56: 
                    case 57: 
                    case 58: 
                    case 59: {
                        ++n4;
                        continue block17;
                    }
                    case 60: {
                        this.flushClean(writer, writerOptimized, cArray, n3, n4);
                        writer.write("&lt;");
                        n3 = ++n4;
                        continue block17;
                    }
                    case 61: {
                        ++n4;
                        continue block17;
                    }
                    case 62: {
                        this.flushClean(writer, writerOptimized, cArray, n3, n4);
                        writer.write("&gt;");
                        n3 = ++n4;
                        continue block17;
                    }
                    case 63: 
                    case 64: 
                    case 65: 
                    case 66: 
                    case 67: 
                    case 68: 
                    case 69: 
                    case 70: 
                    case 71: 
                    case 72: 
                    case 73: 
                    case 74: 
                    case 75: 
                    case 76: 
                    case 77: 
                    case 78: 
                    case 79: 
                    case 80: 
                    case 81: 
                    case 82: 
                    case 83: 
                    case 84: 
                    case 85: 
                    case 86: 
                    case 87: 
                    case 88: 
                    case 89: 
                    case 90: 
                    case 91: 
                    case 92: 
                    case 93: 
                    case 94: 
                    case 95: 
                    case 96: 
                    case 97: 
                    case 98: 
                    case 99: 
                    case 100: 
                    case 101: 
                    case 102: 
                    case 103: 
                    case 104: 
                    case 105: 
                    case 106: 
                    case 107: 
                    case 108: 
                    case 109: 
                    case 110: 
                    case 111: 
                    case 112: 
                    case 113: 
                    case 114: 
                    case 115: 
                    case 116: 
                    case 117: 
                    case 118: 
                    case 119: 
                    case 120: 
                    case 121: 
                    case 122: 
                    case 123: 
                    case 124: 
                    case 125: 
                    case 126: {
                        ++n4;
                        continue block17;
                    }
                    case 127: {
                        this.flushClean(writer, writerOptimized, cArray, n3, n4);
                        writer.write("&#127;");
                        n3 = ++n4;
                        continue block17;
                    }
                }
                continue;
            }
            if (Encodings.isHighUTF16Surrogate((char)n8) && n4 + 1 < n5) {
                char c = cArray[n4 + 1];
                n7 = Encodings.toCodePoint((char)n8, c);
                n6 = 2;
            } else {
                n7 = n8;
                n6 = 1;
            }
            if (this.m_encodingInfo.isInEncoding(n7)) {
                if (n7 == 160) {
                    this.flushClean(writer, writerOptimized, cArray, n3, n4);
                    writer.write("&nbsp;");
                    n3 = n4 += n6;
                    continue;
                }
                if (writerOptimized == null) {
                    n4 += n6;
                    continue;
                }
                int n9 = n4 - n3;
                if (0 < n9) {
                    writerOptimized.writeASCII(cArray, n3, n9);
                }
                if (n6 == 1) {
                    writerOptimized.write(n8);
                } else {
                    writerOptimized.write(cArray, n4, 2);
                }
                n3 = n4 += n6;
                continue;
            }
            this.flushClean(writer, writerOptimized, cArray, n3, n4);
            String string = this.m_charInfo.getOutputStringForChar(n7, this.m_charKey);
            if (this.shouldMapTextChar(n7) && string != null) {
                writer.write(string);
            } else {
                writer.write("&#");
                writer.write(Integer.toString(n7));
                writer.write(59);
            }
            n3 = n4 += n6;
        }
        this.flushClean(writer, writerOptimized, cArray, n3, n4);
    }

    private void processTextNonOpt(char[] cArray, Writer writer, WriterOptimized writerOptimized, int n, int n2) throws IOException {
        int n3;
        int n4;
        int n5;
        int n6 = n + n2;
        for (n4 = n; n4 < n6; n4 += n5) {
            String string;
            int n7;
            int n8 = cArray[n4];
            if (Encodings.isHighUTF16Surrogate((char)n8) && n4 + 1 < n6) {
                char c = cArray[n4 + 1];
                n7 = Encodings.toCodePoint((char)n8, c);
                n5 = 2;
            } else {
                n7 = n8;
                n5 = 1;
            }
            if (this.m_codepoint2String == null || !this.m_codepoint2String.hasMappings() || (string = this.m_codepoint2String.getString(n7)) == null) continue;
            n3 = n4 - n;
            if (n3 > 0) {
                this.unicodeNormalizeThenEscape8(cArray, writer, writerOptimized, n, n3);
            }
            writer.write(string);
            n = n4 + n5;
        }
        n3 = n4 - n;
        if (n3 > 0) {
            this.unicodeNormalizeThenEscape8(cArray, writer, writerOptimized, n, n3);
        }
    }

    private void unicodeNormalizeThenEscape8(char[] cArray, Writer writer, WriterOptimized writerOptimized, int n, int n2) throws IOException {
        char[] cArray2;
        int n3;
        int n4;
        int n5;
        if (this.m_normalizerMode != 1 && !this.m_unicodeNormalizer.alreadyNormalized(cArray, n, n + n2, this.m_normalizerMode)) {
            n5 = 3 * n2 + 1;
            if (this.m_normalizedCharsBuff.length < n5) {
                this.m_normalizedCharsBuff = new char[n5];
            }
            n4 = this.m_unicodeNormalizer.normalizeUnicode(cArray, n, n + n2, this.m_normalizedCharsBuff, 0, n5, this.m_normalizerMode);
            n3 = 0;
            cArray2 = this.m_normalizedCharsBuff;
        } else {
            n4 = n2;
            n3 = n;
            cArray2 = cArray;
        }
        if (!this.m_charInfo.getOnlyStandardEntities()) {
            n5 = n3;
            int n6 = 0;
            int n7 = n3;
            int n8 = n3 + n4;
            while (n7 < n8) {
                int n9;
                int n10;
                int n11 = cArray2[n7];
                if (Encodings.isHighUTF16Surrogate((char)n11) && n7 + 1 < n8) {
                    char c = cArray2[n7 + 1];
                    n10 = Encodings.toCodePoint((char)n11, c);
                    n9 = 2;
                } else {
                    n10 = n11;
                    n9 = 1;
                }
                n6 = n7 - n5;
                if (n6 > 0) {
                    writer.write(cArray, n5, n6);
                    n5 = n7;
                }
                if (this.m_charInfo.shouldMapTextChar(n10)) {
                    String string = this.m_charInfo.getOutputStringForChar(n10, this.m_charKey);
                    if (string != null) {
                        writer.write(string);
                        n5 = ++n7;
                        continue;
                    }
                } else if (this.m_encodingInfo.isInEncoding(n10)) {
                    if (n10 == 160) {
                        n6 = n7 - n5;
                        if (n6 > 0) {
                            writer.write(cArray, n5, n6);
                            n5 = n7;
                        }
                        writer.write("&nbsp;");
                        n5 = n7 += n9;
                        continue;
                    }
                    if (0 <= n10 && n10 <= 31) {
                        n6 = n7 - n5;
                        if (n6 > 0) {
                            writer.write(cArray, n5, n6);
                            n5 = n7;
                        }
                        switch (n10) {
                            case 9: {
                                ++n7;
                                break;
                            }
                            case 10: {
                                if (!this.m_lineSepUse || this.m_lineSepLen == 1 && this.m_lineSep[0] == '\n') {
                                    ++n7;
                                    break;
                                }
                                n6 = n7 - n5;
                                if (n6 > 0) {
                                    writer.write(cArray, n5, n6);
                                    n5 = n7;
                                }
                                writer.write(this.m_lineSep, 0, this.m_lineSepLen);
                                n5 = ++n7;
                                break;
                            }
                            case 13: {
                                n6 = n7 - n5;
                                if (n6 > 0) {
                                    writer.write(cArray, n5, n6);
                                    n5 = n7;
                                }
                                writer.write("&#13;");
                                n5 = ++n7;
                                break;
                            }
                            default: {
                                writer.write("&#");
                                writer.write(Integer.toString(n10));
                                writer.write(59);
                                n5 = n7 += n9;
                            }
                        }
                        if ((n6 = n7 - n5) <= 0) continue;
                        writer.write(cArray, n5, n6);
                        n5 = n7;
                        continue;
                    }
                    if (n10 < 127) {
                        n6 = (n7 += n9) - n5;
                        if (n6 <= 0) continue;
                        writer.write(cArray, n5, n6);
                        n5 = n7;
                        continue;
                    }
                    if (n10 == 127) {
                        n6 = n7 - n5;
                        if (n6 > 0) {
                            writer.write(cArray, n5, n6);
                            n5 = n7;
                        }
                        writer.write("&#127;");
                        n5 = ++n7;
                        continue;
                    }
                    n7 += n9;
                } else {
                    n6 = n7 - n5;
                    if (n6 > 0) {
                        writer.write(cArray, n5, n6);
                        n5 = n7;
                    }
                    writer.write("&#");
                    writer.write(Integer.toString(n10));
                    writer.write(59);
                    n5 = n7 += n9;
                    continue;
                }
                if ((n6 = n7 - n5) <= 0) continue;
                writer.write(cArray, n5, n6);
                n5 = n7;
            }
        } else {
            this.processTextOptimized(cArray2, writer, this.m_writerOptimized, n3, n4);
        }
    }

    private int processLeadingWhiteSpace(Writer writer, char[] cArray, int n, int n2) throws IOException {
        int n3;
        boolean bl;
        int n4 = n;
        int n5 = n + n2;
        int n6 = n;
        n4 = n;
        boolean bl2 = bl = this.m_codepoint2String != null;
        block5: while (n4 < n5) {
            char c = cArray[n4];
            if (bl && this.m_codepoint2String.getString(c) != null) {
                n3 = n4 - n6;
                if (n3 > 0) {
                    writer.write(cArray, n6, n3);
                }
                this.m_ispreserve = true;
                return n4;
            }
            switch (c) {
                case '\t': 
                case ' ': {
                    ++n4;
                    continue block5;
                }
                case '\n': {
                    if (!this.m_lineSepUse || this.m_lineSepLen == 1 && this.m_lineSep[0] == '\n') {
                        ++n4;
                        continue block5;
                    }
                    n3 = n4 - n6;
                    if (n3 > 0) {
                        writer.write(cArray, n6, n3);
                    }
                    writer.write(this.m_lineSep, 0, this.m_lineSepLen);
                    n6 = ++n4;
                    continue block5;
                }
                case '\r': {
                    n3 = n4 - n6;
                    if (n3 > 0) {
                        writer.write(cArray, n6, n3);
                        n3 = 0;
                    }
                    writer.write("&#13;");
                    n6 = ++n4;
                    continue block5;
                }
            }
            n3 = n4 - n6;
            if (n3 > 0) {
                writer.write(cArray, n6, n3);
            }
            this.m_ispreserve = true;
            return n4;
        }
        n3 = n4 - n6;
        if (n3 > 0) {
            writer.write(cArray, n6, n3);
        }
        return n + n2;
    }

    public final void cdata(char[] cArray, int n, int n2) throws SAXException {
        if (null != this.m_elemContext.m_elementName && (this.m_elemContext.m_elementName.equalsIgnoreCase("SCRIPT") || this.m_elemContext.m_elementName.equalsIgnoreCase("STYLE"))) {
            try {
                if (this.m_elemContext.m_startTagOpen) {
                    this.closeStartTag();
                    this.m_elemContext.m_startTagOpen = false;
                }
                this.m_ispreserve = true;
                if (this.shouldIndent()) {
                    this.indent();
                }
                this.writeNormalizedChars(cArray, n, n2, true, this.m_lineSepUse);
            }
            catch (IOException iOException) {
                throw new SAXException(Utils.messages.createMessage("ER_OIERROR", null), iOException);
            }
        } else {
            super.cdata(cArray, n, n2);
        }
    }

    public void processingInstruction(String string, String string2) throws SAXException {
        this.flushInternal();
        if (string.equals("javax.xml.transform.disable-output-escaping")) {
            this.startNonEscaping();
        } else if (string.equals("javax.xml.transform.enable-output-escaping")) {
            this.endNonEscaping();
        } else {
            try {
                if (this.m_elemContext.m_startTagOpen) {
                    this.closeStartTag();
                    this.m_elemContext.m_startTagOpen = false;
                } else if (this.m_cdataTagOpen) {
                    this.closeCDATA();
                } else if (this.m_needToCallStartDocument) {
                    this.m_docIsEmpty = false;
                    this.startDocumentInternal();
                }
                if (this.m_needToOutputDocTypeDecl) {
                    this.outputDocTypeDecl("html");
                }
                if (this.shouldIndent()) {
                    this.indent();
                }
                Writer writer = this.m_writer;
                writer.write("<?");
                writer.write(string);
                if (string2.length() > 0 && !Character.isSpaceChar(string2.charAt(0))) {
                    writer.write(32);
                }
                writer.write(string2);
                writer.write(62);
                if (this.m_elemContext.m_currentElemDepth <= 0) {
                    this.outputLineSep();
                }
                this.m_startNewLine = true;
            }
            catch (IOException iOException) {
                throw new SAXException(iOException);
            }
        }
        if (this.m_tracer != null) {
            super.fireEscapingEvent(string, string2);
        }
    }

    public final void entityReference(String string) throws SAXException {
        try {
            Writer writer = this.m_writer;
            writer.write(38);
            writer.write(string);
            writer.write(59);
        }
        catch (IOException iOException) {
            throw new SAXException(iOException);
        }
    }

    public final void endElement(String string) throws SAXException {
        String string2 = this.m_elemContext.m_elementURI;
        if (string2 == null) {
            string2 = this.getElementURI();
        }
        this.endElement(string2, null, string);
    }

    protected void closeStartTag() throws SAXException {
        try {
            int n;
            ElemDesc elemDesc;
            String string;
            NamespaceMappings.MappingRecord mappingRecord;
            boolean bl;
            String string2 = this.m_elemContext.m_elementName;
            Writer writer = this.m_writer;
            writer.write(60);
            writer.write(string2);
            if (this.m_tracer != null) {
                super.fireStartElem(string2);
            }
            boolean bl2 = bl = this.m_elemContext.m_elementDesc == null;
            if (bl && (mappingRecord = this.m_prefixMap.getMappingFromPrefix("")) != null && (string = mappingRecord.m_uri) == null && (elemDesc = ToHTMLStream.getElemDesc(this.m_elemContext.m_elementName)) != s_elemNotFound) {
                this.m_elemContext.m_elementDesc = elemDesc;
                bl = false;
            }
            if ((n = this.m_attributes.getLength()) > 0) {
                this.processAttributes(writer, n);
                this.m_attributes.clear();
            }
            writer.write(62);
            if (string2.length() == 4 && !bl && (this.m_elemContext.m_elementDesc.getFlags() & 0x400000) != 0 && ("".equals(this.m_elemContext.m_elementURI) || this.m_elemContext.m_elementURI == null)) {
                this.metaCreate(this.m_elemContext, writer);
            }
            if (this.m_CdataElems != null) {
                this.m_elemContext.m_isCdataSection = this.isCdataSection();
            }
            if (this.m_doIndent) {
                this.m_isprevtext = false;
            }
        }
        catch (IOException iOException) {
            throw new SAXException(iOException);
        }
    }

    public void namespaceAfterStartElement(String string, String string2) throws SAXException {
        String string3;
        if (this.m_elemContext.m_elementURI == null && (string3 = ToHTMLStream.getPrefixPart(this.m_elemContext.m_elementName)) == null && "".equals(string)) {
            this.m_elemContext.m_elementURI = string2;
        }
        this.startPrefixMapping(string, string2, false);
    }

    public void startDTD(String string, String string2, String string3) throws SAXException {
        this.m_inDTD = true;
        super.startDTD(string, string2, string3);
    }

    public void endDTD() throws SAXException {
        this.m_inDTD = false;
    }

    public void attributeDecl(String string, String string2, String string3, String string4, String string5) throws SAXException {
    }

    public void elementDecl(String string, String string2) throws SAXException {
    }

    public void internalEntityDecl(String string, String string2) throws SAXException {
    }

    public void externalEntityDecl(String string, String string2, String string3) throws SAXException {
    }

    public void comment(char[] cArray, int n, int n2) throws SAXException {
        if (this.m_inDTD) {
            return;
        }
        if (this.m_elemContext.m_startTagOpen) {
            this.closeStartTag();
            this.m_elemContext.m_startTagOpen = false;
        } else if (this.m_cdataTagOpen) {
            this.closeCDATA();
        } else if (this.m_needToCallStartDocument) {
            this.startDocumentInternal();
        }
        if (this.m_needToOutputDocTypeDecl) {
            this.outputDocTypeDecl("html");
        }
        super.comment(cArray, n, n2);
    }

    public boolean reset() {
        super.reset();
        this.resetToHTMLStream();
        this.m_wasJustReset = true;
        return true;
    }

    private void resetToHTMLStream() {
        this.m_inBlockElem = false;
        this.m_inDTD = false;
    }

    public final void endDocument() throws SAXException {
        this.flushInternal();
        if (this.m_doIndent && !this.m_isprevtext) {
            try {
                this.outputLineSep();
            }
            catch (IOException iOException) {
                throw new SAXException(iOException);
            }
        }
        this.flushWriter();
        if (this.m_tracer != null) {
            super.fireEndDoc();
        }
    }

    public void flushPending() throws SAXException {
        this.flushInternal();
        this.flushWriter();
    }

    public boolean shouldMapTextChar(int n) {
        boolean bl = this.m_encodingInfo.isInEncoding(n) ? false : this.m_charInfo.shouldMapTextChar(n);
        return bl;
    }

    public boolean shouldMapAttrChar(int n) {
        boolean bl = this.m_encodingInfo.isInEncoding(n) ? false : this.m_charInfo.shouldMapAttrChar(n);
        return bl;
    }

    private boolean metaDiscard(String string) {
        String string2;
        ElemDesc elemDesc;
        return !this.m_omitMetaTag && "meta".equalsIgnoreCase(string) && this.m_elemContext.m_currentElemDepth > 1 && (elemDesc = this.m_elemContext.m_prev.m_elementDesc) != null && elemDesc.is(0x400000) && "Content-Type".equals(string2 = this.m_attributes.getValue("http-equiv"));
    }

    public static final ElemDesc getElemDesc(QName qName) {
        Object object = m_elementFlags.get(ToHTMLStream.getStringRep(qName));
        if (null != object) {
            return (ElemDesc)object;
        }
        return s_elemNotFound;
    }

    void processAttribute(Writer writer, WriterOptimized writerOptimized, AttributesImplSerializer.AttributeImpl attributeImpl, ElemDesc elemDesc, int n) throws IOException {
        writer.write(32);
        String string = attributeImpl.m_qName;
        String string2 = attributeImpl.m_value;
        if ((string2.length() == 0 || string2.equalsIgnoreCase(string)) && elemDesc != null && elemDesc.isAttrFlagSet(string, 4)) {
            writer.write(string);
        } else {
            writer.write(string);
            writer.write("=\"");
            if (elemDesc != null && elemDesc.isAttrFlagSet(string, 2)) {
                switch (n) {
                    case 0: {
                        if ((attributeImpl.m_flags & 1) != 0) {
                            if (writer == writerOptimized) {
                                writerOptimized.writeASCII(string2);
                                break;
                            }
                            writer.write(string2);
                            break;
                        }
                        this.writeHTMLAttrURIOpt(writer, writerOptimized, string2);
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: {
                        this.writeHTMLAttrURI(writer, writerOptimized, string2);
                    }
                }
            } else {
                switch (n) {
                    case 0: {
                        if ((attributeImpl.m_flags & 1) != 0) {
                            if (writer == writerOptimized) {
                                writerOptimized.writeASCII(string2);
                                break;
                            }
                            writer.write(string2);
                            break;
                        }
                        this.writeHTMLAttrOpt(writer, writerOptimized, string2);
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: {
                        this.writeHTMLAttr(writer, writerOptimized, string2);
                    }
                }
            }
            writer.write(34);
        }
    }

    static {
        ToHTMLStream.initTagReference(m_elementFlags);
    }

    static class Trie {
        public static final int ALPHA_SIZE = 128;
        final Node m_Root;
        private char[] m_charBuffer = new char[0];
        private final boolean m_lowerCaseOnly;

        public Trie() {
            this.m_Root = new Node();
            this.m_lowerCaseOnly = false;
        }

        public Trie(boolean bl) {
            this.m_Root = new Node();
            this.m_lowerCaseOnly = bl;
        }

        public Object put(String string, Object object) {
            int n = string.length();
            if (n > this.m_charBuffer.length) {
                this.m_charBuffer = new char[n];
            }
            Node node = this.m_Root;
            for (int i = 0; i < n; ++i) {
                Node node2 = node.m_nextChar[Character.toLowerCase(string.charAt(i))];
                if (node2 != null) {
                    node = node2;
                    continue;
                }
                while (i < n) {
                    Node node3 = new Node();
                    if (this.m_lowerCaseOnly) {
                        node.m_nextChar[Character.toLowerCase((char)string.charAt((int)i))] = node3;
                    } else {
                        node.m_nextChar[Character.toUpperCase((char)string.charAt((int)i))] = node3;
                        node.m_nextChar[Character.toLowerCase((char)string.charAt((int)i))] = node3;
                    }
                    node = node3;
                    ++i;
                }
                break;
            }
            Object object2 = node.m_Value;
            node.m_Value = object;
            return object2;
        }

        public Object get(String string) {
            int n = string.length();
            if (this.m_charBuffer.length < n) {
                return null;
            }
            Node node = this.m_Root;
            switch (n) {
                case 0: {
                    return null;
                }
                case 1: {
                    char c = string.charAt(0);
                    if (c < '\u0080' && (node = node.m_nextChar[c]) != null) {
                        return node.m_Value;
                    }
                    return null;
                }
            }
            for (int i = 0; i < n; ++i) {
                char c = string.charAt(i);
                if ('\u0080' <= c) {
                    return null;
                }
                node = node.m_nextChar[c];
                if (node != null) continue;
                return null;
            }
            return node.m_Value;
        }

        public Trie(Trie trie) {
            this.m_Root = trie.m_Root;
            this.m_lowerCaseOnly = trie.m_lowerCaseOnly;
            int n = trie.getLongestKeyLength();
            this.m_charBuffer = new char[n];
        }

        public Object get2(String string) {
            int n = string.length();
            if (this.m_charBuffer.length < n) {
                return null;
            }
            Node node = this.m_Root;
            switch (n) {
                case 0: {
                    return null;
                }
                case 1: {
                    char c = string.charAt(0);
                    if (c < '\u0080' && (node = node.m_nextChar[c]) != null) {
                        return node.m_Value;
                    }
                    return null;
                }
            }
            string.getChars(0, n, this.m_charBuffer, 0);
            for (int i = 0; i < n; ++i) {
                char c = this.m_charBuffer[i];
                if ('\u0080' <= c) {
                    return null;
                }
                node = node.m_nextChar[c];
                if (node != null) continue;
                return null;
            }
            return node.m_Value;
        }

        public int getLongestKeyLength() {
            return this.m_charBuffer.length;
        }

        private class Node {
            final Node[] m_nextChar = new Node[128];
            Object m_Value = null;

            Node() {
            }
        }
    }
}

