/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.serializer;

import java.io.IOException;
import java.io.Writer;
import javax.xml.namespace.QName;
import org.apache.xml.serializer.AttributesImplSerializer;
import org.apache.xml.serializer.ElemDesc;
import org.apache.xml.serializer.Encodings;
import org.apache.xml.serializer.ToStream;
import org.apache.xml.serializer.ToXHTMLStream;
import org.apache.xml.serializer.WriterOptimized;
import org.apache.xml.serializer.unicode.UnicodeNormalizerFactory;
import org.apache.xml.serializer.utils.Utils;
import org.xml.sax.SAXException;

public abstract class ToHTMLCommon
extends ToStream {
    private final boolean m_isXHTML = this instanceof ToXHTMLStream;
    static final boolean s_output_entities_which_are_in_the_encoding = false;
    static final ElemDesc s_elemNotFound = new ElemDesc(8);

    ToHTMLCommon() {
    }

    public boolean reset() {
        super.reset();
        this.resetToHTMLCommon();
        return true;
    }

    private void resetToHTMLCommon() {
    }

    private static String makeHHString(int n) {
        String string = Integer.toHexString(n).toUpperCase();
        if (string.length() == 1) {
            string = "0" + string;
        }
        return string;
    }

    void writeHTMLAttrURI(Writer writer, WriterOptimized writerOptimized, String string) throws IOException {
        boolean bl = this.m_specialEscapeURLs;
        int n = 0;
        int n2 = 0;
        if (bl) {
            int n3;
            if (this.m_unicodeNormalizer == null) {
                this.m_unicodeNormalizer = UnicodeNormalizerFactory.getUnicodeNormalizer();
            }
            if (!this.m_unicodeNormalizer.alreadyNormalized(string, 2)) {
                string = this.m_unicodeNormalizer.normalizeUnicode(string, 2);
            }
            int n4 = string.length();
            for (int i = 0; i < n4; i += n3) {
                n3 = this.getChars(string, i, n4);
                char[] cArray = this.getCharsBuff();
                char c = '\u0000';
                for (int j = 0; j < n3; ++j) {
                    String string2;
                    c = cArray[j];
                    if (c < ' ' || c > '~') {
                        int n5;
                        int n6;
                        if (n2 > 0) {
                            writer.write(cArray, n, n2);
                            n2 = 0;
                        }
                        if (c <= '\u007f') {
                            writer.write(37);
                            writer.write(ToHTMLCommon.makeHHString(c));
                        } else if (c <= '\u07ff') {
                            int n7 = c >> 6 | 0xC0;
                            n6 = c & 0x3F | 0x80;
                            writer.write(37);
                            writer.write(ToHTMLCommon.makeHHString(n7));
                            writer.write(37);
                            writer.write(ToHTMLCommon.makeHHString(n6));
                        } else if (Encodings.isHighUTF16Surrogate(c)) {
                            int n8 = c & 0x3FF;
                            n6 = (n8 & 0x3C0) >> 6;
                            n5 = n6 + 1;
                            int n9 = (n8 & 0x3C) >> 2;
                            int n10 = (n8 & 3) << 4 & 0x30;
                            c = cArray[++j];
                            int n11 = c & 0x3FF;
                            int n12 = n11 & 0x3F;
                            int n13 = 0xF0 | n5 >> 2;
                            int n14 = 0x80 | (n5 & 3) << 4 & 0x30 | n9;
                            int n15 = 0x80 | (n10 |= (n11 & 0x3C0) >> 6);
                            int n16 = 0x80 | n12;
                            writer.write(37);
                            writer.write(ToHTMLCommon.makeHHString(n13));
                            writer.write(37);
                            writer.write(ToHTMLCommon.makeHHString(n14));
                            writer.write(37);
                            writer.write(ToHTMLCommon.makeHHString(n15));
                            writer.write(37);
                            writer.write(ToHTMLCommon.makeHHString(n16));
                        } else {
                            int n17 = c >> 12 | 0xE0;
                            n6 = (c & 0xFC0) >> 6 | 0x80;
                            n5 = c & 0x3F | 0x80;
                            writer.write(37);
                            writer.write(ToHTMLCommon.makeHHString(n17));
                            writer.write(37);
                            writer.write(ToHTMLCommon.makeHHString(n6));
                            writer.write(37);
                            writer.write(ToHTMLCommon.makeHHString(n5));
                        }
                        n = j + 1;
                        continue;
                    }
                    switch (c) {
                        case '\"': {
                            if (!this.isXSLT10()) {
                                string2 = "&quot;";
                                break;
                            }
                            string2 = "%22";
                            break;
                        }
                        case '&': {
                            string2 = "&amp;";
                            break;
                        }
                        case '>': {
                            string2 = "&gt;";
                            break;
                        }
                        default: {
                            string2 = null;
                        }
                    }
                    if (string2 != null) {
                        if (n2 > 0) {
                            writer.write(cArray, n, n2);
                            n2 = 0;
                        }
                        writer.write(string2);
                        n = j + 1;
                        continue;
                    }
                    ++n2;
                }
                if (n2 > 1) {
                    if (n == 0 && string != null) {
                        writer.write(string);
                        continue;
                    }
                    writer.write(cArray, n, n2);
                    continue;
                }
                if (n2 != 1) continue;
                writer.write(c);
            }
        } else {
            int n18;
            int n19 = string.length();
            for (int i = 0; i < n19; i += n18) {
                n18 = this.getChars(string, i, n19);
                char[] cArray = this.getCharsBuff();
                int n20 = 1;
                if (this.m_codepoint2String != null && this.m_codepoint2String.hasMappings()) {
                    for (int j = n + n2; j < n18; j += n20) {
                        int n21;
                        int n22 = cArray[j];
                        if (Encodings.isHighUTF16Surrogate((char)n22) && j + 1 < n18) {
                            char c = cArray[j + 1];
                            n21 = Encodings.toCodePoint((char)n22, c);
                            n20 = 2;
                        } else {
                            n21 = n22;
                            n20 = 1;
                        }
                        String string3 = this.m_codepoint2String.getString(n21);
                        if (string3 != null) {
                            if (n2 > 0) {
                                this.unicodeNormalizeAttrUriThendEscape(null, cArray, writerOptimized, n, n2);
                            }
                            writer.write(string3);
                            n = j + n20;
                            n2 = 0;
                            continue;
                        }
                        n2 += n20;
                    }
                } else {
                    n2 = n18;
                }
                if (n2 <= 0) continue;
                this.unicodeNormalizeAttrUriThendEscape(string, cArray, writerOptimized, n, n2);
            }
        }
    }

    void writeHTMLAttrURIOpt(Writer writer, WriterOptimized writerOptimized, String string) throws IOException {
        int n;
        boolean bl = this.m_specialEscapeURLs;
        int n2 = string.length();
        for (int i = 0; i < n2; i += n) {
            int n3;
            int n4;
            int n5;
            int n6;
            n = this.getChars(string, i, n2);
            char[] cArray = this.getCharsBuff();
            int n7 = 0;
            int n8 = 0;
            int n9 = 0;
            int n10 = n;
            if (bl) {
                block27: while (n9 < n10) {
                    n7 = cArray[n9];
                    switch (n7) {
                        case 0: 
                        case 1: 
                        case 2: 
                        case 3: 
                        case 4: 
                        case 5: 
                        case 6: 
                        case 7: 
                        case 8: 
                        case 9: 
                        case 10: 
                        case 11: 
                        case 12: 
                        case 13: 
                        case 14: 
                        case 15: 
                        case 16: 
                        case 17: 
                        case 18: 
                        case 19: 
                        case 20: 
                        case 21: 
                        case 22: 
                        case 23: 
                        case 24: 
                        case 25: 
                        case 26: 
                        case 27: 
                        case 28: 
                        case 29: 
                        case 30: 
                        case 31: {
                            this.flushClean(writer, writerOptimized, cArray, n8, n9);
                            writer.write(37);
                            writer.write(ToHTMLCommon.makeHHString(n7));
                            n8 = ++n9;
                            continue block27;
                        }
                        case 32: 
                        case 33: {
                            ++n9;
                            continue block27;
                        }
                        case 34: {
                            this.flushClean(writer, writerOptimized, cArray, n8, n9);
                            if (!this.isXSLT10()) {
                                writer.write("&quot;");
                            } else {
                                writer.write("%22");
                            }
                            n8 = ++n9;
                            continue block27;
                        }
                        case 35: 
                        case 36: 
                        case 37: {
                            ++n9;
                            continue block27;
                        }
                        case 38: {
                            if (n9 + 1 < n10 && cArray[n9 + 1] == '{') {
                                n9 += 2;
                                continue block27;
                            }
                            this.flushClean(writer, writerOptimized, cArray, n8, n9);
                            writer.write("&amp;");
                            n8 = ++n9;
                            continue block27;
                        }
                        case 39: 
                        case 40: 
                        case 41: 
                        case 42: 
                        case 43: 
                        case 44: 
                        case 45: 
                        case 46: 
                        case 47: 
                        case 48: 
                        case 49: 
                        case 50: 
                        case 51: 
                        case 52: 
                        case 53: 
                        case 54: 
                        case 55: 
                        case 56: 
                        case 57: 
                        case 58: 
                        case 59: 
                        case 60: 
                        case 61: {
                            ++n9;
                            continue block27;
                        }
                        case 62: {
                            this.flushClean(writer, writerOptimized, cArray, n8, n9);
                            writer.write("&gt;");
                            n8 = ++n9;
                            continue block27;
                        }
                        case 63: 
                        case 64: 
                        case 65: 
                        case 66: 
                        case 67: 
                        case 68: 
                        case 69: 
                        case 70: 
                        case 71: 
                        case 72: 
                        case 73: 
                        case 74: 
                        case 75: 
                        case 76: 
                        case 77: 
                        case 78: 
                        case 79: 
                        case 80: 
                        case 81: 
                        case 82: 
                        case 83: 
                        case 84: 
                        case 85: 
                        case 86: 
                        case 87: 
                        case 88: 
                        case 89: 
                        case 90: 
                        case 91: 
                        case 92: 
                        case 93: 
                        case 94: 
                        case 95: 
                        case 96: 
                        case 97: 
                        case 98: 
                        case 99: 
                        case 100: 
                        case 101: 
                        case 102: 
                        case 103: 
                        case 104: 
                        case 105: 
                        case 106: 
                        case 107: 
                        case 108: 
                        case 109: 
                        case 110: 
                        case 111: 
                        case 112: 
                        case 113: 
                        case 114: 
                        case 115: 
                        case 116: 
                        case 117: 
                        case 118: 
                        case 119: 
                        case 120: 
                        case 121: 
                        case 122: 
                        case 123: 
                        case 124: 
                        case 125: 
                        case 126: {
                            ++n9;
                            continue block27;
                        }
                        case 127: {
                            this.flushClean(writer, writerOptimized, cArray, n8, n9);
                            writer.write("%7F");
                            n8 = ++n9;
                            continue block27;
                        }
                    }
                    if (n7 <= 2047) {
                        this.flushClean(writer, writerOptimized, cArray, n8, n9);
                        n6 = n7 >> 6 | 0xC0;
                        n5 = n7 & 0x3F | 0x80;
                        writer.write(37);
                        writer.write(ToHTMLCommon.makeHHString(n6));
                        writer.write(37);
                        writer.write(ToHTMLCommon.makeHHString(n5));
                        n8 = ++n9;
                        continue;
                    }
                    if (Encodings.isHighUTF16Surrogate((char)n7)) {
                        this.flushClean(writer, writerOptimized, cArray, n8, n9);
                        n6 = n7 & 0x3FF;
                        n5 = (n6 & 0x3C0) >> 6;
                        n4 = n5 + 1;
                        int n11 = (n6 & 0x3C) >> 2;
                        int n12 = (n6 & 3) << 4 & 0x30;
                        n7 = cArray[++n9];
                        int n13 = n7 & 0x3FF;
                        int n14 = n13 & 0x3F;
                        int n15 = 0xF0 | n4 >> 2;
                        int n16 = 0x80 | (n4 & 3) << 4 & 0x30 | n11;
                        int n17 = 0x80 | (n12 |= (n13 & 0x3C0) >> 6);
                        int n18 = 0x80 | n14;
                        writer.write(37);
                        writer.write(ToHTMLCommon.makeHHString(n15));
                        writer.write(37);
                        writer.write(ToHTMLCommon.makeHHString(n16));
                        writer.write(37);
                        writer.write(ToHTMLCommon.makeHHString(n17));
                        writer.write(37);
                        writer.write(ToHTMLCommon.makeHHString(n18));
                        n8 = ++n9;
                        continue;
                    }
                    this.flushClean(writer, writerOptimized, cArray, n8, n9);
                    n6 = n7 >> 12 | 0xE0;
                    n5 = (n7 & 0xFC0) >> 6 | 0x80;
                    n4 = n7 & 0x3F | 0x80;
                    writer.write(37);
                    writer.write(ToHTMLCommon.makeHHString(n6));
                    writer.write(37);
                    writer.write(ToHTMLCommon.makeHHString(n5));
                    writer.write(37);
                    writer.write(ToHTMLCommon.makeHHString(n4));
                    n8 = ++n9;
                }
                n3 = n9 - n8;
                if (n3 > 1) {
                    this.flushClean(writer, writerOptimized, cArray, n8, n9);
                    continue;
                }
                if (n3 != 1) continue;
                writer.write(n7);
                continue;
            }
            block28: while (n9 < n10) {
                n7 = cArray[n9];
                switch (n7) {
                    case 0: 
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: 
                    case 8: {
                        this.flushClean(writer, writerOptimized, cArray, n8, n9);
                        writer.write("&#");
                        writer.write(Integer.toString(n7));
                        writer.write(59);
                        n8 = ++n9;
                        continue block28;
                    }
                    case 9: 
                    case 10: {
                        ++n9;
                        continue block28;
                    }
                    case 11: 
                    case 12: {
                        this.flushClean(writer, writerOptimized, cArray, n8, n9);
                        writer.write("&#");
                        writer.write(Integer.toString(n7));
                        writer.write(59);
                        n8 = ++n9;
                        continue block28;
                    }
                    case 13: {
                        ++n9;
                        continue block28;
                    }
                    case 14: 
                    case 15: 
                    case 16: 
                    case 17: 
                    case 18: 
                    case 19: 
                    case 20: 
                    case 21: 
                    case 22: 
                    case 23: 
                    case 24: 
                    case 25: 
                    case 26: 
                    case 27: 
                    case 28: 
                    case 29: 
                    case 30: 
                    case 31: {
                        this.flushClean(writer, writerOptimized, cArray, n8, n9);
                        writer.write("&#");
                        writer.write(Integer.toString(n7));
                        writer.write(59);
                        n8 = ++n9;
                        continue block28;
                    }
                    case 32: 
                    case 33: {
                        ++n9;
                        continue block28;
                    }
                    case 34: {
                        this.flushClean(writer, writerOptimized, cArray, n8, n9);
                        writer.write("&quot;");
                        n8 = ++n9;
                        continue block28;
                    }
                    case 35: 
                    case 36: 
                    case 37: {
                        ++n9;
                        continue block28;
                    }
                    case 38: {
                        this.flushClean(writer, writerOptimized, cArray, n8, n9);
                        writer.write("&amp;");
                        n8 = ++n9;
                        continue block28;
                    }
                    case 39: 
                    case 40: 
                    case 41: 
                    case 42: 
                    case 43: 
                    case 44: 
                    case 45: 
                    case 46: 
                    case 47: 
                    case 48: 
                    case 49: 
                    case 50: 
                    case 51: 
                    case 52: 
                    case 53: 
                    case 54: 
                    case 55: 
                    case 56: 
                    case 57: 
                    case 58: 
                    case 59: 
                    case 60: 
                    case 61: {
                        ++n9;
                        continue block28;
                    }
                    case 62: {
                        this.flushClean(writer, writerOptimized, cArray, n8, n9);
                        writer.write("&gt;");
                        n8 = ++n9;
                        continue block28;
                    }
                    case 63: 
                    case 64: 
                    case 65: 
                    case 66: 
                    case 67: 
                    case 68: 
                    case 69: 
                    case 70: 
                    case 71: 
                    case 72: 
                    case 73: 
                    case 74: 
                    case 75: 
                    case 76: 
                    case 77: 
                    case 78: 
                    case 79: 
                    case 80: 
                    case 81: 
                    case 82: 
                    case 83: 
                    case 84: 
                    case 85: 
                    case 86: 
                    case 87: 
                    case 88: 
                    case 89: 
                    case 90: 
                    case 91: 
                    case 92: 
                    case 93: 
                    case 94: 
                    case 95: 
                    case 96: 
                    case 97: 
                    case 98: 
                    case 99: 
                    case 100: 
                    case 101: 
                    case 102: 
                    case 103: 
                    case 104: 
                    case 105: 
                    case 106: 
                    case 107: 
                    case 108: 
                    case 109: 
                    case 110: 
                    case 111: 
                    case 112: 
                    case 113: 
                    case 114: 
                    case 115: 
                    case 116: 
                    case 117: 
                    case 118: 
                    case 119: 
                    case 120: 
                    case 121: 
                    case 122: 
                    case 123: 
                    case 124: 
                    case 125: 
                    case 126: {
                        ++n9;
                        continue block28;
                    }
                    case 127: {
                        this.flushClean(writer, writerOptimized, cArray, n8, n9);
                        writer.write("%7F");
                        n8 = ++n9;
                        continue block28;
                    }
                }
                n6 = 0;
                if (Encodings.isHighUTF16Surrogate((char)n7) && n9 + 1 < n10) {
                    n4 = cArray[n9 + 1];
                    n6 = Encodings.toCodePoint((char)n7, (char)n4);
                    n5 = 2;
                } else {
                    n6 = n7;
                    n5 = 1;
                }
                n3 = n9 - n8;
                if (n3 > 0) {
                    this.flushClean(writer, writerOptimized, cArray, n8, n9);
                }
                if (this.m_encodingInfo.isInEncoding(n6)) {
                    if (n5 == 2) {
                        writer.write(cArray, n8, 2);
                    } else {
                        writer.write(n7);
                    }
                }
                n8 = n9 += n5;
            }
            n3 = n9 - n8;
            if (n3 > 1) {
                this.flushClean(writer, writerOptimized, cArray, n8, n9);
                continue;
            }
            if (n3 != 1) continue;
            writer.write(n7);
        }
    }

    void flushClean(Writer writer, WriterOptimized writerOptimized, char[] cArray, int n, int n2) throws IOException {
        int n3 = n2 - n;
        if (n3 > 0) {
            if (writerOptimized == writer) {
                writerOptimized.writeASCII(cArray, n, n3);
            } else {
                writer.write(cArray, n, n3);
            }
        }
    }

    private void unicodeNormalizeAttrUriThendEscape(String string, char[] cArray, WriterOptimized writerOptimized, int n, int n2) throws IOException {
        int n3;
        int n4 = 0;
        int n5 = n2;
        int n6 = n;
        Writer writer = this.m_writer;
        if (this.m_normalizerMode != 1 && !this.m_unicodeNormalizer.alreadyNormalized(cArray, n, n + n2, this.m_normalizerMode)) {
            n3 = n + 3 * n2 + 1;
            if (this.m_normalizedCharsBuff.length < n3) {
                this.m_normalizedCharsBuff = new char[n3];
            }
            n5 = this.m_unicodeNormalizer.normalizeUnicode(cArray, n, n + n2, this.m_normalizedCharsBuff, n, n3, this.m_normalizerMode);
            cArray = this.m_normalizedCharsBuff;
        }
        if (!this.m_charInfo.getOnlyStandardEntities()) {
            n3 = 0;
            char c = '\u0000';
            int n7 = 1;
            int n8 = n5 + n;
            int n9 = 0;
            for (int i = n; i < n8; i += n7) {
                n3 = cArray[i];
                if (Encodings.isHighUTF16Surrogate((char)n3) && i + 1 < n8) {
                    c = cArray[i + 1];
                    n9 = Encodings.toCodePoint((char)n3, c);
                    n7 = 2;
                } else {
                    n9 = n3;
                    n7 = 1;
                }
                if (n9 == 60) {
                    ++n4;
                    continue;
                }
                String string2 = this.m_charInfo.getOutputStringForChar(n9, this.m_charKey);
                if (string2 != null) {
                    if (n4 > 0) {
                        writer.write(cArray, n6, n4);
                        n4 = 0;
                    }
                    n6 = i + n7;
                    writer.write(string2);
                    continue;
                }
                if (n9 < 32 || n9 > 127) {
                    if (this.escapingNotNeeded(n9)) {
                        if (n4 > 0) {
                            this.m_writer.write(cArray, n6, n4);
                            n4 = 0;
                        }
                        n6 = i + n7;
                        writer.write(n9);
                        continue;
                    }
                    if (n4 > 0) {
                        this.m_writer.write(cArray, n6, n4);
                        n4 = 0;
                    }
                    n6 = i + n7;
                    writer.write("&#");
                    writer.write(Integer.toString(n9));
                    writer.write(59);
                    continue;
                }
                if (n9 == 34) {
                    if (n4 > 0) {
                        this.m_writer.write(cArray, n6, n4);
                        n4 = 0;
                    }
                    n6 = i + 1;
                    writer.write("&quot;");
                    continue;
                }
                n4 += n7;
            }
            if (n4 > 1) {
                if (n6 == 0) {
                    writer.write(string);
                } else {
                    writer.write(cArray, n6, n4);
                }
            } else if (n4 == 1) {
                writer.write(n9);
            }
        } else {
            this.writeHTMLAttrURIOpt(writer, writerOptimized, new String(cArray));
        }
    }

    void writeHTMLAttr(Writer writer, WriterOptimized writerOptimized, String string) throws IOException {
        int n;
        int n2 = string.length();
        for (int i = 0; i < n2; i += n) {
            n = this.getChars(string, i, n2);
            char[] cArray = this.getCharsBuff();
            int n3 = 0;
            int n4 = 0;
            int n5 = 1;
            if (this.m_codepoint2String != null && this.m_codepoint2String.hasMappings()) {
                for (int j = 0; j < n; j += n5) {
                    int n6;
                    int n7 = cArray[j];
                    if (Encodings.isHighUTF16Surrogate((char)n7) && j + 1 < n) {
                        char c = cArray[j + 1];
                        n6 = Encodings.toCodePoint((char)n7, c);
                        n5 = 2;
                    } else {
                        n6 = n7;
                        n5 = 1;
                    }
                    String string2 = this.m_codepoint2String.getString(n6);
                    if (string2 != null) {
                        if (n4 > 0) {
                            this.unicodeNormalizeHTMLAttrThenEscape(null, cArray, writerOptimized, n3, n4);
                        }
                        writer.write(string2);
                        n3 = j + n5;
                        n4 = 0;
                        continue;
                    }
                    n4 += n5;
                }
            } else {
                n4 = n;
            }
            if (n4 <= 0) continue;
            this.unicodeNormalizeHTMLAttrThenEscape(string, cArray, writerOptimized, n3, n4);
        }
    }

    void writeHTMLAttrOpt(Writer writer, WriterOptimized writerOptimized, String string) throws IOException {
        int n;
        int n2 = string.length();
        for (int i = 0; i < n2; i += n) {
            int n3;
            n = this.getChars(string, i, n2);
            char[] cArray = this.getCharsBuff();
            int n4 = n3 = 0;
            int n5 = n3;
            int n6 = n3 + n;
            block16: while (n5 < n6) {
                int n7;
                int n8;
                int n9;
                int n10 = cArray[n5];
                switch (n10) {
                    case 0: 
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: 
                    case 8: 
                    case 9: {
                        n9 = n5 - n4;
                        this.writeNumericEntity(writer, writerOptimized, n10, cArray, n9, n4);
                        n4 = ++n5;
                        continue block16;
                    }
                    case 10: {
                        ++n5;
                        continue block16;
                    }
                    case 11: 
                    case 12: {
                        n9 = n5 - n4;
                        this.writeNumericEntity(writer, writerOptimized, n10, cArray, n9, n4);
                        n4 = ++n5;
                        continue block16;
                    }
                    case 13: {
                        ++n5;
                        continue block16;
                    }
                    case 14: 
                    case 15: 
                    case 16: 
                    case 17: 
                    case 18: 
                    case 19: 
                    case 20: 
                    case 21: 
                    case 22: 
                    case 23: 
                    case 24: 
                    case 25: 
                    case 26: 
                    case 27: 
                    case 28: 
                    case 29: 
                    case 30: 
                    case 31: {
                        n9 = n5 - n4;
                        this.writeNumericEntity(writer, writerOptimized, n10, cArray, n9, n4);
                        n4 = ++n5;
                        continue block16;
                    }
                    case 32: 
                    case 33: {
                        ++n5;
                        continue block16;
                    }
                    case 34: {
                        this.flushClean(writer, writerOptimized, cArray, n4, n5);
                        writer.write("&quot;");
                        n4 = ++n5;
                        continue block16;
                    }
                    case 35: 
                    case 36: 
                    case 37: {
                        ++n5;
                        continue block16;
                    }
                    case 38: {
                        if (n5 + 1 < n6 && cArray[n5 + 1] == '{') {
                            n5 += 2;
                            continue block16;
                        }
                        this.flushClean(writer, writerOptimized, cArray, n4, n5);
                        writer.write("&amp;");
                        n4 = ++n5;
                        continue block16;
                    }
                    case 39: 
                    case 40: 
                    case 41: 
                    case 42: 
                    case 43: 
                    case 44: 
                    case 45: 
                    case 46: 
                    case 47: 
                    case 48: 
                    case 49: 
                    case 50: 
                    case 51: 
                    case 52: 
                    case 53: 
                    case 54: 
                    case 55: 
                    case 56: 
                    case 57: 
                    case 58: 
                    case 59: 
                    case 60: 
                    case 61: {
                        ++n5;
                        continue block16;
                    }
                    case 62: {
                        if (!this.isXSLT10()) {
                            this.flushClean(writer, writerOptimized, cArray, n4, n5);
                            writer.write("&gt;");
                            n4 = ++n5;
                            continue block16;
                        }
                        ++n5;
                        continue block16;
                    }
                    case 63: 
                    case 64: 
                    case 65: 
                    case 66: 
                    case 67: 
                    case 68: 
                    case 69: 
                    case 70: 
                    case 71: 
                    case 72: 
                    case 73: 
                    case 74: 
                    case 75: 
                    case 76: 
                    case 77: 
                    case 78: 
                    case 79: 
                    case 80: 
                    case 81: 
                    case 82: 
                    case 83: 
                    case 84: 
                    case 85: 
                    case 86: 
                    case 87: 
                    case 88: 
                    case 89: 
                    case 90: 
                    case 91: 
                    case 92: 
                    case 93: 
                    case 94: 
                    case 95: 
                    case 96: 
                    case 97: 
                    case 98: 
                    case 99: 
                    case 100: 
                    case 101: 
                    case 102: 
                    case 103: 
                    case 104: 
                    case 105: 
                    case 106: 
                    case 107: 
                    case 108: 
                    case 109: 
                    case 110: 
                    case 111: 
                    case 112: 
                    case 113: 
                    case 114: 
                    case 115: 
                    case 116: 
                    case 117: 
                    case 118: 
                    case 119: 
                    case 120: 
                    case 121: 
                    case 122: 
                    case 123: 
                    case 124: 
                    case 125: 
                    case 126: {
                        ++n5;
                        continue block16;
                    }
                    case 127: {
                        n9 = n5 - n4;
                        this.writeNumericEntity(writer, writerOptimized, n10, cArray, n9, n4);
                        n4 = ++n5;
                        continue block16;
                    }
                }
                if (Encodings.isHighUTF16Surrogate((char)n10) && n5 + 1 < n6) {
                    char c = cArray[n5 + 1];
                    n8 = Encodings.toCodePoint((char)n10, c);
                    n7 = 2;
                } else {
                    n8 = n10;
                    n7 = 1;
                }
                if (this.m_encodingInfo.isInEncoding(n8)) {
                    if (n8 == 160) {
                        this.flushClean(writer, writerOptimized, cArray, n4, n5);
                        writer.write("&nbsp;");
                        n4 = n5 += n7;
                        continue;
                    }
                    if (writerOptimized != writer) {
                        n5 += n7;
                        continue;
                    }
                    n9 = n5 - n4;
                    writerOptimized.writeASCII(cArray, n4, n9);
                    if (n7 == 1) {
                        writerOptimized.write(n10);
                    } else {
                        writerOptimized.write(cArray, n5, 2);
                    }
                    n4 = n5 += n7;
                    continue;
                }
                this.flushClean(writer, writerOptimized, cArray, n4, n5);
                String string2 = this.m_charInfo.getOutputStringForChar(n8, this.m_charKey);
                if (this.shouldMapAttrChar(n8) && string2 != null) {
                    writer.write(string2);
                } else {
                    writer.write("&#");
                    writer.write(Integer.toString(n8));
                    writer.write(59);
                }
                n4 = n5 += n7;
            }
            this.flushClean(writer, writerOptimized, cArray, n4, n5);
        }
    }

    public void addUniqueAttribute(String string, String string2, int n) throws SAXException {
        String string3 = this.patchName(string);
        String string4 = ToHTMLCommon.getLocalName(string3);
        String string5 = this.getNamespaceURI(string3, false);
        this.m_attributes.addAttribute(string5, string4, string3, "CDATA", string2, n);
    }

    private void unicodeNormalizeHTMLAttrThenEscape(String string, char[] cArray, WriterOptimized writerOptimized, int n, int n2) throws IOException {
        int n3;
        int n4 = n2;
        int n5 = n;
        Writer writer = this.m_writer;
        if (this.m_normalizerMode != 1 && !this.m_unicodeNormalizer.alreadyNormalized(cArray, n, n + n2, this.m_normalizerMode)) {
            n3 = n + 3 * n2 + 1;
            if (this.m_normalizedCharsBuff.length < n3) {
                this.m_normalizedCharsBuff = new char[n3];
            }
            n4 = this.m_unicodeNormalizer.normalizeUnicode(cArray, n, n + n2, this.m_normalizedCharsBuff, n, n3, this.m_normalizerMode);
            cArray = this.m_normalizedCharsBuff;
            string = null;
        }
        if (!this.m_charInfo.getOnlyStandardEntities()) {
            char c;
            n3 = n;
            int n6 = n3 + n4;
            char c2 = '\u0000';
            int n7 = 1;
            boolean c22 = false;
            int n8 = 0;
            for (int i = n3; i < n6; i += n7) {
                char c3 = cArray[i];
                if (Encodings.isHighUTF16Surrogate(c3) && i + 1 < n4) {
                    c2 = cArray[i + 1];
                    c = Encodings.toCodePoint(c3, c2);
                    n7 = 2;
                } else {
                    c = c3;
                    n7 = 1;
                }
                if (c == '&' && i + 1 < n6 && cArray[i + 1] == '{') {
                    n8 += 2;
                    continue;
                }
                String string2 = this.m_charInfo.getOutputStringForChar(c, this.m_charKey);
                if (c == '<') {
                    ++n8;
                    continue;
                }
                if (string2 != null) {
                    if (n8 > 0) {
                        writer.write(cArray, n5, n8);
                        n8 = 0;
                    }
                    n5 = i + n7;
                    writer.write(string2);
                    continue;
                }
                if (c == '\"') {
                    if (n8 > 0) {
                        writer.write(cArray, n5, n8);
                        n8 = 0;
                    }
                    writer.write("&quot;");
                    n5 = i + n7;
                    continue;
                }
                if (this.escapingHTMLAttrNeeded(c)) {
                    if (n8 > 0) {
                        writer.write(cArray, n5, n8);
                        n8 = 0;
                    }
                    n5 = i + n7;
                    writer.write("&#");
                    writer.write(Integer.toString(c));
                    writer.write(59);
                    continue;
                }
                if (n7 == 1 && this.m_encodingInfo.isInEncoding(c3) || n7 == 2 && this.m_encodingInfo.isInEncoding(c3, c2)) {
                    n8 += n7;
                    continue;
                }
                if (n8 > 0) {
                    writer.write(cArray, n5, n8);
                    n8 = 0;
                }
                n5 = i + n7;
                writer.write("&#");
                writer.write(Integer.toString(c));
                writer.write(59);
            }
            if (n8 > 1) {
                if (n5 == 0 && string != null) {
                    writer.write(string);
                } else {
                    writer.write(cArray, n5, n8);
                }
            } else if (n8 == 1) {
                writer.write(c);
            }
        } else {
            this.writeHTMLAttrOpt(writer, this.m_writerOptimized, new String(cArray));
        }
    }

    private boolean escapingHTMLAttrNeeded(int n) {
        if (n < 127) {
            switch (n) {
                case 9: 
                case 10: 
                case 13: {
                    return false;
                }
                case 34: {
                    return true;
                }
            }
            return n < 32;
        }
        return !this.m_encodingInfo.isInEncoding(n);
    }

    void outputDocTypeDecl(String string) throws SAXException {
        if (this.m_needToOutputDocTypeDecl) {
            String string2 = this.getDoctypeSystem();
            String string3 = this.getDoctypePublic();
            if (null != string2 || null != string3) {
                Writer writer = this.m_writer;
                try {
                    writer.write("<!DOCTYPE ");
                    writer.write(string);
                    if (null != string3) {
                        writer.write(" PUBLIC \"");
                        writer.write(string3);
                        writer.write(34);
                    }
                    if (null != string2) {
                        if (null == string3) {
                            writer.write(" SYSTEM \"");
                        } else {
                            writer.write(" \"");
                        }
                        writer.write(string2);
                        writer.write(34);
                    }
                    writer.write(62);
                    this.outputLineSep();
                }
                catch (IOException iOException) {
                    throw new SAXException(iOException);
                }
            }
        }
        this.m_needToOutputDocTypeDecl = false;
    }

    static String getStringRep(QName qName) {
        Object object;
        String string = qName.getPrefix();
        if (string.startsWith("http:")) {
            System.out.println();
            object = new RuntimeException(Utils.messages.createMessage("WRONG_QNAME_PREFIX_LIKE_URL", new Object[0]));
            ((Throwable)object).printStackTrace();
        }
        object = qName.getLocalPart();
        if (string != null && !string.equals("")) {
            String string2 = qName.getNamespaceURI();
            if (string2 == null || string2.equals("")) {
                System.out.println();
                RuntimeException runtimeException = new RuntimeException(Utils.messages.createMessage("WRONG_QNAME_PREFIX_WITHOUT_URL", new Object[0]));
                runtimeException.printStackTrace();
            }
            return string + ':' + (String)object;
        }
        return object;
    }

    final void processAttributes(Writer writer, int n) throws IOException, SAXException {
        WriterOptimized writerOptimized = writer == this.m_writerOptimized ? this.m_writerOptimized : null;
        for (int i = 0; i < n; ++i) {
            this.processAttribute(writer, writerOptimized, this.m_attributes.getAttribute(i), this.m_elemContext.m_elementDesc, this.m_optLevel);
        }
    }

    abstract void processAttribute(Writer var1, WriterOptimized var2, AttributesImplSerializer.AttributeImpl var3, ElemDesc var4, int var5) throws IOException;
}

