/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xylem.types;

import com.ibm.xtq.bcel.generic.BasicType;
import com.ibm.xtq.bcel.generic.Type;
import com.ibm.xylem.codegen.bcel.BCELCodeGenerationHelper;
import com.ibm.xylem.codegen.bcel.InstructionListBuilder;
import com.ibm.xylem.codegen.bcel.SwitchBuilder;
import com.ibm.xylem.types.PrimitiveNumericalType;
import java.io.ObjectStreamException;

public final class FloatType
extends PrimitiveNumericalType {
    private static final long serialVersionUID = -910053815345277840L;
    public static final FloatType s_floatType = new FloatType();
    private static short[] s_branchOpcode = new short[]{0, 0, 0, 0, 0, 158, 155, 156, 157, 154};

    private FloatType() {
    }

    public Type getImplementationType(BCELCodeGenerationHelper bCELCodeGenerationHelper) {
        return BasicType.FLOAT;
    }

    public Object clone() throws CloneNotSupportedException {
        return this;
    }

    public String toString() {
        return "float";
    }

    public Class getJavaType() {
        return Float.TYPE;
    }

    public Object evaluateOperation(Object object, Object object2, int n) {
        switch (n) {
            case 0: {
                return new Float(((Float)object).floatValue() + ((Float)object2).floatValue());
            }
            case 1: {
                return new Float(((Float)object).floatValue() - ((Float)object2).floatValue());
            }
            case 2: {
                return new Float(((Float)object).floatValue() * ((Float)object2).floatValue());
            }
            case 3: {
                return new Float(((Float)object).floatValue() / ((Float)object2).floatValue());
            }
            case 4: {
                return new Float(((Float)object).floatValue() % ((Float)object2).floatValue());
            }
            case 5: {
                return ((Float)object).floatValue() > ((Float)object2).floatValue() ? Boolean.TRUE : Boolean.FALSE;
            }
            case 6: {
                return ((Float)object).floatValue() >= ((Float)object2).floatValue() ? Boolean.TRUE : Boolean.FALSE;
            }
            case 7: {
                return ((Float)object).floatValue() < ((Float)object2).floatValue() ? Boolean.TRUE : Boolean.FALSE;
            }
            case 8: {
                return ((Float)object).floatValue() <= ((Float)object2).floatValue() ? Boolean.TRUE : Boolean.FALSE;
            }
            case 9: {
                return ((Float)object).floatValue() == ((Float)object2).floatValue() ? Boolean.TRUE : Boolean.FALSE;
            }
            case 16: {
                return new Float(-((Float)object).floatValue());
            }
        }
        throw new UnsupportedOperationException("The " + PrimitiveNumericalType.getOperator(n) + " operator is not supported on float.");
    }

    public void generateCodeForOperation(InstructionListBuilder instructionListBuilder, int n) {
        if (n < 5 || n > 9) {
            super.generateCodeForOperation(instructionListBuilder, n);
        } else {
            short s = s_branchOpcode[n];
            switch (s) {
                case 156: 
                case 157: {
                    instructionListBuilder.appendFCmpg();
                    break;
                }
                default: {
                    instructionListBuilder.appendFCmpl();
                }
            }
            SwitchBuilder switchBuilder = new SwitchBuilder(instructionListBuilder, 1);
            switchBuilder.startTest(s);
            instructionListBuilder.appendConstant(true);
            switchBuilder.endTest();
            switchBuilder.startElse();
            instructionListBuilder.appendConstant(false);
            switchBuilder.endElse();
        }
    }

    private Object readResolve() throws ObjectStreamException {
        return s_floatType;
    }

    public String getDefaultValue() {
        return "0.0";
    }
}

