/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xylem.optimizers.partialeval;

import com.ibm.xylem.Instruction;
import com.ibm.xylem.Type;
import com.ibm.xylem.instructions.LetInstruction;
import com.ibm.xylem.instructions.LiteralInstruction;
import com.ibm.xylem.instructions.NegateInstruction;
import com.ibm.xylem.optimizers.partialeval.LetChainManager;
import com.ibm.xylem.optimizers.partialeval.PartialEvaluationResult;
import com.ibm.xylem.optimizers.partialeval.PartialEvaluator;
import com.ibm.xylem.optimizers.partialeval.PartialInformationCollector;
import com.ibm.xylem.types.INumericalType;
import com.ibm.xylem.utils.XylemError;

public class NegateEvaluator
extends PartialEvaluator {
    public PartialEvaluationResult extractPartialInformation(Instruction instruction, PartialInformationCollector partialInformationCollector, LetInstruction letInstruction, LetChainManager letChainManager) {
        NegateInstruction negateInstruction = (NegateInstruction)instruction;
        partialInformationCollector.partiallyEvaluate(negateInstruction.getOperand(), letChainManager);
        Object object = PartialEvaluator.extractLiteralValue(partialInformationCollector, negateInstruction.getOperand(), letChainManager);
        Type type = partialInformationCollector.resolveType(negateInstruction);
        if (!(type instanceof INumericalType)) {
            throw new XylemError("ERR_SYSTEM", "The operand of a negation operation must be of a numeric type.");
        }
        INumericalType iNumericalType = (INumericalType)((Object)type);
        if (object == null) {
            return PartialEvaluationResult.s_emptyResult;
        }
        return new PartialEvaluationResult(new LiteralInstruction(type, iNumericalType.evaluateOperation(object, null, 16)));
    }
}

