/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xylem.interpreter;

import com.ibm.xylem.Function;
import com.ibm.xylem.IBinding;
import com.ibm.xylem.IContext;
import com.ibm.xylem.IDebuggerInterceptor;
import com.ibm.xylem.Instruction;
import com.ibm.xylem.interpreter.Environment;
import com.ibm.xylem.utils.XylemError;
import java.net.URL;

public class Closure
implements IContext {
    public IBinding[] m_closureBindings;
    public Object[] m_closureValues;
    public Function m_function;
    public Instruction m_expression;
    public IBinding[] m_params;
    public URL m_definitionURL;
    public int m_definitionLineNumber;

    public Closure(IBinding[] iBindingArray, Object[] objectArray, Function function, Instruction instruction, IBinding[] iBindingArray2, URL uRL, int n) {
        this.m_closureBindings = iBindingArray;
        this.m_closureValues = objectArray;
        this.m_function = function;
        this.m_expression = instruction;
        this.m_params = iBindingArray2;
        this.m_definitionURL = uRL;
        this.m_definitionLineNumber = n;
    }

    public String getName() {
        return "<closure " + this.hashCode() + ">";
    }

    public String toString() {
        return this.getName();
    }

    public URL getDefinitionURL() {
        return this.m_definitionURL;
    }

    public int getDefinitionLineNumber() {
        return this.m_definitionLineNumber;
    }

    public Object evaluate(Environment environment, Object[] objectArray, IDebuggerInterceptor iDebuggerInterceptor) {
        int n;
        if (objectArray.length != this.m_params.length) {
            throw new XylemError("ERR_SYSTEM", "Lambda takes " + this.m_params.length + " parameters but is provided here with " + objectArray.length);
        }
        Object[] objectArray2 = new Object[objectArray.length];
        for (int i = 0; i < objectArray2.length; ++i) {
            objectArray2[i] = environment.bind(this.m_params[i], objectArray[i]);
        }
        Object[] objectArray3 = new Object[this.m_closureBindings.length];
        for (int i = 0; i < objectArray3.length; ++i) {
            objectArray3[i] = environment.bind(this.m_closureBindings[i], this.m_closureValues[i]);
        }
        Object object = this.m_expression.evaluate(environment, this.m_function, iDebuggerInterceptor, false);
        for (n = 0; n < objectArray2.length; ++n) {
            environment.bind(this.m_params[n], objectArray2[n]);
        }
        for (n = 0; n < objectArray3.length; ++n) {
            environment.bind(this.m_closureBindings[n], objectArray3[n]);
        }
        return object;
    }
}

