/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xylem.instructions;

import com.ibm.xtq.bcel.generic.InstructionHandle;
import com.ibm.xylem.Binding;
import com.ibm.xylem.BindingEnvironment;
import com.ibm.xylem.Function;
import com.ibm.xylem.IBinding;
import com.ibm.xylem.IDebuggerInterceptor;
import com.ibm.xylem.INewNameGenerator;
import com.ibm.xylem.ISpecialForm;
import com.ibm.xylem.Instruction;
import com.ibm.xylem.PrettyPrinter;
import com.ibm.xylem.ReadObjectFileHelper;
import com.ibm.xylem.ReductionHelper;
import com.ibm.xylem.Type;
import com.ibm.xylem.TypeCheckException;
import com.ibm.xylem.TypeEnvironment;
import com.ibm.xylem.WriteObjectFileHelper;
import com.ibm.xylem.codegen.CodeGenerationTracker;
import com.ibm.xylem.codegen.DataFlowCodeGenerationHelper;
import com.ibm.xylem.codegen.bcel.BCELCodeGenerationHelper;
import com.ibm.xylem.codegen.bcel.InstructionListBuilder;
import com.ibm.xylem.instructions.FunctionCallInstruction;
import com.ibm.xylem.instructions.IdentifierInstruction;
import com.ibm.xylem.interpreter.Debugger;
import com.ibm.xylem.interpreter.Environment;
import com.ibm.xylem.interpreter.Tuple;
import com.ibm.xylem.optimizers.OptimizerUtilities;
import com.ibm.xylem.types.TupleType;
import com.ibm.xylem.utils.XylemError;
import java.io.IOException;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;

public class TupleMatchInstruction
extends Instruction
implements ISpecialForm {
    protected Instruction m_toMatch;
    protected Instruction m_body;
    protected Binding[] m_bindings;

    public TupleMatchInstruction() {
    }

    public TupleMatchInstruction(Instruction instruction, Object[] objectArray, Instruction instruction2) {
        this.m_toMatch = instruction;
        this.m_bindings = Binding.getBindings(objectArray);
        this.m_body = instruction2;
    }

    public TupleMatchInstruction(Instruction instruction, int n, int n2) {
        this.m_bindings = new Binding[n];
        String string = OptimizerUtilities.generateIntermediateIdentifier() + "_";
        for (int i = 0; i < n; ++i) {
            this.m_bindings[i] = new Binding(string + i);
        }
        this.m_body = new IdentifierInstruction(this.m_bindings[n2].getName());
        this.m_toMatch = instruction;
    }

    public Instruction getToMatch() {
        return this.m_toMatch;
    }

    public Object[] getVariableNames() {
        return Binding.getNames(this.m_bindings);
    }

    public Instruction getBody() {
        return this.m_body;
    }

    public Binding[] getBindings() {
        return this.m_bindings;
    }

    public int getChildInstructionCount() {
        return 2;
    }

    public Instruction getChildInstruction(int n) {
        switch (n) {
            case 0: {
                return this.m_toMatch;
            }
            case 1: {
                return this.m_body;
            }
        }
        return null;
    }

    public void setChildInstruction(int n, Instruction instruction) {
        switch (n) {
            case 0: {
                this.m_toMatch = instruction;
                break;
            }
            case 1: {
                this.m_body = instruction;
            }
        }
    }

    public String generateCodeBasedOnDataFlow(DataFlowCodeGenerationHelper dataFlowCodeGenerationHelper, CodeGenerationTracker codeGenerationTracker, String string, boolean bl) {
        throw new UnsupportedOperationException("tuple-match is syntactic sugar and must be removed prior to codegen");
    }

    public void generateCode(BCELCodeGenerationHelper bCELCodeGenerationHelper, CodeGenerationTracker codeGenerationTracker, String string, InstructionHandle instructionHandle, InstructionListBuilder instructionListBuilder) {
        throw new UnsupportedOperationException("tuple-match is syntactic sugar and must be removed prior to codegen");
    }

    public Instruction cloneWithoutTypeInformation() {
        return new TupleMatchInstruction(this.m_toMatch.cloneWithoutTypeInformation(), Binding.getNames(this.m_bindings), this.m_body.cloneWithoutTypeInformation());
    }

    public Instruction cloneShallow() {
        return new TupleMatchInstruction(this.m_toMatch, Binding.getNames(this.m_bindings), this.m_body);
    }

    public void generateReducedForm(ReductionHelper reductionHelper, Instruction[] instructionArray, BindingEnvironment bindingEnvironment) {
        this.m_toMatch = reductionHelper.reduceToBasicInstruction(instructionArray, this.m_toMatch, bindingEnvironment);
        ReductionHelper reductionHelper2 = (ReductionHelper)reductionHelper.clone();
        for (int i = 0; i < this.m_bindings.length; ++i) {
            reductionHelper2.upgradeBinding(this.m_bindings[i]);
            bindingEnvironment.setVariableBinding(this.m_bindings[i]);
        }
        this.m_body = reductionHelper2.reduce(this.m_body, bindingEnvironment);
        this.m_bindingEnvironment = null;
        instructionArray[0] = this;
    }

    public Type typeCheck(TypeEnvironment typeEnvironment, BindingEnvironment bindingEnvironment, LinkedList linkedList) throws TypeCheckException {
        super.doDefaultTypeCheck(typeEnvironment, bindingEnvironment, linkedList);
        Type[] typeArray = new Type[this.m_bindings.length];
        BindingEnvironment bindingEnvironment2 = new BindingEnvironment(bindingEnvironment);
        for (int i = 0; i < typeArray.length; ++i) {
            this.m_bindings[i].setTypeEnvironment(typeEnvironment);
            typeArray[i] = this.m_bindings[i].getBindingType();
            bindingEnvironment2.setVariableBinding(this.m_bindings[i]);
        }
        typeEnvironment.unify(new TupleType(typeArray), this.m_toMatch.typeCheck(typeEnvironment, bindingEnvironment, linkedList), this);
        return this.setCachedType(this.m_body.typeCheck(typeEnvironment, bindingEnvironment2, linkedList));
    }

    public void typeCheckReduced(TypeEnvironment typeEnvironment, BindingEnvironment bindingEnvironment, LinkedList linkedList) {
        Type type = null;
        try {
            this.m_toMatch.typeCheckReduced(typeEnvironment, bindingEnvironment, linkedList);
            type = this.m_toMatch.getType(typeEnvironment, bindingEnvironment);
            Type[] typeArray = new Type[this.m_bindings.length];
            for (int i = 0; i < typeArray.length; ++i) {
                typeArray[i] = this.m_bindings[i].getBindingType();
                this.m_bindings[i].setType(typeArray[i]);
                bindingEnvironment.setVariableBinding(this.m_bindings[i]);
            }
            typeEnvironment.unify(new TupleType(typeArray), type, this);
            this.m_body.typeCheckReduced(typeEnvironment, bindingEnvironment, linkedList);
        }
        catch (TypeCheckException typeCheckException) {
            s_logger.error("type check exception in tuple-match", typeCheckException);
            throw new XylemError("ERR_SYSTEM", "error in TupleMatch.typeCheckReduced");
        }
    }

    public Type getType(TypeEnvironment typeEnvironment, BindingEnvironment bindingEnvironment) {
        return this.m_body.getType(typeEnvironment, bindingEnvironment);
    }

    public Object evaluate(Environment environment, Function function, IDebuggerInterceptor iDebuggerInterceptor, boolean bl) {
        if (null != iDebuggerInterceptor) {
            iDebuggerInterceptor.enter(this, environment, function);
        }
        Tuple tuple = (Tuple)this.m_toMatch.evaluate(environment, function, iDebuggerInterceptor, false);
        Object[] objectArray = new Object[this.m_bindings.length];
        Object[] objectArray2 = tuple.getValues();
        for (int i = 0; i < objectArray.length; ++i) {
            objectArray[i] = environment.bind(this.m_bindings[i], objectArray2[i]);
        }
        Object object = null;
        try {
            object = this.m_body.evaluate(environment, function, iDebuggerInterceptor, bl);
        }
        catch (FunctionCallInstruction.TailCallEvent tailCallEvent) {
            for (int i = 0; i < objectArray.length; ++i) {
                environment.bind(this.m_bindings[i], objectArray[i]);
            }
            throw tailCallEvent;
        }
        for (int i = 0; i < objectArray.length; ++i) {
            environment.bind(this.m_bindings[i], objectArray[i]);
        }
        Object object2 = object;
        return Debugger.leave(iDebuggerInterceptor, this, environment, function, object2);
    }

    public void toString(PrettyPrinter prettyPrinter, int n) {
        prettyPrinter.newline();
        prettyPrinter.printFormOpen("tuple-match", n);
        if (this.m_toMatch == null) {
            prettyPrinter.print(" !null!");
        } else {
            this.m_toMatch.toString(prettyPrinter, n + 1);
        }
        prettyPrinter.print("(");
        for (int i = 0; i < this.m_bindings.length; ++i) {
            prettyPrinter.printIdentifier(this.m_bindings[i].getName(), n + 2);
        }
        prettyPrinter.printFormClose(n);
        this.m_body.toString(prettyPrinter, n + 1);
        prettyPrinter.print(")");
    }

    public void accumulateNonLiteralFreeBindings(Set set, BindingEnvironment bindingEnvironment) {
        super.accumulateNonLiteralFreeBindings(set, bindingEnvironment);
        for (int i = 0; i < this.m_bindings.length; ++i) {
            set.remove(this.m_bindings[i]);
        }
    }

    public void accumulateFreeBindings(Set set, BindingEnvironment bindingEnvironment) {
        super.accumulateFreeBindings(set, bindingEnvironment);
        for (int i = 0; i < this.m_bindings.length; ++i) {
            set.remove(this.m_bindings[i]);
        }
    }

    public void write(WriteObjectFileHelper writeObjectFileHelper) throws IOException {
        writeObjectFileHelper.writeInstruction(this.m_toMatch);
        writeObjectFileHelper.writeTypeSpecificBindingSet(this.m_bindings);
        writeObjectFileHelper.writeInstruction(this.m_body);
    }

    public void read(ReadObjectFileHelper readObjectFileHelper, BindingEnvironment bindingEnvironment) throws Exception {
        this.m_toMatch = readObjectFileHelper.readInstruction(bindingEnvironment);
        this.m_bindings = readObjectFileHelper.readTypeSpecificBindingSet();
        this.m_body = readObjectFileHelper.readInstruction(bindingEnvironment);
    }

    public boolean isChildInstructionBody(int n) {
        return n == 1;
    }

    public IBinding[] getChildInstructionBindings(int n) {
        if (n != 1) {
            return null;
        }
        return this.m_bindings;
    }

    public boolean isChildInstructionInTailPosition(int n) {
        return false;
    }

    public Instruction assignNewNames(Map map, INewNameGenerator iNewNameGenerator) {
        Object[] objectArray = new Object[this.m_bindings.length];
        for (int i = 0; i < this.m_bindings.length; ++i) {
            Object object = objectArray[i] = iNewNameGenerator.getNewName();
            map.put(this.m_bindings[i].getName(), new IdentifierInstruction(object));
        }
        return new TupleMatchInstruction(this.m_toMatch.assignNewNames(map, iNewNameGenerator), objectArray, this.m_body.assignNewNames(map, iNewNameGenerator));
    }

    public int getTypeParameterCount() {
        return this.m_bindings.length;
    }

    public Type getTypeParameter(int n) {
        return this.m_bindings[n].getBindingType();
    }

    public void setTypeParameter(int n, Type type) {
        this.m_bindings[n].setType(type);
    }
}

