/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xylem.instructions;

import com.ibm.xtq.bcel.generic.InstructionHandle;
import com.ibm.xylem.Binding;
import com.ibm.xylem.BindingEnvironment;
import com.ibm.xylem.Function;
import com.ibm.xylem.IBinding;
import com.ibm.xylem.IDebuggerInterceptor;
import com.ibm.xylem.ISpecialForm;
import com.ibm.xylem.Instruction;
import com.ibm.xylem.PrettyPrinter;
import com.ibm.xylem.ReadObjectFileHelper;
import com.ibm.xylem.ReductionHelper;
import com.ibm.xylem.Type;
import com.ibm.xylem.TypeCheckException;
import com.ibm.xylem.TypeEnvironment;
import com.ibm.xylem.WriteObjectFileHelper;
import com.ibm.xylem.codegen.CodeGenerationOptimizationStyle;
import com.ibm.xylem.codegen.CodeGenerationTracker;
import com.ibm.xylem.codegen.ConventionalBasedOptimizationStyle;
import com.ibm.xylem.codegen.DataFlowCodeGenerationHelper;
import com.ibm.xylem.codegen.IStreamInADTOptimizationInstruction;
import com.ibm.xylem.codegen.IStreamOptimizationInstruction;
import com.ibm.xylem.codegen.StreamInADTOptimizationStyle;
import com.ibm.xylem.codegen.StreamOptimizationStyle;
import com.ibm.xylem.codegen.bcel.BCELCodeGenerationHelper;
import com.ibm.xylem.codegen.bcel.InstructionListBuilder;
import com.ibm.xylem.codegen.bcel.SwitchBuilder;
import com.ibm.xylem.instructions.LetInstruction;
import com.ibm.xylem.instructions.LiteralInstruction;
import com.ibm.xylem.interpreter.Debugger;
import com.ibm.xylem.interpreter.Environment;
import com.ibm.xylem.interpreter.IAppendableStream;
import com.ibm.xylem.types.BooleanType;
import com.ibm.xylem.types.TypeVariable;
import com.ibm.xylem.utils.XylemError;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedList;

public class ChooseInstruction
extends Instruction
implements IStreamInADTOptimizationInstruction,
IStreamOptimizationInstruction,
ISpecialForm {
    public Case[] m_cases;
    protected Instruction m_defaultHandler;
    protected boolean m_assumeComplete;

    public ChooseInstruction() {
    }

    public ChooseInstruction(Instruction instruction, Instruction instruction2, Instruction instruction3) {
        this(new Case[]{new Case(instruction, instruction2)}, instruction3);
    }

    public ChooseInstruction(Case[] caseArray, Instruction instruction, boolean bl) {
        this.m_cases = caseArray;
        this.m_defaultHandler = instruction;
        this.m_assumeComplete = instruction != null || bl;
    }

    public ChooseInstruction(Case[] caseArray, Instruction instruction) {
        this(caseArray, instruction, false);
    }

    public Instruction getDefaultHandler() {
        return this.m_defaultHandler;
    }

    public void setDefaultHandler(Instruction instruction) {
        this.m_defaultHandler = instruction;
    }

    public boolean canAssumeComplete() {
        return this.m_assumeComplete;
    }

    public int getChildInstructionCount() {
        return (this.m_defaultHandler == null ? 0 : 1) + this.m_cases.length * 2;
    }

    public Instruction getChildInstruction(int n) {
        if (this.m_defaultHandler != null) {
            if (n == 0) {
                return this.m_defaultHandler;
            }
            --n;
        }
        return n % 2 == 0 ? this.m_cases[n / 2].m_test : this.m_cases[n / 2].m_handler;
    }

    public void setChildInstruction(int n, Instruction instruction) {
        if (this.m_defaultHandler != null) {
            if (n == 0) {
                this.m_defaultHandler = instruction;
                return;
            }
            --n;
        }
        if (n % 2 == 0) {
            this.m_cases[n / 2].m_test = instruction;
        } else {
            this.m_cases[n / 2].m_handler = instruction;
        }
    }

    public Instruction cloneWithoutTypeInformation() {
        Case[] caseArray = new Case[this.m_cases.length];
        for (int i = 0; i < this.m_cases.length; ++i) {
            caseArray[i] = new Case(this.m_cases[i].m_test.cloneWithoutTypeInformation(), this.m_cases[i].m_handler.cloneWithoutTypeInformation());
        }
        return new ChooseInstruction(caseArray, this.m_defaultHandler == null ? null : this.m_defaultHandler.cloneWithoutTypeInformation());
    }

    public Instruction cloneShallow() {
        Case[] caseArray = new Case[this.m_cases.length];
        for (int i = 0; i < this.m_cases.length; ++i) {
            caseArray[i] = new Case(this.m_cases[i].m_test, this.m_cases[i].m_handler);
        }
        return new ChooseInstruction(caseArray, this.m_defaultHandler);
    }

    public Type typeCheck(TypeEnvironment typeEnvironment, BindingEnvironment bindingEnvironment, LinkedList linkedList) throws TypeCheckException {
        super.doDefaultTypeCheck(typeEnvironment, bindingEnvironment, linkedList);
        TypeVariable typeVariable = new TypeVariable();
        Type type = null;
        for (int i = 0; i < this.m_cases.length; ++i) {
            try {
                typeEnvironment.unify(this.m_cases[i].m_test.typeCheck(typeEnvironment, bindingEnvironment, linkedList), BooleanType.s_booleanType, this);
            }
            catch (TypeCheckException typeCheckException) {
                System.out.println(">> test " + this.m_cases[i].m_test);
                throw typeCheckException;
            }
            type = this.m_cases[i].m_handler.typeCheck(typeEnvironment, bindingEnvironment, linkedList);
            typeEnvironment.unify(type, typeVariable, this);
        }
        if (this.m_defaultHandler != null) {
            type = this.m_defaultHandler.typeCheck(typeEnvironment, bindingEnvironment, linkedList);
            typeEnvironment.unify(type, typeVariable, this);
        }
        return this.setCachedType(type);
    }

    public Type getType(TypeEnvironment typeEnvironment, BindingEnvironment bindingEnvironment) {
        if (this.m_defaultHandler != null) {
            return this.m_defaultHandler.getType(typeEnvironment, bindingEnvironment);
        }
        return this.m_cases[0].m_handler.getType(typeEnvironment, bindingEnvironment);
    }

    public void generateCode(BCELCodeGenerationHelper bCELCodeGenerationHelper, CodeGenerationTracker codeGenerationTracker, String string, InstructionHandle instructionHandle, InstructionListBuilder instructionListBuilder) {
        if (this.m_cases.length > 1) {
            throw new XylemError("ERR_SYSTEM", "reduced cond should only have one case " + this);
        }
        Case case_ = this.m_cases[0];
        codeGenerationTracker.generateConventionally(case_.m_test, bCELCodeGenerationHelper, null, instructionListBuilder);
        SwitchBuilder switchBuilder = new SwitchBuilder(instructionListBuilder, 1);
        switchBuilder.startTest(1);
        case_.m_handler.generateCode(bCELCodeGenerationHelper, codeGenerationTracker.cloneBranch(), null, instructionHandle, instructionListBuilder);
        switchBuilder.endTest();
        switchBuilder.startElse();
        if (this.m_defaultHandler != null) {
            this.m_defaultHandler.generateCode(bCELCodeGenerationHelper, codeGenerationTracker.cloneBranch(), null, instructionHandle, instructionListBuilder);
        } else {
            instructionListBuilder.appendThrowRuntimeSystemError("unexpected choose result");
        }
        switchBuilder.endElse();
    }

    public void generateCodeWithStreamOptimization(BCELCodeGenerationHelper bCELCodeGenerationHelper, InstructionListBuilder instructionListBuilder, int[] nArray, CodeGenerationTracker codeGenerationTracker, InstructionHandle instructionHandle) {
        if (this.m_cases.length > 1) {
            throw new XylemError("ERR_SYSTEM", "reduced cond should only have one case " + this);
        }
        Case case_ = this.m_cases[0];
        codeGenerationTracker.generateConventionally(case_.m_test, bCELCodeGenerationHelper, null, instructionListBuilder);
        SwitchBuilder switchBuilder = new SwitchBuilder(instructionListBuilder, 1);
        switchBuilder.startTest(1);
        ((IStreamOptimizationInstruction)((Object)case_.m_handler)).generateCodeWithStreamOptimization(bCELCodeGenerationHelper, instructionListBuilder, nArray, codeGenerationTracker.cloneBranch(), instructionHandle);
        switchBuilder.endTest();
        switchBuilder.startElse();
        if (this.m_defaultHandler != null) {
            ((IStreamOptimizationInstruction)((Object)this.m_defaultHandler)).generateCodeWithStreamOptimization(bCELCodeGenerationHelper, instructionListBuilder, nArray, codeGenerationTracker.cloneBranch(), instructionHandle);
        } else {
            instructionListBuilder.appendThrowRuntimeSystemError("unexpected choose result");
        }
        switchBuilder.endElse();
    }

    public String generateCodeBasedOnDataFlow(DataFlowCodeGenerationHelper dataFlowCodeGenerationHelper, CodeGenerationTracker codeGenerationTracker, String string, boolean bl) {
        Type type = codeGenerationTracker.resolveType(this);
        String string2 = dataFlowCodeGenerationHelper.generateNewLocalVariableName(string);
        type.appendHolderVariableDeclaration(dataFlowCodeGenerationHelper, string2, false, null, codeGenerationTracker);
        if (this.m_cases.length > 1) {
            throw new XylemError("ERR_SYSTEM", "reduced cond should only have one case " + this);
        }
        for (int i = 0; i < this.m_cases.length; ++i) {
            Case case_ = this.m_cases[i];
            String string3 = codeGenerationTracker.generateConventionally(case_.m_test, dataFlowCodeGenerationHelper);
            dataFlowCodeGenerationHelper.append("if (" + string3 + ") {\n");
            String string4 = case_.m_handler.generateCodeBasedOnDataFlow(dataFlowCodeGenerationHelper, codeGenerationTracker.cloneBranch(), null, bl);
            type.appendHolderVariableAssignment(dataFlowCodeGenerationHelper, string2, string4, false, null, codeGenerationTracker);
            dataFlowCodeGenerationHelper.append("}\n");
        }
        dataFlowCodeGenerationHelper.append("else {\n");
        if (this.m_defaultHandler != null) {
            String string5 = this.m_defaultHandler.generateCodeBasedOnDataFlow(dataFlowCodeGenerationHelper, codeGenerationTracker.cloneBranch(), null, bl);
            type.appendHolderVariableAssignment(dataFlowCodeGenerationHelper, string2, string5, false, null, codeGenerationTracker);
        } else if (dataFlowCodeGenerationHelper.isTargetJava()) {
            if (this.isDeadCode()) {
                dataFlowCodeGenerationHelper.append("throw new RuntimeException(\"should never reach\");\n");
            } else {
                dataFlowCodeGenerationHelper.append("throw new RuntimeException(\"unexpected choose result\");\n");
            }
        } else {
            dataFlowCodeGenerationHelper.append("longjmp(ErrorJmp, -1);\n");
        }
        dataFlowCodeGenerationHelper.append("}\n");
        return string2;
    }

    private boolean isDeadCode() {
        return this.m_cases.length == 0 && this.m_cases[0].m_test instanceof LiteralInstruction && ((LiteralInstruction)this.m_cases[0].m_test).getValue().equals(Boolean.FALSE);
    }

    public String generateCodeBasedOnDataFlow(DataFlowCodeGenerationHelper dataFlowCodeGenerationHelper, String string, Binding binding, CodeGenerationTracker codeGenerationTracker, boolean bl, boolean bl2) {
        TypeEnvironment typeEnvironment = codeGenerationTracker.m_typeEnvironment;
        Type type = this.getType(typeEnvironment, codeGenerationTracker.m_bindingEnvironment);
        String string2 = dataFlowCodeGenerationHelper.generateNewLocalVariableName();
        type.appendHolderVariableDeclaration(dataFlowCodeGenerationHelper, string2, bl, binding, codeGenerationTracker);
        if (this.m_cases.length > 1) {
            throw new XylemError("ERR_SYSTEM", "reduced cond should only have one case");
        }
        for (int i = 0; i < this.m_cases.length; ++i) {
            Case case_ = this.m_cases[i];
            String string3 = codeGenerationTracker.generateConventionally(case_.m_test, dataFlowCodeGenerationHelper);
            dataFlowCodeGenerationHelper.append("if (" + string3 + ") {\n");
            String string4 = ((IStreamInADTOptimizationInstruction)((Object)case_.m_handler)).generateCodeBasedOnDataFlow(dataFlowCodeGenerationHelper, string, binding, codeGenerationTracker.cloneBranch(), bl, bl2);
            type.appendHolderVariableAssignment(dataFlowCodeGenerationHelper, string2, string4, bl, binding, codeGenerationTracker);
            dataFlowCodeGenerationHelper.append("}\n");
        }
        dataFlowCodeGenerationHelper.append("else {\n");
        if (this.m_defaultHandler != null) {
            String string5 = ((IStreamInADTOptimizationInstruction)((Object)this.m_defaultHandler)).generateCodeBasedOnDataFlow(dataFlowCodeGenerationHelper, string, binding, codeGenerationTracker.cloneBranch(), bl, bl2);
            type.appendHolderVariableAssignment(dataFlowCodeGenerationHelper, string2, string5, bl, binding, codeGenerationTracker);
        } else if (dataFlowCodeGenerationHelper.isTargetJava()) {
            dataFlowCodeGenerationHelper.append("throw new RuntimeException();\n");
        } else {
            dataFlowCodeGenerationHelper.append("longjmp(ErrorJmp, -1);\n");
        }
        dataFlowCodeGenerationHelper.append("}\n");
        return string2;
    }

    public void generateCode(BCELCodeGenerationHelper bCELCodeGenerationHelper, int[] nArray, Binding binding, CodeGenerationTracker codeGenerationTracker, boolean bl, InstructionHandle instructionHandle, InstructionListBuilder instructionListBuilder) {
        if (this.m_cases.length > 1) {
            throw new XylemError("ERR_SYSTEM", "reduced cond should only have one case " + this);
        }
        Case case_ = this.m_cases[0];
        codeGenerationTracker.generateConventionally(case_.m_test, bCELCodeGenerationHelper, null, instructionListBuilder);
        SwitchBuilder switchBuilder = new SwitchBuilder(instructionListBuilder, 1);
        switchBuilder.startTest(1);
        ((IStreamInADTOptimizationInstruction)((Object)case_.m_handler)).generateCode(bCELCodeGenerationHelper, nArray, binding, codeGenerationTracker.cloneBranch(), bl, instructionHandle, instructionListBuilder);
        switchBuilder.endTest();
        switchBuilder.startElse();
        if (this.m_defaultHandler != null) {
            ((IStreamInADTOptimizationInstruction)((Object)this.m_defaultHandler)).generateCode(bCELCodeGenerationHelper, nArray, binding, codeGenerationTracker.cloneBranch(), bl, instructionHandle, instructionListBuilder);
        } else {
            instructionListBuilder.appendThrowRuntimeSystemError("unexpected choose result");
        }
        switchBuilder.endElse();
    }

    public void generateCodeWithStreamOptimization(DataFlowCodeGenerationHelper dataFlowCodeGenerationHelper, String string, CodeGenerationTracker codeGenerationTracker, boolean bl) {
        if (this.m_cases.length > 1) {
            throw new XylemError("ERR_SYSTEM", "reduced cond should only have one case");
        }
        for (int i = 0; i < this.m_cases.length; ++i) {
            Case case_ = this.m_cases[i];
            String string2 = codeGenerationTracker.generateConventionally(case_.m_test, dataFlowCodeGenerationHelper);
            dataFlowCodeGenerationHelper.append("if (" + string2 + ") {\n");
            ((IStreamOptimizationInstruction)((Object)case_.m_handler)).generateCodeWithStreamOptimization(dataFlowCodeGenerationHelper, string, codeGenerationTracker.cloneBranch(), bl);
            dataFlowCodeGenerationHelper.append("}\n");
        }
        dataFlowCodeGenerationHelper.append("else {\n");
        if (this.m_defaultHandler != null) {
            ((IStreamOptimizationInstruction)((Object)this.m_defaultHandler)).generateCodeWithStreamOptimization(dataFlowCodeGenerationHelper, string, codeGenerationTracker.cloneBranch(), bl);
        } else if (dataFlowCodeGenerationHelper.isTargetJava()) {
            dataFlowCodeGenerationHelper.append("throw new RuntimeException();\n");
        } else {
            dataFlowCodeGenerationHelper.append("longjmp(ErrorJmp, -1);\n");
        }
        dataFlowCodeGenerationHelper.append("}\n");
    }

    protected boolean supportsCodeGenerationOptimizationInternal(CodeGenerationOptimizationStyle codeGenerationOptimizationStyle, TypeEnvironment typeEnvironment, BindingEnvironment bindingEnvironment) {
        if (codeGenerationOptimizationStyle instanceof StreamOptimizationStyle || codeGenerationOptimizationStyle instanceof StreamInADTOptimizationStyle || codeGenerationOptimizationStyle instanceof ConventionalBasedOptimizationStyle) {
            for (int i = 0; i < this.m_cases.length; ++i) {
                if (this.m_cases[i].m_handler.supportsCodeGenerationOptimization(codeGenerationOptimizationStyle, typeEnvironment, bindingEnvironment)) continue;
                return false;
            }
            return this.m_defaultHandler == null || this.m_defaultHandler.supportsCodeGenerationOptimization(codeGenerationOptimizationStyle, typeEnvironment, bindingEnvironment);
        }
        return super.supportsCodeGenerationOptimizationInternal(codeGenerationOptimizationStyle, typeEnvironment, bindingEnvironment);
    }

    public void generateReducedForm(ReductionHelper reductionHelper, Instruction[] instructionArray, BindingEnvironment bindingEnvironment) {
        if (this.m_cases.length == 0) {
            this.m_defaultHandler.generateReducedForm(reductionHelper, instructionArray, bindingEnvironment);
            return;
        }
        if (this.m_cases.length == 1) {
            Case case_ = this.m_cases[0];
            case_.m_test = reductionHelper.reduceToBasicInstruction(instructionArray, case_.m_test, bindingEnvironment);
            ReductionHelper reductionHelper2 = (ReductionHelper)reductionHelper.clone();
            case_.m_handler = reductionHelper2.reduce(case_.m_handler, bindingEnvironment);
            if (this.m_defaultHandler != null) {
                reductionHelper2 = (ReductionHelper)reductionHelper.clone();
                this.m_defaultHandler = reductionHelper2.reduce(this.m_defaultHandler, bindingEnvironment);
            }
            this.m_bindingEnvironment = null;
            instructionArray[0] = this;
            return;
        }
        ChooseInstruction chooseInstruction = new ChooseInstruction(null, null);
        chooseInstruction.m_hasBeenTypechecked = true;
        chooseInstruction.setCachedType(this.getCachedType());
        ChooseInstruction chooseInstruction2 = chooseInstruction;
        ChooseInstruction chooseInstruction3 = chooseInstruction;
        int n = this.m_cases.length;
        ArrayList<Case> arrayList = new ArrayList<Case>();
        Instruction[] instructionArray2 = instructionArray;
        ReductionHelper reductionHelper3 = reductionHelper;
        for (int i = 0; i < n; ++i) {
            Case case_ = this.m_cases[i];
            case_.m_test = reductionHelper3.reduceToBasicInstruction(instructionArray2, case_.m_test, bindingEnvironment);
            ReductionHelper reductionHelper4 = (ReductionHelper)reductionHelper3.clone();
            case_.m_handler = reductionHelper4.reduce(case_.m_handler, bindingEnvironment);
            if (!arrayList.isEmpty()) {
                chooseInstruction3.m_cases = new Case[arrayList.size()];
                arrayList.toArray(chooseInstruction3.m_cases);
                arrayList.clear();
                chooseInstruction = new ChooseInstruction(null, null);
                chooseInstruction.m_hasBeenTypechecked = true;
                chooseInstruction.setCachedType(this.getCachedType());
                Instruction instruction = chooseInstruction3.m_defaultHandler = instructionArray2[1] == null ? chooseInstruction : instructionArray2[1];
                if (instructionArray2[2] != null) {
                    ((LetInstruction)instructionArray2[2]).setBody(chooseInstruction);
                }
                chooseInstruction3 = chooseInstruction;
            }
            arrayList.add(case_);
            instructionArray2 = new Instruction[3];
            reductionHelper3 = (ReductionHelper)reductionHelper.clone();
        }
        chooseInstruction3.m_cases = new Case[arrayList.size()];
        arrayList.toArray(chooseInstruction3.m_cases);
        if (this.m_defaultHandler != null) {
            ReductionHelper reductionHelper5 = (ReductionHelper)reductionHelper.clone();
            chooseInstruction3.m_defaultHandler = reductionHelper5.reduce(this.m_defaultHandler, bindingEnvironment);
        }
        instructionArray[0] = chooseInstruction2;
    }

    public boolean canGenerateObjectless(TypeEnvironment typeEnvironment) {
        for (int i = 0; i < this.m_cases.length; ++i) {
            Instruction instruction = this.m_cases[i].m_handler;
            if (((IStreamInADTOptimizationInstruction)((Object)instruction)).canGenerateObjectless(typeEnvironment)) continue;
            return false;
        }
        return this.m_defaultHandler == null || ((IStreamInADTOptimizationInstruction)((Object)this.m_defaultHandler)).canGenerateObjectless(typeEnvironment);
    }

    public void toString(PrettyPrinter prettyPrinter, int n) {
        prettyPrinter.printlnFormOpen("choose", n);
        for (int i = 0; i < this.m_cases.length; ++i) {
            Case case_ = this.m_cases[i];
            prettyPrinter.printFormOpen("when", n + 1);
            case_.m_test.toString(prettyPrinter, n + 2);
            case_.m_handler.toString(prettyPrinter, n + 2);
            prettyPrinter.printFormClose(n + 1);
        }
        if (this.m_defaultHandler != null) {
            prettyPrinter.printFormOpen("otherwise", n + 1);
            this.m_defaultHandler.toString(prettyPrinter, n + 2);
            prettyPrinter.printFormClose(n + 1);
        }
        prettyPrinter.printFormClose(n);
    }

    public Object evaluate(Environment environment, Function function, IDebuggerInterceptor iDebuggerInterceptor, boolean bl) {
        if (null != iDebuggerInterceptor) {
            iDebuggerInterceptor.enter(this, environment, function);
        }
        for (int i = 0; i < this.m_cases.length; ++i) {
            if (!((Boolean)this.m_cases[i].m_test.evaluate(environment, function, iDebuggerInterceptor, false)).booleanValue()) continue;
            Object object = this.m_cases[i].m_handler.evaluate(environment, function, iDebuggerInterceptor, bl);
            return Debugger.leave(iDebuggerInterceptor, this, environment, function, object);
        }
        if (this.m_defaultHandler != null) {
            Object object = this.m_defaultHandler.evaluate(environment, function, iDebuggerInterceptor, bl);
            return Debugger.leave(iDebuggerInterceptor, this, environment, function, object);
        }
        throw Debugger.terminate(iDebuggerInterceptor, this, environment, function, "no choose cases matched");
    }

    public void evaluate(IAppendableStream iAppendableStream, Environment environment, Function function, IDebuggerInterceptor iDebuggerInterceptor) {
        if (null != iDebuggerInterceptor) {
            iDebuggerInterceptor.enter(this, environment, function);
        }
        for (int i = 0; i < this.m_cases.length; ++i) {
            if (!((Boolean)this.m_cases[i].m_test.evaluate(environment, function, iDebuggerInterceptor, false)).booleanValue()) continue;
            this.m_cases[i].m_handler.evaluate(iAppendableStream, environment, function, iDebuggerInterceptor);
            Debugger.leave(iDebuggerInterceptor, this, environment, function, null);
            return;
        }
        if (this.m_defaultHandler == null) {
            throw Debugger.terminate(iDebuggerInterceptor, this, environment, function, "no choose cases matched");
        }
        this.m_defaultHandler.evaluate(iAppendableStream, environment, function, iDebuggerInterceptor);
        Debugger.leave(iDebuggerInterceptor, this, environment, function, null);
    }

    public void write(WriteObjectFileHelper writeObjectFileHelper) throws IOException {
        writeObjectFileHelper.writeBoolean(this.m_assumeComplete);
        int n = this.m_cases.length;
        writeObjectFileHelper.writeInt(n);
        for (int i = 0; i < n; ++i) {
            writeObjectFileHelper.writeInstruction(this.m_cases[i].m_test);
            writeObjectFileHelper.writeInstruction(this.m_cases[i].m_handler);
        }
        writeObjectFileHelper.writeBoolean(this.m_defaultHandler != null);
        if (this.m_defaultHandler != null) {
            writeObjectFileHelper.writeInstruction(this.m_defaultHandler);
        }
    }

    public void read(ReadObjectFileHelper readObjectFileHelper, BindingEnvironment bindingEnvironment) throws Exception {
        this.m_assumeComplete = readObjectFileHelper.readBoolean();
        int n = readObjectFileHelper.readInt();
        this.m_cases = new Case[n];
        for (int i = 0; i < n; ++i) {
            this.m_cases[i] = new Case(readObjectFileHelper.readInstruction(bindingEnvironment), readObjectFileHelper.readInstruction(bindingEnvironment));
        }
        if (readObjectFileHelper.readBoolean()) {
            this.m_defaultHandler = readObjectFileHelper.readInstruction(bindingEnvironment);
        }
    }

    public boolean isChildInstructionBody(int n) {
        if (this.m_defaultHandler != null) {
            --n;
        }
        return n % 2 != 0;
    }

    public IBinding[] getChildInstructionBindings(int n) {
        return this.isChildInstructionBody(n) ? ISpecialForm.NO_BINDINGS : null;
    }

    public boolean isChildInstructionInTailPosition(int n) {
        if (this.m_defaultHandler != null) {
            --n;
        }
        return n % 2 != 0;
    }

    public void typeCheckReduced(TypeEnvironment typeEnvironment, BindingEnvironment bindingEnvironment, LinkedList linkedList) {
        this.m_cases[0].m_handler.typeCheckReduced(typeEnvironment, bindingEnvironment, linkedList);
        if (this.m_defaultHandler != null) {
            this.m_defaultHandler.typeCheckReduced(typeEnvironment, bindingEnvironment, linkedList);
        }
    }

    public static class Case {
        ChooseInstruction m_cond;
        protected Instruction m_test;
        protected Instruction m_handler;

        public Case(Instruction instruction, Instruction instruction2) {
            this.m_test = instruction;
            this.m_handler = instruction2;
        }

        public Instruction getHandler() {
            return this.m_handler;
        }

        public void setHandler(Instruction instruction) {
            this.m_handler = instruction;
        }

        public Instruction getTest() {
            return this.m_test;
        }

        public void setTest(Instruction instruction) {
            this.m_test = instruction;
        }
    }
}

