/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xylem.codegen;

import com.ibm.xylem.Instruction;
import com.ibm.xylem.Module;
import com.ibm.xylem.Optimizer;
import com.ibm.xylem.instructions.LiteralInstruction;
import com.ibm.xylem.instructions.StreamInstruction;
import com.ibm.xylem.types.CharType;

public class ConstantStringManager
extends Optimizer {
    public int m_count;

    protected Instruction optimizeStep(Instruction instruction) {
        if (instruction instanceof StreamInstruction) {
            StreamInstruction streamInstruction = (StreamInstruction)instruction;
            int n = streamInstruction.getChildInstructionCount();
            if (streamInstruction.isString()) {
                this.m_count += n;
            } else {
                for (int i = 0; i < n; ++i) {
                    Instruction instruction2 = streamInstruction.getChildInstruction(i);
                    if (instruction2 instanceof LiteralInstruction) {
                        if (!(((LiteralInstruction)instruction2).getType() instanceof CharType)) continue;
                        ++this.m_count;
                        continue;
                    }
                    if (!(instruction2 instanceof StreamInstruction)) continue;
                    this.optimizeStep(instruction2);
                }
            }
            return null;
        }
        return super.optimizeStep(instruction);
    }

    public static int countConstantStrings(Module module) {
        ConstantStringManager constantStringManager = new ConstantStringManager();
        module.optimize(constantStringManager);
        System.err.println(">> count: " + constantStringManager.m_count);
        return constantStringManager.m_count;
    }
}

