/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xylem.annot;

import com.ibm.xylem.Function;
import com.ibm.xylem.Instruction;
import com.ibm.xylem.Logger;
import com.ibm.xylem.Module;
import com.ibm.xylem.annot.AnnotationEnvironment;
import com.ibm.xylem.annot.FunctionAnnotationInfo;
import com.ibm.xylem.annot.FunctionCallSpec;
import com.ibm.xylem.annot.FunctionCallStackItem;
import com.ibm.xylem.annot.IAnnotation;
import com.ibm.xylem.annot.IAnnotator;
import com.ibm.xylem.annot.ICallSpec;
import com.ibm.xylem.annot.IFunctionAnnotationInfo;
import com.ibm.xylem.annot.LambdaApplySpec;
import com.ibm.xylem.annot.meta.LambdaMetaAnnotation;
import com.ibm.xylem.annot.meta.MetaAnnotation;
import com.ibm.xylem.annot.meta.StreamMetaAnnotation;
import com.ibm.xylem.annot.meta.TupleMetaAnnotation;
import com.ibm.xylem.instructions.ApplyInstruction;
import com.ibm.xylem.instructions.AutomatonInstruction;
import com.ibm.xylem.instructions.ChooseInstruction;
import com.ibm.xylem.instructions.ConstructorInstantiationInstruction;
import com.ibm.xylem.instructions.ForEachInstruction;
import com.ibm.xylem.instructions.FunctionCallInstruction;
import com.ibm.xylem.instructions.IdentifierInstruction;
import com.ibm.xylem.instructions.LambdaInstruction;
import com.ibm.xylem.instructions.LetBaseInstruction;
import com.ibm.xylem.instructions.LetInstruction;
import com.ibm.xylem.instructions.LiteralInstruction;
import com.ibm.xylem.instructions.MatchInstruction;
import com.ibm.xylem.instructions.NaryPrimopInstruction;
import com.ibm.xylem.instructions.StreamInstruction;
import com.ibm.xylem.instructions.TestStreamInstruction;
import com.ibm.xylem.utils.XylemError;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.StreamTokenizer;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class AnnotationTable {
    public static final Logger s_logger = Logger.getInstance(class$com$ibm$xylem$annot$AnnotationTable == null ? (class$com$ibm$xylem$annot$AnnotationTable = AnnotationTable.class$("com.ibm.xylem.annot.AnnotationTable")) : class$com$ibm$xylem$annot$AnnotationTable);
    private Module m_module;
    private IAnnotator m_annotator;
    private HashMap m_functionInfo = new HashMap();
    private HashMap m_globalInfo = new HashMap();
    private ArrayList m_postponedFunctions = new ArrayList();
    private static final int FUNCTION_STACK_LIMIT = 100;
    private int m_currentFunctionStacklimit = 100;
    static /* synthetic */ Class class$com$ibm$xylem$annot$AnnotationTable;

    public AnnotationTable(Module module, IAnnotator iAnnotator) {
        this.m_module = module;
        this.m_annotator = iAnnotator;
    }

    public void addGlobalInfo(Object object, Object object2) {
        this.m_globalInfo.put(object, object2);
    }

    public Object getGlobalInfo(Object object) {
        return this.m_globalInfo.get(object);
    }

    public IAnnotator getAnnotator() {
        return this.m_annotator;
    }

    public Module getModule() {
        return this.m_module;
    }

    public IFunctionAnnotationInfo getFunctionInfo(ICallSpec iCallSpec) {
        return (IFunctionAnnotationInfo)this.m_functionInfo.get(iCallSpec);
    }

    public static AnnotationTable analyzeProgram(Module module, Function function, IAnnotator iAnnotator) {
        AnnotationTable annotationTable = new AnnotationTable(module, iAnnotator);
        IAnnotation iAnnotation = annotationTable.analyzeFunction(function, null);
        if (iAnnotation != null) {
            s_logger.warn("non-empty annotation for main return!");
        }
        annotationTable.analyzePostponedFunctions();
        return annotationTable;
    }

    public IAnnotation analyzeFunction(Function function, IAnnotation[] iAnnotationArray) {
        if (iAnnotationArray == null) {
            iAnnotationArray = new IAnnotation[function.m_parameters.length];
        }
        return this.analyzeFunction(new FunctionCallSpec(function, iAnnotationArray), null, new ArrayList(), new ArrayList());
    }

    public IAnnotation analyzeCode(Instruction instruction, AnnotationEnvironment annotationEnvironment, Object object, ArrayList arrayList, ArrayList arrayList2) {
        Object object2;
        Object object3;
        Object object4;
        ArrayList<Object> arrayList3 = new ArrayList<Object>();
        while (true) {
            arrayList3.clear();
            if (!(instruction instanceof LetInstruction)) break;
            object4 = (LetInstruction)instruction;
            object3 = ((LetBaseInstruction)object4).getValue();
            object2 = this.analyzeCode((Instruction)object3, annotationEnvironment, ((LetBaseInstruction)object4).getVariable(), arrayList, arrayList2);
            if (object2 != null && object2.getVariable() != null) {
                object2 = object2.clonePassthru();
            }
            annotationEnvironment.set(((LetBaseInstruction)object4).getVariable(), (IAnnotation)object2);
            instruction = ((LetBaseInstruction)object4).getBody();
        }
        if (instruction instanceof ForEachInstruction) {
            object4 = (ForEachInstruction)instruction;
            object3 = annotationEnvironment.get(((ForEachInstruction)object4).getSource());
            if (object3 != null) {
                object3 = object3.getLoopBindingAnnotation();
            }
            annotationEnvironment.set(((ForEachInstruction)object4).getVarName(), (IAnnotation)object3);
            object2 = this.analyzeCode(((ForEachInstruction)object4).getBody(), annotationEnvironment, null, arrayList, arrayList2);
            if (object2 == null) {
                return null;
            }
            return object2.getLoopValueAnnotation();
        }
        if (instruction instanceof TestStreamInstruction) {
            object4 = (TestStreamInstruction)instruction;
            object3 = annotationEnvironment.get(((TestStreamInstruction)object4).getSource());
            if (object3 != null) {
                object3 = object3.getLoopBindingAnnotation();
            }
            annotationEnvironment.set(((TestStreamInstruction)object4).getElementBinding().getName(), (IAnnotation)object3);
            if (annotationEnvironment.get(((TestStreamInstruction)object4).getHint()) != null) {
                throw new XylemError("ERR_SYSTEM", "not yet supported:" + object4);
            }
            object2 = this.analyzeCode(((TestStreamInstruction)object4).getBody(), annotationEnvironment, null, arrayList, arrayList2);
            if (object2 == null) {
                return null;
            }
            return object2;
        }
        if (instruction instanceof IdentifierInstruction) {
            object4 = annotationEnvironment.get(instruction);
            return object4;
        }
        if (instruction instanceof AutomatonInstruction) {
            Object object5;
            object4 = (AutomatonInstruction)instruction;
            object3 = annotationEnvironment.get(((AutomatonInstruction)object4).getSource());
            object2 = annotationEnvironment.get(((AutomatonInstruction)object4).getInitialState());
            IAnnotation iAnnotation = null;
            if (object3 != null) {
                iAnnotation = object3.getLoopBindingAnnotation();
            }
            if (((AutomatonInstruction)object4).getDefaultHandler() != null) {
                annotationEnvironment.set(((AutomatonInstruction)object4).getDefaultElementBinding().getName(), iAnnotation);
                Instruction instruction2 = ((AutomatonInstruction)object4).getDefaultHandler();
                if (object2 != null) {
                    throw new Error("TODO: support ai state annotation?");
                }
                object5 = this.analyzeCode(instruction2, annotationEnvironment, null, arrayList, arrayList2);
                arrayList3.add(object5);
            }
            for (int i = 0; i < ((AutomatonInstruction)object4).m_matches.length; ++i) {
                if (object2 != null || iAnnotation != null) {
                    throw new Error("TODO: support annotationg non-default ai matches?");
                }
                object5 = ((AutomatonInstruction)object4).getDefaultHandler();
                if (object5 == null) continue;
                IAnnotation iAnnotation2 = this.analyzeCode((Instruction)object5, annotationEnvironment, null, arrayList, arrayList2);
                arrayList3.add(iAnnotation2);
            }
            IAnnotation iAnnotation3 = this.unionValues(annotationEnvironment, arrayList3);
            if (iAnnotation3 == null) {
                return null;
            }
            return iAnnotation3.getLoopValueAnnotation();
        }
        if (instruction instanceof FunctionCallInstruction) {
            return this.analyzeFunctionCall(instruction, annotationEnvironment, arrayList, arrayList2);
        }
        if (instruction instanceof ConstructorInstantiationInstruction && ((ConstructorInstantiationInstruction)instruction).getConstructorName().startsWith("tuple")) {
            boolean bl = true;
            for (int i = 0; i < instruction.getChildInstructionCount(); ++i) {
                if (annotationEnvironment.get(instruction.getChildInstruction(i)) == null) continue;
                bl = false;
                break;
            }
            if (bl) {
                return null;
            }
            return new TupleMetaAnnotation(((NaryPrimopInstruction)instruction).getOperands(), annotationEnvironment);
        }
        if (instruction instanceof MatchInstruction && annotationEnvironment.get(((MatchInstruction)instruction).getToMatch()) instanceof TupleMetaAnnotation) {
            object4 = (TupleMetaAnnotation)annotationEnvironment.get(((MatchInstruction)instruction).getToMatch());
            object3 = ((MatchInstruction)instruction).getMatches();
            if (((MatchInstruction.Match[])object3).length != 1) {
                throw new XylemError("ERR_SYSTEM", "isn't this a tuple?");
            }
            object2 = (MatchInstruction.DeconstructionMatch)object3[0];
            for (int i = 0; i < ((MatchInstruction.DeconstructionMatch)object2).getBindings().length; ++i) {
                if (((TupleMetaAnnotation)object4).getComponents()[i] == null) continue;
                annotationEnvironment.set(((MatchInstruction.DeconstructionMatch)object2).getBindings()[i].getName(), ((TupleMetaAnnotation)object4).getComponents()[i].clonePassthru());
            }
            return this.analyzeCode(((MatchInstruction.Match)object2).getHandler(), annotationEnvironment, null, arrayList, arrayList2);
        }
        if (instruction instanceof MatchInstruction) {
            object4 = (MatchInstruction)instruction;
            if (((MatchInstruction)object4).getMatches()[0] instanceof MatchInstruction.LiteralMatch && ((MatchInstruction)object4).getToMatch() instanceof IdentifierInstruction) {
                object3 = (IdentifierInstruction)((MatchInstruction)object4).getToMatch();
                object2 = annotationEnvironment.getComputedLiteral((Instruction)object3);
                if (object2 == null) {
                    s_logger.debug("no literal for match on " + object3);
                } else {
                    s_logger.debug("proactively optimizing match on " + object3 + " with " + object2.size() + " values");
                    Iterator iterator = object2.iterator();
                    boolean bl = false;
                    while (iterator.hasNext()) {
                        Object e = iterator.next();
                        s_logger.debug("proactively optimizing match on " + object3 + " with val " + e);
                        MatchInstruction.Match[] matchArray = ((MatchInstruction)object4).getMatches();
                        int n = 0;
                        for (n = 0; n < matchArray.length; ++n) {
                            LiteralInstruction literalInstruction = ((MatchInstruction.LiteralMatch)matchArray[n]).getLiteral();
                            if (!literalInstruction.getValue().equals(e)) continue;
                            Instruction instruction3 = matchArray[n].getHandler();
                            s_logger.debug(" -- match found " + object3 + " with value " + e);
                            arrayList3.add(this.analyzeCode(instruction3, annotationEnvironment, null, arrayList, arrayList2));
                            break;
                        }
                        if (n != matchArray.length) continue;
                        s_logger.debug(" -- no match found " + object3);
                        bl = true;
                    }
                    if (bl) {
                        if (((MatchInstruction)object4).getDefault() != null) {
                            s_logger.debug(" some literals do not match any value. analyzing default.");
                            arrayList3.add(this.analyzeCode(((MatchInstruction)object4).getDefault(), annotationEnvironment, null, arrayList, arrayList2));
                        } else {
                            s_logger.debug(" some literal do not match any value. no analysis.");
                        }
                    }
                    return this.unionValues(annotationEnvironment, arrayList3);
                }
            }
            int n = instruction.getChildInstructionCount();
            for (int i = 0; i < n; ++i) {
                Instruction instruction4 = instruction.getChildInstruction(i);
                arrayList3.add(this.analyzeCode(instruction4, annotationEnvironment, null, arrayList, arrayList2));
            }
            return this.unionValues(annotationEnvironment, arrayList3);
        }
        if (instruction instanceof ChooseInstruction) {
            object4 = ((ChooseInstruction)instruction).m_cases;
            for (int i = 0; i < ((Object)object4).length; ++i) {
                object2 = this.analyzeCode(((ChooseInstruction.Case)object4[i]).getHandler(), annotationEnvironment, null, arrayList, arrayList2);
                arrayList3.add(object2);
            }
            Instruction instruction5 = ((ChooseInstruction)instruction).getDefaultHandler();
            if (instruction5 != null) {
                arrayList3.add(this.analyzeCode(instruction5, annotationEnvironment, null, arrayList, arrayList2));
            }
            return this.unionValues(annotationEnvironment, arrayList3);
        }
        if (instruction instanceof LambdaInstruction) {
            object4 = (LambdaInstruction)instruction;
            return LambdaMetaAnnotation.newA((LambdaInstruction)object4, this, annotationEnvironment);
        }
        if (instruction instanceof StreamInstruction) {
            return StreamMetaAnnotation.newStream((StreamInstruction)instruction, annotationEnvironment, this);
        }
        if (instruction instanceof ApplyInstruction) {
            return this.analyzeLambdaApplication((ApplyInstruction)instruction, annotationEnvironment, arrayList, arrayList2);
        }
        if (instruction == null) {
            throw new RuntimeException();
        }
        object4 = this.getAnnotator().analyzeExpression(annotationEnvironment, instruction, object);
        if (object4 == null) {
            for (int i = 0; i < instruction.getChildInstructionCount(); ++i) {
                IAnnotation iAnnotation;
                object2 = instruction.getChildInstruction(i);
                if (object2 instanceof IdentifierInstruction || object2 instanceof LiteralInstruction || (iAnnotation = this.analyzeCode((Instruction)object2, annotationEnvironment, null, arrayList, arrayList2)) == null) continue;
                s_logger.warn("non-null annotation for unsupported special form child in " + instruction);
            }
        }
        return object4;
    }

    private IAnnotation analyzeFunctionCall(Instruction instruction, AnnotationEnvironment annotationEnvironment, ArrayList arrayList, ArrayList arrayList2) {
        FunctionCallInstruction functionCallInstruction = (FunctionCallInstruction)instruction;
        Function function = annotationEnvironment.getTypeEnvironment().getModule().getFunction(functionCallInstruction.getFunction());
        int n = functionCallInstruction.getChildInstructionCount();
        Object e = arrayList.get(arrayList.size() - 1);
        IAnnotation iAnnotation = this.analyzeFunction(new FunctionCallSpec(functionCallInstruction, annotationEnvironment), annotationEnvironment, arrayList, arrayList2);
        if (!arrayList.get(arrayList.size() - 1).equals(e)) {
            throw new RuntimeException();
        }
        return iAnnotation;
    }

    public IAnnotation analyzeSyntheticFunctionCall(Function function, Object[] objectArray, AnnotationEnvironment annotationEnvironment) {
        IAnnotation[] iAnnotationArray = new IAnnotation[objectArray.length];
        for (int i = 0; i < objectArray.length; ++i) {
            iAnnotationArray[i] = annotationEnvironment.get(objectArray[i]);
        }
        return this.analyzeFunction(function, iAnnotationArray);
    }

    public IAnnotation analyzeSyntheticLambdaApplication(String string, LambdaInstruction lambdaInstruction, IAnnotation[] iAnnotationArray, AnnotationEnvironment annotationEnvironment) {
        LambdaApplySpec lambdaApplySpec = new LambdaApplySpec(string, lambdaInstruction, iAnnotationArray, true);
        lambdaInstruction.typeCheckReduced(annotationEnvironment.getTypeEnvironment(), annotationEnvironment.getBindingEnvironment(), new LinkedList());
        return this.analyzeFunction(lambdaApplySpec, annotationEnvironment, new ArrayList(), new ArrayList());
    }

    public IAnnotation analyzeLambdaApplication(ApplyInstruction applyInstruction, AnnotationEnvironment annotationEnvironment, ArrayList arrayList, ArrayList arrayList2) {
        Object object = ((IdentifierInstruction)applyInstruction.getLambda()).getVariable();
        LambdaMetaAnnotation lambdaMetaAnnotation = (LambdaMetaAnnotation)annotationEnvironment.get(object);
        return lambdaMetaAnnotation.analyzeApplication(annotationEnvironment.get(applyInstruction.getOperands()), annotationEnvironment, arrayList, arrayList2);
    }

    private IAnnotation analyzeFunction(ICallSpec iCallSpec, AnnotationEnvironment annotationEnvironment, ArrayList arrayList, ArrayList arrayList2) {
        int n = arrayList2.size();
        int n2 = arrayList.size();
        s_logger.debug("analyzing '" + iCallSpec + "' sp=" + n2 + " pending stacks=" + n);
        IFunctionAnnotationInfo iFunctionAnnotationInfo = null;
        boolean bl = this.m_functionInfo.containsKey(iCallSpec);
        iFunctionAnnotationInfo = bl ? (IFunctionAnnotationInfo)this.m_functionInfo.get(iCallSpec) : iCallSpec.newInfo(this, annotationEnvironment);
        FunctionCallStackItem functionCallStackItem = new FunctionCallStackItem(iCallSpec, iFunctionAnnotationInfo);
        arrayList.add(functionCallStackItem);
        if (!bl) {
            Object object;
            int n3 = -1;
            if (s_logger.isDebugEnabled()) {
                try {
                    object = new ByteArrayOutputStream();
                    PrintStream printStream = new PrintStream((OutputStream)object);
                    new Error().printStackTrace(printStream);
                    StreamTokenizer streamTokenizer = new StreamTokenizer(new StringReader(((ByteArrayOutputStream)object).toString()));
                    while (streamTokenizer.nextToken() != -1) {
                    }
                    n3 = streamTokenizer.lineno();
                    s_logger.debug("stack-depth=" + n3);
                }
                catch (Exception exception) {
                    s_logger.error(exception);
                }
            }
            if (n2 > this.m_currentFunctionStacklimit && iCallSpec instanceof FunctionCallSpec && this.m_annotator.isFunctionReturnNotAnnotated((FunctionCallSpec)iCallSpec)) {
                s_logger.info("postponing analysis of " + iFunctionAnnotationInfo.getFunctionName() + " function stack position = " + n2);
                s_logger.debug("postponing analysis of " + iCallSpec + " function stack position = " + n2);
                s_logger.debug(" real stack depth = " + n3);
                object = new PostponedFunction();
                ((PostponedFunction)object).env = annotationEnvironment;
                ((PostponedFunction)object).fcs = iCallSpec;
                arrayList.remove(n2);
                ((PostponedFunction)object).functionStack = new ArrayList(arrayList);
                this.m_postponedFunctions.add(object);
                return null;
            }
            if ((double)n2 > 1.15 * (double)this.m_currentFunctionStacklimit) {
                s_logger.warn("Function stack limit exceeded by 15% " + n2 + " / " + this.m_currentFunctionStacklimit);
            }
            this.m_functionInfo.put(iCallSpec, iFunctionAnnotationInfo);
            s_logger.debug("analysing " + functionCallStackItem);
            object = this.analyzeCode(iFunctionAnnotationInfo.getBody(), iFunctionAnnotationInfo.getEnvironment(), null, arrayList, arrayList2);
            arrayList.remove(arrayList.size() - 1);
            iFunctionAnnotationInfo.setResultAnnotation((IAnnotation)object);
            s_logger.debug("analysis complete for " + functionCallStackItem);
            s_logger.debug(" result: " + object);
        } else if (iFunctionAnnotationInfo.isComplete()) {
            s_logger.debug("analysis already complete for " + functionCallStackItem);
            arrayList.remove(arrayList.size() - 1);
        } else {
            arrayList2.add(new ArrayList(arrayList));
            arrayList.remove(arrayList.size() - 1);
            s_logger.debug("analysis already pending for " + functionCallStackItem);
            IAnnotation iAnnotation = iFunctionAnnotationInfo.getResultAnnotation();
            if (iAnnotation == null) {
                return null;
            }
            throw new XylemError("ERR_SYSTEM", "recursive function returns cursor !" + iFunctionAnnotationInfo);
        }
        IAnnotation iAnnotation = iFunctionAnnotationInfo.getResultAnnotation();
        if (iAnnotation != null) {
            iAnnotation = iAnnotation.cloneAsFunctionReturn(new ArrayList(arrayList.subList(arrayList.size() - 1, arrayList.size())));
        }
        iAnnotation = this.backpatchPendingFunctions(functionCallStackItem, iAnnotation, arrayList, arrayList2);
        s_logger.debug("result for '" + functionCallStackItem + ":");
        s_logger.debug(" " + iAnnotation);
        return iAnnotation;
    }

    private IAnnotation backpatchPendingFunctions(FunctionCallStackItem functionCallStackItem, IAnnotation iAnnotation, ArrayList arrayList, ArrayList arrayList2) {
        int n = arrayList.size();
        s_logger.debug("backpatching " + functionCallStackItem + " ... ");
        FunctionCallStackItem.backpatchFunctionCalls(Collections.singletonList(functionCallStackItem));
        Iterator iterator = arrayList2.iterator();
        while (iterator.hasNext()) {
            arrayList = (ArrayList)iterator.next();
            if (arrayList.size() <= n || arrayList.get(n) != functionCallStackItem) continue;
            FunctionCallStackItem functionCallStackItem2 = (FunctionCallStackItem)arrayList.get(arrayList.size() - 1);
            List list = arrayList.subList(n, arrayList.size());
            if (((Object)functionCallStackItem.getCallSpec()).equals(functionCallStackItem2.getCallSpec())) {
                if (iAnnotation != null) {
                    iAnnotation = iAnnotation.cloneAsFunctionReturn(new ArrayList(list.subList(0, 1)));
                }
                s_logger.debug("call stack is complete, backpatching " + functionCallStackItem.getFunctionInfo() + " depth = " + list);
                FunctionCallStackItem.backpatchFunctionCalls(list);
                iterator.remove();
                functionCallStackItem.getFunctionInfo().setComplete();
                continue;
            }
            s_logger.debug("call stack is incomplete, not backpatching yet");
        }
        s_logger.debug("... finished backpatching " + functionCallStackItem);
        return iAnnotation;
    }

    public void analyzePostponedFunctions() {
        while (!this.m_postponedFunctions.isEmpty()) {
            PostponedFunction postponedFunction = (PostponedFunction)this.m_postponedFunctions.remove(0);
            this.m_currentFunctionStacklimit = postponedFunction.functionStack.size() + 100;
            ArrayList arrayList = new ArrayList();
            s_logger.debug("resuming analysis of " + postponedFunction.fcs);
            IAnnotation iAnnotation = this.analyzeFunction(postponedFunction.fcs, postponedFunction.env, postponedFunction.functionStack, arrayList);
            while (!postponedFunction.functionStack.isEmpty()) {
                FunctionCallStackItem functionCallStackItem = (FunctionCallStackItem)postponedFunction.functionStack.remove(postponedFunction.functionStack.size() - 1);
                iAnnotation = this.backpatchPendingFunctions(functionCallStackItem, iAnnotation, postponedFunction.functionStack, arrayList);
            }
            if (iAnnotation != null) {
                throw new XylemError("ERR_SYSTEM", "Annotator lied, postponed function " + postponedFunction.fcs + " returns annotation '" + iAnnotation + " (annotator said it wouldn't)");
            }
            s_logger.debug("finished resumed analysis of " + postponedFunction.fcs);
        }
    }

    public IAnnotation unionValues(AnnotationEnvironment annotationEnvironment, List list) {
        if (list.size() == 1) {
            return (IAnnotation)list.iterator().next();
        }
        HashSet hashSet = new HashSet(list);
        hashSet.remove(null);
        if (hashSet.size() == 0) {
            return null;
        }
        Object e = hashSet.iterator().next();
        if (e instanceof MetaAnnotation) {
            return ((MetaAnnotation)e).unionValues(annotationEnvironment, list);
        }
        return this.m_annotator.unionValues(annotationEnvironment, list);
    }

    public FunctionAnnotationInfo[] getEntryPoints() {
        ArrayList<IFunctionAnnotationInfo> arrayList = new ArrayList<IFunctionAnnotationInfo>();
        Iterator iterator = this.m_functionInfo.values().iterator();
        while (iterator.hasNext()) {
            IFunctionAnnotationInfo iFunctionAnnotationInfo = (IFunctionAnnotationInfo)iterator.next();
            if (!(iFunctionAnnotationInfo instanceof FunctionAnnotationInfo) || !iFunctionAnnotationInfo.getEnvironment().hasAnnotations() || iFunctionAnnotationInfo.isCallAnnotated()) continue;
            arrayList.add(iFunctionAnnotationInfo);
        }
        return arrayList.toArray(new FunctionAnnotationInfo[0]);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private static class PostponedFunction {
        private ICallSpec fcs;
        private AnnotationEnvironment env;
        private ArrayList functionStack;

        private PostponedFunction() {
        }
    }
}

