/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xylem.annot;

import com.ibm.xylem.Binding;
import com.ibm.xylem.Function;
import com.ibm.xylem.IBinding;
import com.ibm.xylem.annot.AnnotationEnvironment;
import com.ibm.xylem.annot.IAnnotation;
import com.ibm.xylem.annot.ICallSpec;
import com.ibm.xylem.annot.IFunctionAnnotationInfo;

public abstract class AbstractFunctionAnnotationInfo
implements IFunctionAnnotationInfo {
    private IAnnotation[] m_paramAnnotations;
    private IAnnotation m_resultAnnotation;
    private AnnotationEnvironment m_environment;
    private boolean m_complete;
    private boolean m_isCallAnnotated = false;
    private ICallSpec m_spec;

    public AbstractFunctionAnnotationInfo(ICallSpec iCallSpec, IBinding[] iBindingArray, AnnotationEnvironment annotationEnvironment) {
        this.m_environment = annotationEnvironment;
        this.m_environment.setFunctionInfo(this);
        this.m_paramAnnotations = new IAnnotation[iCallSpec.getParamAnnotations().length];
        for (int i = 0; i < iCallSpec.getParamAnnotations().length; ++i) {
            IAnnotation iAnnotation = iCallSpec.getParamAnnotations()[i];
            if (iAnnotation == null) continue;
            this.m_isCallAnnotated = true;
            this.m_paramAnnotations[i] = iAnnotation = iAnnotation.cloneAsFunctionParam();
            this.m_environment.set(iBindingArray[i].getName(), iAnnotation);
        }
        this.m_spec = iCallSpec;
        this.m_complete = false;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("FAI: " + this.getFunctionName());
        stringBuffer.append("(");
        Binding[] bindingArray = this.getSpec().getParamBindings();
        for (int i = 0; i < bindingArray.length; ++i) {
            stringBuffer.append(bindingArray[i]);
            stringBuffer.append("@");
            stringBuffer.append(this.getParamAnnotations()[i]);
            if (i == bindingArray.length - 1) continue;
            stringBuffer.append(", ");
        }
        stringBuffer.append(")");
        return stringBuffer.toString();
    }

    public AnnotationEnvironment getEnvironment() {
        return this.m_environment;
    }

    public IAnnotation getResultAnnotation() {
        return this.m_resultAnnotation;
    }

    public void setResultAnnotation(IAnnotation iAnnotation) {
        this.m_resultAnnotation = iAnnotation;
        if (this.m_resultAnnotation != null) {
            this.m_isCallAnnotated = true;
        }
    }

    public boolean isComplete() {
        return this.m_complete;
    }

    public void setComplete() {
        this.m_complete = true;
    }

    public Function getEnclosingFunction() {
        return this.m_environment.getEnclosingFunction();
    }

    public IAnnotation[] getParamAnnotations() {
        return this.m_paramAnnotations;
    }

    public Binding[] getParamBindings() {
        return this.getSpec().getParamBindings();
    }

    public ICallSpec getSpec() {
        return this.m_spec;
    }

    public boolean isCallAnnotated() {
        return this.m_isCallAnnotated;
    }
}

