/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xylem;

import com.ibm.xylem.ModuleSignature;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashSet;
import java.util.Iterator;

public class PrettyPrinter {
    protected StringWriter m_sw;
    protected PrintWriter m_pw;
    protected int m_pos = 0;
    protected int m_lineWidth = 150;
    protected boolean m_lastIndent = false;
    protected boolean m_lastNewline = false;
    protected HashSet m_moduleSignatures = new HashSet();

    public PrettyPrinter() {
        this.m_sw = new StringWriter();
        this.m_pw = new PrintWriter(this.m_sw);
    }

    public PrettyPrinter(Writer writer) {
        this.m_pw = new PrintWriter(writer);
    }

    public void addModuleSignature(ModuleSignature moduleSignature) {
        this.m_moduleSignatures.add(moduleSignature);
    }

    public String dumpModuleSignatures() {
        this.m_pw.flush();
        this.m_sw = new StringWriter();
        this.m_pw = new PrintWriter(this.m_sw);
        Iterator iterator = this.m_moduleSignatures.iterator();
        while (iterator.hasNext()) {
            ModuleSignature moduleSignature = (ModuleSignature)iterator.next();
            moduleSignature.toString(this, 0);
        }
        this.m_pw.flush();
        return this.m_sw.toString();
    }

    public void printIdentifier(Object object, int n) {
        this.printToken(PrettyPrinter.prettyPrintIdentifier(object), n);
    }

    public static String prettyPrintIdentifier(Object object) {
        return object instanceof Number ? "#" + object : object.toString();
    }

    public void printToken(String string, int n) {
        if (string.length() + this.m_pos > this.m_lineWidth) {
            this.newline();
            this.indent(n);
        } else if (!this.m_lastIndent && !string.equals(")")) {
            this.space();
        }
        this.print(string);
    }

    public void printToken(int n, int n2) {
        String string = Integer.toString(n);
        if (string.length() + this.m_pos > this.m_lineWidth) {
            this.newline();
            this.indent(n2);
        } else if (!this.m_lastIndent && !string.equals(")")) {
            this.space();
        }
        this.print(string);
    }

    public void indent(int n) {
        if (!this.m_lastNewline) {
            this.newline();
        }
        for (int i = 0; i < n; ++i) {
            this.m_pw.print("  ");
        }
        this.m_pos += 2 * n;
        this.m_lastIndent = true;
    }

    public void print(Object object) {
        this.print(object.toString());
    }

    public void print(String string) {
        this.m_lastIndent = false;
        this.m_lastNewline = false;
        this.m_pos += string.length();
        this.m_pw.print(string);
    }

    public void printlnFormOpen(String string, int n) {
        this.indent(n);
        this.print("(");
        this.print(string);
        this.newline();
    }

    public void printFormOpenIdentifier(Object object, int n) {
        this.printFormOpen(object == null ? "!null!" : (object instanceof Number ? "#" + object : object.toString()), n);
    }

    public void printFormOpen(String string, int n) {
        this.indent(n);
        this.print("(");
        this.print(string);
    }

    public void printFormClose(int n) {
        this.printToken(")", n);
    }

    public void println(String string) {
        this.m_pw.println(string);
        this.m_pos = 0;
        this.m_lastIndent = false;
    }

    public void space() {
        this.m_pw.print(' ');
        ++this.m_pos;
        this.m_lastIndent = false;
        this.m_lastNewline = false;
    }

    public void newline() {
        this.m_pw.println();
        this.m_pos = 0;
        this.m_lastIndent = false;
        this.m_lastNewline = true;
    }

    public String toString() {
        this.m_pw.flush();
        return this.m_sw.toString();
    }

    public void close() {
        this.m_pw.close();
    }

    public void print(ModuleSignature moduleSignature) {
        if (moduleSignature == null) {
            this.println("!NULL-SIG!:");
        } else {
            this.m_moduleSignatures.add(moduleSignature);
            this.print(moduleSignature.prettyPrint());
        }
    }

    public void printComment(String string, int n) {
        string = string.replace('\r', ' ');
        int n2 = 0;
        while (n2 < string.length()) {
            int n3 = string.indexOf(10, n2);
            if (n3 < 0) {
                n3 = string.length();
            }
            this.println("");
            this.printToken(";; " + string.substring(n2, n3), n);
            n2 = n3 + 1;
        }
    }
}

