/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xylem;

import com.ibm.xylem.AbstractTypeStore;
import com.ibm.xylem.FunctionSignature;
import com.ibm.xylem.IObjectFilePersistence;
import com.ibm.xylem.ModuleImportDirective;
import com.ibm.xylem.ModuleSignatureStore;
import com.ibm.xylem.PrettyPrinter;
import com.ibm.xylem.ReadObjectFileHelper;
import com.ibm.xylem.TopLevelModuleImportDirective;
import com.ibm.xylem.WriteObjectFileHelper;
import com.ibm.xylem.types.AbstractDataType;
import com.ibm.xylem.types.CompoundType;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class ModuleSignature
extends AbstractTypeStore
implements Serializable,
IObjectFilePersistence {
    private static final long serialVersionUID = -497906467738812098L;
    public HashMap m_functionSignatures = new HashMap();
    protected HashMap m_moduleImportDirectives = new HashMap();

    public ModuleSignature(String string) {
        this.m_name = string;
    }

    public ModuleSignature() {
    }

    public void addModuleImportDirective(ModuleImportDirective moduleImportDirective) {
        this.m_moduleImportDirectives.put(moduleImportDirective.getLocalName(), moduleImportDirective);
    }

    public ModuleSignature getModuleSignature(String string) {
        ModuleImportDirective moduleImportDirective = (ModuleImportDirective)this.m_moduleImportDirectives.get(string);
        if (moduleImportDirective == null) {
            Iterator iterator = this.m_moduleImportDirectives.values().iterator();
            while (iterator.hasNext()) {
                ModuleImportDirective moduleImportDirective2 = (ModuleImportDirective)iterator.next();
                ModuleSignature moduleSignature = moduleImportDirective2.getSignature();
                ModuleSignature moduleSignature2 = moduleSignature.getModuleSignature(string);
                if (moduleSignature2 == null) continue;
                return moduleSignature2;
            }
            return null;
        }
        return moduleImportDirective.getSignature();
    }

    public void addFunctionSignature(FunctionSignature functionSignature) {
        this.m_functionSignatures.put(functionSignature.getFunctionName(), functionSignature);
    }

    public void removeFunctionSignature(String string) {
        this.m_functionSignatures.remove(string);
    }

    public boolean containsFunction(String string) {
        return this.m_functionSignatures.containsKey(string);
    }

    public FunctionSignature getFunctionSignature(String string) {
        return (FunctionSignature)this.m_functionSignatures.get(string);
    }

    public Map getFunctionSignatureMap() {
        return this.m_functionSignatures;
    }

    public String prettyPrint() {
        return this.m_name;
    }

    public void toString(PrettyPrinter prettyPrinter, int n) {
        Object object;
        prettyPrinter.printFormOpen("module-signature", n + 0);
        prettyPrinter.printToken(this.m_name, n);
        Iterator iterator = this.getAbstractDataTypesIterator();
        while (iterator.hasNext()) {
            object = (AbstractDataType)iterator.next();
            prettyPrinter.printFormOpen("declare-datatype", n + 1);
            prettyPrinter.printToken(((CompoundType)object).getName(), n + 1);
            prettyPrinter.printFormClose(n + 1);
        }
        iterator = this.getAbstractDataTypesIterator();
        while (iterator.hasNext()) {
            ((AbstractDataType)iterator.next()).toString(prettyPrinter, n + 1);
        }
        iterator = this.m_functionSignatures.values().iterator();
        while (iterator.hasNext()) {
            object = (FunctionSignature)iterator.next();
            ((FunctionSignature)object).toString(prettyPrinter, 1);
        }
        prettyPrinter.printFormClose(n + 0);
    }

    public void write(ObjectOutput objectOutput) throws IOException {
        this.write(new WriteObjectFileHelper(this, objectOutput));
    }

    public void read(ObjectInput objectInput, ModuleSignatureStore moduleSignatureStore) throws Exception {
        this.read(new ReadObjectFileHelper(this, objectInput, moduleSignatureStore));
    }

    public void write(WriteObjectFileHelper writeObjectFileHelper) throws IOException {
        Object object;
        writeObjectFileHelper.writeString(this.m_name);
        writeObjectFileHelper.writeInt(this.m_moduleImportDirectives.size());
        Iterator iterator = this.m_moduleImportDirectives.values().iterator();
        while (iterator.hasNext()) {
            object = (ModuleImportDirective)iterator.next();
            ((ModuleImportDirective)object).write(writeObjectFileHelper);
        }
        ModuleSignature.writeTypes(this, writeObjectFileHelper);
        object = this.m_functionSignatures.values();
        writeObjectFileHelper.writeInt(object.size());
        Iterator iterator2 = object.iterator();
        while (iterator2.hasNext()) {
            FunctionSignature functionSignature = (FunctionSignature)iterator2.next();
            functionSignature.write(writeObjectFileHelper);
        }
    }

    public void read(ReadObjectFileHelper readObjectFileHelper) throws Exception {
        int n;
        this.m_name = readObjectFileHelper.readString();
        int n2 = readObjectFileHelper.readInt();
        for (n = 0; n < n2; ++n) {
            TopLevelModuleImportDirective topLevelModuleImportDirective = new TopLevelModuleImportDirective();
            topLevelModuleImportDirective.read(readObjectFileHelper);
            this.addModuleImportDirective(topLevelModuleImportDirective);
        }
        ModuleSignature.readTypes(this, readObjectFileHelper);
        n = readObjectFileHelper.readInt();
        for (int i = 0; i < n; ++i) {
            FunctionSignature functionSignature = new FunctionSignature();
            functionSignature.read(readObjectFileHelper);
            this.addFunctionSignature(functionSignature);
        }
    }

    public String toString() {
        PrettyPrinter prettyPrinter = new PrettyPrinter();
        this.toString(prettyPrinter, 0);
        return prettyPrinter.toString();
    }

    public ModuleSignature cloneModule() {
        ModuleSignature moduleSignature = new ModuleSignature(this.m_name);
        moduleSignature.m_adtDefinitions = (ArrayList)this.m_adtDefinitions.clone();
        moduleSignature.m_adts = (HashMap)this.m_adts.clone();
        moduleSignature.m_compoundTypes = (HashMap)this.m_compoundTypes.clone();
        moduleSignature.m_constructors = (HashMap)this.m_constructors.clone();
        moduleSignature.m_functionSignatures = (HashMap)this.m_functionSignatures.clone();
        return moduleSignature;
    }
}

