/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xylem;

import com.ibm.xylem.IObjectFilePersistence;
import com.ibm.xylem.Instruction;
import com.ibm.xylem.Module;
import com.ibm.xylem.ModuleSignature;
import com.ibm.xylem.PrettyPrinter;
import com.ibm.xylem.ReadObjectFileHelper;
import com.ibm.xylem.WriteObjectFileHelper;
import com.ibm.xylem.instructions.ModuleFunctionCallInstruction;
import java.io.IOException;
import java.io.Serializable;

public abstract class ModuleImportDirective
implements Serializable,
IObjectFilePersistence {
    protected String m_localName;
    protected ModuleSignature m_signature;
    private static final long serialVersionUID = 7739421991906694781L;

    protected ModuleImportDirective(String string, ModuleSignature moduleSignature) {
        this.m_localName = string;
        this.m_signature = moduleSignature;
    }

    protected ModuleImportDirective() {
    }

    public String getLocalName() {
        return this.m_localName;
    }

    public ModuleSignature getSignature() {
        return this.m_signature;
    }

    public static String translateFunctionName(String string, ModuleImportDirective moduleImportDirective) {
        return ModuleImportDirective.translateFunctionName(string, moduleImportDirective.getLocalName());
    }

    public static String translateFunctionName(String string, Module module) {
        return ModuleImportDirective.translateFunctionName(string, module.getName());
    }

    public static String translateFunctionName(String string, String string2) {
        if (string2.length() == 0) {
            return string;
        }
        return string2 + "$" + string;
    }

    public abstract Instruction translateFunctionCall(ModuleFunctionCallInstruction var1, Module var2);

    public abstract void toString(PrettyPrinter var1, int var2);

    public void read(ReadObjectFileHelper readObjectFileHelper) throws Exception {
        this.m_localName = readObjectFileHelper.readString();
    }

    public void write(WriteObjectFileHelper writeObjectFileHelper) throws IOException {
        writeObjectFileHelper.writeString(this.m_localName);
    }
}

