/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xtq.xslt.xylem.autof;

import com.ibm.xtq.xslt.translator.StaticError;
import com.ibm.xtq.xslt.xylem.autof.FunctionComparator;
import com.ibm.xtq.xslt.xylem.autof.FunctionRecord;
import com.ibm.xtq.xslt.xylem.autof.ModuleRecord;
import com.ibm.xylem.BindingEnvironment;
import com.ibm.xylem.Function;
import com.ibm.xylem.FunctionSignature;
import com.ibm.xylem.Instruction;
import com.ibm.xylem.Logger;
import com.ibm.xylem.ModuleSignature;
import com.ibm.xylem.ModuleSignatureStore;
import com.ibm.xylem.ReadObjectFileHelper;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public final class FunctionReader {
    private static final boolean VERIFY = false;
    static Logger s_logger = Logger.getInstance(class$com$ibm$xtq$xslt$xylem$autof$FunctionReader == null ? (class$com$ibm$xtq$xslt$xylem$autof$FunctionReader = FunctionReader.class$("com.ibm.xtq.xslt.xylem.autof.FunctionReader")) : class$com$ibm$xtq$xslt$xylem$autof$FunctionReader);
    List m_functionRecords = new LinkedList();
    HashMap m_moduleMap = new HashMap();
    ModuleRecord[] m_moduleRecords;
    private static final int INITIAL_HIGH_WATER = 0x100000;
    private static final int REFILL_STORE_FACTOR = 10;
    private FunctionStore m_store;
    Thread m_readerThread;
    private ArrayList[] m_functionsToRead;
    static /* synthetic */ Class class$com$ibm$xtq$xslt$xylem$autof$FunctionReader;

    public void readFunctions(String[] stringArray, File[] fileArray, HashMap hashMap, HashMap hashMap2) throws Exception {
        this.m_moduleMap = hashMap2;
        this.m_moduleRecords = new ModuleRecord[stringArray.length];
        for (int i = 0; i < fileArray.length; ++i) {
            this.readIndividualModule(i, stringArray[i], fileArray[i], hashMap);
        }
        this.m_store = new FunctionStore(0x100000);
        Collections.sort(this.m_functionRecords, FunctionComparator.CMP);
        this.m_readerThread = new Thread(new Reader());
        this.m_readerThread.start();
    }

    public final Function getFunction(FunctionRecord functionRecord) {
        return this.m_store.getStoredFunction(functionRecord);
    }

    private void refillStore() {
        ModuleRecord moduleRecord;
        int n;
        Object[] objectArray = this.m_store.waitUntilEmptyOrRequired();
        FunctionRecord functionRecord = (FunctionRecord)objectArray[0];
        int n2 = (Integer)objectArray[1];
        Iterator iterator = this.m_functionRecords.iterator();
        if (this.m_functionsToRead == null) {
            this.m_functionsToRead = new ArrayList[this.m_moduleRecords.length];
            for (n = 0; n < this.m_functionsToRead.length; ++n) {
                this.m_functionsToRead[n] = new ArrayList();
            }
        }
        while (iterator.hasNext()) {
            FunctionRecord functionRecord2 = (FunctionRecord)iterator.next();
            moduleRecord = (ModuleRecord)this.m_moduleMap.get(functionRecord2.m_moduleName);
            if ((n2 -= functionRecord2.m_size) < 0 && functionRecord == null) break;
            this.m_functionsToRead[moduleRecord.m_index].add(functionRecord2);
            if (functionRecord2 == functionRecord) {
                functionRecord = null;
            }
            iterator.remove();
        }
        for (n = 0; n < this.m_moduleRecords.length; ++n) {
            moduleRecord = this.m_moduleRecords[n];
            iterator = this.m_functionsToRead[n].iterator();
            while (iterator.hasNext()) {
                FunctionRecord functionRecord3 = (FunctionRecord)iterator.next();
                Function function = new Function();
                try {
                    function.read(moduleRecord.m_rofh);
                    FunctionSignature functionSignature = new FunctionSignature(function);
                    functionSignature.setFunctionName(functionRecord3.m_signature.getFunctionName());
                }
                catch (Exception exception) {
                    s_logger.error("error encountered reading '" + functionRecord3 + "' : ", exception);
                    throw new RuntimeException();
                }
                this.m_store.saveFunction(functionRecord3, function);
            }
            this.m_functionsToRead[n].clear();
        }
    }

    public void readIndividualModule(int n, String string, File file, HashMap hashMap) throws Exception {
        Object object;
        int n2;
        InputStream inputStream = new FileInputStream(file);
        inputStream = new BufferedInputStream(inputStream, 0x100000);
        int[] nArray = new int[1];
        DataInputStream dataInputStream = new DataInputStream(inputStream);
        ModuleRecord moduleRecord = new ModuleRecord();
        moduleRecord.m_baseOffset = dataInputStream.readInt() + 4;
        ObjectInputStream objectInputStream = new ObjectInputStream(dataInputStream);
        ReadObjectFileHelper readObjectFileHelper = new ReadObjectFileHelper(new ModuleSignature(), objectInputStream, new ModuleSignatureStore(Collections.EMPTY_LIST));
        s_logger.debug("reading xdm tables ...");
        moduleRecord.m_names = (String[])readObjectFileHelper.readObject();
        moduleRecord.m_uris = (String[])readObjectFileHelper.readObject();
        moduleRecord.m_types = (int[])readObjectFileHelper.readObject();
        moduleRecord.m_functionNames = new HashMap();
        int n3 = readObjectFileHelper.readInt();
        s_logger.debug("reading " + n3 + " function records ");
        for (n2 = 0; n2 < n3; ++n2) {
            object = new FunctionRecord();
            ((FunctionRecord)object).m_offset = readObjectFileHelper.readInt();
            ((FunctionRecord)object).m_size = readObjectFileHelper.readInt();
            ((FunctionRecord)object).m_originalName = readObjectFileHelper.readString();
            ((FunctionRecord)object).m_exported = readObjectFileHelper.readBoolean();
            ((FunctionRecord)object).m_signature = new FunctionSignature();
            ((FunctionRecord)object).m_signature.read(readObjectFileHelper);
            ((FunctionRecord)object).m_moduleName = string;
            ArrayList<Object> arrayList = (ArrayList<Object>)hashMap.get(((FunctionRecord)object).m_signature);
            if (arrayList == null) {
                arrayList = new ArrayList<Object>();
                hashMap.put(((FunctionRecord)object).m_signature, arrayList);
            }
            arrayList.add(object);
            moduleRecord.m_functionNames.put(((FunctionRecord)object).m_originalName, ((FunctionRecord)object).m_signature);
            this.m_functionRecords.add(object);
        }
        n2 = objectInputStream.readInt();
        object = new HashMap();
        for (int i = 0; i < n2; ++i) {
            Integer n4 = (Integer)objectInputStream.readObject();
            Class clazz = (Class)objectInputStream.readObject();
            ((HashMap)object).put(n4, clazz);
        }
        ObjectInputStream objectInputStream2 = new ObjectInputStream(inputStream);
        moduleRecord.m_rofh = readObjectFileHelper = new ReadObjectFileHelper(new ModuleSignature(), objectInputStream2, new ModuleSignatureStore(Collections.EMPTY_LIST), (HashMap)object, nArray){
            private final /* synthetic */ HashMap val$instructionNames;
            private final /* synthetic */ int[] val$filePosition;
            {
                this.val$instructionNames = hashMap;
                this.val$filePosition = nArray;
            }

            public Instruction readInstruction(BindingEnvironment bindingEnvironment) throws Exception {
                int n = this.readInt();
                Class clazz = (Class)this.val$instructionNames.get(new Integer(n));
                if (clazz == null) {
                    s_logger.error("instruction class not found for " + Integer.toHexString(n) + " at " + Integer.toHexString(this.val$filePosition[0]));
                }
                try {
                    Instruction instruction = (Instruction)clazz.newInstance();
                    instruction.setCachedType(this.readType());
                    instruction.read(this, bindingEnvironment);
                    return instruction;
                }
                catch (Exception exception) {
                    s_logger.error("could not read class " + clazz, exception);
                    throw new Error();
                }
            }
        };
        moduleRecord.m_index = n;
        this.m_moduleRecords[n] = moduleRecord;
        this.m_moduleMap.put(string, moduleRecord);
        s_logger.debug("done.");
    }

    private void cleanUp() {
        if (!this.m_functionRecords.isEmpty()) {
            this.m_functionRecords = null;
            this.m_store = null;
            this.m_functionsToRead = null;
            this.m_moduleMap = null;
        }
        this.m_readerThread = null;
    }

    public void finish() {
        if (this.m_readerThread != null && this.m_readerThread.isAlive()) {
            try {
                this.m_readerThread.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public void forceFinish() {
        if (this.m_readerThread != null) {
            this.m_readerThread.interrupt();
        }
        this.m_readerThread = null;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    class Reader
    implements Runnable {
        Reader() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                while (!FunctionReader.this.m_functionRecords.isEmpty()) {
                    FunctionReader.this.refillStore();
                }
            }
            catch (Throwable throwable) {
                FunctionReader.this.m_readerThread = null;
                FunctionStore functionStore = FunctionReader.this.m_store;
                synchronized (functionStore) {
                    ((FunctionReader)FunctionReader.this).m_store.m_error = true;
                    FunctionReader.this.m_store.notifyAll();
                }
                s_logger.error("exception " + throwable + " in FunctionReader", throwable);
                return;
            }
            s_logger.info("All functions read storeHighWater=" + ((FunctionReader)FunctionReader.this).m_store.m_storeHighWater);
            FunctionReader.this.cleanUp();
        }
    }

    private static class FunctionStore {
        int m_storeSize = 0;
        boolean m_error = false;
        int m_storeHighWater = 0x100000;
        HashMap m_functionStore = new HashMap(this.m_storeHighWater);
        private FunctionRecord m_required = null;

        public FunctionStore(int n) {
            this.m_storeHighWater = n;
        }

        public synchronized Function getStoredFunction(FunctionRecord functionRecord) {
            Function function = null;
            while (true) {
                if ((function = (Function)this.m_functionStore.remove(functionRecord)) != null) {
                    this.m_storeSize -= functionRecord.m_size;
                    return function;
                }
                this.m_required = functionRecord;
                if (this.m_error) {
                    throw new RuntimeException();
                }
                try {
                    this.notifyAll();
                    this.wait();
                }
                catch (InterruptedException interruptedException) {
                    throw new RuntimeException();
                }
            }
        }

        public synchronized void saveFunction(FunctionRecord functionRecord, Function function) {
            if (this.m_functionStore.put(functionRecord, function) != null) {
                throw new StaticError("ERR_SYSTEM", "added function " + functionRecord + " twice!");
            }
            this.m_storeSize += functionRecord.m_size;
            if (this.m_storeSize > this.m_storeHighWater) {
                s_logger.debug("expanded store to " + this.m_storeSize / 1024 + "k to fit " + this.m_functionStore.size() + " functions");
                this.m_storeHighWater = this.m_storeSize;
            }
            if (this.m_required == functionRecord) {
                this.m_required = null;
                this.notifyAll();
            }
        }

        public synchronized Object[] waitUntilEmptyOrRequired() {
            while (this.m_required == null && this.m_storeSize >= this.m_storeHighWater / 10) {
                if (this.m_error) {
                    throw new RuntimeException();
                }
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {
                    throw new RuntimeException();
                }
            }
            return new Object[]{this.m_required, new Integer(this.m_storeHighWater - this.m_storeSize)};
        }
    }
}

