/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xtq.xslt.translator.v1;

import com.ibm.xtq.ast.XPath20Exception;
import com.ibm.xtq.ast.nodes.Expr;
import com.ibm.xtq.ast.nodes.FunctionCall;
import com.ibm.xtq.ast.nodes.IdOrKeyFunctionCallPattern;
import com.ibm.xtq.ast.nodes.KindTest;
import com.ibm.xtq.ast.nodes.Literal;
import com.ibm.xtq.ast.nodes.OperatorExpr;
import com.ibm.xtq.ast.nodes.PathExpr;
import com.ibm.xtq.ast.nodes.StepExpr;
import com.ibm.xtq.ast.nodes.Text;
import com.ibm.xtq.ast.nodes.VariableBase;
import com.ibm.xtq.ast.nodes.VariableRef;
import com.ibm.xtq.common.utils.Util;
import com.ibm.xtq.common.utils.WrappedRuntimeException;
import com.ibm.xtq.xslt.drivers.XPathCompiler;
import com.ibm.xtq.xslt.drivers.XSLTLinkerSettings;
import com.ibm.xtq.xslt.translator.ASTDecorator;
import com.ibm.xtq.xslt.translator.ASTDecorator1;
import com.ibm.xtq.xslt.translator.NamespaceHelper;
import com.ibm.xtq.xslt.translator.StaticError;
import com.ibm.xtq.xslt.translator.XSLTCHelper;
import com.ibm.xtq.xslt.translator.v1.FunctionTranslator;
import com.ibm.xtq.xslt.translator.v1.XPathPathTranslator;
import com.ibm.xtq.xslt.translator.v1.XSLTTranslator;
import com.ibm.xtq.xslt.typechecker.v1.types.Type;
import com.ibm.xtq.xslt.xylem.instructions.ArithmeticInstruction;
import com.ibm.xtq.xslt.xylem.instructions.CoerceInstruction;
import com.ibm.xtq.xslt.xylem.instructions.ComparisonInstruction;
import com.ibm.xtq.xslt.xylem.instructions.EqualityInstruction;
import com.ibm.xtq.xslt.xylem.instructions.ExpandedTypeIDInstruction;
import com.ibm.xtq.xslt.xylem.instructions.GetAxisCursorInstruction;
import com.ibm.xtq.xslt.xylem.instructions.GetLastInstruction;
import com.ibm.xtq.xslt.xylem.instructions.GetNodeNameInstruction;
import com.ibm.xtq.xslt.xylem.instructions.GetNodeTypeInstruction;
import com.ibm.xtq.xslt.xylem.instructions.IDInstruction;
import com.ibm.xtq.xslt.xylem.instructions.IsEmptyInstruction;
import com.ibm.xtq.xslt.xylem.instructions.MatchParentCursorInstruction;
import com.ibm.xtq.xslt.xylem.instructions.NegationInstruction;
import com.ibm.xtq.xslt.xylem.instructions.NodesetContainsNodeInstruction;
import com.ibm.xtq.xslt.xylem.instructions.PositionInstruction;
import com.ibm.xtq.xslt.xylem.instructions.RelativeDocOrderInstruction;
import com.ibm.xtq.xslt.xylem.instructions.SingleNodeInstruction;
import com.ibm.xtq.xslt.xylem.instructions.StepCursorInstruction;
import com.ibm.xtq.xslt.xylem.instructions.UnionCursorInstruction;
import com.ibm.xtq.xslt.xylem.types.CursorType;
import com.ibm.xylem.Instruction;
import com.ibm.xylem.Module;
import com.ibm.xylem.PrettyPrinter;
import com.ibm.xylem.instructions.AndInstruction;
import com.ibm.xylem.instructions.ChooseInstruction;
import com.ibm.xylem.instructions.DeepEqualityInstruction;
import com.ibm.xylem.instructions.FunctionCallInstruction;
import com.ibm.xylem.instructions.IdentifierInstruction;
import com.ibm.xylem.instructions.LetInstruction;
import com.ibm.xylem.instructions.LiteralInstruction;
import com.ibm.xylem.instructions.MatchInstruction;
import com.ibm.xylem.instructions.ModuleFunctionCallInstruction;
import com.ibm.xylem.instructions.NotInstruction;
import com.ibm.xylem.instructions.OrInstruction;
import com.ibm.xylem.instructions.PrimitiveEqualityInstruction;
import com.ibm.xylem.instructions.StreamInstruction;
import com.ibm.xylem.instructions.TestStreamInstruction;
import com.ibm.xylem.types.BooleanType;
import com.ibm.xylem.types.DoubleType;
import com.ibm.xylem.types.JavaObjectType;
import java.util.ArrayList;
import java.util.LinkedList;

public class XPathTranslator {
    protected Module m_module;
    protected FunctionTranslator m_functionTranslator;
    protected XPathPathTranslator m_xpathPathTranslator;
    protected XPathCompiler m_compiler;
    private XSLTLinkerSettings m_settings;
    private NamespaceHelper m_namespaceHelper;
    private XSLTTranslator m_xsltTranslator;

    public XPathTranslator(XSLTTranslator xSLTTranslator, XPathCompiler xPathCompiler, XSLTLinkerSettings xSLTLinkerSettings, NamespaceHelper namespaceHelper) {
        this.m_compiler = xPathCompiler;
        this.m_functionTranslator = new FunctionTranslator(xSLTTranslator.getModule(), this, xPathCompiler);
        this.m_xpathPathTranslator = new XPathPathTranslator(xSLTTranslator.getModule(), this, xPathCompiler);
        this.m_module = xSLTTranslator.getModule();
        this.m_settings = xSLTLinkerSettings;
        this.m_namespaceHelper = namespaceHelper;
        this.m_xsltTranslator = xSLTTranslator;
        this.m_xpathPathTranslator.setDisableNVCursor(this.m_settings.isDisableNVCursor());
    }

    public XPathTranslator(Module module, XPathCompiler xPathCompiler, XSLTLinkerSettings xSLTLinkerSettings, NamespaceHelper namespaceHelper) {
        this.m_compiler = xPathCompiler;
        this.m_functionTranslator = new FunctionTranslator(module, this, xPathCompiler);
        this.m_xpathPathTranslator = new XPathPathTranslator(module, this, xPathCompiler);
        this.m_module = module;
        this.m_settings = xSLTLinkerSettings;
        this.m_namespaceHelper = namespaceHelper;
        this.m_xsltTranslator = null;
        this.m_xpathPathTranslator.setDisableNVCursor(this.m_settings.isDisableNVCursor());
    }

    protected Instruction compileGlobalVariableReference(String string, Instruction[] instructionArray) {
        if (this.m_settings.getFunctorParamLocalName() == null || this.m_settings.getFunctorParamSignature().getFunctionSignature(string) == null) {
            return new FunctionCallInstruction(string, instructionArray);
        }
        return new ModuleFunctionCallInstruction(this.m_settings.getFunctorParamLocalName(), string, instructionArray);
    }

    public Module getModule() {
        return this.m_module;
    }

    public Instruction visitRawExpression(Expr expr, String string, Instruction instruction) {
        switch (expr.getId()) {
            case 186: {
                return this.pattern(expr, string);
            }
            case 187: {
                return this.pathPattern(expr, string);
            }
            case 188: {
                return this.stepPattern(expr, false, string);
            }
            case 84: {
                return this.slashSlashPattern(expr, false, string);
            }
            case 228: {
                return this.dirTextLiteral(expr);
            }
            case 5: {
                return this.stringLiteral(expr);
            }
            case 100: {
                return this.variableOrParameterReference(expr, string);
            }
            case 57: {
                return this.orExpression(expr, string);
            }
            case 58: {
                return this.andExpression(expr, string);
            }
            case 59: {
                return this.comparisonExpression(expr, string);
            }
            case 61: {
                return this.additiveExpression(expr, string);
            }
            case 62: {
                return this.multiplicativeExpression(expr, string);
            }
            case 69: {
                return this.unaryExpression(expr, string);
            }
            case 63: {
                return this.unionExpression(expr, string);
            }
            case 82: {
                return this.m_xpathPathTranslator.pathExpression(expr, string, instruction);
            }
            case 85: {
                return this.m_xpathPathTranslator.stepExpression(expr, string, instruction);
            }
            case 97: {
                return this.integerLiteral(expr);
            }
            case 99: {
                return this.doubleLiteral(expr);
            }
            case 98: {
                return this.decimalLiteral(expr);
            }
            case 105: {
                if (expr.isRootOnSelfNode()) {
                    return this.m_xpathPathTranslator.rootStepExpression(expr);
                }
                if (expr instanceof IdOrKeyFunctionCallPattern) {
                    return this.idKeyPattern(expr, string);
                }
                return this.m_functionTranslator.visitRawFunction((FunctionCall)expr, string);
            }
            case 102: {
                return this.contextItemExpression(expr);
            }
        }
        throw new StaticError("ERR_UNSUPPORTED_EXP", expr.toString() + "@" + expr.getSystemId() + ":" + expr.getLineNumber() + ":" + expr.getColumnNumber());
    }

    public Instruction compileNode(Expr expr, String string) {
        Instruction instruction = this.visitRawExpression(expr, string, new IdentifierInstruction("__context__"));
        return new LetInstruction("__context__", new IdentifierInstruction("__current__"), instruction);
    }

    protected Instruction additiveExpression(Expr expr, String string) {
        OperatorExpr operatorExpr = (OperatorExpr)expr;
        return new ArithmeticInstruction(operatorExpr.getOperatorType(), this.visitRawExpression(operatorExpr.getOperand(0), string, new IdentifierInstruction("__context__")), this.visitRawExpression(operatorExpr.getOperand(1), string, new IdentifierInstruction("__context__")));
    }

    protected Instruction andExpression(Expr expr, String string) {
        OperatorExpr operatorExpr = (OperatorExpr)expr;
        Expr expr2 = operatorExpr.getOperand(0);
        Expr expr3 = operatorExpr.getOperand(1);
        return new AndInstruction(new CoerceInstruction(this.visitRawExpression(expr2, string, new IdentifierInstruction("__context__")), BooleanType.s_booleanType), new CoerceInstruction(this.visitRawExpression(expr3, string, new IdentifierInstruction("__context__")), BooleanType.s_booleanType));
    }

    protected Instruction orExpression(Expr expr, String string) {
        OperatorExpr operatorExpr = (OperatorExpr)expr;
        Expr expr2 = operatorExpr.getOperand(0);
        Expr expr3 = operatorExpr.getOperand(1);
        return new OrInstruction(new CoerceInstruction(this.visitRawExpression(expr2, string, new IdentifierInstruction("__context__")), BooleanType.s_booleanType), new CoerceInstruction(this.visitRawExpression(expr3, string, new IdentifierInstruction("__context__")), BooleanType.s_booleanType));
    }

    protected Instruction comparisonExpression(Expr expr, String string) {
        OperatorExpr operatorExpr = (OperatorExpr)expr;
        short s = operatorExpr.getOperatorType();
        if (s == 14 || s == 13) {
            return this.equalityExpression(operatorExpr, string);
        }
        if (s == 15 || s == 17 || s == 16 || s == 18) {
            return this.relationalExpression(operatorExpr, string);
        }
        throw new RuntimeException();
    }

    protected Instruction idKeyPattern(Expr expr, String string) {
        if (expr instanceof IdOrKeyFunctionCallPattern) {
            IdOrKeyFunctionCallPattern idOrKeyFunctionCallPattern = (IdOrKeyFunctionCallPattern)expr;
            if (idOrKeyFunctionCallPattern.getFunctionQName().getLocalPart().equals("id")) {
                return new NodesetContainsNodeInstruction(new IDInstruction(this.visitRawExpression(idOrKeyFunctionCallPattern.getOperand(0), string, new IdentifierInstruction("__context__"))), new IdentifierInstruction("__context__"));
            }
            return new NodesetContainsNodeInstruction(this.m_functionTranslator.translateKey(idOrKeyFunctionCallPattern, string, this.getModule().getName()), new IdentifierInstruction("__context__"));
        }
        throw new StaticError("ERR_SYSTEM", "idKeyPattern called on non-IdKeyPattern");
    }

    protected Instruction multiplicativeExpression(Expr expr, String string) {
        OperatorExpr operatorExpr = (OperatorExpr)expr;
        short s = operatorExpr.getOperatorType();
        if (s == 31 || s == 33) {
            return new ArithmeticInstruction(s, new CoerceInstruction(this.visitRawExpression(operatorExpr.getOperand(0), string, new IdentifierInstruction("__context__")), DoubleType.s_doubleType), new CoerceInstruction(this.visitRawExpression(operatorExpr.getOperand(1), string, new IdentifierInstruction("__context__")), DoubleType.s_doubleType));
        }
        return new ArithmeticInstruction(s, this.visitRawExpression(operatorExpr.getOperand(0), string, new IdentifierInstruction("__context__")), this.visitRawExpression(operatorExpr.getOperand(1), string, new IdentifierInstruction("__context__")));
    }

    protected Instruction contextItemExpression(Expr expr) {
        if (ASTDecorator1.getType(expr) == Type.Node) {
            return new IdentifierInstruction("__context__");
        }
        return new SingleNodeInstruction();
    }

    protected void dump(Instruction instruction) {
        PrettyPrinter prettyPrinter = new PrettyPrinter();
        instruction.toString(prettyPrinter, 2);
        String string = prettyPrinter.toString();
        System.out.println("============");
        System.out.println(string);
        System.out.println("============");
    }

    protected Instruction pattern(Expr expr, String string) {
        if (expr instanceof OperatorExpr && ((OperatorExpr)expr).getOperatorType() == 1) {
            return this.unionPattern((OperatorExpr)expr, string);
        }
        throw new StaticError("ERR_INVALID_PATTERN", expr.toString());
    }

    protected Instruction unionPattern(OperatorExpr operatorExpr, String string) {
        Expr expr = operatorExpr.getOperand(0);
        Expr expr2 = operatorExpr.getOperand(1);
        return new OrInstruction(this.visitRawExpression(expr, string, new IdentifierInstruction("__context__")), this.visitRawExpression(expr2, string, new IdentifierInstruction("__context__")));
    }

    protected Instruction pathPattern(Expr expr, String string) {
        PathExpr pathExpr = (PathExpr)expr;
        return this.relativePathPattern(pathExpr, string);
    }

    private Instruction relativePathPattern(PathExpr pathExpr, String string) {
        int n = pathExpr.getOperandCount();
        if (n == 1) {
            Expr expr = pathExpr.getOperand(0);
            return this.stepPattern(expr, pathExpr.isAbsolute(), string);
        }
        return this.translateStepsForPathPattern(pathExpr, 0, string);
    }

    private Instruction translateMultiStepPathPattern(PathExpr pathExpr, boolean bl, LinkedList linkedList, String string) {
        Expr expr = pathExpr.getOperand(0);
        Expr expr2 = pathExpr.getOperand(1);
        linkedList.add(expr);
        if (expr2 instanceof StepExpr) {
            linkedList.add(expr2);
            return this.helper(linkedList, string);
        }
        if (expr2 instanceof PathExpr) {
            return this.translateMultiStepPathPattern((PathExpr)expr2, false, linkedList, string);
        }
        throw new StaticError("ERR_INVALID_PATTERN", "multi step pattern");
    }

    private Instruction helper(LinkedList linkedList, String string) {
        if (linkedList.isEmpty()) {
            return LiteralInstruction.booleanTrueLiteral();
        }
        Instruction instruction = this.stepPattern((Expr)linkedList.removeLast(), false, string);
        return new ChooseInstruction(new CoerceInstruction(instruction, BooleanType.s_booleanType), (Instruction)new LetInstruction("__context__", new GetAxisCursorInstruction(10, new IdentifierInstruction("__context__")), new LetInstruction("__contextposition__", new PositionInstruction(), new LetInstruction("__contextlast__", new GetLastInstruction(), this.helper(linkedList, string)))), LiteralInstruction.booleanFalseLiteral());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Instruction translateStepsForPathPattern(PathExpr pathExpr, int n, String string) {
        Instruction instruction;
        int n2 = pathExpr.getOperandCount();
        Expr expr = pathExpr.getOperand(n);
        if (n == n2 - 2) {
            Expr expr2 = pathExpr.getOperand(n + 1);
            if (!XSLTCHelper.isWildcardPattern(expr2)) {
                if (!(expr2 instanceof StepExpr)) return this.translateMultiStepPathPattern(pathExpr, pathExpr.isAbsolute(), new LinkedList(), string);
                instruction = this.stepPattern(expr2, pathExpr.isAbsolute(), string);
                return new ChooseInstruction(new CoerceInstruction(instruction, BooleanType.s_booleanType), (Instruction)new LetInstruction("__context__", new GetAxisCursorInstruction(10, new IdentifierInstruction("__context__")), new LetInstruction("__contextposition__", new PositionInstruction(), new LetInstruction("__contextlast__", new GetLastInstruction(), this.visitRawExpression(expr, string, new IdentifierInstruction("__context__"))))), LiteralInstruction.booleanFalseLiteral());
            } else {
                instruction = new IdentifierInstruction("__context__");
            }
            return new ChooseInstruction(new CoerceInstruction(instruction, BooleanType.s_booleanType), (Instruction)new LetInstruction("__context__", new GetAxisCursorInstruction(10, new IdentifierInstruction("__context__")), new LetInstruction("__contextposition__", new PositionInstruction(), new LetInstruction("__contextlast__", new GetLastInstruction(), this.visitRawExpression(expr, string, new IdentifierInstruction("__context__"))))), LiteralInstruction.booleanFalseLiteral());
        } else {
            instruction = this.translateStepsForPathPattern(pathExpr, n + 1, string);
        }
        return new ChooseInstruction(new CoerceInstruction(instruction, BooleanType.s_booleanType), (Instruction)new LetInstruction("__context__", new GetAxisCursorInstruction(10, new IdentifierInstruction("__context__")), new LetInstruction("__contextposition__", new PositionInstruction(), new LetInstruction("__contextlast__", new GetLastInstruction(), this.visitRawExpression(expr, string, new IdentifierInstruction("__context__"))))), LiteralInstruction.booleanFalseLiteral());
    }

    protected Instruction processingInstructionPattern(StepExpr stepExpr) {
        String string;
        Object object;
        try {
            object = (KindTest)stepExpr.getNodeTest();
            string = ((KindTest)object).getPITarget();
        }
        catch (XPath20Exception xPath20Exception) {
            throw new StaticError("ERR_SYSTEM", "processing-instruction() error");
        }
        object = new PrimitiveEqualityInstruction(new GetNodeTypeInstruction(), LiteralInstruction.integerLiteral(7));
        if (null == string) {
            return object;
        }
        return new AndInstruction((Instruction)object, new DeepEqualityInstruction(new GetNodeNameInstruction(), StreamInstruction.charStreamLiteral(string)));
    }

    protected Instruction stepPattern(Expr expr, boolean bl, String string) {
        if (expr instanceof PathExpr) {
            return this.translateStepsForPathPattern((PathExpr)expr, 0, string);
        }
        if (expr instanceof IdOrKeyFunctionCallPattern) {
            return this.idKeyPattern(expr, string);
        }
        StepExpr stepExpr = (StepExpr)expr;
        int n = stepExpr.getPredicateCount();
        if (n > 0) {
            Object object;
            int n2 = XSLTCHelper.analyzeContextCasesForStepPattern(stepExpr);
            if (n2 == 1) {
                object = stepExpr.getPredicateAt(0);
                if (ASTDecorator.isNthPositionFilter((Expr)object)) {
                    n2 = 2;
                }
            } else if (n2 == 2) {
                for (int i = 0; i < n; ++i) {
                    Expr expr2 = stepExpr.getPredicateAt(i);
                    XSLTCHelper.dontOptimize(expr2);
                }
            }
            switch (n2) {
                case 0: {
                    object = this.translateStepPatternNoContext(stepExpr, string);
                    return object;
                }
                case 1: {
                    return this.translateStepPatternSimpleContext(stepExpr, string);
                }
            }
            return this.translateStepPatternGeneralContext(stepExpr, string);
        }
        if (XSLTCHelper.isWildcardPattern(stepExpr) && !bl) {
            return LiteralInstruction.booleanTrueLiteral();
        }
        return this.translateStepPatternKernel(stepExpr, bl);
    }

    protected Instruction slashSlashPattern(Expr expr, boolean bl, String string) {
        OperatorExpr operatorExpr = (OperatorExpr)expr;
        StepCursorInstruction stepCursorInstruction = new StepCursorInstruction(new GetAxisCursorInstruction(5, this.m_xpathPathTranslator.stepExpression(operatorExpr.getOperand(0), string, new IdentifierInstruction("__context__"))), this.m_xpathPathTranslator.stepExpression(operatorExpr.getOperand(1), string, this.m_xpathPathTranslator.makeNullCursorInstruction()));
        CoerceInstruction coerceInstruction = new CoerceInstruction(new LetInstruction("__context__", new GetAxisCursorInstruction(19, new IdentifierInstruction("__context__")), new StepCursorInstruction(new IdentifierInstruction("__context__"), stepCursorInstruction)), CursorType.s_cursorType);
        return new NotInstruction(new TestStreamInstruction(coerceInstruction, LiteralInstruction.booleanTrueLiteral(), "x", "hint", new ChooseInstruction(new IdentifierInstruction("hint"), (Instruction)new NotInstruction(new PrimitiveEqualityInstruction(new RelativeDocOrderInstruction(new IdentifierInstruction("__context__"), new IdentifierInstruction("x")), LiteralInstruction.integerLiteral(0))), LiteralInstruction.booleanFalseLiteral()), CursorType.s_cursorType));
    }

    private Instruction translateStepPatternKernel(StepExpr stepExpr, boolean bl) {
        int n = stepExpr.getStepNodeType();
        Instruction instruction = n == 1 ? new PrimitiveEqualityInstruction(LiteralInstruction.integerLiteral(n), new GetNodeTypeInstruction(new IdentifierInstruction("__context__"))) : (n == 2 ? new PrimitiveEqualityInstruction(LiteralInstruction.integerLiteral(n), new GetNodeTypeInstruction(new IdentifierInstruction("__context__"))) : new MatchInstruction((Instruction)new ExpandedTypeIDInstruction(new IdentifierInstruction("__context__")), new MatchInstruction.Match[]{new MatchInstruction.LiteralMatch(LiteralInstruction.integerLiteral(n), LiteralInstruction.booleanTrueLiteral())}, (Instruction)LiteralInstruction.booleanFalseLiteral()));
        if (bl) {
            GetAxisCursorInstruction getAxisCursorInstruction = new GetAxisCursorInstruction(10, new IdentifierInstruction("__context__"));
            MatchInstruction matchInstruction = new MatchInstruction((Instruction)new ExpandedTypeIDInstruction(getAxisCursorInstruction), new MatchInstruction.Match[]{new MatchInstruction.LiteralMatch(LiteralInstruction.integerLiteral(9), LiteralInstruction.booleanTrueLiteral())}, (Instruction)LiteralInstruction.booleanFalseLiteral());
            return new AndInstruction(instruction, matchInstruction);
        }
        return instruction;
    }

    private Instruction translateStepPatternNoContext(StepExpr stepExpr, String string) {
        ArrayList<Instruction> arrayList = new ArrayList<Instruction>();
        if (!ASTDecorator.isPatternReduced(stepExpr)) {
            arrayList.add(this.translateStepPatternKernel(stepExpr, false));
        }
        int n = stepExpr.getPredicateCount();
        for (int i = 0; i < n; ++i) {
            Expr expr = stepExpr.getPredicateAt(i);
            Instruction instruction = this.visitRawExpression(expr, string, new IdentifierInstruction("__context__"));
            arrayList.add(new CoerceInstruction(instruction, BooleanType.s_booleanType));
        }
        return new AndInstruction(arrayList);
    }

    private Instruction translateStepPatternSimpleContext(StepExpr stepExpr, String string) {
        if (!ASTDecorator.isPatternReduced(stepExpr)) {
            this.translateStepPatternKernel(stepExpr, false);
        }
        Expr expr = stepExpr.getPredicateAt(0);
        try {
            return new LetInstruction("__context__", new MatchParentCursorInstruction(this.m_xpathPathTranslator.translateNodeTestForAxisStep(stepExpr, new IdentifierInstruction("__context__")), new IdentifierInstruction("__context__")), new LetInstruction("__contextposition__", new PositionInstruction(), new LetInstruction("__contextlast__", new GetLastInstruction(), new ChooseInstruction(new IsEmptyInstruction(new IdentifierInstruction("__context__")), (Instruction)LiteralInstruction.booleanFalseLiteral(), this.visitRawExpression(expr, string, new IdentifierInstruction("__context__"))))));
        }
        catch (XPath20Exception xPath20Exception) {
            throw new WrappedRuntimeException(xPath20Exception);
        }
    }

    private Instruction translateStepPatternGeneralContext(StepExpr stepExpr, String string) {
        CoerceInstruction coerceInstruction = new CoerceInstruction(new LetInstruction("__context__", new GetAxisCursorInstruction(10, new IdentifierInstruction("__context__")), this.m_xpathPathTranslator.stepExpression(stepExpr, string, new IdentifierInstruction("__context__"))), CursorType.s_cursorType);
        return new NotInstruction(new TestStreamInstruction(coerceInstruction, LiteralInstruction.booleanTrueLiteral(), "x", "hint", new ChooseInstruction(new IdentifierInstruction("hint"), (Instruction)new NotInstruction(new PrimitiveEqualityInstruction(new RelativeDocOrderInstruction(new IdentifierInstruction("__context__"), new IdentifierInstruction("x")), LiteralInstruction.integerLiteral(0))), LiteralInstruction.booleanFalseLiteral()), CursorType.s_cursorType));
    }

    protected Instruction dirTextLiteral(Expr expr) {
        Text text = (Text)expr;
        return StreamInstruction.charStreamLiteral(text.getText().toString());
    }

    protected Instruction stringLiteral(Expr expr) {
        Literal literal = (Literal)expr;
        return StreamInstruction.charStreamLiteral(literal.getStringLiteral());
    }

    protected Instruction integerLiteral(Expr expr) {
        Literal literal = (Literal)expr;
        Type type = ASTDecorator1.getType(expr);
        try {
            if (type == Type.Int) {
                int n = literal.getIntegerLiteral().intValue();
                return LiteralInstruction.integerLiteral(n);
            }
            double d = literal.getIntegerLiteral().doubleValue();
            return LiteralInstruction.doubleLiteral(d);
        }
        catch (XPath20Exception xPath20Exception) {
            throw new WrappedRuntimeException(xPath20Exception);
        }
    }

    protected Instruction decimalLiteral(Expr expr) {
        Literal literal = (Literal)expr;
        try {
            return LiteralInstruction.doubleLiteral(literal.getDecimalLiteralAsDouble());
        }
        catch (XPath20Exception xPath20Exception) {
            throw new WrappedRuntimeException(xPath20Exception);
        }
    }

    protected Instruction doubleLiteral(Expr expr) {
        Literal literal = (Literal)expr;
        try {
            return LiteralInstruction.doubleLiteral(literal.getDoubleLiteral());
        }
        catch (XPath20Exception xPath20Exception) {
            throw new WrappedRuntimeException(xPath20Exception);
        }
    }

    protected Instruction unaryExpression(Expr expr, String string) {
        OperatorExpr operatorExpr = (OperatorExpr)expr;
        Expr expr2 = operatorExpr.getOperand(0);
        Instruction instruction = this.visitRawExpression(expr2, string, new IdentifierInstruction("__context__"));
        if (operatorExpr.getOpType() == 26) {
            instruction = new NegationInstruction(instruction);
        }
        return instruction;
    }

    protected Instruction unionExpression(Expr expr, String string) {
        OperatorExpr operatorExpr = (OperatorExpr)expr;
        ArrayList arrayList = new ArrayList();
        XSLTCHelper.flattenUnionExpression(operatorExpr, arrayList);
        int n = arrayList.size();
        for (int i = 0; i < n; ++i) {
            StepExpr stepExpr;
            Expr expr2 = (Expr)arrayList.get(i);
            if (!(expr2 instanceof StepExpr) || (stepExpr = (StepExpr)expr2).isFilterStep()) continue;
            short s = 0;
            try {
                s = stepExpr.getAxisType();
            }
            catch (XPath20Exception xPath20Exception) {
                throw new WrappedRuntimeException(xPath20Exception);
            }
            if (s != 4) continue;
            arrayList.set(i, arrayList.get(0));
            arrayList.set(0, stepExpr);
        }
        UnionCursorInstruction unionCursorInstruction = null;
        for (int i = 0; i < n; ++i) {
            if (i == 0) {
                unionCursorInstruction = new UnionCursorInstruction(this.visitRawExpression((Expr)arrayList.get(0), string, new IdentifierInstruction("__context__")), this.visitRawExpression((Expr)arrayList.get(1), string, new IdentifierInstruction("__context__")));
                ++i;
                continue;
            }
            unionCursorInstruction = new UnionCursorInstruction(unionCursorInstruction, this.visitRawExpression((Expr)arrayList.get(i), string, new IdentifierInstruction("__context__")));
        }
        return unionCursorInstruction;
    }

    private Instruction equalityExpression(OperatorExpr operatorExpr, String string) {
        Expr expr = operatorExpr.getOperand(0);
        Expr expr2 = operatorExpr.getOperand(1);
        short s = operatorExpr.getOperatorType();
        EqualityInstruction equalityInstruction = new EqualityInstruction(this.visitRawExpression(expr, string, new IdentifierInstruction("__context__")), this.visitRawExpression(expr2, string, new IdentifierInstruction("__context__")), s == 14);
        return equalityInstruction;
    }

    protected Instruction relationalExpression(OperatorExpr operatorExpr, String string) {
        Expr expr = operatorExpr.getOperand(0);
        Expr expr2 = operatorExpr.getOperand(1);
        short s = operatorExpr.getOperatorType();
        return new ComparisonInstruction(s, this.visitRawExpression(expr, string, new IdentifierInstruction("__context__")), this.visitRawExpression(expr2, string, new IdentifierInstruction("__context__")));
    }

    protected Instruction variableOrParameterReference(Expr expr, String string) {
        VariableRef variableRef = (VariableRef)expr;
        VariableBase variableBase = ASTDecorator.getVariable(variableRef);
        if (variableBase == null) {
            Object object = XSLTCHelper.getJAXPVariable(variableRef, this.m_compiler);
            if (object == null) {
                throw new StaticError("ERR_UNSUPPORTED_EXP", expr.toString());
            }
            return new LiteralInstruction(new JavaObjectType("java.lang.Object"), object);
        }
        String string2 = Util.getStringRep(variableBase.getQName());
        return variableBase.isLocal() ? new IdentifierInstruction(string + string2) : this.compileGlobalVariableReference(string2, new Instruction[]{new IdentifierInstruction("__root__"), new IdentifierInstruction("__seenroot__"), new IdentifierInstruction("__seenscript__"), new IdentifierInstruction("__parentnodename__"), new IdentifierInstruction("__currentTemplRule__"), new IdentifierInstruction("__parameters__")});
    }

    public XSLTLinkerSettings getLinkerSettings() {
        return this.m_settings;
    }

    public NamespaceHelper getNamespaceHelper() {
        return this.m_namespaceHelper;
    }

    public XSLTTranslator getXSLTTranslator() {
        return this.m_xsltTranslator;
    }
}

