/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xtq.xml.xdm.ref;

import com.ibm.xtq.xml.xdm.XDMCursor;
import com.ibm.xtq.xml.xdm.ref.XDMCursorProxyCursor;

public class XDMLocPathCursor
extends XDMCursorProxyCursor {
    XDMCursor[] path;
    int m_lastCursor;
    int m_position = 0;
    boolean m_isDocOrdered;
    boolean m_isDocOrderedUnique = true;
    boolean m_multiUp = false;
    boolean m_multiDown = false;

    public XDMLocPathCursor(int n, XDMCursor xDMCursor, Object object) {
        super(xDMCursor);
        this.path = new XDMCursor[n > 0 ? n : 10];
        this.path[0] = xDMCursor;
        this.m_lastCursor = 0;
        this.updateStaticDocOrder(0);
    }

    public void addCursor(XDMCursor xDMCursor) {
        if (++this.m_lastCursor >= this.path.length) {
            XDMCursor[] xDMCursorArray = new XDMCursor[this.m_lastCursor + 10];
            System.arraycopy(this.path, 0, xDMCursorArray, 0, this.path.length);
            this.path = xDMCursorArray;
        }
        this.m_currentCursor = this.path[this.m_lastCursor] = xDMCursor;
        this.updateStaticDocOrder(this.m_lastCursor);
    }

    public int getAxis() {
        return 20;
    }

    public boolean isDocOrdered() {
        return this.m_isDocOrdered;
    }

    public void setShouldCacheNodes() {
    }

    public boolean isMutable() {
        return true;
    }

    public int getCurrentPos() {
        return this.m_position;
    }

    public boolean setDocOrdered() {
        if (!this.m_isDocOrdered) {
            boolean bl = true;
            for (int i = this.m_lastCursor; i >= 0; --i) {
                bl &= this.path[i].setDocOrdered();
            }
            this.updateStaticDocOrder(0);
        }
        return this.m_isDocOrdered;
    }

    public boolean setDocOrderedUnique() {
        boolean bl = true;
        for (int i = this.m_lastCursor; i >= 0; --i) {
            bl &= this.path[i].setDocOrderedUnique();
        }
        this.updateStaticDocOrder(0);
        return this.m_isDocOrderedUnique;
    }

    public boolean isUniqueNodes() {
        return this.m_isDocOrderedUnique;
    }

    void updateStaticDocOrder(int n) {
        if (n <= 0) {
            this.m_multiUp = false;
            this.m_multiDown = false;
            this.m_isDocOrdered = this.path[this.m_lastCursor].isDocOrdered();
            this.m_isDocOrderedUnique = true;
            n = 0;
        }
        while (this.m_isDocOrderedUnique && n <= this.m_lastCursor) {
            XDMCursor xDMCursor = this.path[n];
            int n2 = xDMCursor.getAxis();
            switch (n2) {
                case 13: 
                case 19: {
                    break;
                }
                case 2: 
                case 3: 
                case 8: 
                case 9: {
                    this.m_multiDown = true;
                    this.m_isDocOrderedUnique &= !this.m_multiUp;
                    break;
                }
                case 4: 
                case 5: 
                case 14: 
                case 16: 
                case 17: 
                case 18: {
                    this.m_multiDown = true;
                    this.m_isDocOrderedUnique &= !this.m_multiUp;
                    break;
                }
                case 0: 
                case 1: {
                    this.m_multiUp = true;
                    this.m_isDocOrderedUnique &= !this.m_multiDown;
                    break;
                }
                case 7: 
                case 12: {
                    this.m_isDocOrderedUnique &= !this.m_multiUp && !this.m_multiDown;
                    this.m_multiDown = true;
                    break;
                }
                case 6: 
                case 11: 
                case 15: {
                    this.m_isDocOrderedUnique &= !this.m_multiUp && !this.m_multiDown;
                    this.m_multiDown = true;
                    this.m_multiUp = true;
                    break;
                }
                case 10: {
                    this.m_isDocOrderedUnique &= !this.m_multiDown;
                    break;
                }
                default: {
                    this.m_multiDown = true;
                    this.m_multiUp = true;
                    this.m_isDocOrdered &= xDMCursor.isDocOrdered();
                    this.m_isDocOrderedUnique &= xDMCursor.isUniqueNodes();
                }
            }
            ++n;
        }
        this.m_isDocOrdered &= this.m_isDocOrderedUnique;
    }

    public boolean isEmpty() {
        return this.m_position == 0;
    }

    public boolean nextNode() {
        if (this.m_position == 0) {
            return false;
        }
        int n = this.m_lastCursor;
        boolean bl = this.path[n].nextNode();
        while (n >= 0) {
            if (!bl) {
                if (--n < 0) continue;
                bl = this.path[n].nextNode();
                continue;
            }
            if (n == this.m_lastCursor) {
                this.m_currentCursor = this.path[n];
                ++this.m_position;
                return true;
            }
            int n2 = n + 1;
            this.path[n2] = this.path[n2].newContext(this.path[n], null, false);
            n = n2;
            bl = !this.path[n2].isEmpty();
        }
        return false;
    }

    public XDMCursor newContext(XDMCursor xDMCursor, Object object, boolean bl) {
        if (bl) {
            XDMCursor xDMCursor2 = this.path[0].newContext(xDMCursor, object, true);
            XDMLocPathCursor xDMLocPathCursor = new XDMLocPathCursor(this.path.length, xDMCursor2, null);
            for (int i = 1; i <= this.m_lastCursor; ++i) {
                XDMCursor xDMCursor3 = this.path[i].newContext(xDMCursor2, null, true);
                xDMLocPathCursor.addCursor(xDMCursor3);
                xDMCursor2 = xDMCursor3;
            }
            return xDMLocPathCursor;
        }
        for (int i = 0; i <= this.m_lastCursor; ++i) {
            this.path[i] = this.path[i].newContext(xDMCursor, object, bl);
            if (!(xDMCursor = this.path[i]).isEmpty()) continue;
            this.m_position = 0;
            return this;
        }
        this.m_currentCursor = this.path[this.m_lastCursor];
        this.m_position = 1;
        return this;
    }

    public XDMCursor cloneXDMCursor() {
        XDMLocPathCursor xDMLocPathCursor = new XDMLocPathCursor(this.path.length, this.path[0].cloneXDMCursor(), null);
        for (int i = 1; i <= this.m_lastCursor; ++i) {
            xDMLocPathCursor.addCursor(this.path[i].cloneXDMCursor());
        }
        return xDMLocPathCursor;
    }

    public Object clone() {
        return this.cloneXDMCursor();
    }

    public XDMCursor cloneWithReset() throws CloneNotSupportedException {
        XDMCursor xDMCursor = this.path[0].cloneWithReset();
        XDMLocPathCursor xDMLocPathCursor = new XDMLocPathCursor(this.path.length, xDMCursor, null);
        for (int i = 1; i <= this.m_lastCursor; ++i) {
            XDMCursor xDMCursor2 = this.path[i].newContext(xDMCursor, null, true);
            xDMLocPathCursor.addCursor(xDMCursor2);
            xDMCursor = xDMCursor2;
        }
        return xDMLocPathCursor;
    }

    public void resetIteration() {
        this.path[0].resetIteration();
        this.newContext(this.path[0], null, false);
    }
}

