/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xtq.xml.xcollator;

import com.ibm.xtq.xml.xcollator.CollatorDeclarationImpl;
import com.ibm.xtq.xml.xcollator.CollatorFactory;
import com.ibm.xtq.xml.xcollator.CollatorImplBase;
import com.ibm.xtq.xml.xcollator.LocaleUtility;
import com.ibm.xtq.xml.xcollator.ParamCaseOrder;
import com.ibm.xtq.xml.xcollator.ParamDecomposition;
import com.ibm.xtq.xml.xcollator.ParamStrength;
import com.ibm.xtq.xml.xcollator.Range;
import com.ibm.xtq.xml.xcollator.StringSearch;
import java.text.CollationKey;
import java.text.Collator;
import java.text.ParseException;
import java.text.RuleBasedCollator;
import java.util.ArrayList;
import java.util.Locale;

final class JavaCollator
extends CollatorImplBase {
    private static final Locale[] s_Locales = RuleBasedCollator.getAvailableLocales();
    private static final ArrayList s_LocaleNames = new ArrayList();
    private final RuleBasedCollator m_collator;
    private final StringSearch m_search;
    private final JavaCollator m_helperTertiaryCanonical;
    private final JavaCollator m_helperSecondary;
    private static final boolean old_code = false;

    JavaCollator(CollatorDeclarationImpl collatorDeclarationImpl) {
        super(collatorDeclarationImpl, LocaleUtility.IETFToValidLocale(collatorDeclarationImpl.getLanguage(), s_Locales, s_LocaleNames));
        RuleBasedCollator ruleBasedCollator = (RuleBasedCollator)Collator.getInstance(this.m_locale);
        ruleBasedCollator = this.setRules(ruleBasedCollator, collatorDeclarationImpl.getRules());
        JavaCollator.setDecomposition(ruleBasedCollator, collatorDeclarationImpl.getDecompositionType());
        this.m_collator = ruleBasedCollator;
        this.m_search = new StringSearch(ruleBasedCollator);
        this.setStrength(collatorDeclarationImpl.getStrengthType());
        this.m_helperTertiaryCanonical = this.getHelperTertiaryCanonical(this.m_declaration, this.m_locale);
        this.m_helperSecondary = this.getHelperSecondary(this.m_declaration, this.m_locale);
    }

    private JavaCollator(CollatorDeclarationImpl collatorDeclarationImpl, Locale locale) {
        super(collatorDeclarationImpl, locale);
        RuleBasedCollator ruleBasedCollator = (RuleBasedCollator)Collator.getInstance(this.m_locale);
        ruleBasedCollator = this.setRules(ruleBasedCollator, collatorDeclarationImpl.getRules());
        JavaCollator.setDecomposition(ruleBasedCollator, collatorDeclarationImpl.getDecompositionType());
        this.m_collator = ruleBasedCollator;
        this.m_search = new StringSearch(ruleBasedCollator);
        this.setStrength(collatorDeclarationImpl.getStrengthType());
        this.m_helperSecondary = null;
        this.m_helperTertiaryCanonical = null;
    }

    public Object getComparator(String string) {
        return this.m_collator.getCollationKey(string);
    }

    private final int defaultCaseCompare(Object object, Object object2) {
        int n = 0;
        n = object instanceof CollationKey && object2 instanceof CollationKey ? ((CollationKey)object).compareTo((CollationKey)object2) : this.m_collator.compare((String)object, (String)object2);
        return JavaCollator.formatCompareReturn(n);
    }

    public int compare(Object object, Object object2) {
        ParamCaseOrder paramCaseOrder = this.m_declaration.getCaseOrderType();
        int n = this.m_collator.getStrength();
        if (paramCaseOrder == ParamCaseOrder.NOT_SPECIFIED) {
            return this.defaultCaseCompare(object, object2);
        }
        String string = null;
        String string2 = null;
        if (object instanceof CollationKey && object2 instanceof CollationKey) {
            string = ((CollationKey)object).getSourceString();
            string2 = ((CollationKey)object2).getSourceString();
        } else {
            string = (String)object;
            string2 = (String)object2;
        }
        int n2 = 0;
        n2 = n == 0 || n == 1 ? this.defaultCaseCompare(object, object2) : this.m_helperSecondary.defaultCaseCompare(string, string2);
        if (n2 != 0) {
            return n2;
        }
        n2 = this.getCaseDiff(string, string2);
        if (n2 != 0) {
            return n2;
        }
        return this.defaultCaseCompare(object, object2);
    }

    private final int getCaseDiff(String string, String string2) {
        ParamCaseOrder[] paramCaseOrderArray = this.m_helperTertiaryCanonical.m_search.getFirstCaseDiff(string, string2, this.m_locale);
        if (paramCaseOrderArray != null) {
            if (this.m_declaration.getCaseOrderType() == ParamCaseOrder.UPPER_FIRST) {
                if (paramCaseOrderArray[0] == ParamCaseOrder.UPPER_FIRST) {
                    return -1;
                }
                return 1;
            }
            if (paramCaseOrderArray[0] == ParamCaseOrder.LOWER_FIRST) {
                return -1;
            }
            return 1;
        }
        return 0;
    }

    private final RuleBasedCollator setRules(RuleBasedCollator ruleBasedCollator, String string) {
        if (string != null && 0 < string.length()) {
            String string2 = ruleBasedCollator.getRules();
            try {
                ruleBasedCollator = new RuleBasedCollator(string2 + string);
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
        return ruleBasedCollator;
    }

    private static void setDecomposition(RuleBasedCollator ruleBasedCollator, ParamDecomposition paramDecomposition) {
        if (paramDecomposition != ParamDecomposition.NOT_SPECIFIED) {
            int n = paramDecomposition == ParamDecomposition.NO ? 0 : (paramDecomposition == ParamDecomposition.CANONICAL ? 1 : (paramDecomposition == ParamDecomposition.FULL ? 2 : 0));
            ruleBasedCollator.setDecomposition(n);
        }
    }

    private void setStrength(ParamStrength paramStrength) {
        if (paramStrength != null) {
            int n = paramStrength == ParamStrength.PRIMARY ? 0 : (paramStrength == ParamStrength.SECONDARY ? 1 : (paramStrength == ParamStrength.TERTIARY ? 2 : (paramStrength == ParamStrength.IDENTICAL ? 3 : 2)));
            this.setStrength(n);
        }
    }

    private void setStrength(int n) {
        this.m_collator.setStrength(n);
        this.m_search.resetMaskStrength();
    }

    private JavaCollator getHelperTertiaryCanonical(CollatorDeclarationImpl collatorDeclarationImpl, Locale locale) {
        JavaCollator javaCollator;
        if (collatorDeclarationImpl.getStrengthType() == ParamStrength.TERTIARY && collatorDeclarationImpl.getDecompositionType() == ParamDecomposition.CANONICAL) {
            javaCollator = this;
        } else {
            CollatorDeclarationImpl collatorDeclarationImpl2 = (CollatorDeclarationImpl)CollatorFactory.getCollatorDeclaration(collatorDeclarationImpl.getName() + "/?strength=tertiary?decomposition=primary", collatorDeclarationImpl.getLanguage(), ParamDecomposition.CANONICAL.getValue(), ParamStrength.TERTIARY.getValue(), collatorDeclarationImpl.getRules(), collatorDeclarationImpl.getCaseOrderType().getValue(), this.getClass().getName());
            javaCollator = new JavaCollator(collatorDeclarationImpl2, locale);
        }
        return javaCollator;
    }

    private JavaCollator getHelperSecondary(CollatorDeclarationImpl collatorDeclarationImpl, Locale locale) {
        JavaCollator javaCollator;
        ParamStrength paramStrength = collatorDeclarationImpl.getStrengthType();
        if (paramStrength == ParamStrength.PRIMARY || paramStrength == ParamStrength.SECONDARY) {
            javaCollator = this;
        } else {
            CollatorDeclarationImpl collatorDeclarationImpl2 = (CollatorDeclarationImpl)CollatorFactory.getCollatorDeclaration(collatorDeclarationImpl.getName() + "/?strength=primary", collatorDeclarationImpl.getLanguage(), collatorDeclarationImpl.getDecompositionType().getValue(), ParamStrength.SECONDARY.getValue(), collatorDeclarationImpl.getRules(), collatorDeclarationImpl.getCaseOrderType().getValue(), this.getClass().getName());
            javaCollator = new JavaCollator(collatorDeclarationImpl2, locale);
        }
        return javaCollator;
    }

    Range[] allOccurances(String string, String string2) {
        return this.m_search.allOccurances(string, string2);
    }

    Range firstOccurance(String string, String string2) {
        return this.m_search.firstOccurance(string, string2);
    }

    Range lastOccurance(String string, String string2) {
        return this.m_search.lastOccurance(string, string2);
    }

    static Locale getLocaleSupported(String string) {
        Locale locale = LocaleUtility.IETFToValidLocale(string, s_Locales, s_LocaleNames);
        return locale;
    }

    static {
        for (int i = 0; i < s_Locales.length; ++i) {
            s_LocaleNames.add(s_Locales[i].toString());
        }
    }
}

