/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xtq.xml.datamodel;

import com.ibm.xtq.xml.datamodel.XDecimal;
import com.ibm.xtq.xml.datamodel.XDouble;
import com.ibm.xtq.xml.datamodel.XFloat;
import com.ibm.xtq.xml.datamodel.XItem;
import com.ibm.xtq.xml.datamodel.XItemBase;
import com.ibm.xtq.xml.datamodel.XUntypedAtomic;
import com.ibm.xtq.xml.types.ItemType;
import com.ibm.xtq.xml.types.TypeConstants;
import com.ibm.xtq.xml.types.TypeError;
import com.ibm.xtq.xml.xdm.res.XMLMessages;
import java.math.BigDecimal;
import java.math.BigInteger;

public class XInteger
extends XItemBase {
    public static final BigInteger LONG_MAX = BigInteger.valueOf(Long.MAX_VALUE);
    public static final BigInteger LONG_MIN = BigInteger.valueOf(Long.MIN_VALUE);
    public static final BigInteger INT_MAX = BigInteger.valueOf(Integer.MAX_VALUE);
    public static final BigInteger INT_MIN = BigInteger.valueOf(Integer.MIN_VALUE);
    public static final BigInteger SHORT_MAX = BigInteger.valueOf(32767L);
    public static final BigInteger SHORT_MIN = BigInteger.valueOf(-32768L);
    public static final BigInteger BYTE_MAX = BigInteger.valueOf(127L);
    public static final BigInteger BYTE_MIN = BigInteger.valueOf(-128L);
    public static final BigInteger UNSIGNEDLONG_MAX = new BigInteger("18446744073709551615");
    public static final BigInteger UNSIGNEDINT_MAX = BigInteger.valueOf(0xFFFFFFFFL);
    public static final BigInteger UNSIGNEDSHORT_MAX = BigInteger.valueOf(65535L);
    public static final BigInteger UNSIGNEDBYTE_MAX = BigInteger.valueOf(255L);
    private BigInteger m_value;

    public XInteger(BigInteger bigInteger) {
        this.m_value = bigInteger;
        this.m_type = TypeConstants.INTEGER;
    }

    public XInteger(BigInteger bigInteger, ItemType itemType) {
        this.m_value = bigInteger;
        this.m_type = itemType;
    }

    public int getPrimitiveId() {
        return 5;
    }

    public static XInteger valueOf(BigInteger bigInteger) {
        return new XInteger(bigInteger);
    }

    public static XInteger valueOf(String string) {
        return new XInteger(new BigInteger(string));
    }

    public BigInteger getCurrentItemAsInteger() throws TypeError {
        return this.m_value;
    }

    public BigDecimal getCurrentItemAsDecimal() throws TypeError {
        return new BigDecimal(this.m_value);
    }

    public float getCurrentItemAsFloat() throws TypeError {
        return this.m_value.floatValue();
    }

    public double getCurrentItemAsDouble() throws TypeError {
        return this.m_value.doubleValue();
    }

    public boolean toBoolean() {
        return this.m_value.signum() != 0;
    }

    public BigDecimal toDecimal() {
        return new BigDecimal(this.m_value);
    }

    public double toDouble() {
        return this.m_value.doubleValue();
    }

    public float toFloat() {
        return this.m_value.floatValue();
    }

    public BigInteger toInteger() {
        return this.m_value;
    }

    public String toString() {
        return this.m_value.toString();
    }

    public XUntypedAtomic toUntypedAtomic() {
        return new XUntypedAtomic(this.toString());
    }

    public XItem add(XItem xItem) throws TypeError {
        switch (xItem.getPrimitiveId()) {
            case 5: {
                return new XInteger(this.m_value.add(xItem.toInteger()));
            }
            case 4: {
                return new XDecimal(this.toDecimal().add(xItem.toDecimal()));
            }
            case 2: {
                return new XFloat(this.m_value.floatValue() + xItem.toFloat());
            }
            case 0: 
            case 3: {
                return new XDouble(this.m_value.doubleValue() + xItem.toDouble());
            }
        }
        throw new TypeError();
    }

    public BigInteger add(BigInteger bigInteger) throws TypeError {
        return this.m_value.add(bigInteger);
    }

    public XItem subtract(XItem xItem) throws TypeError {
        switch (xItem.getPrimitiveId()) {
            case 5: {
                return new XInteger(this.m_value.subtract(xItem.toInteger()));
            }
            case 4: {
                return new XDecimal(this.toDecimal().subtract(xItem.toDecimal()));
            }
            case 2: {
                return new XFloat(this.m_value.floatValue() - xItem.toFloat());
            }
            case 0: 
            case 3: {
                return new XDouble(this.m_value.doubleValue() - xItem.toDouble());
            }
        }
        throw new TypeError();
    }

    public BigInteger subtract(BigInteger bigInteger) throws TypeError {
        return this.m_value.subtract(bigInteger);
    }

    public XItem multiply(XItem xItem) throws TypeError {
        switch (xItem.getPrimitiveId()) {
            case 5: {
                return new XInteger(this.m_value.multiply(xItem.toInteger()));
            }
            case 4: {
                return new XDecimal(this.toDecimal().multiply(xItem.toDecimal()));
            }
            case 2: {
                return new XFloat(this.m_value.floatValue() * xItem.toFloat());
            }
            case 0: 
            case 3: {
                return new XDouble(this.m_value.doubleValue() * xItem.toDouble());
            }
            case 8: {
                return xItem.toDayTimeDuration().multiply(this.toDouble());
            }
            case 7: {
                return xItem.toYearMonthDuration().multiply(this.toDouble());
            }
        }
        throw new TypeError();
    }

    public BigInteger multiply(BigInteger bigInteger) throws TypeError {
        return this.m_value.multiply(bigInteger);
    }

    public XItem divide(XItem xItem) throws TypeError {
        switch (xItem.getPrimitiveId()) {
            case 5: {
                return new XDecimal(this.divide(xItem.toInteger()));
            }
            case 4: {
                BigDecimal bigDecimal = xItem.toDecimal();
                int n = bigDecimal.scale() + 20;
                return new XDecimal(this.toDecimal().divide(xItem.toDecimal(), n, 6));
            }
            case 2: {
                return new XFloat(this.m_value.floatValue() * xItem.toFloat());
            }
            case 0: 
            case 3: {
                return new XDouble(this.m_value.doubleValue() * xItem.toDouble());
            }
        }
        throw new TypeError();
    }

    public final BigDecimal divide(BigInteger bigInteger) {
        BigDecimal bigDecimal = new BigDecimal(this.m_value);
        BigDecimal bigDecimal2 = new BigDecimal(bigInteger);
        return bigDecimal.divide(bigDecimal2, 20, 6);
    }

    public XItem idiv(XItem xItem) throws TypeError {
        switch (xItem.getPrimitiveId()) {
            case 0: 
            case 5: {
                return new XInteger(this.m_value.divide(xItem.toInteger()));
            }
        }
        throw new TypeError();
    }

    public BigInteger idiv(BigInteger bigInteger) throws TypeError {
        return this.m_value.divide(bigInteger);
    }

    public final XItem mod(XItem xItem) throws TypeError {
        switch (xItem.getPrimitiveId()) {
            case 5: {
                return new XInteger(this.mod(xItem.toInteger()));
            }
            case 4: {
                XDecimal xDecimal = new XDecimal(this.toDecimal());
                return new XDecimal(xDecimal.mod(xItem.toDecimal()));
            }
            case 2: {
                return new XFloat(this.toFloat() % xItem.toFloat());
            }
            case 0: 
            case 3: {
                return new XDouble(this.toDouble() % xItem.toDouble());
            }
        }
        throw new TypeError(XMLMessages.createXMLMessage("TYPE_ERR_TYPE_UNMATCH", new Object[]{this.getType(), xItem.getType()}));
    }

    public final BigInteger mod(BigInteger bigInteger) throws TypeError {
        BigInteger[] bigIntegerArray = this.m_value.divideAndRemainder(bigInteger);
        return bigIntegerArray[1];
    }

    public XItem negate() throws TypeError {
        return new XInteger(this.m_value.negate());
    }

    public BigInteger _negate() throws TypeError {
        return this.m_value.negate();
    }

    public boolean equals(XItem xItem) throws TypeError {
        switch (xItem.getPrimitiveId()) {
            case 5: {
                return this.m_value.compareTo(xItem.toInteger()) == 0;
            }
            case 4: {
                return this.toDecimal().compareTo(xItem.toDecimal()) == 0;
            }
            case 2: {
                float f = XFloat.compare(this.m_value.floatValue(), xItem.toFloat());
                if (Float.isNaN(f)) {
                    return false;
                }
                return f == 0.0f;
            }
            case 3: {
                double d = XDouble.compare(this.m_value.doubleValue(), xItem.toDouble());
                if (Double.isNaN(d)) {
                    return false;
                }
                return d == 0.0;
            }
        }
        throw new TypeError();
    }

    public final boolean equals(BigInteger bigInteger) throws TypeError {
        return this.m_value.compareTo(bigInteger) == 0;
    }

    public final boolean notEquals(BigInteger bigInteger) throws TypeError {
        return !this.equals(bigInteger);
    }

    public int compareTo(XItem xItem) throws TypeError {
        switch (xItem.getPrimitiveId()) {
            case 5: {
                return this.m_value.compareTo(xItem.toInteger());
            }
            case 4: {
                return this.toDecimal().compareTo(xItem.toDecimal());
            }
            case 2: {
                return (int)XFloat.compare(this.toFloat(), xItem.toFloat());
            }
            case 3: {
                return (int)XDouble.compare(this.toDouble(), xItem.toDouble());
            }
        }
        throw new TypeError(XMLMessages.createXMLMessage("TYPE_ERR_TYPE_UNMATCH", new Object[]{this.getType(), xItem.getType()}));
    }

    public final int compareTo(BigInteger bigInteger) throws TypeError {
        return this.m_value.compareTo(bigInteger);
    }

    public final boolean greaterThan(BigInteger bigInteger) throws TypeError {
        return this.compareTo(bigInteger) > 0;
    }

    public final boolean greaterOrEquals(BigInteger bigInteger) throws TypeError {
        return this.compareTo(bigInteger) >= 0;
    }

    public final boolean lessThan(BigInteger bigInteger) throws TypeError {
        return this.compareTo(bigInteger) < 0;
    }

    public final boolean lessOrEquals(BigInteger bigInteger) throws TypeError {
        return this.compareTo(bigInteger) <= 0;
    }
}

