/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xtq.ast.nodes;

import com.ibm.xtq.ast.nodes.Expr;
import com.ibm.xtq.ast.nodes.Node;
import com.ibm.xtq.ast.nodes.OrderSpec;
import com.ibm.xtq.ast.nodes.QuantifiedExpr;
import com.ibm.xtq.ast.nodes.SimpleNode;
import com.ibm.xtq.ast.nodes.TypeExpr;
import com.ibm.xtq.ast.nodes.VarDecl;
import com.ibm.xtq.ast.nodes.VariableRef;
import com.ibm.xtq.ast.nodes.WhereClause;
import com.ibm.xtq.ast.parsers.xpath.tempconstructors.ILetClause;
import com.ibm.xtq.ast.parsers.xpath.tempconstructors.IPositionalVar;
import com.ibm.xtq.ast.parsers.xslt.ASTBuildingContext;
import com.ibm.xtq.utils.XPathError;
import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.QName;

public class FLWORExpr
extends QuantifiedExpr {
    protected Expr _where = null;
    public static final int NO_MODIFIERS = 0;
    public static final int ASCENDING = 1;
    public static final int DESCENDING = 2;
    public static final int EMPTY_GREATEST = 4;
    public static final int EMPTY_LEAST = 8;
    public static final int ASCENDING_EMPTY_GREATEST = 5;
    public static final int ASCENDING_EMPTY_LEAST = 9;
    public static final int DESCENDING_EMPTY_GREATEST = 6;
    public static final int DESCENDING_EMPTY_LEAST = 10;
    private static final Integer[] MODIFIERS = new Integer[]{new Integer(0), new Integer(1), new Integer(2), null, new Integer(4), new Integer(5), new Integer(6), null, new Integer(8), new Integer(9), new Integer(10)};
    private static final String[] STRING_MODIFIERS = new String[]{null, "ascending", "descending", null, "empty greatest", "ascending empty greatest", "descending empty greatest", null, "empty least", "ascending empty least", "descending empty least"};
    protected boolean m_orderByStable;
    protected List m_osExprList;
    protected List m_osModifiersList;
    protected List m_osCollationList;

    public FLWORExpr(int n) {
        super(n);
    }

    public String toString(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        this.getXQueryString(stringBuffer, false, "  ");
        return stringBuffer.toString();
    }

    public static String getModifierAsString(int n) {
        return STRING_MODIFIERS[n];
    }

    public void getXQueryString(StringBuffer stringBuffer, boolean bl, String string) {
        int n;
        int n2 = -1;
        for (n = 0; n < this._vardecls.size(); ++n) {
            VariableRef variableRef;
            VarDecl varDecl = this.getVardecl(n);
            int n3 = varDecl.getId();
            if (n3 != n2) {
                n2 = n3;
                if (n > 0) {
                    stringBuffer.append("\n");
                }
                if (n3 == 45) {
                    stringBuffer.append(string).append("let").append(' ');
                } else {
                    stringBuffer.append(string).append("for").append(' ');
                }
                if (n == 0) {
                    string = string + "  ";
                }
            } else {
                stringBuffer.append(", ");
            }
            QName qName = varDecl.getQName();
            stringBuffer.append("$").append(qName).append(" ");
            TypeExpr typeExpr = varDecl.getType();
            if (typeExpr != null) {
                stringBuffer.append(" as ");
                typeExpr.getXQueryString(stringBuffer, bl, string + " ");
            }
            if ((variableRef = varDecl.getPositionalVar()) != null) {
                stringBuffer.append(" at ");
                variableRef.getXQueryString(stringBuffer, bl, string + " ");
                stringBuffer.append(" ");
            }
            if (n3 == 45) {
                stringBuffer.append(":=").append(' ');
            } else {
                stringBuffer.append("in").append(' ');
            }
            Expr expr = varDecl.getExpression();
            expr.getXQueryString(stringBuffer, bl, string);
        }
        if (this.getOrderSpecCount() > 0) {
            if (this.isOrderByStable()) {
                stringBuffer.append(" stable");
            }
            stringBuffer.append("\n" + string + " order by");
            for (n = 0; n < this.getOrderSpecCount(); ++n) {
                String string2;
                if (n > 0) {
                    stringBuffer.append(",");
                }
                stringBuffer.append(" ");
                ((SimpleNode)this.getOrderSpecExpr(n)).getXQueryString(stringBuffer, bl, string);
                int n4 = this.getOrderSpecModifiers(n);
                if (n4 != 0) {
                    stringBuffer.append(" ").append(STRING_MODIFIERS[n4]);
                }
                if ((string2 = this.getOrderSpecCollation(n)) == null) continue;
                stringBuffer.append(" collation \"").append(string2).append("\"");
            }
        }
        stringBuffer.append('\n').append(string).append("return").append(' ');
        this._resExpr.getXQueryString(stringBuffer, bl, string + " ");
    }

    public Expr addOrderSpec(Expr expr, int n, String string) {
        return this.insertOrderSpec(this.getOrderSpecCount(), expr, n, string);
    }

    public String getOrderSpecCollation(int n) {
        if (this.getOrderSpecCount() > n) {
            return (String)this.m_osCollationList.get(n);
        }
        throw new IndexOutOfBoundsException();
    }

    public int getOrderSpecCount() {
        return this.m_osExprList == null ? 0 : this.m_osExprList.size();
    }

    public Expr getOrderSpecExpr(int n) {
        if (this.getOrderSpecCount() > n) {
            return (Expr)this.m_osExprList.get(n);
        }
        throw new IndexOutOfBoundsException();
    }

    public int getOrderSpecModifiers(int n) {
        if (this.getOrderSpecCount() > n) {
            return (Integer)this.m_osModifiersList.get(n);
        }
        throw new IndexOutOfBoundsException();
    }

    public Expr insertOrderSpec(int n, Expr expr, int n2, String string) {
        if (this.getOrderSpecCount() < n) {
            throw new IndexOutOfBoundsException();
        }
        if (n2 < 0 || n2 == 3 || n2 == 7 || n2 >= MODIFIERS.length) {
            throw new XPathError("ERR_INVALID_MODIFIER", new Integer(n2));
        }
        if (this.m_osExprList == null) {
            this.m_osExprList = new ArrayList(1);
            this.m_osCollationList = new ArrayList(1);
            this.m_osModifiersList = new ArrayList(1);
        }
        expr = FLWORExpr.parentless(expr);
        this.m_osCollationList.add(n, string);
        this.m_osExprList.add(n, expr);
        this.m_osModifiersList.add(n, MODIFIERS[n2]);
        return expr;
    }

    public boolean isOrderByStable() {
        if (this.getOrderSpecCount() == 0) {
            throw new XPathError("ERR_SYSTEM", "It is an invalid method call when there is no order by clause.");
        }
        return this.m_orderByStable;
    }

    public void setStableOrderBy(boolean bl) {
        if (this.getOrderSpecCount() == 0) {
            throw new XPathError("ERR_SYSTEM", "It is an invalid method call when there is no order by clause.");
        }
        this.m_orderByStable = bl;
    }

    public void removeOrderSpec(int n) {
        if (this.getOrderSpecCount() <= n) {
            throw new IndexOutOfBoundsException();
        }
        this.m_osCollationList.remove(n);
        Expr expr = (Expr)this.m_osExprList.remove(n);
        expr.jjtSetParent(null);
        this.m_osModifiersList.remove(n);
    }

    public Expr replaceOrderSpec(int n, Expr expr, int n2, String string) {
        this.removeOrderSpec(n);
        return this.insertOrderSpec(n, expr, n2, string);
    }

    public void jjtAddChild(ASTBuildingContext aSTBuildingContext, Node node, int n) {
        switch (node.getId()) {
            case 43: 
            case 47: 
            case 48: {
                this.addChildrenOfUselessNode(aSTBuildingContext, node, n);
                break;
            }
            case 46: {
                SimpleNode simpleNode = (SimpleNode)((WhereClause)node).jjtGetChild(0);
                this._where = (Expr)this.reducedNode(aSTBuildingContext, simpleNode);
                break;
            }
            case 45: {
                ILetClause iLetClause = (ILetClause)node;
                this._vardecls.addAll(iLetClause.getVardecls());
                break;
            }
            case 49: {
                OrderSpec orderSpec = (OrderSpec)node;
                this.insertOrderSpec(0, (Expr)orderSpec.jjtGetChild(0), orderSpec.getOrderModifier(), orderSpec.getCollation());
                break;
            }
            case 44: {
                IPositionalVar iPositionalVar = (IPositionalVar)node;
                VariableRef variableRef = (VariableRef)iPositionalVar.jjtGetChild(0);
                VarDecl varDecl = this.getVardecl(0);
                varDecl.setPositionalVar(variableRef);
                break;
            }
            default: {
                super.jjtAddChild(aSTBuildingContext, node, n);
            }
        }
    }
}

