/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.jgss.mech.spnego;

import com.ibm.security.util.DerInputStream;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import com.ibm.security.util.ObjectIdentifier;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.Oid;

class MechTypeList {
    private Oid[] list;

    public MechTypeList(Oid[] oidArray) {
        if (oidArray == null || oidArray.length == 0) {
            throw new IllegalArgumentException("OIDs must not be null or empty");
        }
        this.list = (Oid[])oidArray.clone();
    }

    public MechTypeList(String[] stringArray) throws IllegalArgumentException {
        if (stringArray == null || stringArray.length == 0) {
            throw new IllegalArgumentException("OIDs must not be null or empty");
        }
        this.list = new Oid[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            try {
                this.list[i] = new Oid(stringArray[i]);
                continue;
            }
            catch (Exception exception) {
                throw new IllegalArgumentException("Invalid OID string");
            }
        }
    }

    public MechTypeList(DerInputStream derInputStream) throws GSSException, IOException {
        this.decode(derInputStream);
    }

    private void decode(DerInputStream derInputStream) throws GSSException, IOException {
        DerValue[] derValueArray = derInputStream.getSequence(3);
        this.list = new Oid[derValueArray.length];
        for (int i = 0; i < derValueArray.length; ++i) {
            ObjectIdentifier objectIdentifier = new ObjectIdentifier(new DerInputStream(derValueArray[i].toByteArray()));
            this.list[i] = new Oid(objectIdentifier.toString());
        }
    }

    public byte[] encode() throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        for (int i = 0; i < this.list.length; ++i) {
            ObjectIdentifier objectIdentifier = new ObjectIdentifier(this.list[i].toString());
            DerOutputStream derOutputStream = new DerOutputStream();
            derOutputStream.putOID(objectIdentifier);
            byteArrayOutputStream.write(derOutputStream.toByteArray());
        }
        DerValue derValue = new DerValue(48, byteArrayOutputStream.toByteArray());
        byteArrayOutputStream.close();
        return derValue.toByteArray();
    }

    public Oid[] getMechs() {
        return (Oid[])this.list.clone();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("MechTypeList:[");
        for (int i = 0; i < this.list.length; ++i) {
            stringBuffer.append(this.list[i] + "\n");
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }
}

