/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.cs;

import com.ibm.jvm.io.LocalizedInputStream;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CoderResult;
import java.nio.charset.CodingErrorAction;
import java.nio.charset.IllegalCharsetNameException;
import java.security.AccessController;
import sun.io.ByteToCharConverter;
import sun.io.ConversionBufferFullException;
import sun.nio.cs.HistoricallyNamedCharset;
import sun.security.action.GetPropertyAction;

public abstract class StreamDecoder
extends Reader {
    private static final int MIN_BYTE_BUFFER_SIZE = 32;
    private static final int DEFAULT_BYTE_BUFFER_SIZE = 8192;
    private volatile boolean isOpen = true;
    static final boolean useIo;
    private boolean haveLeftoverChar = false;
    private char leftoverChar;
    private static volatile boolean channelsAvailable;

    private StreamDecoder() {
    }

    private StreamDecoder(Object object) {
        super(object);
    }

    private void ensureOpen() throws IOException {
        if (!this.isOpen) {
            throw new IOException("Stream closed");
        }
    }

    abstract int implRead(char[] var1, int var2, int var3) throws IOException;

    abstract String encodingName();

    abstract boolean implReady();

    abstract void implClose() throws IOException;

    public static StreamDecoder forInputStreamReader(InputStream inputStream, Object object, String string) throws UnsupportedEncodingException {
        String string2 = string;
        if (string2 == null) {
            InputStream inputStream2;
            if (LocalizedInputStream.nonASCIIPlatform && (inputStream2 = LocalizedInputStream.localize(inputStream)) instanceof LocalizedInputStream) {
                if (useIo) {
                    return new LocalizedConverterSD(inputStream, object);
                }
                return new LocalizedCharsetSD(inputStream, object);
            }
            string2 = Charset.defaultCharset().name();
        }
        if (useIo) {
            try {
                return new ConverterSD(inputStream, object, string2);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                try {
                    if (Charset.isSupported(string2)) {
                        return new CharsetSD(inputStream, object, Charset.forName(string2));
                    }
                }
                catch (IllegalCharsetNameException illegalCharsetNameException) {
                    // empty catch block
                }
                throw unsupportedEncodingException;
            }
        }
        try {
            if (Charset.isSupported(string2)) {
                return new CharsetSD(inputStream, object, Charset.forName(string2));
            }
        }
        catch (IllegalCharsetNameException illegalCharsetNameException) {
            // empty catch block
        }
        throw new UnsupportedEncodingException(string2);
    }

    public static StreamDecoder forInputStreamReader(InputStream inputStream, Object object, Charset charset) {
        return new CharsetSD(inputStream, object, charset);
    }

    public static StreamDecoder forInputStreamReader(InputStream inputStream, Object object, CharsetDecoder charsetDecoder) {
        return new CharsetSD(inputStream, object, charsetDecoder);
    }

    public static StreamDecoder forDecoder(ReadableByteChannel readableByteChannel, CharsetDecoder charsetDecoder, int n) {
        return new CharsetSD(readableByteChannel, charsetDecoder, n);
    }

    public String getEncoding() {
        if (this.isOpen()) {
            return this.encodingName();
        }
        return null;
    }

    public int read() throws IOException {
        return this.read0();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int read0() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (this.haveLeftoverChar) {
                this.haveLeftoverChar = false;
                return this.leftoverChar;
            }
            char[] cArray = new char[2];
            int n = this.read(cArray, 0, 2);
            switch (n) {
                case -1: {
                    return -1;
                }
                case 2: {
                    this.leftoverChar = cArray[1];
                    this.haveLeftoverChar = true;
                }
                case 1: {
                    return cArray[0];
                }
            }
            assert (false) : n;
            return -1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int read(char[] cArray, int n, int n2) throws IOException {
        int n3 = n;
        int n4 = n2;
        Object object = this.lock;
        synchronized (object) {
            this.ensureOpen();
            if (n3 < 0 || n3 > cArray.length || n4 < 0 || n3 + n4 > cArray.length || n3 + n4 < 0) {
                throw new IndexOutOfBoundsException();
            }
            if (n4 == 0) {
                return 0;
            }
            int n5 = 0;
            if (this.haveLeftoverChar) {
                cArray[n3] = this.leftoverChar;
                ++n3;
                this.haveLeftoverChar = false;
                n5 = 1;
                if (--n4 == 0 || !this.implReady()) {
                    return n5;
                }
            }
            if (n4 == 1) {
                int n6 = this.read0();
                if (n6 == -1) {
                    return n5 == 0 ? -1 : n5;
                }
                cArray[n3] = (char)n6;
                return n5 + 1;
            }
            return n5 + this.implRead(cArray, n3, n3 + n4);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean ready() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.ensureOpen();
            return this.haveLeftoverChar || this.implReady();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (!this.isOpen) {
                return;
            }
            this.implClose();
            this.isOpen = false;
        }
    }

    private boolean isOpen() {
        return this.isOpen;
    }

    private static FileChannel getChannel(FileInputStream fileInputStream) {
        if (!channelsAvailable) {
            return null;
        }
        try {
            return fileInputStream.getChannel();
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            channelsAvailable = false;
            return null;
        }
    }

    static {
        GetPropertyAction getPropertyAction = new GetPropertyAction("ibm.stream.io");
        String string = AccessController.doPrivileged(getPropertyAction);
        useIo = string != null;
        channelsAvailable = true;
    }

    private static class LocalizedCharsetSD
    extends LocalizedSD {
        LocalizedCharsetSD(InputStream inputStream, Object object) throws UnsupportedEncodingException {
            super(inputStream, object);
        }

        LocalizedCharsetSD(ReadableByteChannel readableByteChannel, String string) throws UnsupportedEncodingException {
            super(readableByteChannel, string);
        }

        StreamDecoder setStreamDecoder(InputStream inputStream, Object object, String string) throws UnsupportedEncodingException {
            try {
                if (Charset.isSupported(string)) {
                    return new CharsetSD(inputStream, object, Charset.forName(string));
                }
            }
            catch (IllegalCharsetNameException illegalCharsetNameException) {
                // empty catch block
            }
            return new ConverterSD(inputStream, object, string);
        }
    }

    private static class LocalizedConverterSD
    extends LocalizedSD {
        LocalizedConverterSD(InputStream inputStream, Object object) throws UnsupportedEncodingException {
            super(inputStream, object);
        }

        LocalizedConverterSD(ReadableByteChannel readableByteChannel, String string) throws UnsupportedEncodingException {
            super(readableByteChannel, string);
        }

        StreamDecoder setStreamDecoder(InputStream inputStream, Object object, String string) throws UnsupportedEncodingException {
            try {
                return new ConverterSD(inputStream, object, string);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                try {
                    if (Charset.isSupported(string)) {
                        return new CharsetSD(inputStream, object, Charset.forName(string));
                    }
                }
                catch (IllegalCharsetNameException illegalCharsetNameException) {
                    // empty catch block
                }
                throw unsupportedEncodingException;
            }
        }
    }

    private static abstract class LocalizedSD
    extends StreamDecoder {
        private StreamDecoder sd;
        private BufferedInputStream bin;
        private Object lock;
        static final String ASCIIEncoding;
        static final String EBCDICEncoding;

        LocalizedSD(InputStream inputStream, Object object) throws UnsupportedEncodingException {
            super(object);
            this.bin = new BufferedInputStream(inputStream);
            this.lock = object;
        }

        LocalizedSD(ReadableByteChannel readableByteChannel, String string) throws UnsupportedEncodingException {
            this(Channels.newInputStream(readableByteChannel), (Object)null);
            this.lock = this;
        }

        String encodingName() {
            if (this.sd == null) {
                try {
                    this.sdInit();
                }
                catch (IOException iOException) {
                    return null;
                }
            }
            return this.sd.encodingName();
        }

        boolean implReady() {
            if (this.sd == null) {
                try {
                    this.sdInit();
                }
                catch (IOException iOException) {
                    return false;
                }
            }
            return this.sd.implReady();
        }

        void implClose() throws IOException {
            if (this.sd == null) {
                this.bin.close();
            } else {
                this.sd.implClose();
            }
        }

        int implRead(char[] cArray, int n, int n2) throws IOException {
            if (this.sd == null) {
                this.sdInit();
            }
            return this.sd.implRead(cArray, n, n2);
        }

        private void sdInit() throws IOException {
            boolean bl = false;
            boolean bl2 = false;
            this.bin.mark(1001);
            for (int i = 0; i < 1000; ++i) {
                int n;
                try {
                    if (i > 0 && this.bin.available() <= 0) break;
                    n = this.bin.read();
                }
                catch (IOException iOException) {
                    break;
                }
                if (n == -1) break;
                if (n == 35 || n == 61 || n == 10) {
                    bl = true;
                    break;
                }
                if (n != 21) continue;
                bl2 = true;
                break;
            }
            this.bin.reset();
            try {
                this.sd = bl2 ? this.setStreamDecoder(this.bin, this.lock, EBCDICEncoding) : (bl ? this.setStreamDecoder(this.bin, this.lock, ASCIIEncoding) : this.setStreamDecoder(this.bin, this.lock, Charset.defaultCharset().name()));
            }
            catch (Exception exception) {
                throw (IOException)new IOException().initCause(exception);
            }
        }

        abstract StreamDecoder setStreamDecoder(InputStream var1, Object var2, String var3) throws UnsupportedEncodingException;

        static {
            String string;
            String string2 = AccessController.doPrivileged(new GetPropertyAction("ibm.ascii.encoding"));
            if (string2 == null) {
                string2 = "8859_1";
            }
            if ((string = AccessController.doPrivileged(new GetPropertyAction("ibm.ebcdic.encoding"))) == null) {
                string = AccessController.doPrivileged(new GetPropertyAction("ibm.system.encoding"));
            }
            ASCIIEncoding = string2;
            EBCDICEncoding = string;
        }
    }

    private static class CharsetSD
    extends StreamDecoder {
        private Charset cs;
        private CharsetDecoder decoder;
        private ByteBuffer bb;
        private InputStream in;
        private ReadableByteChannel ch;

        CharsetSD(Object object) {
            super(object);
        }

        CharsetSD(InputStream inputStream, Object object, Charset charset) {
            this(inputStream, object, charset.newDecoder().onMalformedInput(CodingErrorAction.REPLACE).onUnmappableCharacter(CodingErrorAction.REPLACE));
        }

        CharsetSD(InputStream inputStream, Object object, CharsetDecoder charsetDecoder) {
            super(object);
            this.cs = charsetDecoder.charset();
            this.decoder = charsetDecoder;
            if (this.ch == null) {
                this.in = inputStream;
                this.ch = null;
                this.bb = ByteBuffer.allocate(8192);
            }
            this.bb.flip();
        }

        CharsetSD(ReadableByteChannel readableByteChannel, CharsetDecoder charsetDecoder, int n) {
            this.in = null;
            this.ch = readableByteChannel;
            this.decoder = charsetDecoder;
            this.cs = charsetDecoder.charset();
            this.bb = ByteBuffer.allocate(n < 0 ? 8192 : (n < 32 ? 32 : n));
            this.bb.flip();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private int readBytes() throws IOException {
            int n;
            block9: {
                int n2;
                block11: {
                    int n3;
                    block10: {
                        this.bb.compact();
                        try {
                            int n4;
                            if (this.ch != null) {
                                n = this.ch.read(this.bb);
                                if (n >= 0) break block9;
                                n3 = n;
                                Object var7_4 = null;
                                break block10;
                            }
                            n = this.bb.limit();
                            int n5 = this.bb.position();
                            assert (n5 <= n);
                            int n6 = n4 = n5 <= n ? n - n5 : 0;
                            assert (n4 > 0);
                            int n7 = this.in.read(this.bb.array(), this.bb.arrayOffset() + n5, n4);
                            if (n7 < 0) {
                                n2 = n7;
                                break block11;
                            }
                            if (n7 == 0) {
                                throw new IOException("Underlying input stream returned zero bytes");
                            }
                            assert (n7 <= n4) : "n = " + n7 + ", rem = " + n4;
                            this.bb.position(n5 + n7);
                            break block9;
                        }
                        catch (Throwable throwable) {
                            Object var7_7 = null;
                            this.bb.flip();
                            throw throwable;
                        }
                    }
                    this.bb.flip();
                    return n3;
                }
                Object var7_5 = null;
                this.bb.flip();
                return n2;
            }
            Object var7_6 = null;
            this.bb.flip();
            n = this.bb.remaining();
            assert (n != 0) : n;
            return n;
        }

        int implRead(char[] cArray, int n, int n2) throws IOException {
            assert (n2 - n > 1);
            CharBuffer charBuffer = CharBuffer.wrap(cArray, n, n2 - n);
            if (charBuffer.position() != 0) {
                charBuffer = charBuffer.slice();
            }
            boolean bl = false;
            while (true) {
                CoderResult coderResult;
                if ((coderResult = this.decoder.decode(this.bb, charBuffer, bl)).isUnderflow()) {
                    if (bl || !charBuffer.hasRemaining() || charBuffer.position() > 0 && !this.inReady()) break;
                    int n3 = this.readBytes();
                    if (n3 >= 0) continue;
                    bl = true;
                    if (charBuffer.position() == 0 && !this.bb.hasRemaining()) break;
                    this.decoder.reset();
                    continue;
                }
                if (coderResult.isOverflow()) {
                    assert (charBuffer.position() > 0);
                    break;
                }
                coderResult.throwException();
            }
            if (bl) {
                this.decoder.reset();
            }
            if (charBuffer.position() == 0) {
                if (bl) {
                    return -1;
                }
                assert (false);
            }
            return charBuffer.position();
        }

        String encodingName() {
            return this.cs instanceof HistoricallyNamedCharset ? ((HistoricallyNamedCharset)((Object)this.cs)).historicalName() : this.cs.name();
        }

        private boolean inReady() {
            try {
                return this.in != null && this.in.available() > 0 || this.ch instanceof FileChannel;
            }
            catch (IOException iOException) {
                return false;
            }
        }

        boolean implReady() {
            return this.bb.hasRemaining() || this.inReady();
        }

        void implClose() throws IOException {
            if (this.ch != null) {
                this.ch.close();
            } else {
                this.in.close();
            }
        }
    }

    private static class ConverterSD
    extends StreamDecoder {
        private final InputStream in;
        private ByteToCharConverter btc;
        private byte[] bb;
        private int nBytes = 0;
        private int nextByte = 0;

        private ConverterSD(InputStream inputStream, Object object, String string) throws UnsupportedEncodingException {
            super(object);
            this.in = inputStream;
            this.btc = ByteToCharConverter.getConverter(string);
            this.bb = new byte[8192];
        }

        private ConverterSD(ReadableByteChannel readableByteChannel, String string) throws UnsupportedEncodingException {
            this(Channels.newInputStream(readableByteChannel), null, string);
            this.lock = this;
        }

        private void malfunction() {
            throw new InternalError("Converter malfunction (" + this.btc.getCharacterEncoding() + ") -- please submit a bug report via " + System.getProperty("java.vendor.url.bug"));
        }

        private int convertInto(char[] cArray, int n, int n2) throws IOException {
            int n3 = 0;
            if (this.nextByte < this.nBytes) {
                try {
                    n3 = this.btc.convert(this.bb, this.nextByte, this.nBytes, cArray, n, n2);
                    this.nextByte = this.nBytes;
                    if (this.btc.nextByteIndex() != this.nextByte) {
                        this.malfunction();
                    }
                }
                catch (ConversionBufferFullException conversionBufferFullException) {
                    this.nextByte = this.btc.nextByteIndex();
                    n3 = this.btc.nextCharIndex() - n;
                }
            }
            return n3;
        }

        private int flushInto(char[] cArray, int n, int n2) throws IOException {
            int n3 = 0;
            try {
                n3 = this.btc.flush(cArray, n, n2);
            }
            catch (ConversionBufferFullException conversionBufferFullException) {
                n3 = this.btc.nextCharIndex() - n;
            }
            return n3;
        }

        int implRead(char[] cArray, int n, int n2) throws IOException {
            int n3 = 0;
            if (this.nextByte < this.nBytes) {
                n3 = this.convertInto(cArray, n, n2);
            }
            while (n + n3 < n2) {
                if (this.nBytes != -1) {
                    if (n3 > 0 && !this.inReady()) break;
                    this.nBytes = this.in.read(this.bb);
                }
                if (this.nBytes == -1) {
                    this.nBytes = 0;
                    if ((n3 += this.flushInto(cArray, n + n3, n2)) != 0) break;
                    return -1;
                }
                this.nextByte = 0;
                n3 += this.convertInto(cArray, n + n3, n2);
            }
            return n3;
        }

        String encodingName() {
            return this.btc.getCharacterEncoding();
        }

        private boolean inReady() {
            try {
                return this.in.available() > 0;
            }
            catch (IOException iOException) {
                return false;
            }
        }

        boolean implReady() {
            return this.nextByte < this.nBytes || this.inReady();
        }

        void implClose() throws IOException {
            this.in.close();
        }
    }
}

