/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.text.html;

import java.awt.Color;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Toolkit;
import java.awt.image.ImageObserver;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Dictionary;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.text.AbstractDocument;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.GlyphView;
import javax.swing.text.Highlighter;
import javax.swing.text.JTextComponent;
import javax.swing.text.LayeredHighlighter;
import javax.swing.text.Position;
import javax.swing.text.Segment;
import javax.swing.text.StyledDocument;
import javax.swing.text.View;
import javax.swing.text.ViewFactory;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.InlineView;
import javax.swing.text.html.StyleSheet;

public class ImageView
extends View {
    private static boolean sIsInc = false;
    private static int sIncRate = 100;
    private static final String PENDING_IMAGE = "html.pendingImage";
    private static final String MISSING_IMAGE = "html.missingImage";
    private static final String IMAGE_CACHE_PROPERTY = "imageCache";
    private static final int DEFAULT_WIDTH = 38;
    private static final int DEFAULT_HEIGHT = 38;
    private static final int DEFAULT_BORDER = 2;
    private static final int LOADING_FLAG = 1;
    private static final int LINK_FLAG = 2;
    private static final int WIDTH_FLAG = 4;
    private static final int HEIGHT_FLAG = 8;
    private static final int RELOAD_FLAG = 16;
    private static final int RELOAD_IMAGE_FLAG = 32;
    private static final int SYNC_LOAD_FLAG = 64;
    private AttributeSet attr;
    private Image image;
    private int width;
    private int height;
    private int state = 48;
    private Container container;
    private Rectangle fBounds = new Rectangle();
    private Color borderColor;
    private short borderSize;
    private short leftInset;
    private short rightInset;
    private short topInset;
    private short bottomInset;
    private ImageObserver imageObserver = new ImageHandler();
    private View altView;
    private float vAlign;

    public ImageView(Element element) {
        super(element);
    }

    public String getAltText() {
        return (String)this.getElement().getAttributes().getAttribute(HTML.Attribute.ALT);
    }

    public URL getImageURL() {
        String string = (String)this.getElement().getAttributes().getAttribute(HTML.Attribute.SRC);
        if (string == null) {
            return null;
        }
        URL uRL = ((HTMLDocument)this.getDocument()).getBase();
        try {
            URL uRL2 = new URL(uRL, string);
            return uRL2;
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
    }

    public Icon getNoImageIcon() {
        return (Icon)UIManager.getLookAndFeelDefaults().get(MISSING_IMAGE);
    }

    public Icon getLoadingImageIcon() {
        return (Icon)UIManager.getLookAndFeelDefaults().get(PENDING_IMAGE);
    }

    public Image getImage() {
        this.sync();
        return this.image;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLoadsSynchronously(boolean bl) {
        ImageView imageView = this;
        synchronized (imageView) {
            this.state = bl ? (this.state |= 0x40) : (this.state | 0x40) ^ 0x40;
        }
    }

    public boolean getLoadsSynchronously() {
        return (this.state & 0x40) != 0;
    }

    protected StyleSheet getStyleSheet() {
        HTMLDocument hTMLDocument = (HTMLDocument)this.getDocument();
        return hTMLDocument.getStyleSheet();
    }

    public AttributeSet getAttributes() {
        this.sync();
        return this.attr;
    }

    public String getToolTipText(float f, float f2, Shape shape) {
        return this.getAltText();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setPropertiesFromAttributes() {
        AttributeSet attributeSet;
        StyleSheet styleSheet = this.getStyleSheet();
        this.attr = styleSheet.getViewAttributes(this);
        this.borderSize = (short)this.getIntAttr(HTML.Attribute.BORDER, this.isLink() ? 2 : 0);
        this.leftInset = this.rightInset = (short)(this.getIntAttr(HTML.Attribute.HSPACE, 0) + this.borderSize);
        this.topInset = this.bottomInset = (short)(this.getIntAttr(HTML.Attribute.VSPACE, 0) + this.borderSize);
        this.borderColor = ((StyledDocument)this.getDocument()).getForeground(this.getAttributes());
        AttributeSet attributeSet2 = this.getElement().getAttributes();
        Object object = attributeSet2.getAttribute(HTML.Attribute.ALIGN);
        this.vAlign = 1.0f;
        if (object != null) {
            if ("top".equals(object = object.toString())) {
                this.vAlign = 0.0f;
            } else if ("middle".equals(object)) {
                this.vAlign = 0.5f;
            }
        }
        if ((attributeSet = (AttributeSet)attributeSet2.getAttribute(HTML.Tag.A)) != null && attributeSet.isDefined(HTML.Attribute.HREF)) {
            ImageView imageView = this;
            synchronized (imageView) {
                this.state |= 2;
            }
        }
        ImageView imageView = this;
        synchronized (imageView) {
            this.state = (this.state | 2) ^ 2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setParent(View view) {
        View view2 = this.getParent();
        super.setParent(view);
        Container container = this.container = view != null ? this.getContainer() : null;
        if (view2 != view) {
            ImageView imageView = this;
            synchronized (imageView) {
                this.state |= 0x10;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void changedUpdate(DocumentEvent documentEvent, Shape shape, ViewFactory viewFactory) {
        super.changedUpdate(documentEvent, shape, viewFactory);
        ImageView imageView = this;
        synchronized (imageView) {
            this.state |= 0x30;
        }
        this.preferenceChanged(null, true, true);
    }

    public void paint(Graphics graphics, Shape shape) {
        this.sync();
        Rectangle rectangle = shape instanceof Rectangle ? (Rectangle)shape : shape.getBounds();
        Image image = this.getImage();
        Rectangle rectangle2 = graphics.getClipBounds();
        this.fBounds.setBounds(rectangle);
        this.paintHighlights(graphics, shape);
        this.paintBorder(graphics, rectangle);
        if (rectangle2 != null) {
            graphics.clipRect(rectangle.x + this.leftInset, rectangle.y + this.topInset, rectangle.width - this.leftInset - this.rightInset, rectangle.height - this.topInset - this.bottomInset);
        }
        if (image != null) {
            if (!this.hasPixels(image)) {
                Icon icon;
                Icon icon2 = icon = image == null ? this.getNoImageIcon() : this.getLoadingImageIcon();
                if (icon != null) {
                    icon.paintIcon(this.getContainer(), graphics, rectangle.x + this.leftInset, rectangle.y + this.topInset);
                }
            } else {
                graphics.drawImage(image, rectangle.x + this.leftInset, rectangle.y + this.topInset, this.width, this.height, this.imageObserver);
            }
        } else {
            View view;
            Icon icon = this.getNoImageIcon();
            if (icon != null) {
                icon.paintIcon(this.getContainer(), graphics, rectangle.x + this.leftInset, rectangle.y + this.topInset);
            }
            if ((view = this.getAltView()) != null && ((this.state & 4) == 0 || this.width > 38)) {
                Rectangle rectangle3 = new Rectangle(rectangle.x + this.leftInset + 38, rectangle.y + this.topInset, rectangle.width - this.leftInset - this.rightInset - 38, rectangle.height - this.topInset - this.bottomInset);
                view.paint(graphics, rectangle3);
            }
        }
        if (rectangle2 != null) {
            graphics.setClip(rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height);
        }
    }

    private void paintHighlights(Graphics graphics, Shape shape) {
        JTextComponent jTextComponent;
        Highlighter highlighter;
        if (this.container instanceof JTextComponent && (highlighter = (jTextComponent = (JTextComponent)this.container).getHighlighter()) instanceof LayeredHighlighter) {
            ((LayeredHighlighter)highlighter).paintLayeredHighlights(graphics, this.getStartOffset(), this.getEndOffset(), shape, jTextComponent, this);
        }
    }

    private void paintBorder(Graphics graphics, Rectangle rectangle) {
        Color color = this.borderColor;
        if ((this.borderSize > 0 || this.image == null) && color != null) {
            int n = this.leftInset - this.borderSize;
            int n2 = this.topInset - this.borderSize;
            graphics.setColor(color);
            int n3 = this.image == null ? 1 : this.borderSize;
            for (int i = 0; i < n3; ++i) {
                graphics.drawRect(rectangle.x + n + i, rectangle.y + n2 + i, rectangle.width - i - i - n - n - 1, rectangle.height - i - i - n2 - n2 - 1);
            }
        }
    }

    public float getPreferredSpan(int n) {
        this.sync();
        if (n == 0 && (this.state & 4) == 4) {
            this.getPreferredSpanFromAltView(n);
            return this.width + this.leftInset + this.rightInset;
        }
        if (n == 1 && (this.state & 8) == 8) {
            this.getPreferredSpanFromAltView(n);
            return this.height + this.topInset + this.bottomInset;
        }
        Image image = this.getImage();
        if (image != null) {
            switch (n) {
                case 0: {
                    return this.width + this.leftInset + this.rightInset;
                }
                case 1: {
                    return this.height + this.topInset + this.bottomInset;
                }
            }
            throw new IllegalArgumentException("Invalid axis: " + n);
        }
        View view = this.getAltView();
        float f = 0.0f;
        if (view != null) {
            f = view.getPreferredSpan(n);
        }
        switch (n) {
            case 0: {
                return f + (float)(this.width + this.leftInset + this.rightInset);
            }
            case 1: {
                return f + (float)(this.height + this.topInset + this.bottomInset);
            }
        }
        throw new IllegalArgumentException("Invalid axis: " + n);
    }

    public float getAlignment(int n) {
        switch (n) {
            case 1: {
                return this.vAlign;
            }
        }
        return super.getAlignment(n);
    }

    public Shape modelToView(int n, Shape shape, Position.Bias bias) throws BadLocationException {
        int n2 = this.getStartOffset();
        int n3 = this.getEndOffset();
        if (n >= n2 && n <= n3) {
            Rectangle rectangle = shape.getBounds();
            if (n == n3) {
                rectangle.x += rectangle.width;
            }
            rectangle.width = 0;
            return rectangle;
        }
        return null;
    }

    public int viewToModel(float f, float f2, Shape shape, Position.Bias[] biasArray) {
        Rectangle rectangle = (Rectangle)shape;
        if (f < (float)(rectangle.x + rectangle.width)) {
            biasArray[0] = Position.Bias.Forward;
            return this.getStartOffset();
        }
        biasArray[0] = Position.Bias.Backward;
        return this.getEndOffset();
    }

    public void setSize(float f, float f2) {
        View view;
        this.sync();
        if (this.getImage() == null && (view = this.getAltView()) != null) {
            view.setSize(Math.max(0.0f, f - (float)(38 + this.leftInset + this.rightInset)), Math.max(0.0f, f2 - (float)(this.topInset + this.bottomInset)));
        }
    }

    private boolean isLink() {
        return (this.state & 2) == 2;
    }

    private boolean hasPixels(Image image) {
        return image != null && image.getHeight(this.imageObserver) > 0 && image.getWidth(this.imageObserver) > 0;
    }

    private float getPreferredSpanFromAltView(int n) {
        View view;
        if (this.getImage() == null && (view = this.getAltView()) != null) {
            return view.getPreferredSpan(n);
        }
        return 0.0f;
    }

    private void repaint(long l) {
        if (this.container != null && this.fBounds != null) {
            this.container.repaint(l, this.fBounds.x, this.fBounds.y, this.fBounds.width, this.fBounds.height);
        }
    }

    private int getIntAttr(HTML.Attribute attribute, int n) {
        AttributeSet attributeSet = this.getElement().getAttributes();
        if (attributeSet.isDefined(attribute)) {
            int n2;
            String string = (String)attributeSet.getAttribute(attribute);
            if (string == null) {
                n2 = n;
            } else {
                try {
                    n2 = Math.max(0, Integer.parseInt(string));
                }
                catch (NumberFormatException numberFormatException) {
                    n2 = n;
                }
            }
            return n2;
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sync() {
        int n = this.state;
        if ((n & 0x20) != 0) {
            this.refreshImage();
        }
        if (((n = this.state) & 0x10) != 0) {
            ImageView imageView = this;
            synchronized (imageView) {
                this.state = (this.state | 0x10) ^ 0x10;
            }
            this.setPropertiesFromAttributes();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void refreshImage() {
        ImageView imageView = this;
        synchronized (imageView) {
            this.state = (this.state | 1 | 0x20 | 4 | 8) ^ 0x2C;
            this.image = null;
            this.height = 0;
            this.width = 0;
        }
        try {
            this.loadImage();
            this.updateImageSize();
        }
        finally {
            imageView = this;
            synchronized (imageView) {
                this.state = (this.state | 1) ^ 1;
            }
        }
    }

    private void loadImage() {
        URL uRL = this.getImageURL();
        Image image = null;
        if (uRL != null) {
            Dictionary dictionary = (Dictionary)this.getDocument().getProperty(IMAGE_CACHE_PROPERTY);
            if (dictionary != null) {
                image = (Image)dictionary.get(uRL);
            } else {
                image = Toolkit.getDefaultToolkit().createImage(uRL);
                if (image != null && this.getLoadsSynchronously()) {
                    ImageIcon imageIcon = new ImageIcon();
                    imageIcon.setImage(image);
                }
            }
        }
        this.image = image;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateImageSize() {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        Image image = this.getImage();
        if (image != null) {
            Element element = this.getElement();
            AttributeSet attributeSet = element.getAttributes();
            n = this.getIntAttr(HTML.Attribute.WIDTH, -1);
            if (n > 0) {
                n3 |= 4;
            }
            if ((n2 = this.getIntAttr(HTML.Attribute.HEIGHT, -1)) > 0) {
                n3 |= 8;
            }
            if (n <= 0 && (n = image.getWidth(this.imageObserver)) <= 0) {
                n = 38;
            }
            if (n2 <= 0 && (n2 = image.getHeight(this.imageObserver)) <= 0) {
                n2 = 38;
            }
            if ((n3 & 0xC) != 0) {
                Toolkit.getDefaultToolkit().prepareImage(image, n, n2, this.imageObserver);
            } else {
                Toolkit.getDefaultToolkit().prepareImage(image, -1, -1, this.imageObserver);
            }
            boolean bl = false;
            ImageView imageView = this;
            synchronized (imageView) {
                if (this.image != null) {
                    if ((n3 & 4) == 4 || this.width == 0) {
                        this.width = n;
                    }
                    if ((n3 & 8) == 8 || this.height == 0) {
                        this.height = n2;
                    }
                } else {
                    bl = true;
                    if ((n3 & 4) == 4) {
                        this.width = n;
                    }
                    if ((n3 & 8) == 8) {
                        this.height = n2;
                    }
                }
                this.state |= n3;
                this.state = (this.state | 1) ^ 1;
            }
            if (bl) {
                this.updateAltTextView();
            }
        } else {
            this.height = 38;
            this.width = 38;
            this.updateAltTextView();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateAltTextView() {
        String string = this.getAltText();
        if (string != null) {
            ImageLabelView imageLabelView = new ImageLabelView(this.getElement(), string);
            ImageView imageView = this;
            synchronized (imageView) {
                this.altView = imageLabelView;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private View getAltView() {
        View view;
        ImageView imageView = this;
        synchronized (imageView) {
            view = this.altView;
        }
        if (view != null && view.getParent() == null) {
            view.setParent(this.getParent());
        }
        return view;
    }

    private void safePreferenceChanged() {
        if (SwingUtilities.isEventDispatchThread()) {
            Document document = this.getDocument();
            if (document instanceof AbstractDocument) {
                ((AbstractDocument)document).readLock();
            }
            this.preferenceChanged(null, true, true);
            if (document instanceof AbstractDocument) {
                ((AbstractDocument)document).readUnlock();
            }
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    ImageView.this.safePreferenceChanged();
                }
            });
        }
    }

    private class ImageLabelView
    extends InlineView {
        private Segment segment;
        private Color fg;

        ImageLabelView(Element element, String string) {
            super(element);
            this.reset(string);
        }

        public void reset(String string) {
            this.segment = new Segment(string.toCharArray(), 0, string.length());
        }

        public void paint(Graphics graphics, Shape shape) {
            GlyphView.GlyphPainter glyphPainter = this.getGlyphPainter();
            if (glyphPainter != null) {
                graphics.setColor(this.getForeground());
                glyphPainter.paint(this, graphics, shape, this.getStartOffset(), this.getEndOffset());
            }
        }

        public Segment getText(int n, int n2) {
            if (n < 0 || n2 > this.segment.array.length) {
                throw new RuntimeException("ImageLabelView: Stale view");
            }
            this.segment.offset = n;
            this.segment.count = n2 - n;
            return this.segment;
        }

        public int getStartOffset() {
            return 0;
        }

        public int getEndOffset() {
            return this.segment.array.length;
        }

        public View breakView(int n, int n2, float f, float f2) {
            return this;
        }

        public Color getForeground() {
            View view;
            if (this.fg == null && (view = this.getParent()) != null) {
                Document document = this.getDocument();
                AttributeSet attributeSet = view.getAttributes();
                if (attributeSet != null && document instanceof StyledDocument) {
                    this.fg = ((StyledDocument)document).getForeground(attributeSet);
                }
            }
            return this.fg;
        }
    }

    private class ImageHandler
    implements ImageObserver {
        private ImageHandler() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean imageUpdate(Image image, int n, int n2, int n3, int n4, int n5) {
            if (ImageView.this.image == null || ImageView.this.image != image || ImageView.this.getParent() == null) {
                return false;
            }
            if ((n & 0xC0) != 0) {
                ImageView.this.repaint(0L);
                ImageView imageView = ImageView.this;
                synchronized (imageView) {
                    if (ImageView.this.image == image) {
                        ImageView.this.image = null;
                        if ((ImageView.this.state & 4) != 4) {
                            ImageView.this.width = 38;
                        }
                        if ((ImageView.this.state & 8) != 8) {
                            ImageView.this.height = 38;
                        }
                    }
                    if ((ImageView.this.state & 1) == 1) {
                        return false;
                    }
                }
                ImageView.this.updateAltTextView();
                ImageView.this.safePreferenceChanged();
                return false;
            }
            short s = 0;
            if ((n & 2) != 0 && !ImageView.this.getElement().getAttributes().isDefined(HTML.Attribute.HEIGHT)) {
                s = (short)(s | 1);
            }
            if ((n & 1) != 0 && !ImageView.this.getElement().getAttributes().isDefined(HTML.Attribute.WIDTH)) {
                s = (short)(s | 2);
            }
            ImageView imageView = ImageView.this;
            synchronized (imageView) {
                if (ImageView.this.image != image) {
                    return false;
                }
                if ((s & 1) == 1 && (ImageView.this.state & 4) == 0) {
                    ImageView.this.width = n4;
                }
                if ((s & 2) == 2 && (ImageView.this.state & 8) == 0) {
                    ImageView.this.height = n5;
                }
                if ((ImageView.this.state & 1) == 1) {
                    return true;
                }
            }
            if (s != 0) {
                ImageView.this.safePreferenceChanged();
                return true;
            }
            if ((n & 0x30) != 0) {
                ImageView.this.repaint(0L);
            } else if ((n & 8) != 0 && sIsInc) {
                ImageView.this.repaint(sIncRate);
            }
            return (n & 0x20) == 0;
        }
    }
}

