/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.synth;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.DateFormat;
import java.text.Format;
import java.text.NumberFormat;
import java.util.Date;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.LookAndFeel;
import javax.swing.border.Border;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicTableUI;
import javax.swing.plaf.synth.ColorType;
import javax.swing.plaf.synth.Region;
import javax.swing.plaf.synth.SynthBorder;
import javax.swing.plaf.synth.SynthContext;
import javax.swing.plaf.synth.SynthGraphicsUtils;
import javax.swing.plaf.synth.SynthLabelUI;
import javax.swing.plaf.synth.SynthLookAndFeel;
import javax.swing.plaf.synth.SynthStyle;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import sun.swing.plaf.synth.SynthUI;

class SynthTableUI
extends BasicTableUI
implements SynthUI,
PropertyChangeListener {
    private SynthStyle style;
    private boolean useTableColors;
    private boolean useUIBorder;
    private TableCellRenderer dateRenderer;
    private TableCellRenderer numberRenderer;
    private TableCellRenderer doubleRender;
    private TableCellRenderer floatRenderer;
    private TableCellRenderer iconRenderer;
    private TableCellRenderer imageIconRenderer;
    private TableCellRenderer booleanRenderer;
    private TableCellRenderer objectRenderer;

    SynthTableUI() {
    }

    public static ComponentUI createUI(JComponent jComponent) {
        return new SynthTableUI();
    }

    protected void installDefaults() {
        this.dateRenderer = this.installRendererIfPossible(Date.class, null);
        this.numberRenderer = this.installRendererIfPossible(Number.class, null);
        this.doubleRender = this.installRendererIfPossible(Double.class, null);
        this.floatRenderer = this.installRendererIfPossible(Float.class, null);
        this.iconRenderer = this.installRendererIfPossible(Icon.class, null);
        this.imageIconRenderer = this.installRendererIfPossible(ImageIcon.class, null);
        this.booleanRenderer = this.installRendererIfPossible(Boolean.class, new SynthBooleanTableCellRenderer());
        this.objectRenderer = this.installRendererIfPossible(Object.class, new SynthTableCellRenderer());
        this.updateStyle(this.table);
    }

    private TableCellRenderer installRendererIfPossible(Class clazz, TableCellRenderer tableCellRenderer) {
        TableCellRenderer tableCellRenderer2 = this.table.getDefaultRenderer(clazz);
        if (tableCellRenderer2 instanceof UIResource) {
            this.table.setDefaultRenderer(clazz, tableCellRenderer);
        }
        return tableCellRenderer2;
    }

    private void updateStyle(JTable jTable) {
        SynthContext synthContext = this.getContext(jTable, 1);
        SynthStyle synthStyle = this.style;
        this.style = SynthLookAndFeel.updateStyle(synthContext, this);
        if (this.style != synthStyle) {
            Color color;
            synthContext.setComponentState(513);
            Color color2 = this.table.getSelectionBackground();
            if (color2 == null || color2 instanceof UIResource) {
                this.table.setSelectionBackground(this.style.getColor(synthContext, ColorType.TEXT_BACKGROUND));
            }
            if ((color = this.table.getSelectionForeground()) == null || color instanceof UIResource) {
                this.table.setSelectionForeground(this.style.getColor(synthContext, ColorType.TEXT_FOREGROUND));
            }
            synthContext.setComponentState(1);
            Color color3 = this.table.getGridColor();
            if (color3 == null || color3 instanceof UIResource) {
                color3 = (Color)this.style.get(synthContext, "Table.gridColor");
                if (color3 == null) {
                    color3 = this.style.getColor(synthContext, ColorType.FOREGROUND);
                }
                this.table.setGridColor(color3);
            }
            this.useTableColors = this.style.getBoolean(synthContext, "Table.rendererUseTableColors", true);
            this.useUIBorder = this.style.getBoolean(synthContext, "Table.rendererUseUIBorder", true);
            Object object = this.style.get(synthContext, "Table.rowHeight");
            if (object != null) {
                LookAndFeel.installProperty(this.table, "rowHeight", object);
            }
            if (synthStyle != null) {
                this.uninstallKeyboardActions();
                this.installKeyboardActions();
            }
        }
        synthContext.dispose();
    }

    protected void installListeners() {
        super.installListeners();
        this.table.addPropertyChangeListener(this);
    }

    protected void uninstallDefaults() {
        this.table.setDefaultRenderer(Date.class, this.dateRenderer);
        this.table.setDefaultRenderer(Number.class, this.numberRenderer);
        this.table.setDefaultRenderer(Double.class, this.doubleRender);
        this.table.setDefaultRenderer(Float.class, this.floatRenderer);
        this.table.setDefaultRenderer(Icon.class, this.iconRenderer);
        this.table.setDefaultRenderer(ImageIcon.class, this.imageIconRenderer);
        this.table.setDefaultRenderer(Boolean.class, this.booleanRenderer);
        this.table.setDefaultRenderer(Object.class, this.objectRenderer);
        if (this.table.getTransferHandler() instanceof UIResource) {
            this.table.setTransferHandler(null);
        }
        SynthContext synthContext = this.getContext(this.table, 1);
        this.style.uninstallDefaults(synthContext);
        synthContext.dispose();
        this.style = null;
    }

    protected void uninstallListeners() {
        this.table.removePropertyChangeListener(this);
        super.uninstallListeners();
    }

    public SynthContext getContext(JComponent jComponent) {
        return this.getContext(jComponent, this.getComponentState(jComponent));
    }

    private SynthContext getContext(JComponent jComponent, int n) {
        return SynthContext.getContext(SynthContext.class, jComponent, SynthLookAndFeel.getRegion(jComponent), this.style, n);
    }

    private Region getRegion(JComponent jComponent) {
        return SynthLookAndFeel.getRegion(jComponent);
    }

    private int getComponentState(JComponent jComponent) {
        return SynthLookAndFeel.getComponentState(jComponent);
    }

    public void update(Graphics graphics, JComponent jComponent) {
        SynthContext synthContext = this.getContext(jComponent);
        SynthLookAndFeel.update(synthContext, graphics);
        synthContext.getPainter().paintTableBackground(synthContext, graphics, 0, 0, jComponent.getWidth(), jComponent.getHeight());
        this.paint(synthContext, graphics);
        synthContext.dispose();
    }

    public void paintBorder(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
        synthContext.getPainter().paintTableBorder(synthContext, graphics, n, n2, n3, n4);
    }

    public void paint(Graphics graphics, JComponent jComponent) {
        SynthContext synthContext = this.getContext(jComponent);
        this.paint(synthContext, graphics);
        synthContext.dispose();
    }

    protected void paint(SynthContext synthContext, Graphics graphics) {
        Rectangle rectangle = graphics.getClipBounds();
        Rectangle rectangle2 = this.table.getBounds();
        rectangle2.y = 0;
        rectangle2.x = 0;
        if (this.table.getRowCount() <= 0 || this.table.getColumnCount() <= 0 || !rectangle2.intersects(rectangle)) {
            this.paintDropLines(synthContext, graphics);
            return;
        }
        boolean bl = this.table.getComponentOrientation().isLeftToRight();
        Point point = rectangle.getLocation();
        if (!bl) {
            ++point.x;
        }
        Point point2 = new Point(rectangle.x + rectangle.width - (bl ? 1 : 0), rectangle.y + rectangle.height);
        int n = this.table.rowAtPoint(point);
        int n2 = this.table.rowAtPoint(point2);
        if (n == -1) {
            n = 0;
        }
        if (n2 == -1) {
            n2 = this.table.getRowCount() - 1;
        }
        int n3 = this.table.columnAtPoint(bl ? point : point2);
        int n4 = this.table.columnAtPoint(bl ? point2 : point);
        if (n3 == -1) {
            n3 = 0;
        }
        if (n4 == -1) {
            n4 = this.table.getColumnCount() - 1;
        }
        this.paintGrid(synthContext, graphics, n, n2, n3, n4);
        this.paintCells(synthContext, graphics, n, n2, n3, n4);
        this.paintDropLines(synthContext, graphics);
    }

    private void paintDropLines(SynthContext synthContext, Graphics graphics) {
        int n;
        int n2;
        JTable.DropLocation dropLocation = this.table.getDropLocation();
        if (dropLocation == null) {
            return;
        }
        Color color = (Color)this.style.get(synthContext, "Table.dropLineColor");
        Color color2 = (Color)this.style.get(synthContext, "Table.dropLineShortColor");
        if (color == null && color2 == null) {
            return;
        }
        Rectangle rectangle = this.getHDropLineRect(dropLocation);
        if (rectangle != null) {
            n2 = rectangle.x;
            n = rectangle.width;
            if (color != null) {
                this.extendRect(rectangle, true);
                graphics.setColor(color);
                graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            }
            if (!dropLocation.isInsertColumn() && color2 != null) {
                graphics.setColor(color2);
                graphics.fillRect(n2, rectangle.y, n, rectangle.height);
            }
        }
        if ((rectangle = this.getVDropLineRect(dropLocation)) != null) {
            n2 = rectangle.y;
            n = rectangle.height;
            if (color != null) {
                this.extendRect(rectangle, false);
                graphics.setColor(color);
                graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            }
            if (!dropLocation.isInsertRow() && color2 != null) {
                graphics.setColor(color2);
                graphics.fillRect(rectangle.x, n2, rectangle.width, n);
            }
        }
    }

    private Rectangle getHDropLineRect(JTable.DropLocation dropLocation) {
        if (!dropLocation.isInsertRow()) {
            return null;
        }
        int n = dropLocation.getRow();
        int n2 = dropLocation.getColumn();
        if (n2 >= this.table.getColumnCount()) {
            --n2;
        }
        Rectangle rectangle = this.table.getCellRect(n, n2, true);
        if (n >= this.table.getRowCount()) {
            Rectangle rectangle2 = this.table.getCellRect(--n, n2, true);
            rectangle.y = rectangle2.y + rectangle2.height;
        }
        rectangle.y = rectangle.y == 0 ? -1 : (rectangle.y -= 2);
        rectangle.height = 3;
        return rectangle;
    }

    private Rectangle getVDropLineRect(JTable.DropLocation dropLocation) {
        if (!dropLocation.isInsertColumn()) {
            return null;
        }
        boolean bl = this.table.getComponentOrientation().isLeftToRight();
        int n = dropLocation.getColumn();
        Rectangle rectangle = this.table.getCellRect(dropLocation.getRow(), n, true);
        if (n >= this.table.getColumnCount()) {
            rectangle = this.table.getCellRect(dropLocation.getRow(), --n, true);
            if (bl) {
                rectangle.x += rectangle.width;
            }
        } else if (!bl) {
            rectangle.x += rectangle.width;
        }
        rectangle.x = rectangle.x == 0 ? -1 : (rectangle.x -= 2);
        rectangle.width = 3;
        return rectangle;
    }

    private Rectangle extendRect(Rectangle rectangle, boolean bl) {
        if (rectangle == null) {
            return rectangle;
        }
        if (bl) {
            rectangle.x = 0;
            rectangle.width = this.table.getWidth();
        } else {
            rectangle.y = 0;
            if (this.table.getRowCount() != 0) {
                Rectangle rectangle2 = this.table.getCellRect(this.table.getRowCount() - 1, 0, true);
                rectangle.height = rectangle2.y + rectangle2.height;
            } else {
                rectangle.height = this.table.getHeight();
            }
        }
        return rectangle;
    }

    private void paintGrid(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
        block6: {
            int n5;
            int n6;
            graphics.setColor(this.table.getGridColor());
            Rectangle rectangle = this.table.getCellRect(n, n3, true);
            Rectangle rectangle2 = this.table.getCellRect(n2, n4, true);
            Rectangle rectangle3 = rectangle.union(rectangle2);
            SynthGraphicsUtils synthGraphicsUtils = synthContext.getStyle().getGraphicsUtils(synthContext);
            if (this.table.getShowHorizontalLines()) {
                int n7 = rectangle3.x + rectangle3.width;
                n6 = rectangle3.y;
                for (n5 = n; n5 <= n2; ++n5) {
                    synthGraphicsUtils.drawLine(synthContext, "Table.grid", graphics, rectangle3.x, (n6 += this.table.getRowHeight(n5)) - 1, n7 - 1, n6 - 1);
                }
            }
            if (!this.table.getShowVerticalLines()) break block6;
            TableColumnModel tableColumnModel = this.table.getColumnModel();
            n6 = rectangle3.y + rectangle3.height;
            if (this.table.getComponentOrientation().isLeftToRight()) {
                n5 = rectangle3.x;
                for (int i = n3; i <= n4; ++i) {
                    int n8 = tableColumnModel.getColumn(i).getWidth();
                    synthGraphicsUtils.drawLine(synthContext, "Table.grid", graphics, (n5 += n8) - 1, 0, n5 - 1, n6 - 1);
                }
            } else {
                n5 = rectangle3.x;
                for (int i = n4; i >= n3; --i) {
                    int n9 = tableColumnModel.getColumn(i).getWidth();
                    synthGraphicsUtils.drawLine(synthContext, "Table.grid", graphics, (n5 += n9) - 1, 0, n5 - 1, n6 - 1);
                }
            }
        }
    }

    private int viewIndexForColumn(TableColumn tableColumn) {
        TableColumnModel tableColumnModel = this.table.getColumnModel();
        for (int i = 0; i < tableColumnModel.getColumnCount(); ++i) {
            if (tableColumnModel.getColumn(i) != tableColumn) continue;
            return i;
        }
        return -1;
    }

    private void paintCells(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
        JTableHeader jTableHeader = this.table.getTableHeader();
        TableColumn tableColumn = jTableHeader == null ? null : jTableHeader.getDraggedColumn();
        TableColumnModel tableColumnModel = this.table.getColumnModel();
        int n5 = tableColumnModel.getColumnMargin();
        if (this.table.getComponentOrientation().isLeftToRight()) {
            for (int i = n; i <= n2; ++i) {
                Rectangle rectangle = this.table.getCellRect(i, n3, false);
                for (int j = n3; j <= n4; ++j) {
                    TableColumn tableColumn2 = tableColumnModel.getColumn(j);
                    int n6 = tableColumn2.getWidth();
                    rectangle.width = n6 - n5;
                    if (tableColumn2 != tableColumn) {
                        this.paintCell(synthContext, graphics, rectangle, i, j);
                    }
                    rectangle.x += n6;
                }
            }
        } else {
            for (int i = n; i <= n2; ++i) {
                int n7;
                Rectangle rectangle = this.table.getCellRect(i, n3, false);
                TableColumn tableColumn3 = tableColumnModel.getColumn(n3);
                if (tableColumn3 != tableColumn) {
                    n7 = tableColumn3.getWidth();
                    rectangle.width = n7 - n5;
                    this.paintCell(synthContext, graphics, rectangle, i, n3);
                }
                for (int j = n3 + 1; j <= n4; ++j) {
                    tableColumn3 = tableColumnModel.getColumn(j);
                    n7 = tableColumn3.getWidth();
                    rectangle.width = n7 - n5;
                    rectangle.x -= n7;
                    if (tableColumn3 == tableColumn) continue;
                    this.paintCell(synthContext, graphics, rectangle, i, j);
                }
            }
        }
        if (tableColumn != null) {
            this.paintDraggedArea(synthContext, graphics, n, n2, tableColumn, jTableHeader.getDraggedDistance());
        }
        this.rendererPane.removeAll();
    }

    private void paintDraggedArea(SynthContext synthContext, Graphics graphics, int n, int n2, TableColumn tableColumn, int n3) {
        int n4;
        int n5;
        int n6 = this.viewIndexForColumn(tableColumn);
        Rectangle rectangle = this.table.getCellRect(n, n6, true);
        Rectangle rectangle2 = this.table.getCellRect(n2, n6, true);
        Rectangle rectangle3 = rectangle.union(rectangle2);
        graphics.setColor(this.table.getParent().getBackground());
        graphics.fillRect(rectangle3.x, rectangle3.y, rectangle3.width, rectangle3.height);
        rectangle3.x += n3;
        graphics.setColor(synthContext.getStyle().getColor(synthContext, ColorType.BACKGROUND));
        graphics.fillRect(rectangle3.x, rectangle3.y, rectangle3.width, rectangle3.height);
        SynthGraphicsUtils synthGraphicsUtils = synthContext.getStyle().getGraphicsUtils(synthContext);
        if (this.table.getShowVerticalLines()) {
            graphics.setColor(this.table.getGridColor());
            n5 = rectangle3.x;
            int n7 = rectangle3.y;
            int n8 = n5 + rectangle3.width - 1;
            n4 = n7 + rectangle3.height - 1;
            synthGraphicsUtils.drawLine(synthContext, "Table.grid", graphics, n5 - 1, n7, n5 - 1, n4);
            synthGraphicsUtils.drawLine(synthContext, "Table.grid", graphics, n8, n7, n8, n4);
        }
        for (n5 = n; n5 <= n2; ++n5) {
            Rectangle rectangle4 = this.table.getCellRect(n5, n6, false);
            rectangle4.x += n3;
            this.paintCell(synthContext, graphics, rectangle4, n5, n6);
            if (!this.table.getShowHorizontalLines()) continue;
            graphics.setColor(this.table.getGridColor());
            Rectangle rectangle5 = this.table.getCellRect(n5, n6, true);
            rectangle5.x += n3;
            n4 = rectangle5.x;
            int n9 = rectangle5.y;
            int n10 = n4 + rectangle5.width - 1;
            int n11 = n9 + rectangle5.height - 1;
            synthGraphicsUtils.drawLine(synthContext, "Table.grid", graphics, n4, n11, n10, n11);
        }
    }

    private void paintCell(SynthContext synthContext, Graphics graphics, Rectangle rectangle, int n, int n2) {
        if (this.table.isEditing() && this.table.getEditingRow() == n && this.table.getEditingColumn() == n2) {
            Component component = this.table.getEditorComponent();
            component.setBounds(rectangle);
            component.validate();
        } else {
            TableCellRenderer tableCellRenderer = this.table.getCellRenderer(n, n2);
            Component component = this.table.prepareRenderer(tableCellRenderer, n, n2);
            this.rendererPane.paintComponent(graphics, component, this.table, rectangle.x, rectangle.y, rectangle.width, rectangle.height, true);
        }
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (SynthLookAndFeel.shouldUpdateStyle(propertyChangeEvent)) {
            this.updateStyle((JTable)propertyChangeEvent.getSource());
        }
    }

    private class SynthTableCellRenderer
    extends DefaultTableCellRenderer {
        private Object numberFormat;
        private Object dateFormat;
        private boolean opaque;

        private SynthTableCellRenderer() {
        }

        public void setOpaque(boolean bl) {
            this.opaque = bl;
        }

        public boolean isOpaque() {
            return this.opaque;
        }

        public String getName() {
            String string = super.getName();
            if (string == null) {
                return "Table.cellRenderer";
            }
            return string;
        }

        public void setBorder(Border border) {
            if (SynthTableUI.this.useUIBorder || border instanceof SynthBorder) {
                super.setBorder(border);
            }
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            if (!SynthTableUI.this.useTableColors && (bl || bl2)) {
                SynthLookAndFeel.setSelectedUI((SynthLabelUI)SynthLookAndFeel.getUIOfType(this.getUI(), SynthLabelUI.class), bl, bl2, jTable.isEnabled(), false);
            } else {
                SynthLookAndFeel.resetSelectedUI();
            }
            super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            this.setIcon(null);
            Class<?> clazz = jTable.getColumnClass(n2);
            this.configureValue(object, clazz);
            return this;
        }

        private void configureValue(Object object, Class clazz) {
            if (clazz == Object.class || clazz == null) {
                this.setHorizontalAlignment(10);
            } else if (clazz == Float.class || clazz == Double.class) {
                if (this.numberFormat == null) {
                    this.numberFormat = NumberFormat.getInstance();
                }
                this.setHorizontalAlignment(11);
                this.setText(object == null ? "" : ((NumberFormat)this.numberFormat).format(object));
            } else if (clazz == Number.class) {
                this.setHorizontalAlignment(11);
            } else if (clazz == Icon.class || clazz == ImageIcon.class) {
                this.setHorizontalAlignment(0);
                this.setIcon((Icon)object);
                this.setText("");
            } else if (clazz == Date.class) {
                if (this.dateFormat == null) {
                    this.dateFormat = DateFormat.getDateInstance();
                }
                this.setHorizontalAlignment(10);
                this.setText(object == null ? "" : ((Format)this.dateFormat).format(object));
            } else {
                this.configureValue(object, clazz.getSuperclass());
            }
        }

        public void paint(Graphics graphics) {
            super.paint(graphics);
            SynthLookAndFeel.resetSelectedUI();
        }
    }

    private class SynthBooleanTableCellRenderer
    extends JCheckBox
    implements TableCellRenderer {
        private boolean isRowSelected;

        public SynthBooleanTableCellRenderer() {
            this.setHorizontalAlignment(0);
        }

        public String getName() {
            String string = super.getName();
            if (string == null) {
                return "Table.cellRenderer";
            }
            return string;
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            this.isRowSelected = bl;
            if (bl) {
                this.setForeground(jTable.getSelectionForeground());
                this.setBackground(jTable.getSelectionBackground());
            } else {
                this.setForeground(jTable.getForeground());
                this.setBackground(jTable.getBackground());
            }
            this.setSelected(object != null && (Boolean)object != false);
            return this;
        }

        public boolean isOpaque() {
            return this.isRowSelected ? true : super.isOpaque();
        }
    }
}

