/*
 * Decompiled with CFR 0.152.
 */
package java.util.concurrent.atomic;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import sun.misc.Unsafe;
import sun.reflect.Reflection;
import sun.reflect.misc.ReflectUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AtomicIntegerFieldUpdater<T> {
    public static <U> AtomicIntegerFieldUpdater<U> newUpdater(Class<U> clazz, String string) {
        return new AtomicIntegerFieldUpdaterImpl<U>(clazz, string);
    }

    protected AtomicIntegerFieldUpdater() {
    }

    public abstract boolean compareAndSet(T var1, int var2, int var3);

    public abstract boolean weakCompareAndSet(T var1, int var2, int var3);

    public abstract void set(T var1, int var2);

    public abstract void lazySet(T var1, int var2);

    public abstract int get(T var1);

    public int getAndSet(T t, int n) {
        int n2;
        while (!this.compareAndSet(t, n2 = this.get(t), n)) {
        }
        return n2;
    }

    public int getAndIncrement(T t) {
        int n;
        int n2;
        while (!this.compareAndSet(t, n2 = this.get(t), n = n2 + 1)) {
        }
        return n2;
    }

    public int getAndDecrement(T t) {
        int n;
        int n2;
        while (!this.compareAndSet(t, n2 = this.get(t), n = n2 - 1)) {
        }
        return n2;
    }

    public int getAndAdd(T t, int n) {
        int n2;
        int n3;
        while (!this.compareAndSet(t, n3 = this.get(t), n2 = n3 + n)) {
        }
        return n3;
    }

    public int incrementAndGet(T t) {
        int n;
        int n2;
        while (!this.compareAndSet(t, n2 = this.get(t), n = n2 + 1)) {
        }
        return n;
    }

    public int decrementAndGet(T t) {
        int n;
        int n2;
        while (!this.compareAndSet(t, n2 = this.get(t), n = n2 - 1)) {
        }
        return n;
    }

    public int addAndGet(T t, int n) {
        int n2;
        int n3;
        while (!this.compareAndSet(t, n3 = this.get(t), n2 = n3 + n)) {
        }
        return n2;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class AtomicIntegerFieldUpdaterImpl<T>
    extends AtomicIntegerFieldUpdater<T> {
        private static final Unsafe unsafe = Unsafe.getUnsafe();
        private final long offset;
        private final Class<T> tclass;
        private final Class cclass;

        AtomicIntegerFieldUpdaterImpl(Class<T> clazz, String string) {
            Field field = null;
            Class clazz2 = null;
            int n = 0;
            try {
                field = clazz.getDeclaredField(string);
                clazz2 = Reflection.getCallerClass(3);
                n = field.getModifiers();
                ReflectUtil.ensureMemberAccess(clazz2, clazz, null, n);
                ReflectUtil.checkPackageAccess(clazz);
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
            Class<?> clazz3 = field.getType();
            if (clazz3 != Integer.TYPE) {
                throw new IllegalArgumentException("Must be integer type");
            }
            if (!Modifier.isVolatile(n)) {
                throw new IllegalArgumentException("Must be volatile type");
            }
            this.cclass = Modifier.isProtected(n) && clazz2 != clazz ? clazz2 : null;
            this.tclass = clazz;
            this.offset = unsafe.objectFieldOffset(field);
        }

        private void fullCheck(T t) {
            if (!this.tclass.isInstance(t)) {
                throw new ClassCastException();
            }
            if (this.cclass != null) {
                this.ensureProtectedAccess(t);
            }
        }

        @Override
        public boolean compareAndSet(T t, int n, int n2) {
            if (t == null || t.getClass() != this.tclass || this.cclass != null) {
                this.fullCheck(t);
            }
            return unsafe.compareAndSwapInt(t, this.offset, n, n2);
        }

        @Override
        public boolean weakCompareAndSet(T t, int n, int n2) {
            if (t == null || t.getClass() != this.tclass || this.cclass != null) {
                this.fullCheck(t);
            }
            return unsafe.compareAndSwapInt(t, this.offset, n, n2);
        }

        @Override
        public void set(T t, int n) {
            if (t == null || t.getClass() != this.tclass || this.cclass != null) {
                this.fullCheck(t);
            }
            unsafe.putIntVolatile(t, this.offset, n);
        }

        @Override
        public void lazySet(T t, int n) {
            if (t == null || t.getClass() != this.tclass || this.cclass != null) {
                this.fullCheck(t);
            }
            unsafe.putIntVolatile(t, this.offset, n);
        }

        @Override
        public final int get(T t) {
            if (t == null || t.getClass() != this.tclass || this.cclass != null) {
                this.fullCheck(t);
            }
            return unsafe.getIntVolatile(t, this.offset);
        }

        private void ensureProtectedAccess(T t) {
            if (this.cclass.isInstance(t)) {
                return;
            }
            throw new RuntimeException(new IllegalAccessException("Class " + this.cclass.getName() + " can not access a protected member of class " + this.tclass.getName() + " using an instance of " + t.getClass().getName()));
        }
    }
}

