/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import java.io.UnsupportedEncodingException;
import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ProcessEnvironment {
    private static final HashMap<Variable, Value> theEnvironment;
    private static final Map<String, String> theUnmodifiableEnvironment;
    static final int MIN_NAME_LENGTH = 0;
    static final byte EQUALS_BYTE;
    static final String platformEncoding;

    static String getenv(String string) {
        return theUnmodifiableEnvironment.get(string);
    }

    static Map<String, String> getenv() {
        return theUnmodifiableEnvironment;
    }

    static Map<String, String> environment() {
        return new StringEnvironment((Map)theEnvironment.clone());
    }

    static Map<String, String> emptyEnvironment(int n) {
        return new StringEnvironment(new HashMap<Variable, Value>(n));
    }

    private static native byte[][] environ();

    private ProcessEnvironment() {
    }

    private static void validateVariable(String string) {
        if (string.indexOf(61) != -1 || string.indexOf(0) != -1) {
            throw new IllegalArgumentException("Invalid environment variable name: \"" + string + "\"");
        }
    }

    private static void validateValue(String string) {
        if (string.indexOf(0) != -1) {
            throw new IllegalArgumentException("Invalid environment variable value: \"" + string + "\"");
        }
    }

    static byte[] toEnvironmentBlock(Map<String, String> map, int[] nArray) {
        return map == null ? null : ((StringEnvironment)map).toEnvironmentBlock(nArray);
    }

    private static int arrayCompare(byte[] byArray, byte[] byArray2) {
        int n = byArray.length < byArray2.length ? byArray.length : byArray2.length;
        for (int i = 0; i < n; ++i) {
            if (byArray[i] == byArray2[i]) continue;
            return byArray[i] - byArray2[i];
        }
        return byArray.length - byArray2.length;
    }

    private static boolean arrayEquals(byte[] byArray, byte[] byArray2) {
        if (byArray.length != byArray2.length) {
            return false;
        }
        for (int i = 0; i < byArray.length; ++i) {
            if (byArray[i] == byArray2[i]) continue;
            return false;
        }
        return true;
    }

    private static int arrayHash(byte[] byArray) {
        int n = 0;
        for (int i = 0; i < byArray.length; ++i) {
            n = 31 * n + byArray[i];
        }
        return n;
    }

    static {
        byte by;
        String string = System.getProperty("ibm.system.encoding");
        if (string == null) {
            string = System.getProperty("file.encoding");
        }
        platformEncoding = string;
        try {
            by = new String("=").getBytes(platformEncoding)[0];
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            by = new String("=").getBytes()[0];
        }
        EQUALS_BYTE = by;
        byte[][] byArray = ProcessEnvironment.environ();
        theEnvironment = new HashMap(byArray.length / 2 + 3);
        if (System.getProperty("os.name").compareTo("OS/400") == 0) {
            for (int i = byArray.length - 1; i > 0; i -= 2) {
                theEnvironment.put(Variable.valueOf(byArray[i - 1]), Value.valueOf(byArray[i]));
            }
        } else {
            for (int i = byArray.length - 1; i > 0; i -= 2) {
                theEnvironment.put(Variable.valueOf(byArray[i - 1]), Value.valueOf(byArray[i]));
            }
        }
        theUnmodifiableEnvironment = Collections.unmodifiableMap(new StringEnvironment(theEnvironment));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class StringKeySet
    extends AbstractSet<String> {
        private final Set<Variable> s;

        public StringKeySet(Set<Variable> set) {
            this.s = set;
        }

        @Override
        public int size() {
            return this.s.size();
        }

        @Override
        public boolean isEmpty() {
            return this.s.isEmpty();
        }

        @Override
        public void clear() {
            this.s.clear();
        }

        @Override
        public Iterator<String> iterator() {
            return new Iterator<String>(){
                Iterator<Variable> i;
                {
                    this.i = StringKeySet.this.s.iterator();
                }

                @Override
                public boolean hasNext() {
                    return this.i.hasNext();
                }

                @Override
                public String next() {
                    return this.i.next().toString();
                }

                @Override
                public void remove() {
                    this.i.remove();
                }
            };
        }

        @Override
        public boolean contains(Object object) {
            return this.s.contains(Variable.valueOfQueryOnly(object));
        }

        @Override
        public boolean remove(Object object) {
            return this.s.remove(Variable.valueOfQueryOnly(object));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class StringValues
    extends AbstractCollection<String> {
        private final Collection<Value> c;

        public StringValues(Collection<Value> collection) {
            this.c = collection;
        }

        @Override
        public int size() {
            return this.c.size();
        }

        @Override
        public boolean isEmpty() {
            return this.c.isEmpty();
        }

        @Override
        public void clear() {
            this.c.clear();
        }

        @Override
        public Iterator<String> iterator() {
            return new Iterator<String>(){
                Iterator<Value> i;
                {
                    this.i = StringValues.this.c.iterator();
                }

                @Override
                public boolean hasNext() {
                    return this.i.hasNext();
                }

                @Override
                public String next() {
                    return this.i.next().toString();
                }

                @Override
                public void remove() {
                    this.i.remove();
                }
            };
        }

        @Override
        public boolean contains(Object object) {
            return this.c.contains(Value.valueOfQueryOnly(object));
        }

        @Override
        public boolean remove(Object object) {
            return this.c.remove(Value.valueOfQueryOnly(object));
        }

        @Override
        public boolean equals(Object object) {
            return object instanceof StringValues && ((Object)this.c).equals(((StringValues)object).c);
        }

        @Override
        public int hashCode() {
            return ((Object)this.c).hashCode();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class StringEntrySet
    extends AbstractSet<Map.Entry<String, String>> {
        private final Set<Map.Entry<Variable, Value>> s;

        public StringEntrySet(Set<Map.Entry<Variable, Value>> set) {
            this.s = set;
        }

        @Override
        public int size() {
            return this.s.size();
        }

        @Override
        public boolean isEmpty() {
            return this.s.isEmpty();
        }

        @Override
        public void clear() {
            this.s.clear();
        }

        @Override
        public Iterator<Map.Entry<String, String>> iterator() {
            return new Iterator<Map.Entry<String, String>>(){
                Iterator<Map.Entry<Variable, Value>> i;
                {
                    this.i = StringEntrySet.this.s.iterator();
                }

                @Override
                public boolean hasNext() {
                    return this.i.hasNext();
                }

                @Override
                public Map.Entry<String, String> next() {
                    return new StringEntry(this.i.next());
                }

                @Override
                public void remove() {
                    this.i.remove();
                }
            };
        }

        private static Map.Entry<Variable, Value> vvEntry(final Object object) {
            if (object instanceof StringEntry) {
                return ((StringEntry)object).e;
            }
            return new Map.Entry<Variable, Value>(){

                @Override
                public Variable getKey() {
                    return Variable.valueOfQueryOnly(((Map.Entry)object).getKey());
                }

                @Override
                public Value getValue() {
                    return Value.valueOfQueryOnly(((Map.Entry)object).getValue());
                }

                @Override
                public Value setValue(Value value) {
                    throw new UnsupportedOperationException();
                }
            };
        }

        @Override
        public boolean contains(Object object) {
            return this.s.contains(StringEntrySet.vvEntry(object));
        }

        @Override
        public boolean remove(Object object) {
            return this.s.remove(StringEntrySet.vvEntry(object));
        }

        @Override
        public boolean equals(Object object) {
            return object instanceof StringEntrySet && ((Object)this.s).equals(((StringEntrySet)object).s);
        }

        @Override
        public int hashCode() {
            return ((Object)this.s).hashCode();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class StringEntry
    implements Map.Entry<String, String> {
        private final Map.Entry<Variable, Value> e;

        public StringEntry(Map.Entry<Variable, Value> entry) {
            this.e = entry;
        }

        @Override
        public String getKey() {
            return this.e.getKey().toString();
        }

        @Override
        public String getValue() {
            return this.e.getValue().toString();
        }

        @Override
        public String setValue(String string) {
            return this.e.setValue(Value.valueOf(string)).toString();
        }

        public String toString() {
            return this.getKey() + "=" + this.getValue();
        }

        @Override
        public boolean equals(Object object) {
            return object instanceof StringEntry && ((Object)this.e).equals(((StringEntry)object).e);
        }

        @Override
        public int hashCode() {
            return ((Object)this.e).hashCode();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class StringEnvironment
    extends AbstractMap<String, String> {
        private Map<Variable, Value> m;

        private static String toString(Value value) {
            return value == null ? null : value.toString();
        }

        public StringEnvironment(Map<Variable, Value> map) {
            this.m = map;
        }

        @Override
        public int size() {
            return this.m.size();
        }

        @Override
        public boolean isEmpty() {
            return this.m.isEmpty();
        }

        @Override
        public void clear() {
            this.m.clear();
        }

        @Override
        public boolean containsKey(Object object) {
            return this.m.containsKey(Variable.valueOfQueryOnly(object));
        }

        @Override
        public boolean containsValue(Object object) {
            return this.m.containsValue(Value.valueOfQueryOnly(object));
        }

        @Override
        public String get(Object object) {
            return StringEnvironment.toString(this.m.get(Variable.valueOfQueryOnly(object)));
        }

        @Override
        public String put(String string, String string2) {
            return StringEnvironment.toString(this.m.put(Variable.valueOf(string), Value.valueOf(string2)));
        }

        @Override
        public String remove(Object object) {
            return StringEnvironment.toString(this.m.remove(Variable.valueOfQueryOnly(object)));
        }

        @Override
        public Set<String> keySet() {
            return new StringKeySet(this.m.keySet());
        }

        @Override
        public Set<Map.Entry<String, String>> entrySet() {
            return new StringEntrySet(this.m.entrySet());
        }

        @Override
        public Collection<String> values() {
            return new StringValues(this.m.values());
        }

        public byte[] toEnvironmentBlock(int[] nArray) {
            int n = this.m.size() * 2;
            for (Map.Entry<Variable, Value> entry : this.m.entrySet()) {
                n += entry.getKey().getBytes().length;
                n += entry.getValue().getBytes().length;
            }
            Object object = new byte[n];
            int n2 = 0;
            for (Map.Entry<Variable, Value> entry : this.m.entrySet()) {
                byte[] byArray = entry.getKey().getBytes();
                byte[] byArray2 = entry.getValue().getBytes();
                System.arraycopy(byArray, 0, object, n2, byArray.length);
                n2 += byArray.length;
                object[n2++] = EQUALS_BYTE;
                System.arraycopy(byArray2, 0, object, n2, byArray2.length);
                n2 += byArray2.length + 1;
            }
            nArray[0] = this.m.size();
            return object;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Value
    extends ExternalData
    implements Comparable<Value> {
        protected Value(String string, byte[] byArray) {
            super(string, byArray);
        }

        public static Value valueOfQueryOnly(Object object) {
            return Value.valueOfQueryOnly((String)object);
        }

        public static Value valueOfQueryOnly(String string) {
            try {
                return new Value(string, string.getBytes(platformEncoding));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                return new Value(string, string.getBytes());
            }
        }

        public static Value valueOf(String string) {
            ProcessEnvironment.validateValue(string);
            return Value.valueOfQueryOnly(string);
        }

        public static Value valueOf(byte[] byArray) {
            try {
                return new Value(new String(byArray, platformEncoding), byArray);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                return new Value(new String(byArray), byArray);
            }
        }

        @Override
        public int compareTo(Value value) {
            return ProcessEnvironment.arrayCompare(this.getBytes(), value.getBytes());
        }

        @Override
        public boolean equals(Object object) {
            return object instanceof Value && super.equals(object);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Variable
    extends ExternalData
    implements Comparable<Variable> {
        protected Variable(String string, byte[] byArray) {
            super(string, byArray);
        }

        public static Variable valueOfQueryOnly(Object object) {
            return Variable.valueOfQueryOnly((String)object);
        }

        public static Variable valueOfQueryOnly(String string) {
            try {
                return new Variable(string, string.getBytes(platformEncoding));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                return new Variable(string, string.getBytes());
            }
        }

        public static Variable valueOf(String string) {
            ProcessEnvironment.validateVariable(string);
            return Variable.valueOfQueryOnly(string);
        }

        public static Variable valueOf(byte[] byArray) {
            try {
                return new Variable(new String(byArray, platformEncoding), byArray);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                return new Variable(new String(byArray), byArray);
            }
        }

        @Override
        public int compareTo(Variable variable) {
            return ProcessEnvironment.arrayCompare(this.getBytes(), variable.getBytes());
        }

        @Override
        public boolean equals(Object object) {
            return object instanceof Variable && super.equals(object);
        }
    }

    private static abstract class ExternalData {
        protected final String str;
        protected final byte[] bytes;

        protected ExternalData(String string, byte[] byArray) {
            this.str = string;
            this.bytes = byArray;
        }

        public byte[] getBytes() {
            return this.bytes;
        }

        public String toString() {
            return this.str;
        }

        public boolean equals(Object object) {
            return object instanceof ExternalData && ProcessEnvironment.arrayEquals(this.getBytes(), ((ExternalData)object).getBytes());
        }

        public int hashCode() {
            return ProcessEnvironment.arrayHash(this.getBytes());
        }
    }
}

