/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import java.io.IOException;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.util.Vector;

class ISProcessPipedInputStream
extends PipedInputStream {
    byte[] writeBuf = null;
    boolean chaining = false;
    int inPos = 0;
    Vector chain = new Vector();

    public ISProcessPipedInputStream(PipedOutputStream pipedOutputStream) throws IOException {
        super(pipedOutputStream);
    }

    public ISProcessPipedInputStream() {
    }

    protected synchronized void receive(int n) throws IOException {
        if (this.chaining) {
            if (this.inPos == 1024) {
                this.writeBuf = new byte[1024];
                this.chain.addElement(this.writeBuf);
                this.inPos = 0;
            }
            this.writeBuf[this.inPos++] = (byte)n;
        } else {
            super.receive(n);
            if (this.in == this.out) {
                this.inPos = 0;
                this.chaining = true;
                this.writeBuf = new byte[1024];
                this.chain.addElement(this.writeBuf);
            }
        }
    }

    synchronized void receive(byte[] byArray, int n, int n2) throws IOException {
        for (int i = 0; i < n2; ++i) {
            this.receive(byArray[n + i]);
        }
    }

    public synchronized int read() throws IOException {
        if (!this.chaining) {
            return super.read();
        }
        if (this.in == -1 && this.chain.size() != 0) {
            this.buffer = (byte[])this.chain.elementAt(0);
            this.chain.removeElementAt(0);
            this.out = 0;
            this.in = 0;
            if (this.chain.size() == 0) {
                this.in = this.inPos == 0 ? -1 : (this.inPos == 1024 ? 0 : this.inPos);
                this.chaining = false;
            }
        }
        return super.read();
    }

    public int available() throws IOException {
        int n = super.available();
        int n2 = this.chain.size();
        if (n2 == 0) {
            return n;
        }
        return n + 1024 * n2 - (1024 - this.inPos);
    }
}

