/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.messaging.saaj.soap.impl;

import com.sun.xml.internal.messaging.saaj.SOAPExceptionImpl;
import com.sun.xml.internal.messaging.saaj.soap.SOAPDocument;
import com.sun.xml.internal.messaging.saaj.soap.SOAPDocumentImpl;
import com.sun.xml.internal.messaging.saaj.soap.name.NameImpl;
import com.sun.xml.internal.messaging.saaj.util.JaxmURI;
import com.sun.xml.internal.messaging.saaj.util.NamespaceContextIterator;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import javax.xml.soap.Name;
import javax.xml.soap.Node;
import javax.xml.soap.SOAPBodyElement;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPException;
import org.apache.xerces.dom.CoreDocumentImpl;
import org.apache.xerces.dom.ElementNSImpl;
import org.apache.xerces.xni.NamespaceContext;
import org.w3c.dom.Attr;
import org.w3c.dom.CDATASection;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Text;

public class ElementImpl
extends ElementNSImpl
implements SOAPElement,
SOAPBodyElement {
    public static final String DSIG_NS = "http://www.w3.org/2000/09/xmldsig#".intern();
    public static final String XENC_NS = "http://www.w3.org/2001/04/xmlenc#".intern();
    public static final String WSU_NS = "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd".intern();
    private AttributeManager encodingStyleAttribute = new AttributeManager();
    protected QName elementQName;
    protected static Logger log = Logger.getLogger("javax.xml.messaging.saaj.soap.impl", "com.sun.xml.internal.messaging.saaj.soap.impl.LocalStrings");

    public ElementImpl(SOAPDocumentImpl sOAPDocumentImpl, Name name) {
        super((CoreDocumentImpl)sOAPDocumentImpl, name.getURI(), name.getQualifiedName(), name.getLocalName());
        this.elementQName = NameImpl.convertToQName(name);
    }

    public ElementImpl(SOAPDocumentImpl sOAPDocumentImpl, QName qName) {
        super((CoreDocumentImpl)sOAPDocumentImpl, qName.getNamespaceURI(), ElementImpl.getQualifiedName(qName), qName.getLocalPart());
        this.elementQName = qName;
    }

    public ElementImpl(SOAPDocumentImpl sOAPDocumentImpl, String string, String string2) {
        super((CoreDocumentImpl)sOAPDocumentImpl, string, string2);
        this.elementQName = new QName(string, ElementImpl.getLocalPart(string2), ElementImpl.getPrefix(string2));
    }

    public void ensureNamespaceIsDeclared(String string, String string2) {
        String string3 = this.getNamespaceURI(string);
        if (string3 == null || !string3.equals(string2)) {
            try {
                this.addNamespaceDeclaration(string, string2);
            }
            catch (SOAPException sOAPException) {
                // empty catch block
            }
        }
    }

    public Document getOwnerDocument() {
        SOAPDocument sOAPDocument = (SOAPDocument)((Object)super.getOwnerDocument());
        if (sOAPDocument == null) {
            return null;
        }
        return sOAPDocument.getDocument();
    }

    public SOAPElement addChildElement(Name name) throws SOAPException {
        return this.addElement(name);
    }

    public SOAPElement addChildElement(QName qName) throws SOAPException {
        return this.addElement(qName);
    }

    public SOAPElement addChildElement(String string) throws SOAPException {
        return this.addChildElement(NameImpl.createFromUnqualifiedName(string));
    }

    public SOAPElement addChildElement(String string, String string2) throws SOAPException {
        String string3 = this.getNamespaceURI(string2);
        if (string3 == null) {
            log.log(Level.SEVERE, "SAAJ0101.impl.parent.of.body.elem.mustbe.body", new String[]{string2});
            throw new SOAPExceptionImpl("Unable to locate namespace for prefix " + string2);
        }
        return this.addChildElement(string, string2, string3);
    }

    public String getNamespaceURI(String string) {
        block6: {
            block5: {
                if ("xmlns".equals(string)) {
                    return NamespaceContext.XMLNS_URI;
                }
                if ("xml".equals(string)) {
                    return NamespaceContext.XML_URI;
                }
                if (!"".equals(string)) break block5;
                for (org.w3c.dom.Node node = this; node != null && !(node instanceof Document); node = node.getParentNode()) {
                    if (!(node instanceof ElementImpl)) continue;
                    QName qName = node.getElementQName();
                    if (!((Element)node).hasAttributeNS(NamespaceContext.XMLNS_URI, "xmlns")) continue;
                    String string2 = ((Element)node).getAttributeNS(NamespaceContext.XMLNS_URI, "xmlns");
                    if ("".equals(string2)) {
                        return null;
                    }
                    return string2;
                }
                break block6;
            }
            if (string == null) break block6;
            for (org.w3c.dom.Node node = this; node != null && !(node instanceof Document); node = node.getParentNode()) {
                if (!((Element)node).hasAttributeNS(NamespaceContext.XMLNS_URI, string)) continue;
                return ((Element)node).getAttributeNS(NamespaceContext.XMLNS_URI, string);
            }
        }
        return null;
    }

    public SOAPElement setElementQName(QName qName) throws SOAPException {
        ElementImpl elementImpl = new ElementImpl((SOAPDocumentImpl)((Object)this.getOwnerDocument()), qName);
        return ElementImpl.replaceElementWithSOAPElement(this, elementImpl);
    }

    public QName createQName(String string, String string2) throws SOAPException {
        String string3 = this.getNamespaceURI(string2);
        if (string3 == null) {
            log.log(Level.SEVERE, "SAAJ0102.impl.cannot.locate.ns", new Object[]{string2});
            throw new SOAPException("Unable to locate namespace for prefix " + string2);
        }
        return new QName(string3, string, string2);
    }

    public String getNamespacePrefix(String string) {
        org.w3c.dom.Node node;
        NamespaceContextIterator namespaceContextIterator = this.getNamespaceContextNodes();
        while (namespaceContextIterator.hasNext()) {
            node = namespaceContextIterator.nextNamespaceAttr();
            if (!node.getNodeValue().equals(string)) continue;
            String string2 = node.getLocalName();
            if ("xmlns".equals(string2)) {
                return "";
            }
            return string2;
        }
        for (node = this; node != null && !(node instanceof Document); node = node.getParentNode()) {
            if (!string.equals(node.getNamespaceURI())) continue;
            return node.getPrefix();
        }
        return null;
    }

    protected Attr getNamespaceAttr(String string) {
        NamespaceContextIterator namespaceContextIterator = this.getNamespaceContextNodes();
        if (!"".equals(string)) {
            string = ":" + string;
        }
        while (namespaceContextIterator.hasNext()) {
            Attr attr = namespaceContextIterator.nextNamespaceAttr();
            if (!(!"".equals(string) ? attr.getNodeName().endsWith(string) : attr.getNodeName().equals("xmlns"))) continue;
            return attr;
        }
        return null;
    }

    public NamespaceContextIterator getNamespaceContextNodes() {
        return this.getNamespaceContextNodes(true);
    }

    public NamespaceContextIterator getNamespaceContextNodes(boolean bl) {
        return new NamespaceContextIterator(this, bl);
    }

    public SOAPElement addChildElement(String string, String string2, String string3) throws SOAPException {
        SOAPElement sOAPElement = this.createElement(NameImpl.create(string, string2, string3));
        this.addNode(sOAPElement);
        return this.convertToSoapElement(sOAPElement);
    }

    public SOAPElement addChildElement(SOAPElement sOAPElement) throws SOAPException {
        Object object;
        String string = sOAPElement.getElementName().getURI();
        String string2 = sOAPElement.getLocalName();
        if ("http://schemas.xmlsoap.org/soap/envelope/".equals(string) || "http://www.w3.org/2003/05/soap-envelope".equals(string)) {
            if ("Envelope".equalsIgnoreCase(string2) || "Header".equalsIgnoreCase(string2) || "Body".equalsIgnoreCase(string2)) {
                log.severe("SAAJ0103.impl.cannot.add.fragements");
                throw new SOAPExceptionImpl("Cannot add fragments which contain elements which are in the SOAP namespace");
            }
            if ("Fault".equalsIgnoreCase(string2) && !"Body".equalsIgnoreCase(this.getLocalName())) {
                log.severe("SAAJ0154.impl.adding.fault.to.nonbody");
                throw new SOAPExceptionImpl("Cannot add a SOAPFault as a child of " + this.getLocalName());
            }
            if ("Detail".equalsIgnoreCase(string2) && !"Fault".equalsIgnoreCase(this.getLocalName())) {
                log.severe("SAAJ0155.impl.adding.detail.nonfault");
                throw new SOAPExceptionImpl("Cannot add a Detail as a child of " + this.getLocalName());
            }
            if ("Fault".equalsIgnoreCase(string2)) {
                if (!string.equals(this.getElementName().getURI())) {
                    log.severe("SAAJ0158.impl.version.mismatch.fault");
                    throw new SOAPExceptionImpl("SOAP Version mismatch encountered when trying to add SOAPFault to SOAPBody");
                }
                object = this.getChildElements();
                if (object.hasNext()) {
                    log.severe("SAAJ0156.impl.adding.fault.error");
                    throw new SOAPExceptionImpl("Cannot add SOAPFault as a child of a non-Empty SOAPBody");
                }
            }
        }
        object = sOAPElement.getEncodingStyle();
        ElementImpl elementImpl = (ElementImpl)this.importElement(sOAPElement);
        this.addNode(elementImpl);
        if (object != null) {
            elementImpl.setEncodingStyle((String)object);
        }
        return this.convertToSoapElement(elementImpl);
    }

    protected Element importElement(Element element) {
        Document document = this.getOwnerDocument();
        Document document2 = element.getOwnerDocument();
        if (!document2.equals(document)) {
            return (Element)document.importNode(element, true);
        }
        return element;
    }

    protected SOAPElement addElement(Name name) throws SOAPException {
        SOAPElement sOAPElement = this.createElement(name);
        this.addNode(sOAPElement);
        return this.circumventBug5034339(sOAPElement);
    }

    protected SOAPElement addElement(QName qName) throws SOAPException {
        SOAPElement sOAPElement = this.createElement(qName);
        this.addNode(sOAPElement);
        return this.circumventBug5034339(sOAPElement);
    }

    protected SOAPElement createElement(Name name) {
        if (this.isNamespaceQualified(name)) {
            return (SOAPElement)this.getOwnerDocument().createElementNS(name.getURI(), name.getQualifiedName());
        }
        return (SOAPElement)this.getOwnerDocument().createElement(name.getQualifiedName());
    }

    protected SOAPElement createElement(QName qName) {
        if (this.isNamespaceQualified(qName)) {
            return (SOAPElement)this.getOwnerDocument().createElementNS(qName.getNamespaceURI(), ElementImpl.getQualifiedName(qName));
        }
        return (SOAPElement)this.getOwnerDocument().createElement(ElementImpl.getQualifiedName(qName));
    }

    protected void addNode(org.w3c.dom.Node node) throws SOAPException {
        ElementImpl elementImpl;
        QName qName;
        this.insertBefore(node, null);
        if (this.getOwnerDocument() instanceof DocumentFragment) {
            return;
        }
        if (node instanceof ElementImpl && !"".equals((qName = (elementImpl = (ElementImpl)node).getElementQName()).getNamespaceURI())) {
            elementImpl.ensureNamespaceIsDeclared(qName.getPrefix(), qName.getNamespaceURI());
        }
    }

    protected SOAPElement findChild(NameImpl nameImpl) {
        Iterator iterator = this.getChildElementNodes();
        while (iterator.hasNext()) {
            SOAPElement sOAPElement = (SOAPElement)iterator.next();
            if (!sOAPElement.getElementName().equals(nameImpl)) continue;
            return sOAPElement;
        }
        return null;
    }

    public SOAPElement addTextNode(String string) throws SOAPException {
        if (string.startsWith("<![CDATA[") || string.startsWith("<![cdata[")) {
            return this.addCDATA(string.substring("<![CDATA[".length(), string.length() - 3));
        }
        return this.addText(string);
    }

    protected SOAPElement addCDATA(String string) throws SOAPException {
        CDATASection cDATASection = this.getOwnerDocument().createCDATASection(string);
        this.addNode(cDATASection);
        return this;
    }

    protected SOAPElement addText(String string) throws SOAPException {
        Text text = this.getOwnerDocument().createTextNode(string);
        this.addNode(text);
        return this;
    }

    public SOAPElement addAttribute(Name name, String string) throws SOAPException {
        this.addAttributeBare(name, string);
        if (!"".equals(name.getURI())) {
            this.ensureNamespaceIsDeclared(name.getPrefix(), name.getURI());
        }
        return this;
    }

    public SOAPElement addAttribute(QName qName, String string) throws SOAPException {
        this.addAttributeBare(qName, string);
        if (!"".equals(qName.getNamespaceURI())) {
            this.ensureNamespaceIsDeclared(qName.getPrefix(), qName.getNamespaceURI());
        }
        return this;
    }

    private void addAttributeBare(Name name, String string) {
        this.addAttributeBare(name.getURI(), name.getPrefix(), name.getQualifiedName(), string);
    }

    private void addAttributeBare(QName qName, String string) {
        this.addAttributeBare(qName.getNamespaceURI(), qName.getPrefix(), ElementImpl.getQualifiedName(qName), string);
    }

    private void addAttributeBare(String string, String string2, String string3, String string4) {
        String string5 = string = string.length() == 0 ? null : string;
        if (string3.equals("xmlns")) {
            string = NamespaceContext.XMLNS_URI;
        }
        if (string == null) {
            this.setAttribute(string3, string4);
        } else {
            this.setAttributeNS(string, string3, string4);
        }
    }

    public SOAPElement addNamespaceDeclaration(String string, String string2) throws SOAPException {
        if (string.length() > 0) {
            this.setAttributeNS(NamespaceContext.XMLNS_URI, "xmlns:" + string, string2);
        } else {
            this.setAttributeNS(NamespaceContext.XMLNS_URI, "xmlns", string2);
        }
        return this;
    }

    public String getAttributeValue(Name name) {
        return ElementImpl.getAttributeValueFrom(this, name);
    }

    public String getAttributeValue(QName qName) {
        return ElementImpl.getAttributeValueFrom(this, qName.getNamespaceURI(), qName.getLocalPart(), qName.getPrefix(), ElementImpl.getQualifiedName(qName));
    }

    public Iterator getAllAttributes() {
        Iterator iterator = ElementImpl.getAllAttributesFrom(this);
        ArrayList<Name> arrayList = new ArrayList<Name>();
        while (iterator.hasNext()) {
            Name name = (Name)iterator.next();
            if ("xmlns".equalsIgnoreCase(name.getPrefix())) continue;
            arrayList.add(name);
        }
        return arrayList.iterator();
    }

    public Iterator getAllAttributesAsQNames() {
        Iterator iterator = ElementImpl.getAllAttributesFrom(this);
        ArrayList<QName> arrayList = new ArrayList<QName>();
        while (iterator.hasNext()) {
            Name name = (Name)iterator.next();
            if ("xmlns".equalsIgnoreCase(name.getPrefix())) continue;
            arrayList.add(NameImpl.convertToQName(name));
        }
        return arrayList.iterator();
    }

    public Iterator getNamespacePrefixes() {
        return this.doGetNamespacePrefixes(false);
    }

    public Iterator getVisibleNamespacePrefixes() {
        return this.doGetNamespacePrefixes(true);
    }

    protected Iterator doGetNamespacePrefixes(final boolean bl) {
        return new Iterator(){
            String next = null;
            String last = null;
            NamespaceContextIterator eachNamespace = ElementImpl.this.getNamespaceContextNodes(bl);

            void findNext() {
                while (this.next == null && this.eachNamespace.hasNext()) {
                    String string = this.eachNamespace.nextNamespaceAttr().getNodeName();
                    if (!string.startsWith("xmlns:")) continue;
                    this.next = string.substring("xmlns:".length());
                }
            }

            public boolean hasNext() {
                this.findNext();
                return this.next != null;
            }

            public Object next() {
                this.findNext();
                if (this.next == null) {
                    throw new NoSuchElementException();
                }
                this.last = this.next;
                this.next = null;
                return this.last;
            }

            public void remove() {
                if (this.last == null) {
                    throw new IllegalStateException();
                }
                this.eachNamespace.remove();
                this.next = null;
                this.last = null;
            }
        };
    }

    public Name getElementName() {
        return NameImpl.convertToName(this.elementQName);
    }

    public QName getElementQName() {
        return this.elementQName;
    }

    public boolean removeAttribute(Name name) {
        return this.removeAttribute(name.getURI(), name.getLocalName());
    }

    public boolean removeAttribute(QName qName) {
        return this.removeAttribute(qName.getNamespaceURI(), qName.getLocalPart());
    }

    private boolean removeAttribute(String string, String string2) {
        String string3 = string == null || string.length() == 0 ? null : string;
        Attr attr = this.getAttributeNodeNS(string3, string2);
        if (attr == null) {
            return false;
        }
        this.removeAttributeNode(attr);
        return true;
    }

    public boolean removeNamespaceDeclaration(String string) {
        Attr attr = this.getNamespaceAttr(string);
        if (attr == null) {
            return false;
        }
        try {
            this.removeAttributeNode(attr);
        }
        catch (DOMException dOMException) {
            // empty catch block
        }
        return true;
    }

    public Iterator getChildElements() {
        return ElementImpl.getChildElementsFrom(this);
    }

    protected SOAPElement convertToSoapElement(Element element) {
        if (element instanceof SOAPElement) {
            return (SOAPElement)element;
        }
        return ElementImpl.replaceElementWithSOAPElement(element, (ElementImpl)this.createElement(NameImpl.copyElementName(element)));
    }

    protected static SOAPElement replaceElementWithSOAPElement(Element element, ElementImpl elementImpl) {
        org.w3c.dom.Node node;
        Object object;
        Iterator iterator = ElementImpl.getAllAttributesFrom(element);
        while (iterator.hasNext()) {
            object = (Name)iterator.next();
            elementImpl.addAttributeBare((Name)object, ElementImpl.getAttributeValueFrom(element, (Name)object));
        }
        object = ElementImpl.getChildElementsFrom(element);
        while (object.hasNext()) {
            node = (org.w3c.dom.Node)object.next();
            elementImpl.insertBefore(node, null);
        }
        node = element.getParentNode();
        if (node != null) {
            node.replaceChild(elementImpl, element);
        }
        return elementImpl;
    }

    protected Iterator getChildElementNodes() {
        return new Iterator(){
            Iterator eachNode;
            org.w3c.dom.Node next;
            org.w3c.dom.Node last;
            {
                this.eachNode = ElementImpl.this.getChildElements();
                this.next = null;
                this.last = null;
            }

            public boolean hasNext() {
                if (this.next == null) {
                    while (this.eachNode.hasNext()) {
                        org.w3c.dom.Node node = (org.w3c.dom.Node)this.eachNode.next();
                        if (!(node instanceof SOAPElement)) continue;
                        this.next = node;
                        break;
                    }
                }
                return this.next != null;
            }

            public Object next() {
                if (this.hasNext()) {
                    this.last = this.next;
                    this.next = null;
                    return this.last;
                }
                throw new NoSuchElementException();
            }

            public void remove() {
                if (this.last == null) {
                    throw new IllegalStateException();
                }
                org.w3c.dom.Node node = this.last;
                this.last = null;
                ElementImpl.this.removeChild(node);
            }
        };
    }

    public Iterator getChildElements(Name name) {
        return this.getChildElements(name.getURI(), name.getLocalName());
    }

    public Iterator getChildElements(QName qName) {
        return this.getChildElements(qName.getNamespaceURI(), qName.getLocalPart());
    }

    private Iterator getChildElements(final String string, final String string2) {
        return new Iterator(){
            Iterator eachElement;
            org.w3c.dom.Node next;
            org.w3c.dom.Node last;
            {
                this.eachElement = ElementImpl.this.getChildElementNodes();
                this.next = null;
                this.last = null;
            }

            public boolean hasNext() {
                if (this.next == null) {
                    while (this.eachElement.hasNext()) {
                        org.w3c.dom.Node node = (org.w3c.dom.Node)this.eachElement.next();
                        String string3 = node.getNamespaceURI();
                        string3 = string3 == null ? "" : string3;
                        String string22 = node.getLocalName();
                        if (!string3.equals(string) || !string22.equals(string2)) continue;
                        this.next = node;
                        break;
                    }
                }
                return this.next != null;
            }

            public Object next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                this.last = this.next;
                this.next = null;
                return this.last;
            }

            public void remove() {
                if (this.last == null) {
                    throw new IllegalStateException();
                }
                org.w3c.dom.Node node = this.last;
                this.last = null;
                ElementImpl.this.removeChild(node);
            }
        };
    }

    public void removeContents() {
        org.w3c.dom.Node node = this.getFirstChild();
        while (node != null) {
            org.w3c.dom.Node node2 = node.getNextSibling();
            if (node instanceof Node) {
                ((Node)node).detachNode();
            } else {
                org.w3c.dom.Node node3 = node.getParentNode();
                if (node3 != null) {
                    node3.removeChild(node);
                }
            }
            node = node2;
        }
    }

    public void setEncodingStyle(String string) throws SOAPException {
        if (!"".equals(string)) {
            try {
                JaxmURI jaxmURI = new JaxmURI(string);
            }
            catch (JaxmURI.MalformedURIException malformedURIException) {
                log.log(Level.SEVERE, "SAAJ0105.impl.encoding.style.mustbe.valid.URI", new String[]{string});
                throw new IllegalArgumentException("Encoding style (" + string + ") should be a valid URI");
            }
        }
        this.encodingStyleAttribute.setValue(string);
        this.tryToFindEncodingStyleAttributeName();
    }

    public String getEncodingStyle() {
        Attr attr;
        String string = this.encodingStyleAttribute.getValue();
        if (string != null) {
            return string;
        }
        String string2 = this.getSOAPNamespace();
        if (string2 != null && (attr = this.getAttributeNodeNS(string2, "encodingStyle")) != null) {
            string = attr.getValue();
            try {
                this.setEncodingStyle(string);
            }
            catch (SOAPException sOAPException) {
                // empty catch block
            }
            return string;
        }
        return null;
    }

    public String getValue() {
        Node node = this.getValueNode();
        return node == null ? null : node.getValue();
    }

    public void setValue(String string) {
        org.w3c.dom.Node node = this.getValueNodeStrict();
        if (node != null) {
            node.setNodeValue(string);
        } else {
            try {
                this.addTextNode(string);
            }
            catch (SOAPException sOAPException) {
                throw new RuntimeException(sOAPException.getMessage());
            }
        }
    }

    protected org.w3c.dom.Node getValueNodeStrict() {
        org.w3c.dom.Node node = this.getFirstChild();
        if (node != null) {
            if (node.getNextSibling() == null && node.getNodeType() == 3) {
                return node;
            }
            log.severe("SAAJ0107.impl.elem.child.not.single.text");
            throw new IllegalStateException();
        }
        return null;
    }

    protected Node getValueNode() {
        Iterator iterator = this.getChildElements();
        while (iterator.hasNext()) {
            Node node = (Node)iterator.next();
            if (node.getNodeType() != 3 && node.getNodeType() != 4) continue;
            this.normalize();
            return node;
        }
        return null;
    }

    public void setParentElement(SOAPElement sOAPElement) throws SOAPException {
        if (sOAPElement == null) {
            log.severe("SAAJ0106.impl.no.null.to.parent.elem");
            throw new SOAPException("Cannot pass NULL to setParentElement");
        }
        sOAPElement.addChildElement(this);
        this.findEncodingStyleAttributeName();
    }

    protected void findEncodingStyleAttributeName() throws SOAPException {
        String string;
        String string2 = this.getSOAPNamespace();
        if (string2 != null && (string = this.getNamespacePrefix(string2)) != null) {
            this.setEncodingStyleNamespace(string2, string);
        }
    }

    protected void setEncodingStyleNamespace(String string, String string2) throws SOAPException {
        NameImpl nameImpl = NameImpl.create("encodingStyle", string2, string);
        this.encodingStyleAttribute.setName(nameImpl);
    }

    public SOAPElement getParentElement() {
        org.w3c.dom.Node node = this.getParentNode();
        if (node instanceof SOAPDocument) {
            return null;
        }
        return (SOAPElement)node;
    }

    protected String getSOAPNamespace() {
        String string = null;
        for (SOAPElement sOAPElement = this; sOAPElement != null; sOAPElement = sOAPElement.getParentElement()) {
            Name name = sOAPElement.getElementName();
            String string2 = name.getURI();
            if (!"http://schemas.xmlsoap.org/soap/envelope/".equals(string2) && !"http://www.w3.org/2003/05/soap-envelope".equals(string2)) continue;
            string = string2;
            break;
        }
        return string;
    }

    public void detachNode() {
        org.w3c.dom.Node node = this.getParentNode();
        if (node != null) {
            node.removeChild(this);
        }
        this.encodingStyleAttribute.clearNameAndValue();
    }

    public void tryToFindEncodingStyleAttributeName() {
        try {
            this.findEncodingStyleAttributeName();
        }
        catch (SOAPException sOAPException) {
            // empty catch block
        }
    }

    public void recycleNode() {
        this.detachNode();
    }

    protected static Attr getNamespaceAttrFrom(Element element, String string) {
        NamespaceContextIterator namespaceContextIterator = new NamespaceContextIterator(element);
        while (namespaceContextIterator.hasNext()) {
            Attr attr = namespaceContextIterator.nextNamespaceAttr();
            String string2 = NameImpl.getLocalNameFromTagName(attr.getNodeName());
            if (!string2.equals(string)) continue;
            return attr;
        }
        return null;
    }

    protected static Iterator getAllAttributesFrom(Element element) {
        final NamedNodeMap namedNodeMap = element.getAttributes();
        return new Iterator(){
            int attributesLength;
            int attributeIndex;
            String currentName;
            {
                this.attributesLength = namedNodeMap.getLength();
                this.attributeIndex = 0;
            }

            public boolean hasNext() {
                return this.attributeIndex < this.attributesLength;
            }

            public Object next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                org.w3c.dom.Node node = namedNodeMap.item(this.attributeIndex++);
                this.currentName = node.getNodeName();
                String string = NameImpl.getPrefixFromTagName(this.currentName);
                if (string.length() == 0) {
                    return NameImpl.createFromUnqualifiedName(this.currentName);
                }
                Name name = NameImpl.createFromQualifiedName(this.currentName, node.getNamespaceURI());
                return name;
            }

            public void remove() {
                if (this.currentName == null) {
                    throw new IllegalStateException();
                }
                namedNodeMap.removeNamedItem(this.currentName);
            }
        };
    }

    protected static String getAttributeValueFrom(Element element, Name name) {
        return ElementImpl.getAttributeValueFrom(element, name.getURI(), name.getLocalName(), name.getPrefix(), name.getQualifiedName());
    }

    private static String getAttributeValueFrom(Element element, String string, String string2, String string3, String string4) {
        boolean bl;
        String string5 = string == null || string.length() == 0 ? null : string;
        boolean bl2 = bl = string5 != null;
        if (bl) {
            if (!element.hasAttributeNS(string, string2)) {
                return null;
            }
            String string6 = element.getAttributeNS(string5, string2);
            return string6;
        }
        Attr attr = null;
        attr = element.getAttributeNode(string4);
        return attr == null ? null : attr.getValue();
    }

    protected static Iterator getChildElementsFrom(final Element element) {
        return new Iterator(){
            org.w3c.dom.Node next;
            org.w3c.dom.Node nextNext;
            org.w3c.dom.Node last;
            {
                this.next = element.getFirstChild();
                this.nextNext = null;
                this.last = null;
            }

            public boolean hasNext() {
                if (this.next != null) {
                    return true;
                }
                if (this.next == null && this.nextNext != null) {
                    this.next = this.nextNext;
                }
                return this.next != null;
            }

            public Object next() {
                if (this.hasNext()) {
                    this.last = this.next;
                    this.next = null;
                    if (element instanceof ElementImpl && this.last instanceof Element) {
                        this.last = ((ElementImpl)element).convertToSoapElement((Element)this.last);
                    }
                    this.nextNext = this.last.getNextSibling();
                    return this.last;
                }
                throw new NoSuchElementException();
            }

            public void remove() {
                if (this.last == null) {
                    throw new IllegalStateException();
                }
                org.w3c.dom.Node node = this.last;
                this.last = null;
                element.removeChild(node);
            }
        };
    }

    public static String getQualifiedName(QName qName) {
        String string = qName.getPrefix();
        String string2 = qName.getLocalPart();
        String string3 = null;
        string3 = string != null && string.length() > 0 ? string + ":" + string2 : string2;
        return string3;
    }

    public static String getLocalPart(String string) {
        if (string == null) {
            throw new IllegalArgumentException("Cannot get local name for a \"null\" qualified name");
        }
        int n = string.indexOf(58);
        if (n < 0) {
            return string;
        }
        return string.substring(n + 1);
    }

    public static String getPrefix(String string) {
        if (string == null) {
            throw new IllegalArgumentException("Cannot get prefix for a  \"null\" qualified name");
        }
        int n = string.indexOf(58);
        if (n < 0) {
            return "";
        }
        return string.substring(0, n);
    }

    protected boolean isNamespaceQualified(Name name) {
        return !"".equals(name.getURI());
    }

    protected boolean isNamespaceQualified(QName qName) {
        return !"".equals(qName.getNamespaceURI());
    }

    protected SOAPElement circumventBug5034339(SOAPElement sOAPElement) {
        String string;
        String string2;
        Name name = sOAPElement.getElementName();
        if (!this.isNamespaceQualified(name) && (string2 = this.getNamespaceURI(string = name.getPrefix())) != null) {
            NameImpl nameImpl = NameImpl.create(name.getLocalName(), name.getPrefix(), string2);
            SOAPElement sOAPElement2 = this.createElement(nameImpl);
            this.replaceChild(sOAPElement2, sOAPElement);
            return sOAPElement2;
        }
        return sOAPElement;
    }

    public void setAttributeNS(String string, String string2, String string3) {
        String string4;
        int n = string2.indexOf(58);
        if (n < 0) {
            Object var5_5 = null;
            string4 = string2;
        } else {
            String string5 = string2.substring(0, n);
            string4 = string2.substring(n + 1);
        }
        super.setAttributeNS(string, string2, string3);
        String string6 = this.getNamespaceURI();
        boolean bl = false;
        if (string6 != null && (string6.equals(DSIG_NS) || string6.equals(XENC_NS))) {
            bl = true;
        }
        if (string4.equals("Id")) {
            if (string == null || string.equals("")) {
                this.setIdAttribute(string4, true);
            } else if (bl || WSU_NS.equals(string)) {
                this.setIdAttributeNS(string, string4, true);
            }
        }
    }

    class AttributeManager {
        Name attributeName = null;
        String attributeValue = null;

        AttributeManager() {
        }

        public void setName(Name name) throws SOAPException {
            this.clearAttribute();
            this.attributeName = name;
            this.reconcileAttribute();
        }

        public void clearName() {
            this.clearAttribute();
            this.attributeName = null;
        }

        public void setValue(String string) throws SOAPException {
            this.attributeValue = string;
            this.reconcileAttribute();
        }

        public Name getName() {
            return this.attributeName;
        }

        public String getValue() {
            return this.attributeValue;
        }

        public void clearNameAndValue() {
            this.attributeName = null;
            this.attributeValue = null;
        }

        private void reconcileAttribute() throws SOAPException {
            if (this.attributeName != null) {
                ElementImpl.this.removeAttribute(this.attributeName);
                if (this.attributeValue != null) {
                    ElementImpl.this.addAttribute(this.attributeName, this.attributeValue);
                }
            }
        }

        private void clearAttribute() {
            if (this.attributeName != null) {
                ElementImpl.this.removeAttribute(this.attributeName);
            }
        }
    }
}

