/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jmx.snmp.agent;

import com.sun.jmx.snmp.SnmpEngine;
import com.sun.jmx.snmp.SnmpOid;
import com.sun.jmx.snmp.SnmpPdu;
import com.sun.jmx.snmp.SnmpStatusException;
import com.sun.jmx.snmp.SnmpVarBind;
import com.sun.jmx.snmp.agent.SnmpMibNode;
import com.sun.jmx.snmp.agent.SnmpMibRequest;
import com.sun.jmx.snmp.agent.SnmpMibSubRequest;
import com.sun.jmx.trace.Trace;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Vector;

final class SnmpRequestTree {
    private Hashtable hashtable = null;
    private SnmpMibRequest request = null;
    private int version = 0;
    private boolean creationflag = false;
    private boolean getnextflag = false;
    private int type = 0;
    private boolean setreqflag = false;

    SnmpRequestTree(SnmpMibRequest snmpMibRequest, boolean bl, int n) {
        this.request = snmpMibRequest;
        this.version = snmpMibRequest.getVersion();
        this.creationflag = bl;
        this.hashtable = new Hashtable();
        this.setPduType(n);
    }

    public static int mapSetException(int n, int n2) throws SnmpStatusException {
        int n3 = n;
        if (n2 == 0) {
            return n3;
        }
        int n4 = n3;
        if (n3 == 225) {
            n4 = 17;
        } else if (n3 == 224) {
            n4 = 17;
        }
        return n4;
    }

    public static int mapGetException(int n, int n2) throws SnmpStatusException {
        int n3 = n;
        if (n2 == 0) {
            return n3;
        }
        int n4 = n3;
        if (n3 == 225) {
            n4 = n3;
        } else if (n3 == 224) {
            n4 = n3;
        } else if (n3 == 6) {
            n4 = 224;
        } else if (n3 == 18) {
            n4 = 224;
        } else if (n3 >= 7 && n3 <= 12) {
            n4 = 224;
        } else if (n3 == 4) {
            n4 = 224;
        } else if (n3 != 16 && n3 != 5) {
            n4 = 225;
        }
        return n4;
    }

    public Object getUserData() {
        return this.request.getUserData();
    }

    public boolean isCreationAllowed() {
        return this.creationflag;
    }

    public boolean isSetRequest() {
        return this.setreqflag;
    }

    public int getVersion() {
        return this.version;
    }

    public int getRequestPduVersion() {
        return this.request.getRequestPduVersion();
    }

    public SnmpMibNode getMetaNode(Handler handler) {
        return handler.meta;
    }

    public int getOidDepth(Handler handler) {
        return handler.depth;
    }

    public Enumeration getSubRequests(Handler handler) {
        return new Enum(this, handler);
    }

    public Enumeration getHandlers() {
        return this.hashtable.elements();
    }

    public void add(SnmpMibNode snmpMibNode, int n, SnmpVarBind snmpVarBind) throws SnmpStatusException {
        this.registerNode(snmpMibNode, n, null, snmpVarBind, false, null);
    }

    public void add(SnmpMibNode snmpMibNode, int n, SnmpOid snmpOid, SnmpVarBind snmpVarBind, boolean bl) throws SnmpStatusException {
        this.registerNode(snmpMibNode, n, snmpOid, snmpVarBind, bl, null);
    }

    public void add(SnmpMibNode snmpMibNode, int n, SnmpOid snmpOid, SnmpVarBind snmpVarBind, boolean bl, SnmpVarBind snmpVarBind2) throws SnmpStatusException {
        this.registerNode(snmpMibNode, n, snmpOid, snmpVarBind, bl, snmpVarBind2);
    }

    void setPduType(int n) {
        this.type = n;
        this.setreqflag = n == 253 || n == 163;
    }

    void setGetNextFlag() {
        this.getnextflag = true;
    }

    void switchCreationFlag(boolean bl) {
        this.creationflag = bl;
    }

    SnmpMibSubRequest getSubRequest(Handler handler) {
        if (handler == null) {
            return null;
        }
        return new SnmpMibSubRequestImpl(this.request, handler.getSubList(), null, false, this.getnextflag, null);
    }

    SnmpMibSubRequest getSubRequest(Handler handler, SnmpOid snmpOid) {
        if (handler == null) {
            return null;
        }
        int n = handler.getEntryPos(snmpOid);
        if (n == -1) {
            return null;
        }
        return new SnmpMibSubRequestImpl(this.request, handler.getEntrySubList(n), handler.getEntryOid(n), handler.isNewEntry(n), this.getnextflag, handler.getRowStatusVarBind(n));
    }

    SnmpMibSubRequest getSubRequest(Handler handler, int n) {
        if (handler == null) {
            return null;
        }
        return new SnmpMibSubRequestImpl(this.request, handler.getEntrySubList(n), handler.getEntryOid(n), handler.isNewEntry(n), this.getnextflag, handler.getRowStatusVarBind(n));
    }

    private void put(Object object, Handler handler) {
        if (handler == null) {
            return;
        }
        if (object == null) {
            return;
        }
        if (this.hashtable == null) {
            this.hashtable = new Hashtable();
        }
        this.hashtable.put(object, handler);
    }

    private Handler get(Object object) {
        if (object == null) {
            return null;
        }
        if (this.hashtable == null) {
            return null;
        }
        return (Handler)this.hashtable.get(object);
    }

    private static int findOid(SnmpOid[] snmpOidArray, int n, SnmpOid snmpOid) {
        int n2 = n;
        int n3 = 0;
        int n4 = n2 - 1;
        int n5 = n3 + (n4 - n3) / 2;
        while (n3 <= n4) {
            SnmpOid snmpOid2 = snmpOidArray[n5];
            int n6 = snmpOid.compareTo(snmpOid2);
            if (n6 == 0) {
                return n5;
            }
            if (snmpOid.equals(snmpOid2)) {
                return n5;
            }
            if (n6 > 0) {
                n3 = n5 + 1;
            } else {
                n4 = n5 - 1;
            }
            n5 = n3 + (n4 - n3) / 2;
        }
        return -1;
    }

    private static int getInsertionPoint(SnmpOid[] snmpOidArray, int n, SnmpOid snmpOid) {
        SnmpOid[] snmpOidArray2 = snmpOidArray;
        int n2 = n;
        int n3 = 0;
        int n4 = n2 - 1;
        int n5 = n3 + (n4 - n3) / 2;
        while (n3 <= n4) {
            SnmpOid snmpOid2 = snmpOidArray2[n5];
            int n6 = snmpOid.compareTo(snmpOid2);
            if (n6 == 0) {
                return n5;
            }
            if (n6 > 0) {
                n3 = n5 + 1;
            } else {
                n4 = n5 - 1;
            }
            n5 = n3 + (n4 - n3) / 2;
        }
        return n5;
    }

    private void registerNode(SnmpMibNode snmpMibNode, int n, SnmpOid snmpOid, SnmpVarBind snmpVarBind, boolean bl, SnmpVarBind snmpVarBind2) throws SnmpStatusException {
        if (snmpMibNode == null) {
            if (SnmpRequestTree.isDebugOn()) {
                SnmpRequestTree.debug("registerNode", "meta-node is null!!!");
            }
            return;
        }
        if (snmpVarBind == null) {
            if (SnmpRequestTree.isDebugOn()) {
                SnmpRequestTree.debug("registerNode", "varbind is null!!!");
            }
            return;
        }
        SnmpMibNode snmpMibNode2 = snmpMibNode;
        Handler handler = this.get(snmpMibNode2);
        if (handler == null) {
            handler = new Handler(this.type);
            handler.meta = snmpMibNode;
            handler.depth = n;
            this.put(snmpMibNode2, handler);
        }
        if (snmpOid == null) {
            handler.addVarbind(snmpVarBind);
        } else {
            handler.addVarbind(snmpVarBind, snmpOid, bl, snmpVarBind2);
        }
    }

    private static final boolean isDebugOn() {
        return Trace.isSelected(2, 256);
    }

    private static final void debug(String string, String string2) {
        Trace.send(2, 256, "SnmpRequestTree", string, string2);
    }

    static final class Handler {
        SnmpMibNode meta;
        int depth;
        Vector sublist;
        SnmpOid[] entryoids = null;
        Vector[] entrylists = null;
        boolean[] isentrynew = null;
        SnmpVarBind[] rowstatus = null;
        int entrycount = 0;
        int entrysize = 0;
        final int type;
        private static final int Delta = 10;

        public Handler(int n) {
            this.type = n;
        }

        public void addVarbind(SnmpVarBind snmpVarBind) {
            if (this.sublist == null) {
                this.sublist = new Vector();
            }
            this.sublist.addElement(snmpVarBind);
        }

        void add(int n, SnmpOid snmpOid, Vector vector, boolean bl, SnmpVarBind snmpVarBind) {
            if (this.entryoids == null) {
                this.entryoids = new SnmpOid[10];
                this.entrylists = new Vector[10];
                this.isentrynew = new boolean[10];
                this.rowstatus = new SnmpVarBind[10];
                this.entrysize = 10;
                n = 0;
            } else if (n >= this.entrysize || this.entrycount == this.entrysize) {
                SnmpOid[] snmpOidArray = this.entryoids;
                Vector[] vectorArray = this.entrylists;
                boolean[] blArray = this.isentrynew;
                SnmpVarBind[] snmpVarBindArray = this.rowstatus;
                this.entrysize += 10;
                this.entryoids = new SnmpOid[this.entrysize];
                this.entrylists = new Vector[this.entrysize];
                this.isentrynew = new boolean[this.entrysize];
                this.rowstatus = new SnmpVarBind[this.entrysize];
                if (n > this.entrycount) {
                    n = this.entrycount;
                }
                if (n < 0) {
                    n = 0;
                }
                int n2 = n;
                int n3 = this.entrycount - n;
                if (n2 > 0) {
                    System.arraycopy(snmpOidArray, 0, this.entryoids, 0, n2);
                    System.arraycopy(vectorArray, 0, this.entrylists, 0, n2);
                    System.arraycopy(blArray, 0, this.isentrynew, 0, n2);
                    System.arraycopy(snmpVarBindArray, 0, this.rowstatus, 0, n2);
                }
                if (n3 > 0) {
                    int n4 = n2 + 1;
                    System.arraycopy(snmpOidArray, n2, this.entryoids, n4, n3);
                    System.arraycopy(vectorArray, n2, this.entrylists, n4, n3);
                    System.arraycopy(blArray, n2, this.isentrynew, n4, n3);
                    System.arraycopy(snmpVarBindArray, n2, this.rowstatus, n4, n3);
                }
            } else if (n < this.entrycount) {
                int n5 = n + 1;
                int n6 = this.entrycount - n;
                System.arraycopy(this.entryoids, n, this.entryoids, n5, n6);
                System.arraycopy(this.entrylists, n, this.entrylists, n5, n6);
                System.arraycopy(this.isentrynew, n, this.isentrynew, n5, n6);
                System.arraycopy(this.rowstatus, n, this.rowstatus, n5, n6);
            }
            this.entryoids[n] = snmpOid;
            this.entrylists[n] = vector;
            this.isentrynew[n] = bl;
            this.rowstatus[n] = snmpVarBind;
            ++this.entrycount;
        }

        public void addVarbind(SnmpVarBind snmpVarBind, SnmpOid snmpOid, boolean bl, SnmpVarBind snmpVarBind2) throws SnmpStatusException {
            Vector vector = null;
            SnmpVarBind snmpVarBind3 = snmpVarBind2;
            if (this.entryoids == null) {
                vector = new Vector();
                this.add(0, snmpOid, vector, bl, snmpVarBind3);
            } else {
                int n = SnmpRequestTree.getInsertionPoint(this.entryoids, this.entrycount, snmpOid);
                if (n > -1 && n < this.entrycount && snmpOid.compareTo(this.entryoids[n]) == 0) {
                    vector = this.entrylists[n];
                    snmpVarBind3 = this.rowstatus[n];
                } else {
                    vector = new Vector();
                    this.add(n, snmpOid, vector, bl, snmpVarBind3);
                }
                if (snmpVarBind2 != null) {
                    if (snmpVarBind3 != null && snmpVarBind3 != snmpVarBind2 && (this.type == 253 || this.type == 163)) {
                        throw new SnmpStatusException(12);
                    }
                    this.rowstatus[n] = snmpVarBind2;
                }
            }
            if (snmpVarBind2 != snmpVarBind) {
                vector.addElement(snmpVarBind);
            }
        }

        public int getSubReqCount() {
            int n = 0;
            if (this.sublist != null) {
                ++n;
            }
            if (this.entryoids != null) {
                n += this.entrycount;
            }
            return n;
        }

        public Vector getSubList() {
            return this.sublist;
        }

        public int getEntryPos(SnmpOid snmpOid) {
            return SnmpRequestTree.findOid(this.entryoids, this.entrycount, snmpOid);
        }

        public SnmpOid getEntryOid(int n) {
            if (this.entryoids == null) {
                return null;
            }
            if (n == -1 || n >= this.entrycount) {
                return null;
            }
            return this.entryoids[n];
        }

        public boolean isNewEntry(int n) {
            if (this.entryoids == null) {
                return false;
            }
            if (n == -1 || n >= this.entrycount) {
                return false;
            }
            return this.isentrynew[n];
        }

        public SnmpVarBind getRowStatusVarBind(int n) {
            if (this.entryoids == null) {
                return null;
            }
            if (n == -1 || n >= this.entrycount) {
                return null;
            }
            return this.rowstatus[n];
        }

        public Vector getEntrySubList(int n) {
            if (this.entrylists == null) {
                return null;
            }
            if (n == -1 || n >= this.entrycount) {
                return null;
            }
            return this.entrylists[n];
        }

        public Iterator getEntryOids() {
            if (this.entryoids == null) {
                return null;
            }
            return Arrays.asList(this.entryoids).iterator();
        }

        public int getEntryCount() {
            if (this.entryoids == null) {
                return 0;
            }
            return this.entrycount;
        }
    }

    static final class SnmpMibSubRequestImpl
    implements SnmpMibSubRequest {
        private final Vector varbinds;
        private final SnmpMibRequest global;
        private final int version;
        private final boolean isnew;
        private final SnmpOid entryoid;
        private final boolean getnextflag;
        private final SnmpVarBind statusvb;

        SnmpMibSubRequestImpl(SnmpMibRequest snmpMibRequest, Vector vector, SnmpOid snmpOid, boolean bl, boolean bl2, SnmpVarBind snmpVarBind) {
            this.global = snmpMibRequest;
            this.varbinds = vector;
            this.version = snmpMibRequest.getVersion();
            this.entryoid = snmpOid;
            this.isnew = bl;
            this.getnextflag = bl2;
            this.statusvb = snmpVarBind;
        }

        public Enumeration getElements() {
            return this.varbinds.elements();
        }

        public Vector getSubList() {
            return this.varbinds;
        }

        public final int getSize() {
            if (this.varbinds == null) {
                return 0;
            }
            return this.varbinds.size();
        }

        public void addVarBind(SnmpVarBind snmpVarBind) {
            this.varbinds.addElement(snmpVarBind);
            this.global.addVarBind(snmpVarBind);
        }

        public boolean isNewEntry() {
            return this.isnew;
        }

        public SnmpOid getEntryOid() {
            return this.entryoid;
        }

        public int getVarIndex(SnmpVarBind snmpVarBind) {
            if (snmpVarBind == null) {
                return 0;
            }
            return this.global.getVarIndex(snmpVarBind);
        }

        public Object getUserData() {
            return this.global.getUserData();
        }

        public void registerGetException(SnmpVarBind snmpVarBind, SnmpStatusException snmpStatusException) throws SnmpStatusException {
            if (this.version == 0) {
                throw new SnmpStatusException(snmpStatusException, this.getVarIndex(snmpVarBind) + 1);
            }
            if (snmpVarBind == null) {
                throw snmpStatusException;
            }
            if (this.getnextflag) {
                snmpVarBind.value = SnmpVarBind.endOfMibView;
                return;
            }
            int n = SnmpRequestTree.mapGetException(snmpStatusException.getStatus(), this.version);
            if (n == 225) {
                snmpVarBind.value = SnmpVarBind.noSuchObject;
            } else if (n == 224) {
                snmpVarBind.value = SnmpVarBind.noSuchInstance;
            } else {
                throw new SnmpStatusException(n, this.getVarIndex(snmpVarBind) + 1);
            }
        }

        public void registerSetException(SnmpVarBind snmpVarBind, SnmpStatusException snmpStatusException) throws SnmpStatusException {
            if (this.version == 0) {
                throw new SnmpStatusException(snmpStatusException, this.getVarIndex(snmpVarBind) + 1);
            }
            throw new SnmpStatusException(15, this.getVarIndex(snmpVarBind) + 1);
        }

        public void registerCheckException(SnmpVarBind snmpVarBind, SnmpStatusException snmpStatusException) throws SnmpStatusException {
            int n;
            int n2 = snmpStatusException.getStatus();
            if (n2 != (n = SnmpRequestTree.mapSetException(n2, this.version))) {
                throw new SnmpStatusException(n, this.getVarIndex(snmpVarBind) + 1);
            }
            throw new SnmpStatusException(snmpStatusException, this.getVarIndex(snmpVarBind) + 1);
        }

        public int getVersion() {
            return this.version;
        }

        public SnmpVarBind getRowStatusVarBind() {
            return this.statusvb;
        }

        public SnmpPdu getPdu() {
            return this.global.getPdu();
        }

        public int getRequestPduVersion() {
            return this.global.getRequestPduVersion();
        }

        public SnmpEngine getEngine() {
            return this.global.getEngine();
        }

        public String getPrincipal() {
            return this.global.getPrincipal();
        }

        public int getSecurityLevel() {
            return this.global.getSecurityLevel();
        }

        public int getSecurityModel() {
            return this.global.getSecurityModel();
        }

        public byte[] getContextName() {
            return this.global.getContextName();
        }

        public byte[] getAccessContextName() {
            return this.global.getAccessContextName();
        }
    }

    static final class Enum
    implements Enumeration {
        private final Handler handler;
        private final SnmpRequestTree hlist;
        private int entry = 0;
        private int iter = 0;
        private int size = 0;

        Enum(SnmpRequestTree snmpRequestTree, Handler handler) {
            this.handler = handler;
            this.hlist = snmpRequestTree;
            this.size = handler.getSubReqCount();
        }

        public boolean hasMoreElements() {
            return this.iter < this.size;
        }

        public Object nextElement() throws NoSuchElementException {
            if (this.iter == 0 && this.handler.sublist != null) {
                ++this.iter;
                return this.hlist.getSubRequest(this.handler);
            }
            ++this.iter;
            if (this.iter > this.size) {
                throw new NoSuchElementException();
            }
            SnmpMibSubRequest snmpMibSubRequest = this.hlist.getSubRequest(this.handler, this.entry);
            ++this.entry;
            return snmpMibSubRequest;
        }
    }
}

