/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.se.impl.encoding;

import com.sun.corba.se.impl.corba.TypeCodeImpl;
import com.sun.corba.se.impl.encoding.BufferManagerWrite;
import com.sun.corba.se.impl.encoding.ByteBufferWithInfo;
import com.sun.corba.se.impl.encoding.CDROutputStreamBase;
import com.sun.corba.se.impl.logging.ORBUtilSystemException;
import com.sun.corba.se.impl.orbutil.ORBUtility;
import com.sun.corba.se.impl.util.Utility;
import com.sun.corba.se.spi.ior.IOR;
import com.sun.corba.se.spi.ior.IORFactories;
import com.sun.corba.se.spi.ior.iiop.GIOPVersion;
import com.sun.corba.se.spi.orb.ORB;
import com.sun.corba.se.spi.presentation.rmi.StubAdapter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.rmi.Remote;
import java.security.AccessController;
import java.security.PrivilegedAction;
import org.omg.CORBA.Any;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.LocalObject;
import org.omg.CORBA.Object;
import org.omg.CORBA.Principal;
import org.omg.CORBA.TypeCode;
import org.omg.CORBA.portable.BoxedValueHelper;

public class IDLJavaSerializationOutputStream
extends CDROutputStreamBase {
    private ORB orb;
    private byte encodingVersion;
    private ObjectOutputStream os;
    private _ByteArrayOutputStream bos;
    private BufferManagerWrite bufferManager;
    private final int directWriteLength = 16;
    protected ORBUtilSystemException wrapper;

    public IDLJavaSerializationOutputStream(byte by) {
        this.encodingVersion = by;
    }

    public void init(org.omg.CORBA.ORB oRB, boolean bl, BufferManagerWrite bufferManagerWrite, byte by, boolean bl2) {
        this.orb = (ORB)oRB;
        this.bufferManager = bufferManagerWrite;
        this.wrapper = ORBUtilSystemException.get((ORB)oRB, "rpc.encoding");
        this.bos = new _ByteArrayOutputStream(1024);
    }

    private void initObjectOutputStream() {
        if (this.os != null) {
            throw this.wrapper.javaStreamInitFailed();
        }
        try {
            this.os = new MarshalObjectOutputStream(this.bos, this.orb);
        }
        catch (Exception exception) {
            throw this.wrapper.javaStreamInitFailed(exception);
        }
    }

    public final void write_boolean(boolean bl) {
        try {
            this.os.writeBoolean(bl);
        }
        catch (Exception exception) {
            throw this.wrapper.javaSerializationException(exception, (java.lang.Object)"write_boolean");
        }
    }

    public final void write_char(char c) {
        try {
            this.os.writeChar(c);
        }
        catch (Exception exception) {
            throw this.wrapper.javaSerializationException(exception, (java.lang.Object)"write_char");
        }
    }

    public final void write_wchar(char c) {
        this.write_char(c);
    }

    public final void write_octet(byte by) {
        if (this.bos.size() < 16) {
            this.bos.write(by);
            if (this.bos.size() == 16) {
                this.initObjectOutputStream();
            }
            return;
        }
        try {
            this.os.writeByte(by);
        }
        catch (Exception exception) {
            throw this.wrapper.javaSerializationException(exception, (java.lang.Object)"write_octet");
        }
    }

    public final void write_short(short s) {
        try {
            this.os.writeShort(s);
        }
        catch (Exception exception) {
            throw this.wrapper.javaSerializationException(exception, (java.lang.Object)"write_short");
        }
    }

    public final void write_ushort(short s) {
        this.write_short(s);
    }

    public final void write_long(int n) {
        if (this.bos.size() < 16) {
            this.bos.write((byte)(n >>> 24 & 0xFF));
            this.bos.write((byte)(n >>> 16 & 0xFF));
            this.bos.write((byte)(n >>> 8 & 0xFF));
            this.bos.write((byte)(n >>> 0 & 0xFF));
            if (this.bos.size() == 16) {
                this.initObjectOutputStream();
            } else if (this.bos.size() > 16) {
                this.wrapper.javaSerializationException("write_long");
            }
            return;
        }
        try {
            this.os.writeInt(n);
        }
        catch (Exception exception) {
            throw this.wrapper.javaSerializationException(exception, (java.lang.Object)"write_long");
        }
    }

    public final void write_ulong(int n) {
        this.write_long(n);
    }

    public final void write_longlong(long l) {
        try {
            this.os.writeLong(l);
        }
        catch (Exception exception) {
            throw this.wrapper.javaSerializationException(exception, (java.lang.Object)"write_longlong");
        }
    }

    public final void write_ulonglong(long l) {
        this.write_longlong(l);
    }

    public final void write_float(float f) {
        try {
            this.os.writeFloat(f);
        }
        catch (Exception exception) {
            throw this.wrapper.javaSerializationException(exception, (java.lang.Object)"write_float");
        }
    }

    public final void write_double(double d) {
        try {
            this.os.writeDouble(d);
        }
        catch (Exception exception) {
            throw this.wrapper.javaSerializationException(exception, (java.lang.Object)"write_double");
        }
    }

    public final void write_string(String string) {
        try {
            this.os.writeUTF(string);
        }
        catch (Exception exception) {
            throw this.wrapper.javaSerializationException(exception, (java.lang.Object)"write_string");
        }
    }

    public final void write_wstring(String string) {
        try {
            this.os.writeObject(string);
        }
        catch (Exception exception) {
            throw this.wrapper.javaSerializationException(exception, (java.lang.Object)"write_wstring");
        }
    }

    public final void write_boolean_array(boolean[] blArray, int n, int n2) {
        for (int i = 0; i < n2; ++i) {
            this.write_boolean(blArray[n + i]);
        }
    }

    public final void write_char_array(char[] cArray, int n, int n2) {
        for (int i = 0; i < n2; ++i) {
            this.write_char(cArray[n + i]);
        }
    }

    public final void write_wchar_array(char[] cArray, int n, int n2) {
        this.write_char_array(cArray, n, n2);
    }

    public final void write_octet_array(byte[] byArray, int n, int n2) {
        try {
            this.os.write(byArray, n, n2);
        }
        catch (Exception exception) {
            throw this.wrapper.javaSerializationException(exception, (java.lang.Object)"write_octet_array");
        }
    }

    public final void write_short_array(short[] sArray, int n, int n2) {
        for (int i = 0; i < n2; ++i) {
            this.write_short(sArray[n + i]);
        }
    }

    public final void write_ushort_array(short[] sArray, int n, int n2) {
        this.write_short_array(sArray, n, n2);
    }

    public final void write_long_array(int[] nArray, int n, int n2) {
        for (int i = 0; i < n2; ++i) {
            this.write_long(nArray[n + i]);
        }
    }

    public final void write_ulong_array(int[] nArray, int n, int n2) {
        this.write_long_array(nArray, n, n2);
    }

    public final void write_longlong_array(long[] lArray, int n, int n2) {
        for (int i = 0; i < n2; ++i) {
            this.write_longlong(lArray[n + i]);
        }
    }

    public final void write_ulonglong_array(long[] lArray, int n, int n2) {
        this.write_longlong_array(lArray, n, n2);
    }

    public final void write_float_array(float[] fArray, int n, int n2) {
        for (int i = 0; i < n2; ++i) {
            this.write_float(fArray[n + i]);
        }
    }

    public final void write_double_array(double[] dArray, int n, int n2) {
        for (int i = 0; i < n2; ++i) {
            this.write_double(dArray[n + i]);
        }
    }

    public final void write_Object(Object object) {
        if (object == null) {
            IOR iOR = IORFactories.makeIOR(this.orb);
            iOR.write(this.parent);
            return;
        }
        if (object instanceof LocalObject) {
            throw this.wrapper.writeLocalObject(CompletionStatus.COMPLETED_MAYBE);
        }
        IOR iOR = ORBUtility.connectAndGetIOR(this.orb, object);
        iOR.write(this.parent);
    }

    public final void write_TypeCode(TypeCode typeCode) {
        if (typeCode == null) {
            throw this.wrapper.nullParam(CompletionStatus.COMPLETED_MAYBE);
        }
        TypeCodeImpl typeCodeImpl = typeCode instanceof TypeCodeImpl ? (TypeCodeImpl)typeCode : new TypeCodeImpl(this.orb, typeCode);
        typeCodeImpl.write_value(this.parent);
    }

    public final void write_any(Any any) {
        if (any == null) {
            throw this.wrapper.nullParam(CompletionStatus.COMPLETED_MAYBE);
        }
        this.write_TypeCode(any.type());
        any.write_value((org.omg.CORBA.portable.OutputStream)this.parent);
    }

    public final void write_Principal(Principal principal) {
        this.write_long(principal.name().length);
        this.write_octet_array(principal.name(), 0, principal.name().length);
    }

    public final void write_fixed(BigDecimal bigDecimal) {
        this.write_fixed(bigDecimal.toString(), bigDecimal.signum());
    }

    private void write_fixed(String string, int n) {
        char c;
        int n2;
        int n3 = string.length();
        byte by = 0;
        int n4 = 0;
        for (n2 = 0; n2 < n3; ++n2) {
            c = string.charAt(n2);
            if (c == '-' || c == '+' || c == '.') continue;
            ++n4;
        }
        for (n2 = 0; n2 < n3; ++n2) {
            c = string.charAt(n2);
            if (c == '-' || c == '+' || c == '.') continue;
            byte by2 = (byte)Character.digit(c, 10);
            if (by2 == -1) {
                throw this.wrapper.badDigitInFixed(CompletionStatus.COMPLETED_MAYBE);
            }
            if (n4 % 2 == 0) {
                by = (byte)(by | by2);
                this.write_octet(by);
                by = 0;
            } else {
                by = (byte)(by | by2 << 4);
            }
            --n4;
        }
        by = n == -1 ? (byte)((byte)(by | 0xD)) : (byte)((byte)(by | 0xC));
        this.write_octet(by);
    }

    public final org.omg.CORBA.ORB orb() {
        return this.orb;
    }

    public final void write_value(Serializable serializable) {
        this.write_value(serializable, (String)null);
    }

    public final void write_value(Serializable serializable, Class clazz) {
        this.write_value(serializable);
    }

    public final void write_value(Serializable serializable, String string) {
        try {
            this.os.writeObject(serializable);
        }
        catch (Exception exception) {
            throw this.wrapper.javaSerializationException(exception, (java.lang.Object)"write_value");
        }
    }

    public final void write_value(Serializable serializable, BoxedValueHelper boxedValueHelper) {
        this.write_value(serializable, (String)null);
    }

    public final void write_abstract_interface(java.lang.Object object) {
        boolean bl = false;
        Object object2 = null;
        if (object != null && object instanceof Object) {
            object2 = (Object)object;
            bl = true;
        }
        this.write_boolean(bl);
        if (bl) {
            this.write_Object(object2);
        } else {
            try {
                this.write_value((Serializable)object);
            }
            catch (ClassCastException classCastException) {
                if (object instanceof Serializable) {
                    throw classCastException;
                }
                ORBUtility.throwNotSerializableForCorba(object.getClass().getName());
            }
        }
    }

    public final void start_block() {
        throw this.wrapper.giopVersionError();
    }

    public final void end_block() {
        throw this.wrapper.giopVersionError();
    }

    public final void putEndian() {
        throw this.wrapper.giopVersionError();
    }

    public void writeTo(OutputStream outputStream) throws IOException {
        try {
            this.os.flush();
            this.bos.writeTo(outputStream);
        }
        catch (Exception exception) {
            throw this.wrapper.javaSerializationException(exception, (java.lang.Object)"writeTo");
        }
    }

    public final byte[] toByteArray() {
        try {
            this.os.flush();
            return this.bos.toByteArray();
        }
        catch (Exception exception) {
            throw this.wrapper.javaSerializationException(exception, (java.lang.Object)"toByteArray");
        }
    }

    public final void write_Abstract(java.lang.Object object) {
        this.write_abstract_interface(object);
    }

    public final void write_Value(Serializable serializable) {
        this.write_value(serializable);
    }

    public final void write_any_array(Any[] anyArray, int n, int n2) {
        for (int i = 0; i < n2; ++i) {
            this.write_any(anyArray[n + i]);
        }
    }

    public final String[] _truncatable_ids() {
        throw this.wrapper.giopVersionError();
    }

    public final int getSize() {
        try {
            this.os.flush();
            return this.bos.size();
        }
        catch (Exception exception) {
            throw this.wrapper.javaSerializationException(exception, (java.lang.Object)"write_boolean");
        }
    }

    public final int getIndex() {
        return this.getSize();
    }

    protected int getRealIndex(int n) {
        return this.getSize();
    }

    public final void setIndex(int n) {
        throw this.wrapper.giopVersionError();
    }

    public final ByteBuffer getByteBuffer() {
        throw this.wrapper.giopVersionError();
    }

    public final void setByteBuffer(ByteBuffer byteBuffer) {
        throw this.wrapper.giopVersionError();
    }

    public final boolean isLittleEndian() {
        return false;
    }

    public ByteBufferWithInfo getByteBufferWithInfo() {
        try {
            this.os.flush();
        }
        catch (Exception exception) {
            throw this.wrapper.javaSerializationException(exception, (java.lang.Object)"getByteBufferWithInfo");
        }
        ByteBuffer byteBuffer = ByteBuffer.wrap(this.bos.getByteArray());
        byteBuffer.limit(this.bos.size());
        return new ByteBufferWithInfo((org.omg.CORBA.ORB)this.orb, byteBuffer, this.bos.size());
    }

    public void setByteBufferWithInfo(ByteBufferWithInfo byteBufferWithInfo) {
        throw this.wrapper.giopVersionError();
    }

    public final BufferManagerWrite getBufferManager() {
        return this.bufferManager;
    }

    public final void write_fixed(BigDecimal bigDecimal, short s, short s2) {
        String string;
        String string2;
        int n;
        String string3 = bigDecimal.toString();
        if (string3.charAt(0) == '-' || string3.charAt(0) == '+') {
            string3 = string3.substring(1);
        }
        if ((n = string3.indexOf(46)) == -1) {
            string2 = string3;
            string = null;
        } else if (n == 0) {
            string2 = null;
            string = string3;
        } else {
            string2 = string3.substring(0, n);
            string = string3.substring(n + 1);
        }
        StringBuffer stringBuffer = new StringBuffer(s);
        if (string != null) {
            stringBuffer.append(string);
        }
        while (stringBuffer.length() < s2) {
            stringBuffer.append('0');
        }
        if (string2 != null) {
            stringBuffer.insert(0, string2);
        }
        while (stringBuffer.length() < s) {
            stringBuffer.insert(0, '0');
        }
        this.write_fixed(stringBuffer.toString(), bigDecimal.signum());
    }

    public final void writeOctetSequenceTo(org.omg.CORBA.portable.OutputStream outputStream) {
        byte[] byArray = this.toByteArray();
        outputStream.write_long(byArray.length);
        outputStream.write_octet_array(byArray, 0, byArray.length);
    }

    public final GIOPVersion getGIOPVersion() {
        return GIOPVersion.V1_2;
    }

    public final void writeIndirection(int n, int n2) {
        throw this.wrapper.giopVersionError();
    }

    void freeInternalCaches() {
    }

    void printBuffer() {
        byte[] byArray = this.toByteArray();
        System.out.println("+++++++ Output Buffer ++++++++");
        System.out.println();
        System.out.println("Current position: " + byArray.length);
        System.out.println();
        char[] cArray = new char[16];
        try {
            for (int i = 0; i < byArray.length; i += 16) {
                int n;
                int n2;
                for (n2 = 0; n2 < 16 && n2 + i < byArray.length; ++n2) {
                    String string;
                    n = byArray[i + n2];
                    if (n < 0) {
                        n = 256 + n;
                    }
                    if ((string = Integer.toHexString(n)).length() == 1) {
                        string = "0" + string;
                    }
                    System.out.print(string + " ");
                }
                while (n2 < 16) {
                    System.out.print("   ");
                    ++n2;
                }
                for (n = 0; n < 16 && n + i < byArray.length; ++n) {
                    cArray[n] = ORBUtility.isPrintable((char)byArray[i + n]) ? (int)byArray[i + n] : 46;
                }
                System.out.println(new String(cArray, 0, n));
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        System.out.println("++++++++++++++++++++++++++++++");
    }

    public void alignOnBoundary(int n) {
        throw this.wrapper.giopVersionError();
    }

    public void setHeaderPadding(boolean bl) {
    }

    public void start_value(String string) {
        throw this.wrapper.giopVersionError();
    }

    public void end_value() {
        throw this.wrapper.giopVersionError();
    }

    class MarshalObjectOutputStream
    extends ObjectOutputStream {
        ORB orb;

        MarshalObjectOutputStream(OutputStream outputStream, ORB oRB) throws IOException {
            super(outputStream);
            this.orb = oRB;
            AccessController.doPrivileged(new PrivilegedAction(){

                public java.lang.Object run() {
                    MarshalObjectOutputStream.this.enableReplaceObject(true);
                    return null;
                }
            });
        }

        protected final java.lang.Object replaceObject(java.lang.Object object) throws IOException {
            try {
                if (object instanceof Remote && !StubAdapter.isStub(object)) {
                    return Utility.autoConnect(object, (org.omg.CORBA.ORB)this.orb, true);
                }
            }
            catch (Exception exception) {
                IOException iOException = new IOException("replaceObject failed");
                iOException.initCause(exception);
                throw iOException;
            }
            return object;
        }
    }

    class _ByteArrayOutputStream
    extends ByteArrayOutputStream {
        _ByteArrayOutputStream(int n) {
            super(n);
        }

        byte[] getByteArray() {
            return this.buf;
        }
    }
}

