/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.se.impl.encoding;

import com.sun.corba.se.impl.corba.PrincipalImpl;
import com.sun.corba.se.impl.corba.TypeCodeImpl;
import com.sun.corba.se.impl.encoding.BufferManagerRead;
import com.sun.corba.se.impl.encoding.ByteBufferWithInfo;
import com.sun.corba.se.impl.encoding.CDRInputStreamBase;
import com.sun.corba.se.impl.encoding.CDRInputStream_1_0;
import com.sun.corba.se.impl.logging.ORBUtilSystemException;
import com.sun.corba.se.impl.orbutil.ORBUtility;
import com.sun.corba.se.impl.util.RepositoryId;
import com.sun.corba.se.spi.ior.IOR;
import com.sun.corba.se.spi.ior.IORFactories;
import com.sun.corba.se.spi.ior.iiop.GIOPVersion;
import com.sun.corba.se.spi.orb.ORB;
import com.sun.corba.se.spi.presentation.rmi.PresentationDefaults;
import com.sun.corba.se.spi.presentation.rmi.PresentationManager;
import com.sun.corba.se.spi.presentation.rmi.StubAdapter;
import com.sun.org.omg.SendingContext.CodeBase;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.rmi.RemoteException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.LinkedList;
import org.omg.CORBA.Any;
import org.omg.CORBA.AnySeqHolder;
import org.omg.CORBA.BooleanSeqHolder;
import org.omg.CORBA.CharSeqHolder;
import org.omg.CORBA.DoubleSeqHolder;
import org.omg.CORBA.FloatSeqHolder;
import org.omg.CORBA.LongLongSeqHolder;
import org.omg.CORBA.LongSeqHolder;
import org.omg.CORBA.MARSHAL;
import org.omg.CORBA.Object;
import org.omg.CORBA.OctetSeqHolder;
import org.omg.CORBA.Principal;
import org.omg.CORBA.ShortSeqHolder;
import org.omg.CORBA.TypeCode;
import org.omg.CORBA.ULongLongSeqHolder;
import org.omg.CORBA.ULongSeqHolder;
import org.omg.CORBA.UShortSeqHolder;
import org.omg.CORBA.WCharSeqHolder;
import org.omg.CORBA.portable.BoxedValueHelper;
import org.omg.CORBA.portable.IDLEntity;

public class IDLJavaSerializationInputStream
extends CDRInputStreamBase {
    private ORB orb;
    private int bufSize;
    private ByteBuffer buffer;
    private byte encodingVersion;
    private ObjectInputStream is;
    private _ByteArrayInputStream bis;
    private BufferManagerRead bufferManager;
    private final int directReadLength = 16;
    private boolean markOn;
    private int peekIndex;
    private int peekCount;
    private LinkedList markedItemQ = new LinkedList();
    protected ORBUtilSystemException wrapper;

    public IDLJavaSerializationInputStream(byte by) {
        this.encodingVersion = by;
    }

    public void init(org.omg.CORBA.ORB oRB, ByteBuffer byteBuffer, int n, boolean bl, BufferManagerRead bufferManagerRead) {
        byte[] byArray;
        this.orb = (ORB)oRB;
        this.bufSize = n;
        this.bufferManager = bufferManagerRead;
        this.buffer = byteBuffer;
        this.wrapper = ORBUtilSystemException.get((ORB)oRB, "rpc.encoding");
        if (this.buffer.hasArray()) {
            byArray = this.buffer.array();
        } else {
            byArray = new byte[n];
            this.buffer.get(byArray);
        }
        this.bis = new _ByteArrayInputStream(byArray);
    }

    private void initObjectInputStream() {
        if (this.is != null) {
            throw this.wrapper.javaStreamInitFailed();
        }
        try {
            this.is = new MarshalObjectInputStream(this.bis, this.orb);
        }
        catch (Exception exception) {
            throw this.wrapper.javaStreamInitFailed(exception);
        }
    }

    public boolean read_boolean() {
        if (!this.markOn && !this.markedItemQ.isEmpty()) {
            return (Boolean)this.markedItemQ.removeFirst();
        }
        if (this.markOn && !this.markedItemQ.isEmpty() && this.peekIndex < this.peekCount) {
            return (Boolean)this.markedItemQ.get(this.peekIndex++);
        }
        try {
            boolean bl = this.is.readBoolean();
            if (this.markOn) {
                this.markedItemQ.addLast(bl);
            }
            return bl;
        }
        catch (Exception exception) {
            throw this.wrapper.javaSerializationException(exception, (java.lang.Object)"read_boolean");
        }
    }

    public char read_char() {
        if (!this.markOn && !this.markedItemQ.isEmpty()) {
            return ((Character)this.markedItemQ.removeFirst()).charValue();
        }
        if (this.markOn && !this.markedItemQ.isEmpty() && this.peekIndex < this.peekCount) {
            return ((Character)this.markedItemQ.get(this.peekIndex++)).charValue();
        }
        try {
            char c = this.is.readChar();
            if (this.markOn) {
                this.markedItemQ.addLast(new Character(c));
            }
            return c;
        }
        catch (Exception exception) {
            throw this.wrapper.javaSerializationException(exception, (java.lang.Object)"read_char");
        }
    }

    public char read_wchar() {
        return this.read_char();
    }

    public byte read_octet() {
        if (this.bis.getPosition() < 16) {
            byte by = (byte)this.bis.read();
            if (this.bis.getPosition() == 16) {
                this.initObjectInputStream();
            }
            return by;
        }
        if (!this.markOn && !this.markedItemQ.isEmpty()) {
            return (Byte)this.markedItemQ.removeFirst();
        }
        if (this.markOn && !this.markedItemQ.isEmpty() && this.peekIndex < this.peekCount) {
            return (Byte)this.markedItemQ.get(this.peekIndex++);
        }
        try {
            byte by = this.is.readByte();
            if (this.markOn) {
                this.markedItemQ.addLast(new Byte(by));
            }
            return by;
        }
        catch (Exception exception) {
            throw this.wrapper.javaSerializationException(exception, (java.lang.Object)"read_octet");
        }
    }

    public short read_short() {
        if (!this.markOn && !this.markedItemQ.isEmpty()) {
            return (Short)this.markedItemQ.removeFirst();
        }
        if (this.markOn && !this.markedItemQ.isEmpty() && this.peekIndex < this.peekCount) {
            return (Short)this.markedItemQ.get(this.peekIndex++);
        }
        try {
            short s = this.is.readShort();
            if (this.markOn) {
                this.markedItemQ.addLast(new Short(s));
            }
            return s;
        }
        catch (Exception exception) {
            throw this.wrapper.javaSerializationException(exception, (java.lang.Object)"read_short");
        }
    }

    public short read_ushort() {
        return this.read_short();
    }

    public int read_long() {
        if (this.bis.getPosition() < 16) {
            int n = this.bis.read() << 24 & 0xFF000000;
            int n2 = this.bis.read() << 16 & 0xFF0000;
            int n3 = this.bis.read() << 8 & 0xFF00;
            int n4 = this.bis.read() << 0 & 0xFF;
            if (this.bis.getPosition() == 16) {
                this.initObjectInputStream();
            } else if (this.bis.getPosition() > 16) {
                this.wrapper.javaSerializationException("read_long");
            }
            return n | n2 | n3 | n4;
        }
        if (!this.markOn && !this.markedItemQ.isEmpty()) {
            return (Integer)this.markedItemQ.removeFirst();
        }
        if (this.markOn && !this.markedItemQ.isEmpty() && this.peekIndex < this.peekCount) {
            return (Integer)this.markedItemQ.get(this.peekIndex++);
        }
        try {
            int n = this.is.readInt();
            if (this.markOn) {
                this.markedItemQ.addLast(new Integer(n));
            }
            return n;
        }
        catch (Exception exception) {
            throw this.wrapper.javaSerializationException(exception, (java.lang.Object)"read_long");
        }
    }

    public int read_ulong() {
        return this.read_long();
    }

    public long read_longlong() {
        if (!this.markOn && !this.markedItemQ.isEmpty()) {
            return (Long)this.markedItemQ.removeFirst();
        }
        if (this.markOn && !this.markedItemQ.isEmpty() && this.peekIndex < this.peekCount) {
            return (Long)this.markedItemQ.get(this.peekIndex++);
        }
        try {
            long l = this.is.readLong();
            if (this.markOn) {
                this.markedItemQ.addLast(new Long(l));
            }
            return l;
        }
        catch (Exception exception) {
            throw this.wrapper.javaSerializationException(exception, (java.lang.Object)"read_longlong");
        }
    }

    public long read_ulonglong() {
        return this.read_longlong();
    }

    public float read_float() {
        if (!this.markOn && !this.markedItemQ.isEmpty()) {
            return ((Float)this.markedItemQ.removeFirst()).floatValue();
        }
        if (this.markOn && !this.markedItemQ.isEmpty() && this.peekIndex < this.peekCount) {
            return ((Float)this.markedItemQ.get(this.peekIndex++)).floatValue();
        }
        try {
            float f = this.is.readFloat();
            if (this.markOn) {
                this.markedItemQ.addLast(new Float(f));
            }
            return f;
        }
        catch (Exception exception) {
            throw this.wrapper.javaSerializationException(exception, (java.lang.Object)"read_float");
        }
    }

    public double read_double() {
        if (!this.markOn && !this.markedItemQ.isEmpty()) {
            return (Double)this.markedItemQ.removeFirst();
        }
        if (this.markOn && !this.markedItemQ.isEmpty() && this.peekIndex < this.peekCount) {
            return (Double)this.markedItemQ.get(this.peekIndex++);
        }
        try {
            double d = this.is.readDouble();
            if (this.markOn) {
                this.markedItemQ.addLast(new Double(d));
            }
            return d;
        }
        catch (Exception exception) {
            throw this.wrapper.javaSerializationException(exception, (java.lang.Object)"read_double");
        }
    }

    public String read_string() {
        if (!this.markOn && !this.markedItemQ.isEmpty()) {
            return (String)this.markedItemQ.removeFirst();
        }
        if (this.markOn && !this.markedItemQ.isEmpty() && this.peekIndex < this.peekCount) {
            return (String)this.markedItemQ.get(this.peekIndex++);
        }
        try {
            String string = this.is.readUTF();
            if (this.markOn) {
                this.markedItemQ.addLast(string);
            }
            return string;
        }
        catch (Exception exception) {
            throw this.wrapper.javaSerializationException(exception, (java.lang.Object)"read_string");
        }
    }

    public String read_wstring() {
        if (!this.markOn && !this.markedItemQ.isEmpty()) {
            return (String)this.markedItemQ.removeFirst();
        }
        if (this.markOn && !this.markedItemQ.isEmpty() && this.peekIndex < this.peekCount) {
            return (String)this.markedItemQ.get(this.peekIndex++);
        }
        try {
            String string = (String)this.is.readObject();
            if (this.markOn) {
                this.markedItemQ.addLast(string);
            }
            return string;
        }
        catch (Exception exception) {
            throw this.wrapper.javaSerializationException(exception, (java.lang.Object)"read_wstring");
        }
    }

    public void read_boolean_array(boolean[] blArray, int n, int n2) {
        for (int i = 0; i < n2; ++i) {
            blArray[i + n] = this.read_boolean();
        }
    }

    public void read_char_array(char[] cArray, int n, int n2) {
        for (int i = 0; i < n2; ++i) {
            cArray[i + n] = this.read_char();
        }
    }

    public void read_wchar_array(char[] cArray, int n, int n2) {
        this.read_char_array(cArray, n, n2);
    }

    public void read_octet_array(byte[] byArray, int n, int n2) {
        for (int i = 0; i < n2; ++i) {
            byArray[i + n] = this.read_octet();
        }
    }

    public void read_short_array(short[] sArray, int n, int n2) {
        for (int i = 0; i < n2; ++i) {
            sArray[i + n] = this.read_short();
        }
    }

    public void read_ushort_array(short[] sArray, int n, int n2) {
        this.read_short_array(sArray, n, n2);
    }

    public void read_long_array(int[] nArray, int n, int n2) {
        for (int i = 0; i < n2; ++i) {
            nArray[i + n] = this.read_long();
        }
    }

    public void read_ulong_array(int[] nArray, int n, int n2) {
        this.read_long_array(nArray, n, n2);
    }

    public void read_longlong_array(long[] lArray, int n, int n2) {
        for (int i = 0; i < n2; ++i) {
            lArray[i + n] = this.read_longlong();
        }
    }

    public void read_ulonglong_array(long[] lArray, int n, int n2) {
        this.read_longlong_array(lArray, n, n2);
    }

    public void read_float_array(float[] fArray, int n, int n2) {
        for (int i = 0; i < n2; ++i) {
            fArray[i + n] = this.read_float();
        }
    }

    public void read_double_array(double[] dArray, int n, int n2) {
        for (int i = 0; i < n2; ++i) {
            dArray[i + n] = this.read_double();
        }
    }

    public Object read_Object() {
        return this.read_Object(null);
    }

    public TypeCode read_TypeCode() {
        TypeCodeImpl typeCodeImpl = new TypeCodeImpl(this.orb);
        typeCodeImpl.read_value(this.parent);
        return typeCodeImpl;
    }

    public Any read_any() {
        Any any = this.orb.create_any();
        TypeCodeImpl typeCodeImpl = new TypeCodeImpl(this.orb);
        try {
            typeCodeImpl.read_value(this.parent);
        }
        catch (MARSHAL mARSHAL) {
            if (typeCodeImpl.kind().value() != 29) {
                throw mARSHAL;
            }
            mARSHAL.printStackTrace();
        }
        any.read_value((org.omg.CORBA.portable.InputStream)this.parent, (TypeCode)typeCodeImpl);
        return any;
    }

    public Principal read_Principal() {
        int n = this.read_long();
        byte[] byArray = new byte[n];
        this.read_octet_array(byArray, 0, n);
        PrincipalImpl principalImpl = new PrincipalImpl();
        principalImpl.name(byArray);
        return principalImpl;
    }

    public BigDecimal read_fixed() {
        return new BigDecimal(this.read_fixed_buffer().toString());
    }

    private StringBuffer read_fixed_buffer() {
        StringBuffer stringBuffer = new StringBuffer(64);
        boolean bl = false;
        boolean bl2 = true;
        while (bl2) {
            byte by = this.read_octet();
            int n = (by & 0xF0) >> 4;
            int n2 = by & 0xF;
            if (bl || n != 0) {
                stringBuffer.append(Character.forDigit(n, 10));
                bl = true;
            }
            if (n2 == 12) {
                if (!bl) {
                    return new StringBuffer("0.0");
                }
                bl2 = false;
                continue;
            }
            if (n2 == 13) {
                stringBuffer.insert(0, '-');
                bl2 = false;
                continue;
            }
            stringBuffer.append(Character.forDigit(n2, 10));
            bl = true;
        }
        return stringBuffer;
    }

    public Object read_Object(Class clazz) {
        IOR iOR = IORFactories.makeIOR(this.parent);
        if (iOR.isNil()) {
            return null;
        }
        PresentationManager.StubFactoryFactory stubFactoryFactory = ORB.getStubFactoryFactory();
        String string = iOR.getProfile().getCodebase();
        PresentationManager.StubFactory stubFactory = null;
        if (clazz == null) {
            RepositoryId repositoryId = RepositoryId.cache.getId(iOR.getTypeId());
            String string2 = repositoryId.getClassName();
            boolean bl = repositoryId.isIDLType();
            if (string2 == null || string2.equals("")) {
                stubFactory = null;
            } else {
                try {
                    stubFactory = stubFactoryFactory.createStubFactory(string2, bl, string, null, null);
                }
                catch (Exception exception) {
                    stubFactory = null;
                }
            }
        } else if (StubAdapter.isStubClass(clazz)) {
            stubFactory = PresentationDefaults.makeStaticStubFactory(clazz);
        } else {
            boolean bl = IDLEntity.class.isAssignableFrom(clazz);
            stubFactory = stubFactoryFactory.createStubFactory(clazz.getName(), bl, string, clazz, clazz.getClassLoader());
        }
        return CDRInputStream_1_0.internalIORToObject(iOR, stubFactory, this.orb);
    }

    public org.omg.CORBA.ORB orb() {
        return this.orb;
    }

    public Serializable read_value() {
        if (!this.markOn && !this.markedItemQ.isEmpty()) {
            return (Serializable)this.markedItemQ.removeFirst();
        }
        if (this.markOn && !this.markedItemQ.isEmpty() && this.peekIndex < this.peekCount) {
            return (Serializable)this.markedItemQ.get(this.peekIndex++);
        }
        try {
            Serializable serializable = (Serializable)this.is.readObject();
            if (this.markOn) {
                this.markedItemQ.addLast(serializable);
            }
            return serializable;
        }
        catch (Exception exception) {
            throw this.wrapper.javaSerializationException(exception, (java.lang.Object)"read_value");
        }
    }

    public Serializable read_value(Class clazz) {
        return this.read_value();
    }

    public Serializable read_value(BoxedValueHelper boxedValueHelper) {
        return this.read_value();
    }

    public Serializable read_value(String string) {
        return this.read_value();
    }

    public Serializable read_value(Serializable serializable) {
        return this.read_value();
    }

    public java.lang.Object read_abstract_interface() {
        return this.read_abstract_interface(null);
    }

    public java.lang.Object read_abstract_interface(Class clazz) {
        boolean bl = this.read_boolean();
        if (bl) {
            return this.read_Object(clazz);
        }
        return this.read_value();
    }

    public void consumeEndian() {
        throw this.wrapper.giopVersionError();
    }

    public int getPosition() {
        try {
            return this.bis.getPosition();
        }
        catch (Exception exception) {
            throw this.wrapper.javaSerializationException(exception, (java.lang.Object)"getPosition");
        }
    }

    public java.lang.Object read_Abstract() {
        return this.read_abstract_interface();
    }

    public Serializable read_Value() {
        return this.read_value();
    }

    public void read_any_array(AnySeqHolder anySeqHolder, int n, int n2) {
        this.read_any_array(anySeqHolder.value, n, n2);
    }

    private final void read_any_array(Any[] anyArray, int n, int n2) {
        for (int i = 0; i < n2; ++i) {
            anyArray[i + n] = this.read_any();
        }
    }

    public void read_boolean_array(BooleanSeqHolder booleanSeqHolder, int n, int n2) {
        this.read_boolean_array(booleanSeqHolder.value, n, n2);
    }

    public void read_char_array(CharSeqHolder charSeqHolder, int n, int n2) {
        this.read_char_array(charSeqHolder.value, n, n2);
    }

    public void read_wchar_array(WCharSeqHolder wCharSeqHolder, int n, int n2) {
        this.read_wchar_array(wCharSeqHolder.value, n, n2);
    }

    public void read_octet_array(OctetSeqHolder octetSeqHolder, int n, int n2) {
        this.read_octet_array(octetSeqHolder.value, n, n2);
    }

    public void read_short_array(ShortSeqHolder shortSeqHolder, int n, int n2) {
        this.read_short_array(shortSeqHolder.value, n, n2);
    }

    public void read_ushort_array(UShortSeqHolder uShortSeqHolder, int n, int n2) {
        this.read_ushort_array(uShortSeqHolder.value, n, n2);
    }

    public void read_long_array(LongSeqHolder longSeqHolder, int n, int n2) {
        this.read_long_array(longSeqHolder.value, n, n2);
    }

    public void read_ulong_array(ULongSeqHolder uLongSeqHolder, int n, int n2) {
        this.read_ulong_array(uLongSeqHolder.value, n, n2);
    }

    public void read_ulonglong_array(ULongLongSeqHolder uLongLongSeqHolder, int n, int n2) {
        this.read_ulonglong_array(uLongLongSeqHolder.value, n, n2);
    }

    public void read_longlong_array(LongLongSeqHolder longLongSeqHolder, int n, int n2) {
        this.read_longlong_array(longLongSeqHolder.value, n, n2);
    }

    public void read_float_array(FloatSeqHolder floatSeqHolder, int n, int n2) {
        this.read_float_array(floatSeqHolder.value, n, n2);
    }

    public void read_double_array(DoubleSeqHolder doubleSeqHolder, int n, int n2) {
        this.read_double_array(doubleSeqHolder.value, n, n2);
    }

    public String[] _truncatable_ids() {
        throw this.wrapper.giopVersionError();
    }

    public void mark(int n) {
        if (this.markOn || this.is == null) {
            throw this.wrapper.javaSerializationException("mark");
        }
        this.markOn = true;
        if (!this.markedItemQ.isEmpty()) {
            this.peekIndex = 0;
            this.peekCount = this.markedItemQ.size();
        }
    }

    public void reset() {
        this.markOn = false;
        this.peekIndex = 0;
        this.peekCount = 0;
    }

    public boolean markSupported() {
        return true;
    }

    public CDRInputStreamBase dup() {
        CDRInputStreamBase cDRInputStreamBase = null;
        try {
            cDRInputStreamBase = (CDRInputStreamBase)this.getClass().newInstance();
        }
        catch (Exception exception) {
            throw this.wrapper.couldNotDuplicateCdrInputStream(exception);
        }
        cDRInputStreamBase.init((org.omg.CORBA.ORB)this.orb, this.buffer, this.bufSize, false, null);
        ((IDLJavaSerializationInputStream)cDRInputStreamBase).skipBytes(this.getPosition());
        ((IDLJavaSerializationInputStream)cDRInputStreamBase).setMarkData(this.markOn, this.peekIndex, this.peekCount, (LinkedList)this.markedItemQ.clone());
        return cDRInputStreamBase;
    }

    void skipBytes(int n) {
        try {
            this.is.skipBytes(n);
        }
        catch (Exception exception) {
            throw this.wrapper.javaSerializationException(exception, (java.lang.Object)"skipBytes");
        }
    }

    void setMarkData(boolean bl, int n, int n2, LinkedList linkedList) {
        this.markOn = bl;
        this.peekIndex = n;
        this.peekCount = n2;
        this.markedItemQ = linkedList;
    }

    public BigDecimal read_fixed(short s, short s2) {
        StringBuffer stringBuffer = this.read_fixed_buffer();
        if (s != stringBuffer.length()) {
            throw this.wrapper.badFixed(new Integer(s), new Integer(stringBuffer.length()));
        }
        stringBuffer.insert(s - s2, '.');
        return new BigDecimal(stringBuffer.toString());
    }

    public boolean isLittleEndian() {
        throw this.wrapper.giopVersionError();
    }

    void setHeaderPadding(boolean bl) {
    }

    public ByteBuffer getByteBuffer() {
        throw this.wrapper.giopVersionError();
    }

    public void setByteBuffer(ByteBuffer byteBuffer) {
        throw this.wrapper.giopVersionError();
    }

    public void setByteBufferWithInfo(ByteBufferWithInfo byteBufferWithInfo) {
        throw this.wrapper.giopVersionError();
    }

    public int getBufferLength() {
        return this.bufSize;
    }

    public void setBufferLength(int n) {
    }

    public int getIndex() {
        return this.bis.getPosition();
    }

    public void setIndex(int n) {
        try {
            this.bis.setPosition(n);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw this.wrapper.javaSerializationException(indexOutOfBoundsException, (java.lang.Object)"setIndex");
        }
    }

    public void orb(org.omg.CORBA.ORB oRB) {
        this.orb = (ORB)oRB;
    }

    public BufferManagerRead getBufferManager() {
        return this.bufferManager;
    }

    public GIOPVersion getGIOPVersion() {
        return GIOPVersion.V1_2;
    }

    CodeBase getCodeBase() {
        return this.parent.getCodeBase();
    }

    void printBuffer() {
        byte[] byArray = this.buffer.array();
        System.out.println("+++++++ Input Buffer ++++++++");
        System.out.println();
        System.out.println("Current position: " + this.getPosition());
        System.out.println("Total length : " + this.bufSize);
        System.out.println();
        char[] cArray = new char[16];
        try {
            for (int i = 0; i < byArray.length; i += 16) {
                int n;
                int n2;
                for (n2 = 0; n2 < 16 && n2 + i < byArray.length; ++n2) {
                    String string;
                    n = byArray[i + n2];
                    if (n < 0) {
                        n = 256 + n;
                    }
                    if ((string = Integer.toHexString(n)).length() == 1) {
                        string = "0" + string;
                    }
                    System.out.print(string + " ");
                }
                while (n2 < 16) {
                    System.out.print("   ");
                    ++n2;
                }
                for (n = 0; n < 16 && n + i < byArray.length; ++n) {
                    cArray[n] = ORBUtility.isPrintable((char)byArray[i + n]) ? (int)byArray[i + n] : 46;
                }
                System.out.println(new String(cArray, 0, n));
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        System.out.println("++++++++++++++++++++++++++++++");
    }

    void alignOnBoundary(int n) {
        throw this.wrapper.giopVersionError();
    }

    void performORBVersionSpecificInit() {
    }

    public void resetCodeSetConverters() {
    }

    public void start_value() {
        throw this.wrapper.giopVersionError();
    }

    public void end_value() {
        throw this.wrapper.giopVersionError();
    }

    class MarshalObjectInputStream
    extends ObjectInputStream {
        ORB orb;

        MarshalObjectInputStream(InputStream inputStream, ORB oRB) throws IOException {
            super(inputStream);
            this.orb = oRB;
            AccessController.doPrivileged(new PrivilegedAction(){

                public java.lang.Object run() {
                    MarshalObjectInputStream.this.enableResolveObject(true);
                    return null;
                }
            });
        }

        protected final java.lang.Object resolveObject(java.lang.Object object) throws IOException {
            try {
                if (StubAdapter.isStub(object)) {
                    StubAdapter.connect(object, (org.omg.CORBA.ORB)this.orb);
                }
            }
            catch (RemoteException remoteException) {
                IOException iOException = new IOException("resolveObject failed");
                iOException.initCause(remoteException);
                throw iOException;
            }
            return object;
        }
    }

    class _ByteArrayInputStream
    extends ByteArrayInputStream {
        _ByteArrayInputStream(byte[] byArray) {
            super(byArray);
        }

        int getPosition() {
            return this.pos;
        }

        void setPosition(int n) {
            if (n < 0 || n > this.count) {
                throw new IndexOutOfBoundsException();
            }
            this.pos = n;
        }
    }
}

