/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.auth.login;

import com.ibm.jvm.io.LocalizedInputStream;
import com.ibm.security.util.Debug;
import com.ibm.security.util.PropertyExpander;
import com.ibm.security.util.ResourcesMgr;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StreamTokenizer;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.Security;
import java.text.Format;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import javax.security.auth.AuthPermission;
import javax.security.auth.login.AppConfigurationEntry;
import javax.security.auth.login.Configuration;

public class ConfigFile
extends Configuration {
    private StreamTokenizer st;
    private int lookahead;
    private int linenum;
    private HashMap configuration;
    private boolean expandProp = true;
    private URL url;
    private static Debug debugConfig = Debug.getInstance("configfile");
    private static Debug debugParser = Debug.getInstance("configparser");

    public ConfigFile() {
        try {
            this.init(this.url);
        }
        catch (IOException iOException) {
            throw (SecurityException)new SecurityException(iOException.getMessage()).initCause(iOException);
        }
    }

    public ConfigFile(URI uRI) {
        try {
            this.url = uRI.toURL();
            this.init(this.url);
        }
        catch (MalformedURLException malformedURLException) {
            throw (SecurityException)new SecurityException(malformedURLException.getMessage()).initCause(malformedURLException);
        }
        catch (IOException iOException) {
            throw (SecurityException)new SecurityException(iOException.getMessage()).initCause(iOException);
        }
    }

    private synchronized void init(URL uRL) throws IOException {
        String string;
        Object[] objectArray;
        String string2;
        boolean bl = false;
        Object var3_3 = null;
        String string3 = File.separator;
        if ("false".equals(System.getProperty("policy.expandProperties"))) {
            this.expandProp = false;
        }
        HashMap hashMap = new HashMap();
        if (uRL != null) {
            if (debugConfig != null) {
                debugConfig.println("reading " + uRL);
            }
            this.init(uRL, hashMap);
            this.configuration = hashMap;
            return;
        }
        String string4 = Security.getProperty("policy.allowSystemProperty");
        if ("true".equalsIgnoreCase(string4) && (string2 = System.getProperty("java.security.auth.login.config")) != null) {
            boolean bl2 = false;
            if (string2.startsWith("=")) {
                bl2 = true;
                string2 = string2.substring(1);
            }
            try {
                string2 = PropertyExpander.expand(string2);
            }
            catch (PropertyExpander.ExpandException expandException) {
                MessageFormat messageFormat = new MessageFormat(ResourcesMgr.getString("Unable to properly expand config", "com.ibm.security.util.AuthResources"));
                Object[] objectArray2 = new Object[]{string2};
                throw new IOException(messageFormat.format(objectArray2));
            }
            URL uRL2 = null;
            try {
                uRL2 = new URL(string2);
            }
            catch (MalformedURLException malformedURLException) {
                objectArray = new File(string2);
                if (objectArray.exists()) {
                    uRL2 = new URL("file:" + objectArray.getCanonicalPath());
                }
                MessageFormat messageFormat = new MessageFormat(ResourcesMgr.getString("extra_config (No such file or directory)", "com.ibm.security.util.AuthResources"));
                Object[] objectArray3 = new Object[]{string2};
                throw new IOException(messageFormat.format(objectArray3));
            }
            if (debugConfig != null) {
                debugConfig.println("reading " + uRL2);
            }
            this.init(uRL2, hashMap);
            bl = true;
            if (bl2) {
                if (debugConfig != null) {
                    debugConfig.println("overriding other policies!");
                }
                this.configuration = hashMap;
                return;
            }
        }
        int n = 1;
        while ((string = Security.getProperty("login.config.url." + n)) != null) {
            try {
                string = PropertyExpander.expand(string).replace(File.separatorChar, '/');
                if (debugConfig != null) {
                    debugConfig.println("\tReading config: " + string);
                }
                this.init(new URL(string), hashMap);
                bl = true;
            }
            catch (PropertyExpander.ExpandException expandException) {
                MessageFormat messageFormat = new MessageFormat(ResourcesMgr.getString("Unable to properly expand config", "com.ibm.security.util.AuthResources"));
                objectArray = new Object[]{string};
                throw new IOException(messageFormat.format(objectArray));
            }
            ++n;
        }
        if (!bl && n == 1 && string == null) {
            if (debugConfig != null) {
                debugConfig.println("\tReading Policy from ~/.java.login.config");
            }
            string = System.getProperty("user.home");
            try {
                this.init(new URL("file:" + string + File.separatorChar + ".java.login.config"), hashMap);
            }
            catch (IOException iOException) {
                throw new IOException(ResourcesMgr.getString("Unable to locate a login configuration", "com.ibm.security.util.AuthResources"));
            }
        }
        this.configuration = hashMap;
    }

    private void init(URL uRL, HashMap hashMap) throws IOException {
        InputStream inputStream = LocalizedInputStream.localize(this.getInputStream(uRL));
        LocalizedInputStream.dontUnwrap(inputStream);
        InputStreamReader inputStreamReader = new InputStreamReader(inputStream, "UTF-8");
        this.readConfig(inputStreamReader, hashMap);
        inputStreamReader.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AppConfigurationEntry[] getAppConfigurationEntry(String string) {
        LinkedList linkedList = null;
        AppConfigurationEntry[] appConfigurationEntryArray = this.configuration;
        synchronized (this.configuration) {
            linkedList = (LinkedList)this.configuration.get(string);
            // ** MonitorExit[var3_3] (shouldn't be in output)
            if (linkedList == null || linkedList.size() == 0) {
                return null;
            }
            appConfigurationEntryArray = new AppConfigurationEntry[linkedList.size()];
            Iterator iterator = linkedList.iterator();
            int n = 0;
            while (iterator.hasNext()) {
                AppConfigurationEntry appConfigurationEntry = (AppConfigurationEntry)iterator.next();
                appConfigurationEntryArray[n] = new AppConfigurationEntry(appConfigurationEntry.getLoginModuleName(), appConfigurationEntry.getControlFlag(), appConfigurationEntry.getOptions());
                ++n;
            }
            return appConfigurationEntryArray;
        }
    }

    public synchronized void refresh() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new AuthPermission("refreshLoginConfiguration"));
        }
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                try {
                    ConfigFile.this.init(ConfigFile.this.url);
                }
                catch (IOException iOException) {
                    throw (SecurityException)new SecurityException(iOException.getLocalizedMessage()).initCause(iOException);
                }
                return null;
            }
        });
    }

    private void readConfig(Reader reader, HashMap hashMap) throws IOException {
        boolean bl = true;
        if (!(reader instanceof BufferedReader)) {
            reader = new BufferedReader(reader);
        }
        this.st = new StreamTokenizer(reader);
        this.st.quoteChar(34);
        this.st.wordChars(36, 36);
        this.st.wordChars(95, 95);
        this.st.wordChars(45, 45);
        this.st.lowerCaseMode(false);
        this.st.slashSlashComments(true);
        this.st.slashStarComments(true);
        this.st.eolIsSignificant(true);
        this.lookahead = this.nextToken();
        while (this.lookahead != -1) {
            this.parseLoginEntry(hashMap);
        }
    }

    private void parseLoginEntry(HashMap hashMap) throws IOException {
        Object object;
        Cloneable cloneable;
        LinkedList<AppConfigurationEntry> linkedList = new LinkedList<AppConfigurationEntry>();
        String string = this.st.sval;
        this.lookahead = this.nextToken();
        if (debugParser != null) {
            debugParser.println("\tReading next config entry: " + string);
        }
        this.match("{");
        while (!this.peek("}")) {
            Object object22;
            AppConfigurationEntry.LoginModuleControlFlag loginModuleControlFlag;
            cloneable = new HashSet();
            String string2 = this.match("module class name");
            String string3 = this.match("controlFlag");
            if (string3.equalsIgnoreCase("REQUIRED")) {
                loginModuleControlFlag = AppConfigurationEntry.LoginModuleControlFlag.REQUIRED;
            } else if (string3.equalsIgnoreCase("REQUISITE")) {
                loginModuleControlFlag = AppConfigurationEntry.LoginModuleControlFlag.REQUISITE;
            } else if (string3.equalsIgnoreCase("SUFFICIENT")) {
                loginModuleControlFlag = AppConfigurationEntry.LoginModuleControlFlag.SUFFICIENT;
            } else if (string3.equalsIgnoreCase("OPTIONAL")) {
                loginModuleControlFlag = AppConfigurationEntry.LoginModuleControlFlag.OPTIONAL;
            } else {
                object = new MessageFormat(ResourcesMgr.getString("Configuration Error:\n\tInvalid control flag, flag", "com.ibm.security.util.AuthResources"));
                object22 = new Object[]{string3};
                throw new IOException(((Format)object).format(object22));
            }
            object = new HashMap();
            while (!this.peek(";")) {
                String string4;
                object22 = this.match("option key");
                this.match("=");
                try {
                    string4 = this.expand(this.match("option value"));
                }
                catch (PropertyExpander.ExpandException expandException) {
                    throw new IOException(expandException.getLocalizedMessage());
                }
                ((HashMap)object).put(object22, string4);
            }
            this.lookahead = this.nextToken();
            if (debugParser != null) {
                debugParser.println("\t\t" + string2 + ", " + string3);
                for (Object object22 : ((HashMap)object).keySet()) {
                    debugParser.println("\t\t\t" + (String)object22 + "=" + (String)((HashMap)object).get(object22));
                }
            }
            AppConfigurationEntry appConfigurationEntry = new AppConfigurationEntry(string2, loginModuleControlFlag, (Map<String, ?>)object);
            linkedList.add(appConfigurationEntry);
        }
        this.match("}");
        this.match(";");
        if (hashMap.containsKey(string)) {
            cloneable = new MessageFormat(ResourcesMgr.getString("Configuration Error:\n\tCan not specify multiple entries for appName", "com.ibm.security.util.AuthResources"));
            object = new Object[]{string};
            throw new IOException(((Format)cloneable).format(object));
        }
        hashMap.put(string, linkedList);
    }

    private String match(String string) throws IOException {
        String string2 = null;
        switch (this.lookahead) {
            case -1: {
                MessageFormat messageFormat = new MessageFormat(ResourcesMgr.getString("Configuration Error:\n\texpected [expect], read [end of file]", "com.ibm.security.util.AuthResources"));
                Object[] objectArray = new Object[]{string};
                throw new IOException(messageFormat.format(objectArray));
            }
            case -3: 
            case 34: {
                if (string.equalsIgnoreCase("module class name") || string.equalsIgnoreCase("controlFlag") || string.equalsIgnoreCase("option key") || string.equalsIgnoreCase("option value")) {
                    string2 = this.st.sval;
                    this.lookahead = this.nextToken();
                    break;
                }
                MessageFormat messageFormat = new MessageFormat(ResourcesMgr.getString("Configuration Error:\n\tLine line: expected [expect], found [value]", "com.ibm.security.util.AuthResources"));
                Object[] objectArray = new Object[]{new Integer(this.linenum), string, this.st.sval};
                throw new IOException(messageFormat.format(objectArray));
            }
            case 123: {
                if (string.equalsIgnoreCase("{")) {
                    this.lookahead = this.nextToken();
                    break;
                }
                MessageFormat messageFormat = new MessageFormat(ResourcesMgr.getString("Configuration Error:\n\tLine line: expected [expect]", "com.ibm.security.util.AuthResources"));
                Object[] objectArray = new Object[]{new Integer(this.linenum), string, this.st.sval};
                throw new IOException(messageFormat.format(objectArray));
            }
            case 59: {
                if (string.equalsIgnoreCase(";")) {
                    this.lookahead = this.nextToken();
                    break;
                }
                MessageFormat messageFormat = new MessageFormat(ResourcesMgr.getString("Configuration Error:\n\tLine line: expected [expect]", "com.ibm.security.util.AuthResources"));
                Object[] objectArray = new Object[]{new Integer(this.linenum), string, this.st.sval};
                throw new IOException(messageFormat.format(objectArray));
            }
            case 125: {
                if (string.equalsIgnoreCase("}")) {
                    this.lookahead = this.nextToken();
                    break;
                }
                MessageFormat messageFormat = new MessageFormat(ResourcesMgr.getString("Configuration Error:\n\tLine line: expected [expect]", "com.ibm.security.util.AuthResources"));
                Object[] objectArray = new Object[]{new Integer(this.linenum), string, this.st.sval};
                throw new IOException(messageFormat.format(objectArray));
            }
            case 61: {
                if (string.equalsIgnoreCase("=")) {
                    this.lookahead = this.nextToken();
                    break;
                }
                MessageFormat messageFormat = new MessageFormat(ResourcesMgr.getString("Configuration Error:\n\tLine line: expected [expect]", "com.ibm.security.util.AuthResources"));
                Object[] objectArray = new Object[]{new Integer(this.linenum), string, this.st.sval};
                throw new IOException(messageFormat.format(objectArray));
            }
            default: {
                MessageFormat messageFormat = new MessageFormat(ResourcesMgr.getString("Configuration Error:\n\tLine line: expected [expect], found [value]", "com.ibm.security.util.AuthResources"));
                Object[] objectArray = new Object[]{new Integer(this.linenum), string, this.st.sval};
                throw new IOException(messageFormat.format(objectArray));
            }
        }
        return string2;
    }

    private boolean peek(String string) {
        boolean bl = false;
        switch (this.lookahead) {
            case 44: {
                if (!string.equalsIgnoreCase(",")) break;
                bl = true;
                break;
            }
            case 59: {
                if (!string.equalsIgnoreCase(";")) break;
                bl = true;
                break;
            }
            case 123: {
                if (!string.equalsIgnoreCase("{")) break;
                bl = true;
                break;
            }
            case 125: {
                if (!string.equalsIgnoreCase("}")) break;
                bl = true;
                break;
            }
        }
        return bl;
    }

    private int nextToken() throws IOException {
        int n;
        while ((n = this.st.nextToken()) == 10) {
            ++this.linenum;
        }
        return n;
    }

    private InputStream getInputStream(URL uRL) throws IOException {
        if ("file".equals(uRL.getProtocol())) {
            String string = uRL.getFile().replace('/', File.separatorChar);
            return new FileInputStream(string);
        }
        return uRL.openStream();
    }

    private String expand(String string) throws PropertyExpander.ExpandException, IOException {
        if ("".equals(string)) {
            return string;
        }
        if (this.expandProp) {
            String string2 = PropertyExpander.expand(string);
            if (string2 == null || string2.length() == 0) {
                MessageFormat messageFormat = new MessageFormat(ResourcesMgr.getString("Configuration Error:\n\tLine line: system property [value] expanded to empty value", "com.ibm.security.util.AuthResources"));
                Object[] objectArray = new Object[]{new Integer(this.linenum), string};
                throw new IOException(messageFormat.format(objectArray));
            }
            return string2;
        }
        return string;
    }
}

