/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.util;

import com.ibm.jvm.util.DataChain;
import com.ibm.jvm.util.DataChainPolicy;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;

public class ByteArrayOutputStream
extends OutputStream {
    protected DataChain chain;

    public ByteArrayOutputStream() {
        this.chain = new DataChain();
    }

    public ByteArrayOutputStream(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("Negative initial size: " + n);
        }
        this.chain = new DataChain(new DataChainPolicy(n));
    }

    public synchronized void write(int n) {
        this.chain.write((byte)n);
    }

    public synchronized void write(byte[] byArray, int n, int n2) {
        if (n < 0 || n > byArray.length || n2 < 0 || n + n2 > byArray.length || n + n2 < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (n2 == 0) {
            return;
        }
        this.chain.write(byArray, n, n2);
    }

    public synchronized void writeTo(OutputStream outputStream) throws IOException {
        this.chain.writeTo(outputStream);
    }

    public synchronized void reset() {
        this.chain.reset();
    }

    public synchronized byte[] toByteArray() {
        return this.chain.toByteArray();
    }

    public int size() {
        return this.chain.size();
    }

    public String toString() {
        byte[] byArray = this.chain.toByteArray();
        return new String(byArray, 0, byArray.length);
    }

    public String toString(String string) throws UnsupportedEncodingException {
        byte[] byArray = this.chain.toByteArray();
        return new String(byArray, 0, byArray.length, string);
    }

    public String toString(int n) {
        byte[] byArray = this.chain.toByteArray();
        return new String(byArray, n, 0, byArray.length);
    }

    public void close() throws IOException {
    }
}

