/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.gsk.ikeyman.util;

import com.ibm.gsk.ikeyman.command.Constants;
import com.ibm.gsk.ikeyman.error.KeyManagerException;
import com.ibm.gsk.ikeyman.messages.Messages;
import com.ibm.gsk.ikeyman.util.ComparatorFactory;
import com.ibm.gsk.ikeyman.util.Debug;
import com.ibm.gsk.ikeyman.util.KeymanSettings;
import com.ibm.security.util.ObjectIdentifier;
import com.ibm.security.x509.AlgorithmId;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.UnknownHostException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.Security;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KeymanUtil {
    private static final String JCE_PROVIDER_NAME = "IBMJCE";
    private static final String JCE_PROVIDER_FIPS_NAME = "IBMJCEFIPS";
    public static final String DSA_TYPE = "DSA";
    public static final String RSA_TYPE = "RSA";
    private static final String PKCS11_PREFIX = "IBMPKCS11Impl-";
    private static String hostName = null;
    private static String JCEProvider = null;
    private static Comparator<String> comparator = ComparatorFactory.newCollatedStringComparator();
    private static final Map<String, ObjectIdentifier> algorithmOIDs = new TreeMap<String, ObjectIdentifier>(ComparatorFactory.newIgnoreCaseStringComparator());
    public static final String[] ISO_3166_ORDERED_COUNTRY_CODES = new String[]{"  ", "AD", "AE", "AF", "AG", "AI", "AL", "AM", "AN", "AO", "AQ", "AR", "AS", "AT", "AU", "AW", "AZ", "BA", "BB", "BD", "BE", "BF", "BG", "BH", "BI", "BJ", "BM", "BN", "BO", "BR", "BS", "BT", "BV", "BW", "BY", "BZ", "CA", "CC", "CF", "CG", "CH", "CI", "CK", "CL", "CM", "CN", "CO", "CR", "CU", "CV", "CX", "CY", "CZ", "DE", "DJ", "DK", "DM", "DO", "DZ", "EC", "EE", "EG", "EH", "ER", "ES", "ET", "FI", "FJ", "FK", "FM", "FO", "FR", "FX", "GA", "GB", "GD", "GE", "GF", "GH", "GI", "GL", "GM", "GN", "GP", "GQ", "GR", "GS", "GT", "GU", "GW", "GY", "HK", "HM", "HN", "HR", "HT", "HU", "ID", "IE", "IL", "IN", "IO", "IQ", "IR", "IS", "IT", "JM", "JO", "JP", "KE", "KG", "KH", "KI", "KM", "KN", "KP", "KR", "KW", "KY", "KZ", "LA", "LB", "LC", "LI", "LK", "LR", "LS", "LT", "LU", "LV", "LY", "MA", "MC", "MD", "MG", "MH", "MK", "ML", "MM", "MN", "MO", "MP", "MQ", "MR", "MS", "MT", "MU", "MV", "MW", "MX", "MY", "MZ", "NA", "NC", "NE", "NF", "NG", "NI", "NL", "NO", "NP", "NR", "NU", "NZ", "OM", "PA", "PE", "PF", "PG", "PH", "PK", "PL", "PM", "PN", "PR", "PT", "PW", "PY", "QA", "RE", "RO", "RU", "RW", "SA", "SB", "SC", "SD", "SE", "SG", "SH", "SI", "SJ", "SK", "SL", "SM", "SN", "SO", "SR", "ST", "SV", "SY", "SZ", "TC", "TD", "TF", "TG", "TH", "TJ", "TK", "TM", "TN", "TO", "TP", "TR", "TT", "TV", "TW", "TZ", "UA", "UG", "UM", "US", "UY", "UZ", "VA", "VC", "VE", "VG", "VI", "VN", "VU", "WF", "WS", "YE", "YT", "YU", "ZA", "ZM", "ZR", "ZW"};

    public static String getIndentedString(int count) {
        String returnString = "";
        for (int i = 0; i < count; ++i) {
            returnString = returnString + " ";
        }
        return returnString;
    }

    public static String getLocalisedColon() {
        if (Locale.getDefault().getLanguage().equals(new Locale("fr", "", "").getLanguage())) {
            return " :";
        }
        return ":";
    }

    public static String getLocalisedDateTimeToString(Date date) {
        DateFormat format = DateFormat.getDateTimeInstance();
        return format.format(date);
    }

    public static String getLocalisedDateToString(Date date) {
        DateFormat format = DateFormat.getDateInstance();
        return format.format(date);
    }

    public static String getSupportedDatabaseTypes() {
        Constants.DatabaseType[] supportedTypes;
        String returnString = "";
        for (Constants.DatabaseType type : supportedTypes = Constants.DatabaseType.values(Constants.DatabaseType.SupportType.Opening)) {
            returnString = returnString + type + "\n";
        }
        return returnString;
    }

    public static Provider[] getProviders() {
        return Security.getProviders();
    }

    public static String[] getProviderList() {
        Provider[] providers = KeymanUtil.getProviders();
        ArrayList<String> tempList = new ArrayList<String>();
        int i = 1;
        for (Provider provider : providers) {
            tempList.add(i++ + ". " + provider.getName());
        }
        return tempList.toArray(new String[0]);
    }

    public static String getHostName() {
        if (hostName == null) {
            try {
                InetAddress localHosts = InetAddress.getLocalHost();
                InetAddress fullNameAddr = InetAddress.getByName(localHosts.getHostAddress());
                hostName = fullNameAddr.getHostName();
                String osname = System.getProperty("os.name");
                if (osname != null && osname.startsWith("Windows 9")) {
                    try {
                        ServerSocket ss = new ServerSocket(11111);
                        ss.close();
                    }
                    catch (IOException ioe) {
                        ioe.printStackTrace();
                    }
                }
            }
            catch (UnknownHostException e) {
                e.printStackTrace();
                hostName = "";
            }
        }
        return hostName;
    }

    public static String getJCEProviderName() {
        Debug.entering();
        if (JCEProvider == null) {
            if (KeymanSettings.Setting.DefaultFIPSModeProcessing.getBoolean().booleanValue()) {
                JCEProvider = JCE_PROVIDER_FIPS_NAME;
            } else {
                Provider[] providers;
                for (Provider provider : providers = Security.getProviders()) {
                    Debug.log("Checking provider {0}", provider);
                    if (provider.getName().startsWith(JCE_PROVIDER_FIPS_NAME)) {
                        JCEProvider = JCE_PROVIDER_FIPS_NAME;
                        break;
                    }
                    if (!provider.getName().startsWith(JCE_PROVIDER_NAME)) continue;
                    JCEProvider = JCE_PROVIDER_NAME;
                    break;
                }
            }
            if (Security.getProvider(JCEProvider) == null) {
                JCEProvider = null;
            }
        }
        Debug.exiting(JCEProvider);
        return JCEProvider;
    }

    public static void validateJCEProvider() throws KeyManagerException {
        if (KeymanUtil.getJCEProviderName() == null) {
            throw new KeyManagerException(KeyManagerException.ExceptionReason.NO_JCE_PROVIDER, KeymanSettings.Setting.DefaultFIPSModeProcessing.getBoolean() != false ? JCE_PROVIDER_FIPS_NAME : JCE_PROVIDER_NAME, KeymanSettings.Setting.DefaultFIPSModeProcessing.getPropertyKey());
        }
    }

    public static ObjectIdentifier getAlgorithmOid(String name) throws KeyManagerException {
        if (algorithmOIDs.containsKey(name)) {
            return algorithmOIDs.get(name);
        }
        try {
            return AlgorithmId.get((String)name).getOID();
        }
        catch (NoSuchAlgorithmException e) {
            throw new KeyManagerException(KeyManagerException.ExceptionReason.NO_SUCH_ALGORITHM, (Throwable)e, name);
        }
    }

    public static String getCmsVersion() {
        Provider cmsProvider = Security.getProvider("IBMCMSProvider");
        return cmsProvider == null ? Messages.getString("Label.NoCMSProvider") : Messages.getString("Label.CMSProviderVersion") + " " + cmsProvider.getVersion();
    }

    public static String getJavaVersion() {
        return Messages.getString("Label.JavaVersion") + " " + System.getProperty("java.version");
    }

    public static String getKeyType(String signatureAlgorithm) {
        if (signatureAlgorithm.contains(DSA_TYPE)) {
            return DSA_TYPE;
        }
        return RSA_TYPE;
    }

    public static String getKeyType() {
        return KeymanUtil.getKeyType(KeymanSettings.DEFAULT_SIGNATURE_ALGORITHM);
    }

    public static AlgorithmId getSignatureAlgorithm(String sigAlgOID) throws KeyManagerException {
        try {
            return AlgorithmId.get((String)sigAlgOID);
        }
        catch (NoSuchAlgorithmException e) {
            throw new KeyManagerException(KeyManagerException.ExceptionReason.NO_SUCH_ALGORITHM, sigAlgOID, e.getMessage());
        }
    }

    public static String getSignatureDigest(PrivateKey key, String oid) throws KeyManagerException {
        try {
            AlgorithmId id = AlgorithmId.get((String)oid);
            String digest = KeymanUtil.match(id.getName(), new String[]{"MD5", "MD2", "SHA1"});
            String prefix = KeymanUtil.isPKCS11Key(key) ? "PKCS11Direct" : "";
            return prefix + digest;
        }
        catch (NoSuchAlgorithmException e) {
            throw new KeyManagerException(KeyManagerException.ExceptionReason.NO_SUCH_ALGORITHM, (Throwable)e, e.toString());
        }
    }

    private static boolean isPKCS11Key(PrivateKey key) {
        return key.getClass().toString().toLowerCase().contains("pkcs11") && !key.getClass().toString().toLowerCase().contains("pkcs11impl");
    }

    private static String match(String str, String[] searchStrings) {
        for (String searchString : searchStrings) {
            if (!str.contains(searchString)) continue;
            return searchString;
        }
        return searchStrings[0];
    }

    public static char getHotKeyChar(String str) {
        int index = str.indexOf("&");
        if (index != -1) {
            return str.charAt(index + 1);
        }
        return '\u0000';
    }

    public static String getMenuItemLabel(String str) {
        return str.replace("&", "");
    }

    public static boolean isMacSystem() {
        return System.getProperty("os.name").toLowerCase().contains("mac");
    }

    public static boolean isWindowsSystem() {
        return System.getProperty("os.name").toLowerCase().contains("windows");
    }

    public static String getStackTraceString(Throwable e) {
        StringWriter str = new StringWriter();
        PrintWriter writer = new PrintWriter(str);
        e.printStackTrace(writer);
        writer.close();
        return str.toString();
    }

    public static Collection<String> getPKCS11TokenList() {
        Provider[] providers;
        ArrayList<String> returnList = new ArrayList<String>();
        for (Provider provider : providers = Security.getProviders()) {
            if (!provider.getName().startsWith(PKCS11_PREFIX)) continue;
            returnList.add(provider.getName().substring(PKCS11_PREFIX.length()));
        }
        return returnList;
    }

    public static int compareStrings(String str1, String str2) {
        return comparator.compare(str1, str2);
    }

    public static String getVersionString() {
        String ikeymanVersion = KeymanSettings.PROGRAM_VERSION;
        String cmsVersion = KeymanUtil.getCmsVersion();
        String javaVersion = KeymanUtil.getJavaVersion();
        return ikeymanVersion + "\n" + cmsVersion + "\n" + javaVersion + "\n\n" + Messages.getString("Message.Copyright") + "\n" + Messages.getString("Message.Copyright2");
    }

    static {
        algorithmOIDs.put("SHA256withRSA", AlgorithmId.sha256WithRSAEncryption_oid);
        algorithmOIDs.put("SHA384withRSA", AlgorithmId.sha384WithRSAEncryption_oid);
        algorithmOIDs.put("SHA512withRSA", AlgorithmId.sha512WithRSAEncryption_oid);
    }
}

