/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.gsk.ikeyman.keystore.entry;

import com.ibm.crypto.pkcs11impl.provider.GeneralPKCS11Key;
import com.ibm.gsk.ikeyman.error.KeyManagerException;
import com.ibm.gsk.ikeyman.io.CertificateWriter;
import com.ibm.gsk.ikeyman.keystore.entry.AbstractEntry;
import com.ibm.gsk.ikeyman.keystore.entry.DisplayItemFactory;
import com.ibm.gsk.ikeyman.keystore.entry.SecretKeyItem;
import com.ibm.gsk.ikeyman.keystore.ext.Details;
import com.ibm.gsk.ikeyman.keystore.ext.KeymanTree;
import com.ibm.gsk.ikeyman.messages.Messages;
import com.ibm.pkcs11.PKCS11Exception;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyStore;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.PublicKey;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;

class SecretKeyItemImpl
extends AbstractEntry
implements SecretKeyItem {
    public static final String ENCRYPTION_ALGORITHM = "RSA";
    private static final int BITS_PER_BYTE = 8;
    private DisplayItemFactory.AlgorithmItem algorithm;
    private SecretKey key;
    private int keySize;

    public SecretKeyItemImpl(String label, SecretKey key) throws KeyManagerException {
        block2: {
            super(label);
            this.key = key;
            this.keySize = key instanceof GeneralPKCS11Key ? ((GeneralPKCS11Key)key).getValueLen() * 8 : key.getEncoded().length * 8;
            try {
                this.algorithm = DisplayItemFactory.getAlgorithmItem(key, this.keySize);
            }
            catch (KeyManagerException e) {
                if (e.getReason() != KeyManagerException.ExceptionReason.NO_SUCH_ALGORITHM) break block2;
                this.algorithm = DisplayItemFactory.getUnsupportedAlgorithmItem(key);
            }
        }
    }

    public void extract(String target, CertificateWriter.OutputMode format) throws KeyManagerException {
        throw new RuntimeException("not implemented yet");
    }

    public String getAlgorithm() {
        return this.algorithm.getOID();
    }

    public KeyStore.Entry toKeyStoreEntry() {
        return new KeyStore.SecretKeyEntry(this.key);
    }

    public boolean isValid() {
        return true;
    }

    public String toLongString() {
        return Messages.getString("Label.Label") + " " + this.getLabel() + "\n" + Messages.getString("Label.Algorithm") + ": " + this.algorithm + "\n" + Messages.getString("Label.KeySize") + ": " + this.keySize + "\n";
    }

    public KeymanTree toTree() {
        return null;
    }

    public String get(Details.DetailIdentifier id) throws KeyManagerException {
        switch (id) {
            case KeyAlgorithm: {
                return this.algorithm.toString();
            }
            case SecretKeySize: {
                return this.keySize + "";
            }
        }
        return super.get(id);
    }

    public byte[] encryptKey(PublicKey encryptionKey, String provider) throws KeyManagerException {
        try {
            Cipher cipher = Cipher.getInstance(ENCRYPTION_ALGORITHM, provider);
            cipher.init(3, encryptionKey);
            return cipher.wrap(this.key);
        }
        catch (InvalidKeyException e) {
            throw new KeyManagerException(KeyManagerException.ExceptionReason.KEY_ENCRYPTION_ERROR, (Throwable)e, this.getLabel());
        }
        catch (NoSuchAlgorithmException e) {
            throw new KeyManagerException(KeyManagerException.ExceptionReason.NO_SUCH_ALGORITHM, (Throwable)e, e.getMessage());
        }
        catch (NoSuchPaddingException e) {
            throw new KeyManagerException(KeyManagerException.ExceptionReason.KEY_ENCRYPTION_ERROR, (Throwable)e, this.getLabel());
        }
        catch (IllegalBlockSizeException e) {
            throw new KeyManagerException(KeyManagerException.ExceptionReason.KEY_ENCRYPTION_ERROR, (Throwable)e, this.getLabel());
        }
        catch (NoSuchProviderException e) {
            throw new KeyManagerException(KeyManagerException.ExceptionReason.NO_SUCH_PROVIDER, (Throwable)e, provider);
        }
        catch (PKCS11Exception e) {
            throw new KeyManagerException(KeyManagerException.ExceptionReason.PKCS11_ERROR, (Throwable)e, this.getLabel(), e.getMessage());
        }
    }

    public static SecretKeyItem decryptKey(PrivateKey privateKey, byte[] encrypted, String keyAlgorithm, String alias, String provider) throws KeyManagerException {
        try {
            Cipher cipher = Cipher.getInstance(ENCRYPTION_ALGORITHM, provider);
            cipher.init(4, privateKey);
            Key key = cipher.unwrap(encrypted, keyAlgorithm, 3);
            return new SecretKeyItemImpl(alias, (SecretKey)key);
        }
        catch (InvalidKeyException e) {
            throw new KeyManagerException(KeyManagerException.ExceptionReason.KEY_DECRYPTION_ERROR, (Throwable)e, alias);
        }
        catch (NoSuchAlgorithmException e) {
            throw new KeyManagerException(KeyManagerException.ExceptionReason.NO_SUCH_ALGORITHM, (Throwable)e, e.getMessage());
        }
        catch (NoSuchPaddingException e) {
            throw new KeyManagerException(KeyManagerException.ExceptionReason.KEY_DECRYPTION_ERROR, (Throwable)e, alias);
        }
        catch (NoSuchProviderException e) {
            throw new KeyManagerException(KeyManagerException.ExceptionReason.NO_SUCH_PROVIDER, (Throwable)e, provider);
        }
    }
}

