/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.gsk.ikeyman.io;

import com.ibm.gsk.ikeyman.util.Debug;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.OverlappingFileLockException;

public class LockedFileOutputStream
extends OutputStream {
    private FileOutputStream outputStream;

    public LockedFileOutputStream(String fileName) throws IOException {
        try {
            this.outputStream = new FileOutputStream(fileName, true);
            FileChannel channel = this.outputStream.getChannel();
            FileLock lock = channel.tryLock();
            if (lock == null) {
                throw new IOException("Unable to acquire file lock for " + fileName);
            }
            channel.truncate(0L);
        }
        catch (OverlappingFileLockException e) {
            Debug.throwing(e);
            throw new IOException("Unable to acquire file lock for " + fileName);
        }
    }

    public LockedFileOutputStream(File file) throws IOException {
        this(file.getAbsolutePath());
    }

    public void write(int b) throws IOException {
        this.outputStream.write(b);
    }

    public void close() throws IOException {
        this.outputStream.close();
    }

    public void flush() throws IOException {
        this.outputStream.flush();
    }
}

